/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.clientapp.client.ClientApp;
import hec.data.ParamDouble;
import hec.data.Parameter;
import hec.gfx2d.G2dGlyphFactory;
import hec.gfx2d.G2dPanel;
import hec.gfx2d.G2dPanelProp;
import hec.gfx2d.G2dPlotProp;
import hec.rss.client.FloatingWaterAccountBucketDataManager;
import hec.rss.client.FloatingWaterAccountBucketGlyph;
import hec.rss.client.FloatingWaterAccountBucketPlotPanel$1;
import hec.rss.client.FloatingWaterAccountCurveData;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import rma.swing.RmaInsets;
import rma.swing.RmaJPanel;
import rma.swing.RmaJTable;
import rma.swing.table.RmaTableModel;

class FloatingWaterAccountBucketPlotPanel
extends RmaJPanel {
    private FloatingWaterAccountBucketDataManager _dataManager;
    private RmaJTable _bucketTable;
    private G2dPanel _bucketPlot;

    FloatingWaterAccountBucketPlotPanel() {
        this.buildControls();
        G2dGlyphFactory.addMapping((String)FloatingWaterAccountCurveData.class.getName(), (String)FloatingWaterAccountBucketGlyph.class.getName());
    }

    private void buildControls() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)5, (int)5);
        this._bucketPlot = new G2dPanel();
        RmaJPanel rmaJPanel = new RmaJPanel((LayoutManager)new GridBagLayout());
        rmaJPanel.add((Component)this._bucketPlot, gridBagConstraints);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = RmaInsets.insets((int)0, (int)0, (int)0, (int)0);
        this.add((Component)rmaJPanel, gridBagConstraints);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.25;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)5, (int)5);
        FloatingWaterAccountBucketPlotPanel floatingWaterAccountBucketPlotPanel = this;
        floatingWaterAccountBucketPlotPanel.add(floatingWaterAccountBucketPlotPanel.createBucketTable().getScrollPane(), gridBagConstraints);
    }

    public void fillPanel(FloatingWaterAccountBucketDataManager floatingWaterAccountBucketDataManager) {
        this._dataManager = floatingWaterAccountBucketDataManager;
        this.loadBucketTable();
        this.createInitialViewport();
        this.updateValues(0);
    }

    private RmaJTable createBucketTable() {
        FloatingWaterAccountBucketPlotPanel floatingWaterAccountBucketPlotPanel = this;
        this._bucketTable = new FloatingWaterAccountBucketPlotPanel$1(floatingWaterAccountBucketPlotPanel, (Component)((Object)floatingWaterAccountBucketPlotPanel), new String[]{"Account", "Storage (%S)"});
        this._bucketTable.setColumnSelectionAllowed(false);
        this._bucketTable.setCellSelectionEnabled(false);
        this._bucketTable.setRowSelectionAllowed(false);
        this._bucketTable.setAddRemoveEnabled(false);
        this._bucketTable.setEditable(false);
        this._bucketTable.setUnitsHeaderRenderer();
        this._bucketTable.setNumRows(10);
        this._bucketTable.setRowHeight(20);
        int n = ClientApp.Workspace().getUnitSystem();
        RmaTableModel rmaTableModel = (RmaTableModel)this._bucketTable.getModel();
        rmaTableModel.setUnitSystem(n);
        rmaTableModel.setColumnParameters(new int[]{-1, Parameter.PARAMID_STOR});
        n = rmaTableModel.getRowCount();
        --n;
        while (n >= 0) {
            rmaTableModel.deleteRow(n);
            --n;
        }
        this._bucketTable.setPreferredScrollableViewportSize(new Dimension(200, 200));
        return this._bucketTable;
    }

    private void loadBucketTable() {
        int n = this._bucketTable.getModel().getRowCount();
        --n;
        while (n >= 0) {
            ((RmaTableModel)this._bucketTable.getModel()).deleteRow(n);
            --n;
        }
        n = ClientApp.Workspace().getUnitSystem();
        for (FloatingWaterAccountCurveData floatingWaterAccountCurveData : this._dataManager.d()) {
            String string = floatingWaterAccountCurveData.getName();
            Object object = floatingWaterAccountCurveData.getActualCurve().getData();
            double d = 0.0;
            if (object.getValues() != null && object.getValues().length > 0) {
                d = object.getValue(0);
            }
            object = new Vector<String>(2);
            ((Vector)object).add(string);
            string = new ParamDouble(d, Parameter.PARAMID_STOR, n, 2);
            ((Vector)object).add(string);
            this._bucketTable.appendRow((Vector)object);
            this._bucketTable.setRowBackground(this._bucketTable.getRowCount() - 1, floatingWaterAccountCurveData.getDrawingProperties().b());
        }
    }

    private void createInitialViewport() {
        this._bucketPlot.clearPanel();
        Object object = new G2dPanelProp();
        new G2dPanelProp().hasLegend = false;
        ((G2dPanelProp)object).hasToolbar = true;
        ((G2dPanelProp)object).toolbarProp = G2dPanel.createDefaultToolbarProperties();
        G2dPlotProp g2dPlotProp = new G2dPlotProp();
        new G2dPlotProp().hasX1Tics = false;
        g2dPlotProp.hasY1Tics = false;
        g2dPlotProp.hasY1Label = false;
        g2dPlotProp.hasX1Label = false;
        g2dPlotProp.y1AxisProp.isReversed = true;
        g2dPlotProp.viewportDrawProp.drawMajorXGrid = true;
        g2dPlotProp.viewportDrawProp.drawMajorYGrid = true;
        g2dPlotProp.x1AxisProp.name = "XAxis";
        g2dPlotProp.x1AxisProp.label = "XAxisProp";
        g2dPlotProp.y1AxisProp.name = "YAxis";
        g2dPlotProp.y1AxisProp.label = "YAxisProp";
        g2dPlotProp.x1AxisProp.min = 0.0;
        g2dPlotProp.x1AxisProp.max = 10.0;
        g2dPlotProp.y1AxisProp.min = 0.0;
        g2dPlotProp.y1AxisProp.max = 14.0;
        object.addPlotProp(g2dPlotProp);
        this._bucketPlot.configurePanel((G2dPanelProp)object);
        object = new ArrayList<FloatingWaterAccountCurveData>();
        object.add(this._dataManager.b());
        object.addAll(this._dataManager.c());
        this._bucketPlot.setPlotObjects((List)object);
    }

    void updateValues(int n) {
        this._dataManager.a(n);
        int n2 = ClientApp.Workspace().getUnitSystem();
        List<FloatingWaterAccountCurveData> list = this._dataManager.d();
        for (int i = 0; i < list.size(); ++i) {
            FloatingWaterAccountCurveData floatingWaterAccountCurveData = list.get(i);
            double d = floatingWaterAccountCurveData.getActualCurve().getData().getValue(n);
            floatingWaterAccountCurveData = new ParamDouble(d, Parameter.PARAMID_STOR, n2);
            this._bucketTable.setValueAt((Object)floatingWaterAccountCurveData, i, 1);
        }
    }
}

