/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.geometry.WorldRect;
import hec.gfx2d.G2dData;
import hec.gfx2d.TimeSeriesDataSet;
import hec.rss.client.FloatingWaterAccountBucketDrawingProperties;
import java.util.Arrays;
import rma.util.RMAConst;

public class FloatingWaterAccountCurveData
extends G2dData {
    private final String _name;
    private final TimeSeriesDataSet _maxCurve;
    private final TimeSeriesDataSet _actualCurve;
    private final FloatingWaterAccountBucketDrawingProperties _drawingProperties;
    private double _width;
    private double _height;
    private double _leftX;
    private double _lowerY;
    private double _waterDepth;

    FloatingWaterAccountCurveData(String string, TimeSeriesDataSet timeSeriesDataSet, TimeSeriesDataSet timeSeriesDataSet2, FloatingWaterAccountBucketDrawingProperties floatingWaterAccountBucketDrawingProperties) {
        this._name = string;
        this._maxCurve = timeSeriesDataSet;
        this._actualCurve = timeSeriesDataSet2;
        this._drawingProperties = floatingWaterAccountBucketDrawingProperties;
    }

    void updateBucketValues(double d, double d2, double d3, double d4, double d5) {
        this._width = d;
        this._height = d2;
        this._leftX = d3;
        this._lowerY = d4;
        this._waterDepth = d5;
        this.setChanged();
        this.notifyObservers("update data");
    }

    boolean isTimeSeriesDataValid() {
        FloatingWaterAccountCurveData floatingWaterAccountCurveData = this;
        if (floatingWaterAccountCurveData.isTimeSeriesDataSetValid(floatingWaterAccountCurveData._maxCurve)) {
            FloatingWaterAccountCurveData floatingWaterAccountCurveData2 = this;
            if (floatingWaterAccountCurveData2.isTimeSeriesDataSetValid(floatingWaterAccountCurveData2._actualCurve)) {
                return true;
            }
        }
        return false;
    }

    private boolean isTimeSeriesDataSetValid(TimeSeriesDataSet timeSeriesDataSet) {
        if (timeSeriesDataSet == null) {
            return false;
        }
        return (timeSeriesDataSet = timeSeriesDataSet.getData()) != null && timeSeriesDataSet.getValues() != null && timeSeriesDataSet.getTimes() != null;
    }

    FloatingWaterAccountBucketDrawingProperties getDrawingProperties() {
        return this._drawingProperties;
    }

    public String getName() {
        return this._name;
    }

    TimeSeriesDataSet getMaxCurve() {
        return this._maxCurve;
    }

    TimeSeriesDataSet getActualCurve() {
        return this._actualCurve;
    }

    double getBucketWidth() {
        return this._width;
    }

    double getBucketHeight() {
        return this._height;
    }

    double getLeftX() {
        return this._leftX;
    }

    double getLowerY() {
        return this._lowerY;
    }

    double getWaterDepth() {
        return this._waterDepth;
    }

    double getMaxCurveValue(int n) {
        return this.getMaxCurve().getData().getValue(n);
    }

    double getActualCurveValue(int n) {
        return this.getActualCurve().getData().getValue(n);
    }

    double getMaxMaxCurveValue() {
        FloatingWaterAccountCurveData floatingWaterAccountCurveData = this;
        return floatingWaterAccountCurveData.getRecordMaximum(floatingWaterAccountCurveData.getMaxCurve());
    }

    double getMaxActualCurveValue() {
        FloatingWaterAccountCurveData floatingWaterAccountCurveData = this;
        return floatingWaterAccountCurveData.getRecordMaximum(floatingWaterAccountCurveData.getActualCurve());
    }

    private double getRecordMaximum(TimeSeriesDataSet timeSeriesDataSet) {
        return Arrays.stream(timeSeriesDataSet.getData().getValues()).filter(d -> !RMAConst.isUndefinedValue((double)d)).max().getAsDouble();
    }

    public double[] getXValues() {
        return new double[0];
    }

    public double[] getYValues(int n) {
        return new double[0];
    }

    public String getXAxisName() {
        return "XAxis";
    }

    public String getYAxisName() {
        return "YAxis";
    }

    public int getXAxisType() {
        return 0;
    }

    public int getYAxisType() {
        return 0;
    }

    public void load() {
    }

    public void unload() {
    }

    public WorldRect getBounds() {
        return new WorldRect(0.0, 14.0, 10.0, 0.0);
    }
}

