/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.gfx2d.G2dLineProperties;
import hec.heclib.util.HecTime;
import hec.heclib.util.HecTimeArray;
import hec.io.TimeSeriesContainer;
import hec.rss.client.FloatingWaterAccountBucketDataManager;
import hec.rss.client.FloatingWaterAccountBucketDrawingPropertiesFactory;
import hec.rss.client.FloatingWaterAccountBucketPlotPanel;
import hec.rss.client.FloatingWaterAccountCurveData;
import hec.rss.client.FloatingWaterAccountDialog$1;
import hec.rss.client.FloatingWaterAccountDialog$SimpleLayoutManager;
import hec.rss.client.FloatingWaterAccountJSlider;
import hec.rss.client.FloatingWaterAccountTimeSeriesPlotPanel;
import hec.rss.client.WaterAccountCurveActualStorage;
import hec.rss.client.WaterAccountCurveCheckbox;
import hec.rss.client.WaterAccountCurveMaxStorage;
import hec.rss.model.RssRun;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import rma.swing.CollapsableJPanel;
import rma.swing.RmaInsets;
import rma.swing.RmaJButton;
import rma.swing.RmaJCheckBox;
import rma.swing.RmaJDateTimeField;
import rma.swing.RmaJDialog;
import rma.swing.RmaJLabel;
import rma.swing.RmaJPanel;
import rma.util.RMAIO;
import rma.util.RmaDrawConst;

class FloatingWaterAccountDialog
extends RmaJDialog {
    private FloatingWaterAccountBucketDataManager _bucketDataManager;
    private RmaJButton _timeStepGoButton;
    private FloatingWaterAccountBucketPlotPanel _bucketChartPanel;
    private RmaJCheckBox _showPlotCheckbox;
    private RmaJCheckBox _showBucketChartCheckbox;
    private FloatingWaterAccountJSlider _slider;
    private FloatingWaterAccountTimeSeriesPlotPanel _plotPanel;
    private RmaJDateTimeField _timeStepField;
    private List<WaterAccountCurveCheckbox> _curveCheckboxes;
    private CollapsableJPanel _checkboxCurvePanel;
    private JSplitPane _splitPane;
    private JPanel _sliderContainer;
    protected JMenu _viewMenu;
    protected JMenuBar jmb;
    private JCheckBoxMenuItem mRefreshMenuItem;
    private RssRun _rssRun;
    private RmaJPanel _checkboxPanel;

    FloatingWaterAccountDialog(Frame frame, boolean bl) {
        super(frame, bl);
        this.setTitle("Floating Water Account");
        this.setSize(1000, 800);
        this.buildControls();
        this.addActionListener();
    }

    public void fillDialog(RssRun serializable2) {
        this._rssRun = serializable2;
        this._bucketDataManager = new FloatingWaterAccountBucketDataManager(this._rssRun);
        this._bucketChartPanel.fillPanel(this._bucketDataManager);
        this.createCurveCheckboxes();
        this.fillCheckboxPanel();
        this._plotPanel.setCheckboxes(this._curveCheckboxes);
        this._plotPanel.plotSelectedCheckboxes();
        serializable2 = ((GridBagLayout)this._plotPanel.getLayout()).getConstraints((Component)this._plotPanel.getViewports()[0]);
        ((GridBagLayout)this._plotPanel.getLayout()).getConstraints((Component)this._plotPanel.getViewports()[0]).anchor = 15;
        ((GridBagConstraints)serializable2).fill = 2;
        ((GridBagConstraints)serializable2).weighty = 0.0;
        ((GridBagConstraints)serializable2).gridy += 2;
        serializable2 = this._plotPanel.getAxisTics(0);
        serializable2.addComponentListener(new FloatingWaterAccountDialog$1(this));
        serializable2 = this.createSlider();
        this._sliderContainer.removeAll();
        this._sliderContainer.add((Component)serializable2);
        this._slider.addChangeListener(serializable -> {
            serializable = (FloatingWaterAccountJSlider)serializable.getSource();
            int n = ((JSlider)((Object)serializable)).getValue();
            SwingUtilities.invokeLater(() -> this.lambda$fillDialog$0(n, (FloatingWaterAccountJSlider)((Object)serializable)));
        });
        this._timeStepField.setText(this._slider.getTimeStepString(0));
    }

    private void addActionListener() {
        this._showPlotCheckbox.addActionListener(actionEvent -> {
            this._plotPanel.setVisible(this._showPlotCheckbox.isSelected());
            this._checkboxCurvePanel.setVisible(this._showPlotCheckbox.isSelected());
        });
        this._showBucketChartCheckbox.addActionListener(actionEvent -> {
            this._bucketChartPanel.setVisible(this._showBucketChartCheckbox.isSelected());
            this._splitPane.setDividerLocation(200);
        });
        this._timeStepGoButton.addActionListener(actionEvent -> this.goButtonClicked());
    }

    private void goButtonClicked() {
        String string = this._timeStepField.getText();
        if (!this.isDateStringValidFormat(string)) {
            JOptionPane.showMessageDialog((Component)((Object)this), "The date entered is not in the correct format: ddMMMyyyy hhmm.", "Invalid format", 0);
            return;
        }
        Object object = this._slider.getFirstTime();
        if ((string = new HecTime(string)).lessThan(object)) {
            object = object.dateAndTime(4);
            JOptionPane.showMessageDialog((Component)((Object)this), "The date entered is before the starting date of " + (String)object, "Invalid Date", 0);
            return;
        }
        object = this._slider.getLastTime();
        if (string.greaterThan(object)) {
            string = object.dateAndTime(4);
            JOptionPane.showMessageDialog((Component)((Object)this), "The date entered is after the last date of " + string, "Invalid Date", 0);
            return;
        }
        this._slider.setValue(this._slider.getTimeStepInt((HecTime)string));
    }

    private boolean isDateStringValidFormat(String string) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("ddMMMyyyy hhmm");
        try {
            simpleDateFormat.parse(string);
        }
        catch (ParseException parseException) {
            return false;
        }
        return true;
    }

    private void buildControls() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)5, (int)5);
        FloatingWaterAccountDialog floatingWaterAccountDialog = this;
        floatingWaterAccountDialog.add((Component)floatingWaterAccountDialog.createShowPlotsCheckboxPanel(), gridBagConstraints);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)5, (int)5);
        this._bucketChartPanel = new FloatingWaterAccountBucketPlotPanel();
        this._plotPanel = new FloatingWaterAccountTimeSeriesPlotPanel();
        this._splitPane = new JSplitPane(0, (Component)((Object)this._bucketChartPanel), (Component)this.createPlotPanelScrollPane());
        this._splitPane.setOneTouchExpandable(true);
        this._splitPane.setDividerSize(this._splitPane.getDividerSize() + 5);
        EventQueue.invokeLater(() -> this._splitPane.setDividerLocation(200));
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)5, (int)5);
        FloatingWaterAccountDialog floatingWaterAccountDialog2 = this;
        floatingWaterAccountDialog2.add(floatingWaterAccountDialog2._splitPane, gridBagConstraints);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS0050;
        this._sliderContainer = new JPanel();
        this._sliderContainer.setLayout(new FloatingWaterAccountDialog$SimpleLayoutManager(this));
        FloatingWaterAccountDialog floatingWaterAccountDialog3 = this;
        floatingWaterAccountDialog3.add(floatingWaterAccountDialog3._sliderContainer, gridBagConstraints);
    }

    private RmaJPanel createPlotPanelScrollPane() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        RmaJPanel rmaJPanel = new RmaJPanel((LayoutManager)new GridBagLayout());
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)5, (int)5);
        this._checkboxPanel = new RmaJPanel((LayoutManager)new GridBagLayout());
        this._checkboxCurvePanel = new CollapsableJPanel("Available Curves:", (JPanel)this._checkboxPanel);
        rmaJPanel.add((Component)this._checkboxCurvePanel, (Object)gridBagConstraints);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)5, (int)5);
        rmaJPanel.add((Component)((Object)this._plotPanel), (Object)gridBagConstraints);
        return rmaJPanel;
    }

    private RmaJPanel createShowPlotsCheckboxPanel() {
        RmaJPanel rmaJPanel = new RmaJPanel((LayoutManager)new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this._showPlotCheckbox = new RmaJCheckBox("Show Plot");
        this._showPlotCheckbox.setSelected(true);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)5, (int)5);
        rmaJPanel.add((Component)this._showPlotCheckbox, (Object)gridBagConstraints);
        this._showBucketChartCheckbox = new RmaJCheckBox("Show Bucket Chart");
        this._showBucketChartCheckbox.setSelected(true);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)5, (int)5);
        rmaJPanel.add((Component)this._showBucketChartCheckbox, (Object)gridBagConstraints);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)5, (int)5);
        rmaJPanel.add((Component)new RmaJLabel("Time Step:"), (Object)gridBagConstraints);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)5, (int)5);
        this._timeStepField = new RmaJDateTimeField();
        rmaJPanel.add((Component)this._timeStepField, (Object)gridBagConstraints);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)5, (int)5);
        this._timeStepGoButton = new RmaJButton("Go");
        rmaJPanel.add((Component)this._timeStepGoButton, (Object)gridBagConstraints);
        return rmaJPanel;
    }

    private void createCurveCheckboxes() {
        List<FloatingWaterAccountCurveData> list = this._bucketDataManager.d();
        this._curveCheckboxes = new ArrayList<WaterAccountCurveCheckbox>();
        for (int i = 0; i < list.size(); ++i) {
            Color color = i == 0 ? FloatingWaterAccountBucketDrawingPropertiesFactory.a().a() : (i == list.size() - 1 ? FloatingWaterAccountBucketDrawingPropertiesFactory.b().a() : FloatingWaterAccountBucketDrawingPropertiesFactory.a(i - 1).a());
            color = this.createWaterAccountCurveLineProperties(color);
            this._curveCheckboxes.add(this.createMaxCurveCheckbox(list.get(i), (G2dLineProperties)color));
            this._curveCheckboxes.add(this.createActualCurveCheckbox(list.get(i), (G2dLineProperties)color));
        }
    }

    private RmaJPanel fillCheckboxPanel() {
        this._checkboxPanel.invalidate();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        for (int i = 0; i < this._curveCheckboxes.size(); ++i) {
            gridBagConstraints.gridx = -1;
            gridBagConstraints.gridy = -1;
            gridBagConstraints.gridwidth = (i + 1) % 5 == 0 ? 0 : 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = RmaInsets.insets((int)0, (int)5, (int)0, (int)0);
            this._checkboxPanel.add((Component)((Object)this._curveCheckboxes.get(i)), (Object)gridBagConstraints);
        }
        return this._checkboxPanel;
    }

    private WaterAccountCurveCheckbox createMaxCurveCheckbox(FloatingWaterAccountCurveData floatingWaterAccountCurveData, G2dLineProperties object) {
        WaterAccountCurveMaxStorage waterAccountCurveMaxStorage = new WaterAccountCurveMaxStorage(this._plotPanel, floatingWaterAccountCurveData.getMaxCurve());
        G2dLineProperties g2dLineProperties = object;
        object = waterAccountCurveMaxStorage;
        waterAccountCurveMaxStorage.a = g2dLineProperties;
        return new WaterAccountCurveCheckbox(waterAccountCurveMaxStorage, floatingWaterAccountCurveData.getName() + ": Max", true);
    }

    private WaterAccountCurveCheckbox createActualCurveCheckbox(FloatingWaterAccountCurveData floatingWaterAccountCurveData, G2dLineProperties object) {
        WaterAccountCurveActualStorage waterAccountCurveActualStorage = new WaterAccountCurveActualStorage(this._plotPanel, floatingWaterAccountCurveData.getActualCurve());
        G2dLineProperties g2dLineProperties = object;
        object = waterAccountCurveActualStorage;
        waterAccountCurveActualStorage.a = g2dLineProperties;
        return new WaterAccountCurveCheckbox(waterAccountCurveActualStorage, floatingWaterAccountCurveData.getName() + ": Actual", true);
    }

    private G2dLineProperties createWaterAccountCurveLineProperties(Color color) {
        G2dLineProperties g2dLineProperties = new G2dLineProperties();
        new G2dLineProperties()._lineWidth = 1.5f;
        g2dLineProperties._lineStylePattern = RmaDrawConst.SOLID_STYLE_PATTERN;
        g2dLineProperties._lineColor = color;
        g2dLineProperties._drawPoints = false;
        return g2dLineProperties;
    }

    private JSlider createSlider() {
        TimeSeriesContainer timeSeriesContainer = this._bucketDataManager.a().getActualCurve().getData();
        int n = timeSeriesContainer.getTimeIntervalSeconds();
        timeSeriesContainer = timeSeriesContainer.getTimes();
        this._slider = new FloatingWaterAccountJSlider((HecTimeArray)timeSeriesContainer, n /= 60);
        return this._slider;
    }

    public void refreshData() {
        if (this.mRefreshMenuItem.isSelected()) {
            FloatingWaterAccountDialog floatingWaterAccountDialog = this;
            floatingWaterAccountDialog.fillDialog(floatingWaterAccountDialog._rssRun);
        }
    }

    private void makeMenus() {
        this.jmb = new JMenuBar();
        this._viewMenu = new JMenu("View");
        this._viewMenu.setMnemonic('V');
        this.jmb.add(this._viewMenu);
        RMAIO.getOSType();
        this.mRefreshMenuItem = new JCheckBoxMenuItem("Live Display...");
        this._viewMenu.add(this.mRefreshMenuItem);
        FloatingWaterAccountDialog floatingWaterAccountDialog = this;
        floatingWaterAccountDialog.setJMenuBar(floatingWaterAccountDialog.jmb);
    }

    private /* synthetic */ void lambda$fillDialog$0(int n, FloatingWaterAccountJSlider floatingWaterAccountJSlider) {
        this._plotPanel.updateVerticalLine(n);
        this._timeStepField.setText(floatingWaterAccountJSlider.getTimeStepString(n));
        this._bucketChartPanel.updateValues(n);
    }
}

