/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.gfx2d.G2dGlyph;
import hec.gfx2d.G2dGlyphFactory;
import hec.gfx2d.G2dLineProperties;
import hec.gfx2d.G2dObject;
import hec.gfx2d.G2dPanel;
import hec.gfx2d.PlotLayout;
import hec.gfx2d.Viewport;
import hec.gfx2d.ViewportLayout;
import hec.rss.client.FloatingWaterAccountVerticalLineData;
import hec.rss.client.FloatingWaterAccountVerticalLineGlyph;
import hec.rss.client.WaterAccountCheckboxPanel;
import hec.rss.client.WaterAccountCurveCheckbox;
import java.awt.Container;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import rma.services.ServiceLookup;

public class FloatingWaterAccountTimeSeriesPlotPanel
extends G2dPanel
implements WaterAccountCheckboxPanel {
    private List<WaterAccountCurveCheckbox> _checkboxes;
    private PlotLayout _layout = new PlotLayout();
    private FloatingWaterAccountVerticalLineData _verticalLineData;

    FloatingWaterAccountTimeSeriesPlotPanel() {
        G2dGlyphFactory.addMapping((String)FloatingWaterAccountVerticalLineData.class.getName(), (String)FloatingWaterAccountVerticalLineGlyph.class.getName());
    }

    void setCheckboxes(List<WaterAccountCurveCheckbox> list) {
        this._checkboxes = list;
    }

    public void addPlotObject(G2dObject g2dObject, G2dLineProperties g2dLineProperties, boolean bl) {
        super.addPlotObject(g2dObject, g2dLineProperties, bl);
        this.removeThenAddVerticalLine();
    }

    private void removeThenAddVerticalLine() {
        block0: for (Viewport viewport : this.getViewports()) {
            Object object = viewport.getGlyphVector();
            object = ((Vector)object).iterator();
            while (object.hasNext()) {
                Object e = object.next();
                if (!(e instanceof FloatingWaterAccountVerticalLineGlyph)) continue;
                object = (G2dGlyph)e;
                this.removeGlyph((G2dGlyph)object);
                viewport.addG2dGlyph((G2dGlyph)object);
                continue block0;
            }
        }
    }

    private List<WaterAccountCurveCheckbox> getSelectedCheckboxes() {
        ArrayList<WaterAccountCurveCheckbox> arrayList = new ArrayList<WaterAccountCurveCheckbox>();
        for (WaterAccountCurveCheckbox waterAccountCurveCheckbox : this._checkboxes) {
            if (!waterAccountCurveCheckbox.isSelected()) continue;
            arrayList.add(waterAccountCurveCheckbox);
        }
        return arrayList;
    }

    void plotSelectedCheckboxes() {
        List<WaterAccountCurveCheckbox> list = this.getSelectedCheckboxes();
        this._layout = new PlotLayout();
        ViewportLayout viewportLayout = this._layout.addViewport();
        viewportLayout.setAxisLabel("Y1", "Stor (%S)");
        viewportLayout.setAxisLabel("X1", "");
        if (list.size() > 0) {
            for (WaterAccountCurveCheckbox waterAccountCurveCheckbox : list) {
                viewportLayout.addCurve("Y1", (Object)waterAccountCurveCheckbox.getCurve().c(), waterAccountCurveCheckbox.getCurve().e());
            }
            Object object = list.get((int)0).getCurve().c()._timeSeries.times;
            this._verticalLineData = new FloatingWaterAccountVerticalLineData((int[])object);
            viewportLayout.addCurve("Y1", (Object)this._verticalLineData);
        }
        this.buildPlotComponents();
    }

    void updateVerticalLine(int n) {
        this._verticalLineData.updateXValue(n);
    }

    private void buildPlotComponents() {
        this.setVisible(false);
        FloatingWaterAccountTimeSeriesPlotPanel floatingWaterAccountTimeSeriesPlotPanel = this;
        floatingWaterAccountTimeSeriesPlotPanel.buildComponents(floatingWaterAccountTimeSeriesPlotPanel._layout);
        ServiceLookup.getUnitsDisplayService().updateUnitSystem((Container)((Object)this));
        this.setVisible(true);
    }

    @Override
    public void checkboxSelectionChanged() {
        this.plotSelectedCheckboxes();
    }
}

