/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.clientapp.client.ClientApp;
import hec.data.Parameter;
import hec.model.PairedValues;
import hec.model.PairedValuesTableModel;
import hec.rss.client.FlowContingencyDialog$1;
import hec.rss.client.FlowContingencyDialog$2;
import hec.rss.client.RulePanel;
import hec.rss.model.DownstreamCntrlOpRule;
import hec.rss.model.DownstreamOpRule;
import hec.rss.model.OpRule;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.table.TableModel;
import rma.swing.ButtonCmdPanel;
import rma.swing.ButtonCmdPanelListener;
import rma.swing.RmaJDecimalField;
import rma.swing.RmaJDialog;
import rma.swing.RmaJRadioButton;
import rma.swing.RmaJTable;
import rma.util.RMAIO;

public class FlowContingencyDialog
extends RmaJDialog {
    public static int a = 0;
    public static int b = 1;
    boolean _cancelled = true;
    boolean _checkDefaultData = false;
    FlowContingencyDialog _FlowContingencyDialog = null;
    private RmaJDecimalField _contingencyPercentage;
    private RmaJRadioButton _constContingencyRadioButton;
    private RmaJRadioButton _contingencyFunctionRadioButton;
    RmaJTable _table;
    ButtonGroup _buttonGroup = new ButtonGroup();
    private RulePanel _parentPanel;
    private ButtonCmdPanel _cmdPanel;

    public FlowContingencyDialog(Dialog dialog, JPanel jPanel, boolean bl) {
        super(dialog, bl);
        this.setTitle("Flow Contingency for Downstream Operation");
        this.buildComponents();
        this._parentPanel = (RulePanel)((Object)jPanel);
    }

    void buildComponents() {
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        String[] stringArray = new JPanel(new GridBagLayout());
        this._constContingencyRadioButton = new RmaJRadioButton("Constant Contingency percentage (%)");
        this._constContingencyRadioButton.setMnemonic('C');
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        stringArray.add((Component)this._constContingencyRadioButton, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 10);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        this._contingencyPercentage = new RmaJDecimalField();
        this._contingencyPercentage.setMaxValue(100.0);
        this._contingencyPercentage.setMinValue(0.0);
        stringArray.add((Component)this._contingencyPercentage, gridBagConstraints);
        this._contingencyFunctionRadioButton = new RmaJRadioButton("Contingency percentage as a function of Cumulative local Flow");
        this._contingencyFunctionRadioButton.setMnemonic('p');
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        stringArray.add((Component)this._contingencyFunctionRadioButton, gridBagConstraints);
        this._buttonGroup.add((AbstractButton)this._constContingencyRadioButton);
        this._buttonGroup.add((AbstractButton)this._contingencyFunctionRadioButton);
        this._buttonGroup.setSelected(this._constContingencyRadioButton.getModel(), true);
        FlowContingencyDialog$1 flowContingencyDialog$1 = new FlowContingencyDialog$1(this);
        this._constContingencyRadioButton.addActionListener((ActionListener)flowContingencyDialog$1);
        this._contingencyFunctionRadioButton.addActionListener((ActionListener)flowContingencyDialog$1);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 25);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)stringArray, gridBagConstraints);
        stringArray = new String[]{"Cum. Local Flow (%S)", "Contingency %"};
        this._table = new RmaJTable((Component)((Object)this), (Object[])stringArray);
        stringArray = new PairedValuesTableModel(stringArray, new boolean[]{true, true});
        this._table.setModel((TableModel)stringArray);
        this._table.setNumRows(9);
        this._table.setDoubleCellEditor(true);
        this._table.setColumnPrecision(0, 2);
        this._table.setColumnPrecision(1, 1);
        this._table.setUnitsHeaderRenderer();
        this._table.setColumnParameters(new int[]{Parameter.PARAMID_FLOW, Parameter.PARAMID_PERCENT});
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(5, 50, 5, 35);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 1;
        this.getContentPane().add((Component)this._table.getScrollPane(), gridBagConstraints);
        this._cmdPanel = new ButtonCmdPanel(12);
        this._cmdPanel.getButton(8).setName("Compute");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 15);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)this._cmdPanel, gridBagConstraints);
        this._cmdPanel.addCmdPanelListener((ButtonCmdPanelListener)new FlowContingencyDialog$2(this));
        this.pack();
        this.setSize(500, 295);
        FlowContingencyDialog flowContingencyDialog = this;
        flowContingencyDialog.setLocationRelativeTo(flowContingencyDialog.getParent());
    }

    public boolean isCancelled() {
        return this._cancelled;
    }

    public void cmdOKAction() {
        this._cancelled = false;
        this.setVisible(false);
        this.dispose();
    }

    public void cmdCancelAction() {
        this._cancelled = true;
        this.setVisible(false);
        this.dispose();
    }

    public void fillForm() {
        OpRule opRule = this._parentPanel._currentRuleRef.getRule();
        if (opRule.isDnstrmRule()) {
            DownstreamCntrlOpRule downstreamCntrlOpRule = (DownstreamCntrlOpRule)opRule;
            this.setContingencyType(downstreamCntrlOpRule.getContingencyType());
            this.setContingencyConstant(downstreamCntrlOpRule.getContingencyConstant());
            downstreamCntrlOpRule = downstreamCntrlOpRule.getContingencyPV();
            if (downstreamCntrlOpRule == null) {
                downstreamCntrlOpRule = new PairedValues();
            }
            downstreamCntrlOpRule.setUnitSystem(opRule.getUnitSystem());
            this.setContingencyPV((PairedValues)downstreamCntrlOpRule);
        }
        this.setModified(false);
    }

    private void radioSelectionChangedAction() {
        if (this._contingencyFunctionRadioButton.isSelected()) {
            this._table.setEnabled(true);
            this._contingencyPercentage.setEditable(false);
            return;
        }
        this._contingencyPercentage.setEditable(true);
        this._table.setEnabled(false);
    }

    public double getContingencyConstant() {
        return this._contingencyPercentage.getValue();
    }

    public void setContingencyConstant(double d) {
        this._contingencyPercentage.setValue(d);
    }

    public PairedValues getContingencyPV() {
        OpRule opRule = this._parentPanel._currentRuleRef.getRule();
        if (opRule.isDnstrmRule()) {
            opRule = (DownstreamCntrlOpRule)opRule;
            opRule = (PairedValues)((DownstreamOpRule)opRule).getContingencyPV().clone();
            opRule.clearValues();
            this._table.commitEdit(true);
            Vector vector = this._table.getCells();
            for (int i = 0; i < vector.size(); ++i) {
                if (vector.elementAt(i) == null || ((Vector)vector.elementAt(i)).size() < 2) continue;
                Object e = ((Vector)vector.elementAt(i)).elementAt(0);
                Object e2 = ((Vector)vector.elementAt(i)).elementAt(1);
                double d = RMAIO.parseDouble(e);
                double d2 = RMAIO.parseDouble(e2);
                if (d == Double.NEGATIVE_INFINITY && d2 == Double.NEGATIVE_INFINITY) continue;
                opRule.addPair(d, d2);
            }
            return opRule;
        }
        return null;
    }

    public void setContingencyPV(PairedValues pairedValues) {
        pairedValues.setParamXId(Parameter.PARAMID_FLOW);
        pairedValues.setParamYId(Parameter.PARAMID_PERCENT);
        ((PairedValuesTableModel)this._table.getModel()).setPairedValues(pairedValues);
        if (this._table.getRowCount() == 1) {
            this._table.appendRows(8);
        }
    }

    public int getContingencyType() {
        if (this._buttonGroup.getSelection() == this._contingencyFunctionRadioButton.getModel()) {
            return b;
        }
        return a;
    }

    public void setContingencyType(int n) {
        if (n == b) {
            this._contingencyFunctionRadioButton.doClick(0);
            return;
        }
        this._constContingencyRadioButton.doClick(0);
    }

    private boolean saveForm() {
        OpRule opRule = this._parentPanel._currentRuleRef.getRule();
        if (opRule.isDnstrmRule()) {
            opRule = (DownstreamOpRule)opRule;
            ((DownstreamOpRule)opRule).setContingencyConstant(this.getContingencyConstant());
            ((DownstreamOpRule)opRule).setContingencyType(this.getContingencyType());
            PairedValues pairedValues = new PairedValues();
            this._table.commitEdit(true);
            pairedValues.setUnitSystem(ClientApp.Workspace().getUnitSystem());
            ((PairedValuesTableModel)this._table.getModel()).storeData(pairedValues);
            pairedValues.setParamXId(Parameter.PARAMID_FLOW);
            pairedValues.setParamYId(Parameter.PARAMID_PERCENT);
            ((DownstreamOpRule)opRule).setContingencyPV(pairedValues);
            ((DownstreamOpRule)opRule).setContingencyType(this.getContingencyType());
        }
        return true;
    }
}

