/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.data.ParamDouble;
import hec.data.Parameter;
import hec.rss.client.GateOpeningsDialog$1;
import hec.rss.model.AdjustableFlow;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.EventObject;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.UIManager;
import rma.swing.ButtonCmdPanel;
import rma.swing.ButtonCmdPanelListener;
import rma.swing.RmaGridBagConstraints;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJDialog;
import rma.swing.RmaJLabel;
import rma.swing.RmaJRadioButton;
import rma.swing.RmaJTable;
import rma.util.RMAIO;

public class GateOpeningsDialog
extends RmaJDialog
implements ItemListener,
ButtonCmdPanelListener {
    RmaJRadioButton _singleCapacityRadioBtn = new RmaJRadioButton("Specify Maximum Capacity Only");
    RmaJRadioButton _gateCapacitiesRadioBtn = new RmaJRadioButton("Specify Capacity at Specific Gate Openings");
    RmaJLabel _numGateSettingsLabel = new RmaJLabel("Number of Gate Settings");
    RmaJComboBox _numGateSettingsCombo = new RmaJComboBox();
    RmaJLabel _settingUnitsLabel = new RmaJLabel("Gate Setting Units");
    RmaJComboBox _settingUnitsCombo = new RmaJComboBox();
    RmaJTable _settingTable;
    JPanel _gateSpecPanel = new JPanel();
    ButtonCmdPanel _buttonCmdPanel = new ButtonCmdPanel(12);
    boolean _isOk = false;
    AdjustableFlow _adjustableFlow;
    private static Insets a = new Insets(5, 5, 5, 5);
    private static Insets b = new Insets(5, 5, 0, 0);
    private static Insets c;

    public GateOpeningsDialog(RmaJDialog rmaJDialog, boolean bl) {
        super((Dialog)rmaJDialog, bl);
        this.buildControls();
    }

    public void fillForm(AdjustableFlow object) {
        this._adjustableFlow = object;
        this.clearForm();
        if (this._adjustableFlow == null) {
            return;
        }
        if (this._adjustableFlow.hasMultipleGateSettings()) {
            this._gateCapacitiesRadioBtn.setSelected(true);
        } else {
            this._singleCapacityRadioBtn.setSelected(true);
        }
        if (this._adjustableFlow.getGateSettingsParamId() == Parameter.PARAMID_PERCENT) {
            this._settingUnitsCombo.setSelectedIndex(0);
        } else if (this._adjustableFlow.getGateSettingsParamId() == Parameter.PARAMID_LENGTH) {
            this._settingUnitsCombo.setSelectedIndex(1);
        }
        object = Parameter.getUnitsStringForSystem((int)this._adjustableFlow.getGateSettingsParamId(), (int)GateOpeningsDialog.getUnitSystem());
        this._settingTable.setColumnLabels(new String[]{" ", "Setting\n(" + (String)object + ")"});
        double[] dArray = this._adjustableFlow.getGateSettings();
        object = dArray;
        if (dArray == null || ((Object)object).length <= 0) {
            this._numGateSettingsCombo.setSelectedIndex(0);
            this._settingTable.setNumRows(1);
            this._settingTable.setCell((Object)Integer.toString(1), 0, 0);
            this._settingTable.setCell((Object)"", 0, 1);
            return;
        }
        this._numGateSettingsCombo.setSelectedIndex(((Object)object).length - 1);
        this._settingTable.setNumRows(((Object)object).length);
        if (this._adjustableFlow.getGateSettingsParamId() == Parameter.PARAMID_PERCENT) {
            for (int i = 0; i < ((Object)object).length; ++i) {
                this._settingTable.setCell((Object)Integer.toString(i + 1), i, 0);
                this._settingTable.setCell((Object)Double.toString((double)object[i]), i, 1);
            }
            return;
        }
        ParamDouble paramDouble = new ParamDouble();
        paramDouble.setParameterId(this._adjustableFlow.getGateSettingsParamId());
        paramDouble.setUnitSystem(this._adjustableFlow.getUnitSystem());
        for (int i = 0; i < ((Object)object).length; ++i) {
            this._settingTable.setCell((Object)Integer.toString(i + 1), i, 0);
            paramDouble.setValue((double)object[i]);
            String string = RMAIO.setPrecision2((double)paramDouble.convertToUnitSystem(GateOpeningsDialog.getUnitSystem()), (int)2);
            this._settingTable.setCell((Object)string, i, 1);
        }
    }

    public boolean saveForm() {
        if (this._adjustableFlow == null) {
            return false;
        }
        this._adjustableFlow.setMultipleGateSettings(this._gateCapacitiesRadioBtn.isSelected());
        if (this._gateCapacitiesRadioBtn.isSelected()) {
            if (this._settingUnitsCombo.getSelectedIndex() == 0) {
                this._adjustableFlow.setGateSettingsParamId(Parameter.PARAMID_PERCENT);
            } else {
                this._adjustableFlow.setGateSettingsParamId(Parameter.PARAMID_LENGTH);
            }
            double[] dArray = new double[this._numGateSettingsCombo.getSelectedIndex() + 1];
            if (this._adjustableFlow.getGateSettingsParamId() == Parameter.PARAMID_PERCENT) {
                for (int i = 0; i < dArray.length; ++i) {
                    String string = this._settingTable.getCell(i, 1).toString();
                    dArray[i] = string.length() > 0 ? Double.parseDouble(string) : 0.0;
                }
            } else {
                ParamDouble paramDouble = new ParamDouble();
                paramDouble.setParameterId(this._adjustableFlow.getGateSettingsParamId());
                paramDouble.setUnitSystem(GateOpeningsDialog.getUnitSystem());
                for (int i = 0; i < dArray.length; ++i) {
                    String string = this._settingTable.getCell(i, 1).toString();
                    double d = RMAIO.parseDouble((String)string);
                    paramDouble.setValue(d);
                    dArray[i] = paramDouble.convertToUnitSystem(this._adjustableFlow.getUnitSystem());
                }
            }
            this._adjustableFlow.setGateSettings(dArray);
        }
        return true;
    }

    public void clearForm() {
    }

    public void setOk(boolean bl) {
        this._isOk = bl;
    }

    public boolean isOk() {
        return this._isOk;
    }

    public void buttonCmdActionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getID() == 8) {
            this.cmdOK_Action();
            return;
        }
        if (actionEvent.getID() == 4) {
            this.cmdCancel_Action();
        }
    }

    public void cmdOK_Action() {
        this._settingTable.commitEdit(true);
        this.setOk(true);
        this.setVisible(false);
    }

    public void cmdCancel_Action() {
        this._settingTable.commitEdit(true);
        this.setOk(false);
        this.setVisible(false);
    }

    @Override
    public void itemStateChanged(ItemEvent object) {
        if (((ItemEvent)object).getStateChange() == 2) {
            return;
        }
        if ((object = ((EventObject)object).getSource()) == this._gateCapacitiesRadioBtn || object == this._singleCapacityRadioBtn) {
            this.capacities_StateChange();
            return;
        }
        if (object == this._numGateSettingsCombo) {
            int n = this._numGateSettingsCombo.getSelectedIndex() + 1;
            this._settingTable.setNumRows(n);
            for (int i = 0; i < n; ++i) {
                this._settingTable.setCell((Object)Integer.toString(i + 1), i, 0);
            }
            return;
        }
        if (object == this._settingUnitsCombo) {
            object = this._settingUnitsCombo.getSelectedIndex() == 0 ? Parameter.getUnitsStringForSystem((int)Parameter.PARAMID_PERCENT, (int)GateOpeningsDialog.getUnitSystem()) : Parameter.getUnitsStringForSystem((int)Parameter.PARAMID_LENGTH, (int)GateOpeningsDialog.getUnitSystem());
            this._settingTable.setColumnLabels(new String[]{" ", "Setting\n(" + (String)object + ")"});
        }
    }

    private void capacities_StateChange() {
        this._gateSpecPanel.setEnabled(this._gateCapacitiesRadioBtn.isSelected());
        this._numGateSettingsCombo.setEnabled(this._gateCapacitiesRadioBtn.isSelected());
        this._settingUnitsCombo.setEnabled(this._gateCapacitiesRadioBtn.isSelected());
        this._settingTable.setEnabled(this._gateCapacitiesRadioBtn.isSelected());
        this._settingTable.commitEdit(true);
        this._settingTable.setBackground(this._gateCapacitiesRadioBtn.isSelected() ? Color.white : UIManager.getColor("TextField.disabledBackground"));
    }

    private void buildControls() {
        this.getContentPane().setLayout(new GridBagLayout());
        this._singleCapacityRadioBtn.setMnemonic('S');
        this._gateCapacitiesRadioBtn.setMnemonic('C');
        this._numGateSettingsLabel.setDisplayedMnemonic('N');
        this._numGateSettingsLabel.setLabelFor((Component)this._numGateSettingsCombo);
        this._settingUnitsLabel.setDisplayedMnemonic('G');
        this._settingUnitsLabel.setLabelFor((Component)this._settingUnitsCombo);
        this.setTitle("Gate Settings");
        this.setSize(275, 350);
        this._settingUnitsCombo.addItem((Object)"Percent");
        this._settingUnitsCombo.addItem((Object)"Length");
        for (int i = 1; i <= 50; ++i) {
            this._numGateSettingsCombo.addItem((Object)Integer.toString(i));
        }
        Object object = new String[]{" ", "Setting\n(%S)"};
        GateOpeningsDialog gateOpeningsDialog = this;
        this._settingTable = new GateOpeningsDialog$1(gateOpeningsDialog, (Component)((Object)gateOpeningsDialog), (Object[])object);
        this._settingTable.setUnitsHeaderRenderer();
        this._settingTable.getScrollPane().setVerticalScrollBarPolicy(20);
        this._settingTable.getScrollPane().setHorizontalScrollBarPolicy(30);
        this._settingTable.setColumnWidth(0, 25);
        this._settingTable.setDoubleCellEditor();
        this._settingTable.setAutoRowHeaders(true, 1);
        this._settingTable.setColumnEnabled(false, 0);
        object = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this._singleCapacityRadioBtn, new RmaGridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, c, 0, 0));
        this.getContentPane().add((Component)this._gateCapacitiesRadioBtn, new RmaGridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, c, 0, 0));
        this._gateSpecPanel.setLayout(new GridBagLayout());
        this._gateSpecPanel.setBorder(BorderFactory.createEtchedBorder());
        this._gateSpecPanel.add((Component)this._numGateSettingsLabel, new RmaGridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, b, 0, 0));
        this._gateSpecPanel.add((Component)this._numGateSettingsCombo, new RmaGridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 2, c, 0, 0));
        this._gateSpecPanel.add((Component)this._settingUnitsLabel, new RmaGridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, b, 0, 0));
        this._gateSpecPanel.add((Component)this._settingUnitsCombo, new RmaGridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 18, 2, c, 0, 0));
        this._gateSpecPanel.add((Component)this._settingTable.getScrollPane(), new RmaGridBagConstraints(0, 2, 2, 1, 1.0, 1.0, 18, 1, a, 0, 0));
        this.getContentPane().add((Component)this._gateSpecPanel, new RmaGridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 18, 1, (Insets)object, 0, 0));
        this.getContentPane().add((Component)this._buttonCmdPanel, new RmaGridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 18, 2, (Insets)object, 0, 0));
        object = new ButtonGroup();
        ((ButtonGroup)object).add((AbstractButton)this._singleCapacityRadioBtn);
        ((ButtonGroup)object).add((AbstractButton)this._gateCapacitiesRadioBtn);
        this._singleCapacityRadioBtn.setSelected(true);
        this.capacities_StateChange();
        this._buttonCmdPanel.addCmdPanelListener((ButtonCmdPanelListener)this);
        this._singleCapacityRadioBtn.addItemListener((ItemListener)this);
        this._gateCapacitiesRadioBtn.addItemListener((ItemListener)this);
        this._numGateSettingsCombo.addItemListener((ItemListener)this);
        this._settingUnitsCombo.addItemListener((ItemListener)this);
        this._settingTable.requestFocus();
        this.pack();
        this.setLocation();
    }

    static {
        new Insets(5, 5, 5, 0);
        c = new Insets(5, 5, 0, 5);
    }
}

