/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.clientapp.client.ClientApp;
import hec.rss.RssRmiWorkspace;
import hec.rss.server.RssComputeOptions;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.rmi.RemoteException;
import java.text.DecimalFormat;
import java.util.EventObject;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import rma.swing.ButtonCmdPanel;
import rma.swing.ButtonCmdPanelListener;
import rma.swing.RmaInsets;
import rma.swing.RmaJCheckBox;
import rma.swing.RmaJDecimalField;
import rma.swing.RmaJDialog;
import rma.swing.RmaJIntegerField;

public class GlobalRocEditor
extends RmaJDialog
implements ItemListener,
ButtonCmdPanelListener {
    private ButtonCmdPanel _buttonCmdPanel = new ButtonCmdPanel(2060);
    private RmaJCheckBox _considerROCCheckbox;
    private RmaJCheckBox _iterateNonConstCheckbox;
    private RmaJDecimalField _minLookAheadDaysField;
    private RmaJDecimalField _maxLookAheadDaysField;
    private RmaJIntegerField _maxInterNonConstROCField;
    private RmaJDecimalField _flowTolField;
    private RmaJDecimalField _storTolField;
    private Component _parent;

    public GlobalRocEditor(Component component) {
        this.buildControls();
        this.setTitle("Global ROC Options Editor");
        this.setModal(true);
        this._parent = component;
    }

    private void buildControls() {
        this.setLayout(new GridBagLayout());
        this._considerROCCheckbox = new RmaJCheckBox("Consider  Rate of Change Constraints in Guide Curve Release Computations");
        Cloneable cloneable = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        cloneable.gridy = 0;
        cloneable.gridwidth = 2;
        cloneable.anchor = 18;
        cloneable.fill = 2;
        cloneable.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        GlobalRocEditor globalRocEditor = this;
        globalRocEditor.add((Component)globalRocEditor._considerROCCheckbox, cloneable);
        this._considerROCCheckbox.addItemListener((ItemListener)this);
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(new TitledBorder(""));
        cloneable.gridx = 0;
        cloneable.gridy = 1;
        cloneable.anchor = 18;
        cloneable.fill = 1;
        cloneable.insets = RmaInsets.insets((int)0, (int)5, (int)0, (int)5);
        this.add(jPanel, cloneable);
        JLabel jLabel = new JLabel("Minimum Look Ahead (days):");
        cloneable = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        cloneable.gridy = 3;
        cloneable.anchor = 18;
        cloneable.fill = 0;
        cloneable.insets = RmaInsets.insets((int)5, (int)6, (int)0, (int)5);
        jPanel.add((Component)jLabel, cloneable);
        this._minLookAheadDaysField = new RmaJDecimalField();
        cloneable = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        cloneable.gridy = 3;
        cloneable.anchor = 18;
        cloneable.fill = 2;
        cloneable.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        jPanel.add((Component)this._minLookAheadDaysField, cloneable);
        jLabel = new JLabel("Maximum Look Ahead (days):");
        cloneable = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        cloneable.gridy = 4;
        cloneable.anchor = 18;
        cloneable.fill = 0;
        cloneable.insets = RmaInsets.insets((int)5, (int)6, (int)0, (int)5);
        jPanel.add((Component)jLabel, cloneable);
        this._maxLookAheadDaysField = new RmaJDecimalField();
        cloneable = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        cloneable.gridy = 4;
        cloneable.anchor = 18;
        cloneable.fill = 2;
        cloneable.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        jPanel.add((Component)this._maxLookAheadDaysField, cloneable);
        this._iterateNonConstCheckbox = new RmaJCheckBox("Allow Iterations for Variable ROC");
        cloneable = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        cloneable.gridy = 5;
        cloneable.anchor = 18;
        cloneable.fill = 2;
        cloneable.insets = RmaInsets.insets((int)5, (int)3, (int)0, (int)5);
        jPanel.add((Component)this._iterateNonConstCheckbox, cloneable);
        this._iterateNonConstCheckbox.addItemListener((ItemListener)this);
        jLabel = new JLabel("Maximum Iterations:");
        cloneable = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        cloneable.gridy = 6;
        cloneable.anchor = 18;
        cloneable.fill = 0;
        cloneable.insets = RmaInsets.insets((int)5, (int)30, (int)0, (int)5);
        jPanel.add((Component)jLabel, cloneable);
        this._maxInterNonConstROCField = new RmaJIntegerField();
        cloneable = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        cloneable.gridy = 6;
        cloneable.anchor = 18;
        cloneable.fill = 2;
        cloneable.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        jPanel.add((Component)this._maxInterNonConstROCField, cloneable);
        jLabel = new JLabel("Flow Tolerance:");
        cloneable = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        cloneable.gridy = 7;
        cloneable.anchor = 18;
        cloneable.fill = 0;
        cloneable.insets = RmaInsets.insets((int)5, (int)30, (int)0, (int)5);
        jPanel.add((Component)jLabel, cloneable);
        this._flowTolField = new RmaJDecimalField();
        this._flowTolField.setMinValue(1.0E-15);
        cloneable = this._flowTolField.getDecimalFormatter();
        ((DecimalFormat)cloneable).setMaximumFractionDigits(15);
        this._flowTolField.setDecimalFormat((DecimalFormat)cloneable);
        cloneable = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        cloneable.gridy = 7;
        cloneable.anchor = 18;
        cloneable.fill = 2;
        cloneable.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        jPanel.add((Component)this._flowTolField, cloneable);
        jLabel = new JLabel("Storage Tolerance:");
        cloneable = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        cloneable.gridy = 8;
        cloneable.anchor = 18;
        cloneable.fill = 0;
        cloneable.insets = RmaInsets.insets((int)5, (int)30, (int)0, (int)5);
        jPanel.add((Component)jLabel, cloneable);
        this._storTolField = new RmaJDecimalField();
        this._storTolField.setMinValue(1.0E-15);
        cloneable = this._storTolField.getDecimalFormatter();
        ((DecimalFormat)cloneable).setMaximumFractionDigits(15);
        this._storTolField.setDecimalFormat((DecimalFormat)cloneable);
        cloneable = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        cloneable.gridy = 8;
        cloneable.weightx = 1.0;
        cloneable.weighty = 1.0;
        cloneable.anchor = 18;
        cloneable.fill = 2;
        cloneable.insets = RmaInsets.insets((int)5, (int)5, (int)5, (int)5);
        jPanel.add((Component)this._storTolField, cloneable);
        cloneable = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        cloneable.gridy = 9;
        cloneable.gridwidth = 3;
        cloneable.anchor = 13;
        cloneable.fill = 2;
        cloneable.insets = RmaInsets.insets((int)5, (int)5, (int)5, (int)5);
        GlobalRocEditor globalRocEditor2 = this;
        globalRocEditor2.add((Component)globalRocEditor2._buttonCmdPanel, cloneable);
        this._buttonCmdPanel.getButton("Remove").setText("Reset Default Values");
        this._buttonCmdPanel.addCmdPanelListener((ButtonCmdPanelListener)this);
        this.pack();
        GlobalRocEditor globalRocEditor3 = this;
        globalRocEditor3.setLocationRelativeTo(globalRocEditor3._parent);
    }

    public void fill(RssComputeOptions rssComputeOptions) {
        this._considerROCCheckbox.setSelected(rssComputeOptions.getConsiderROC());
        this._iterateNonConstCheckbox.setSelected(rssComputeOptions.getIterateNonConstantROC());
        this._minLookAheadDaysField.setValue(rssComputeOptions.getMinLookAheadDays());
        this._maxLookAheadDaysField.setValue(rssComputeOptions.getMaxLookAheadDays());
        this._maxInterNonConstROCField.setValue(rssComputeOptions.getMaxIterNonConstROC());
        this._flowTolField.setValue(rssComputeOptions.getFlowTol());
        this._storTolField.setValue(rssComputeOptions.getStorTol());
        if (this._considerROCCheckbox.isSelected()) {
            this._maxLookAheadDaysField.setEnabled(true);
            this._minLookAheadDaysField.setEnabled(true);
            this._iterateNonConstCheckbox.setEnabled(true);
            if (this._iterateNonConstCheckbox.isSelected()) {
                this._maxInterNonConstROCField.setEnabled(true);
                this._flowTolField.setEnabled(true);
                this._storTolField.setEnabled(true);
                return;
            }
            this._maxInterNonConstROCField.setEnabled(false);
            this._flowTolField.setEnabled(false);
            this._storTolField.setEnabled(false);
            return;
        }
        this._maxLookAheadDaysField.setEnabled(false);
        this._minLookAheadDaysField.setEnabled(false);
        this._iterateNonConstCheckbox.setEnabled(false);
        this._maxInterNonConstROCField.setEnabled(false);
        this._flowTolField.setEnabled(false);
        this._storTolField.setEnabled(false);
    }

    public void buttonCmdActionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getID() == 8) {
            this.save();
            this.setVisible(false);
            this.dispose();
            return;
        }
        if (actionEvent.getID() == 4) {
            this.setVisible(false);
            this.dispose();
            return;
        }
        this.resetDefaults();
    }

    private void save() {
        RssComputeOptions rssComputeOptions = this.getOptions();
        rssComputeOptions.setConsiderROC(this._considerROCCheckbox.isSelected());
        rssComputeOptions.setIterateNonConstantROC(this._iterateNonConstCheckbox.isSelected());
        rssComputeOptions.setMinLookAheadDays(this._minLookAheadDaysField.getValue());
        rssComputeOptions.setMaxLookAheadDays(this._maxLookAheadDaysField.getValue());
        rssComputeOptions.setMaxIterNonConstROC(this._maxInterNonConstROCField.getValue());
        rssComputeOptions.setFlowTol(this._flowTolField.getValue());
        rssComputeOptions.setStorTol(this._storTolField.getValue());
        rssComputeOptions = ClientApp.Workspace();
        rssComputeOptions.setModified(true);
    }

    private RssComputeOptions getOptions() {
        Object object = ClientApp.Workspace();
        if (object == null) {
            return null;
        }
        if ((object = (RssRmiWorkspace)object.getChildWorkspace("rss")) == null) {
            return null;
        }
        try {
            object = object.getRssComputeOptions();
        }
        catch (RemoteException remoteException) {
            StringBuffer stringBuffer = new StringBuffer("An error occured while trying to get the ResSim Compute Options to the server.\n");
            stringBuffer.append(remoteException.getMessage());
            JOptionPane.showMessageDialog((Component)((Object)this), stringBuffer.toString(), "Error!", 0);
            return null;
        }
        return object;
    }

    private void resetDefaults() {
        RssComputeOptions rssComputeOptions = this.getOptions();
        rssComputeOptions.resetROCDefaults();
        this.fill(rssComputeOptions);
        this.repaint();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void itemStateChanged(ItemEvent object) {
        if ((object = ((EventObject)object).getSource()) == this._considerROCCheckbox) {
            if (this._considerROCCheckbox.isSelected()) {
                this._maxLookAheadDaysField.setEnabled(true);
                this._minLookAheadDaysField.setEnabled(true);
                this._iterateNonConstCheckbox.setEnabled(true);
                if (this._iterateNonConstCheckbox.isSelected()) {
                    this._maxInterNonConstROCField.setEnabled(true);
                    this._flowTolField.setEnabled(true);
                    this._storTolField.setEnabled(true);
                    return;
                }
                this._maxInterNonConstROCField.setEnabled(false);
                this._flowTolField.setEnabled(false);
                this._storTolField.setEnabled(false);
                return;
            }
            this._maxLookAheadDaysField.setEnabled(false);
            this._minLookAheadDaysField.setEnabled(false);
            this._iterateNonConstCheckbox.setEnabled(false);
        } else {
            if (object != this._iterateNonConstCheckbox) return;
            if (this._iterateNonConstCheckbox.isSelected()) {
                this._maxInterNonConstROCField.setEnabled(true);
                this._flowTolField.setEnabled(true);
                this._storTolField.setEnabled(true);
                return;
            }
        }
        this._maxInterNonConstROCField.setEnabled(false);
        this._flowTolField.setEnabled(false);
        this._storTolField.setEnabled(false);
    }
}

