/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.clientapp.client.ClientApp;
import hec.data.ParamDouble;
import hec.data.Parameter;
import hec.model.ParamDoubleTableModel;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.table.TableModel;
import rma.swing.ButtonCmdPanel;
import rma.swing.ButtonCmdPanelListener;
import rma.swing.RmaGridBagConstraints;
import rma.swing.RmaJDecimalField;
import rma.swing.RmaJDialog;
import rma.swing.RmaJTable;

public class HillCurveFlowsDialog
extends RmaJDialog
implements ButtonCmdPanelListener {
    double[] _values = null;
    boolean _useRateOfRise;
    double _lookbackHours = 1.0;
    RmaJTable _settingTable;
    ButtonCmdPanel _buttonCmdPanel = new ButtonCmdPanel(12);
    boolean _isOk = false;

    public HillCurveFlowsDialog(Dialog dialog, boolean bl) {
        super(dialog, bl);
        this.setTitle("Specify Inflows for Hill Curve");
        this.buildControls();
    }

    public HillCurveFlowsDialog(Frame frame, boolean bl) {
        super(frame, bl);
        this.setTitle("Specify Inflows for Hill Curve");
    }

    protected void buildControls() {
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Specify Inflows for Hill Curve");
        this.setSize(220, 350);
        Object object = new String[]{" ", "Setting\n(%S)"};
        int[] nArray = new int[]{-1, Parameter.PARAMID_FLOW};
        object = new ParamDoubleTableModel(object, nArray, new boolean[]{false, true});
        this._settingTable = new RmaJTable((Component)((Object)this));
        this._settingTable.setModel((TableModel)object);
        this._settingTable.setUnitsHeaderRenderer();
        this._settingTable.getScrollPane().setVerticalScrollBarPolicy(20);
        this._settingTable.getScrollPane().setHorizontalScrollBarPolicy(30);
        this._settingTable.setDoubleCellEditor(1);
        this._settingTable.setNumRows(8);
        this._settingTable.setRowHeaderEnabled(true);
        this._settingTable.setAutoRowHeaders(true, 1);
        this._settingTable.setColumnWidth(0, 10);
        this.getContentPane().add((Component)this._settingTable.getScrollPane(), new RmaGridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 1, new Insets(5, 5, 0, 5), 0, 0));
        object = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this._buttonCmdPanel, new RmaGridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 14, 0, (Insets)object, 0, 0));
        this._buttonCmdPanel.addCmdPanelListener((ButtonCmdPanelListener)this);
        this.setLocation();
    }

    public void fillForm(double[] dArray, int n, boolean n2, double d, double d2) {
        ParamDoubleTableModel cfr_ignored_0 = (ParamDoubleTableModel)this._settingTable.getModel();
        RmaJDecimalField rmaJDecimalField = this._settingTable.setDoubleCellEditor(1);
        rmaJDecimalField.setMinValue(d2);
        this._useRateOfRise = n2;
        this._settingTable.setColumnLabel(1, "Turbine Flow\n(%S)");
        this._settingTable.setColumnParameters(new int[]{-1, Parameter.PARAMID_FLOW});
        ((ParamDoubleTableModel)this._settingTable.getModel()).setUnitSystem(ClientApp.app().getClientUnitSystem());
        int n3 = this._settingTable.getModel().getRowCount();
        for (n2 = 0; n2 < n3; ++n2) {
            this._settingTable.setCell((Object)"", n2, 1);
        }
        if (dArray == null || dArray.length <= 0) {
            return;
        }
        for (n2 = 0; n2 < dArray.length; ++n2) {
            this._settingTable.setValueAt((Object)Double.toString(dArray[n2]), n2, 1);
        }
    }

    public boolean saveForm() {
        int n;
        int n2;
        this._settingTable.commitEdit(true);
        ParamDoubleTableModel paramDoubleTableModel = (ParamDoubleTableModel)this._settingTable.getModel();
        Vector vector = new Vector(paramDoubleTableModel.getDataVector());
        int n3 = 0;
        for (n2 = 0; n2 < vector.size(); ++n2) {
            Vector vector2 = (Vector)vector.elementAt(n2);
            Object e = vector2.elementAt(1);
            if (e == null || e.toString().equals("")) continue;
            ++n3;
        }
        this._values = new double[n3];
        int n4 = 0;
        for (n = 0; n < vector.size(); ++n) {
            Vector vector3 = (Vector)vector.elementAt(n);
            Object object = vector3.elementAt(1);
            if (object == null || object.toString().equals("")) continue;
            object = (ParamDouble)paramDoubleTableModel.getValueAt(n, 1);
            this._values[n4] = object.getValue();
            ++n4;
        }
        for (n = 0; n < this._values.length - 1; ++n) {
            if (!(this._values[n + 1] <= this._values[n])) continue;
            String string = this._settingTable.getColumnLabel(1);
            n2 = string.indexOf("\n");
            if (n2 >= 0) {
                string = string.substring(0, n2);
            }
            JOptionPane.showMessageDialog((Component)((Object)this), "The " + string + " values of your function must be a continuously increasing sequence.", "Error", 0);
            return false;
        }
        if (this._useRateOfRise) {
            this._lookbackHours = 1.0;
        }
        return true;
    }

    public double[] getTableValues() {
        return this._values;
    }

    public double getLookbackHours() {
        return this._lookbackHours;
    }

    public void clearForm() {
    }

    public void setOk(boolean bl) {
        this._isOk = bl;
    }

    public boolean isOk() {
        return this._isOk;
    }

    public void buttonCmdActionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getID() == 8) {
            this.cmdOK_Action();
            return;
        }
        if (actionEvent.getID() == 4) {
            this.cmdCancel_Action();
        }
    }

    public void cmdOK_Action() {
        if (!this.saveForm()) {
            return;
        }
        this.setOk(true);
        this.setVisible(false);
    }

    public void cmdCancel_Action() {
        this._settingTable.commitEdit(true);
        this.setOk(false);
        this.setVisible(false);
    }

    static {
        new Insets(5, 5, 5, 5);
        new Insets(5, 5, 0, 0);
        new Insets(5, 5, 5, 0);
        new Insets(5, 5, 0, 5);
    }
}

