/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.data.ParamDouble;
import hec.data.Parameter;
import hec.rss.model.InducedSurchargeOpRule;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.Serializable;
import java.util.EventObject;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import rma.swing.RmaGridBagConstraints;
import rma.swing.RmaInsets;
import rma.swing.RmaJDecimalField;
import rma.swing.RmaJDialog;
import rma.swing.RmaJLabel;
import rma.swing.RmaJRadioButton;
import rma.swing.RmaJTextField;

public class ISFallingPoolDialog
extends RmaJDialog
implements ActionListener,
ItemListener {
    InducedSurchargeOpRule _rule = null;
    private boolean _okPressed = false;
    JButton _ok_jB = new JButton("OK");
    JButton _cancel_jB = new JButton("Cancel");
    RmaJRadioButton jRadio_peakRelease = new RmaJRadioButton("Maintain Peak Release");
    RmaJRadioButton jRadio_peakGate = new RmaJRadioButton("Maintain Peak Gate Openings");
    RmaJRadioButton jRadio_ratioInflow = new RmaJRadioButton("Ratio of Inflow");
    RmaJRadioButton jRadio_avgInflowOutflow = new RmaJRadioButton("Avg of Inflow and Previous Release");
    RmaJTextField nameTxt = new RmaJTextField();
    RmaJDecimalField jThresholdPeriodTxt = new RmaJDecimalField();
    RmaJDecimalField jTransitionElevTxt = new RmaJDecimalField();
    RmaJDecimalField jRatioValueTxt = new RmaJDecimalField();
    RmaJDecimalField jRatioPeriodTxt = new RmaJDecimalField();
    RmaJDecimalField jAvgPeriodTxt = new RmaJDecimalField();
    RmaJLabel jRatioValueLabel = new RmaJLabel("Release");
    RmaJLabel jRatioValueLabel2 = new RmaJLabel("times Inflow averaged over");
    RmaJLabel jRatioPeriodLabel = new RmaJLabel("hours");
    RmaJLabel jAvgPeriodLabel = new RmaJLabel("Inflow averaged over");
    RmaJLabel jAvgPeriodLabel2 = new RmaJLabel("hours");
    RmaJLabel jThresholdPeriodLabel = new RmaJLabel("Time for Pool Decrease (hrs)");
    RmaJLabel jTransitionElevLabel = new RmaJLabel("Falling Pool Transition Elev (%S):");

    public ISFallingPoolDialog(Dialog dialog, boolean bl) {
        super(dialog, bl);
        this.buildControls();
    }

    private void buildControls() {
        this.getContentPane().setLayout(new GridBagLayout());
        this.setSize(400, 400);
        this.setTitle("Induced Surcharge - Falling Pool Options");
        Serializable serializable = new Insets(5, 5, 5, 5);
        Serializable serializable2 = new Insets(5, 5, 0, 5);
        Insets insets = new Insets(0, 5, 0, 5);
        Insets insets2 = new Insets(2, 5, 2, 5);
        Insets insets3 = new Insets(0, 0, 0, 0);
        new GridBagConstraints();
        RmaInsets.insets((int)1, (int)5, (int)1, (int)0);
        RmaInsets.insets((int)0, (int)5, (int)0, (int)5);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)this.jThresholdPeriodLabel, new RmaGridBagConstraints(0, 0, 1, 0, 0.0, 0.0, 18, 0, insets2, 0, 0));
        jPanel.add((Component)this.jThresholdPeriodTxt, new RmaGridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 2, insets2, 20, 0));
        jPanel.add((Component)this.jTransitionElevLabel, new RmaGridBagConstraints(0, 1, 1, 0, 0.0, 0.0, 18, 0, insets2, 0, 0));
        jPanel.add((Component)this.jTransitionElevTxt, new RmaGridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 18, 2, insets2, 20, 0));
        this.jTransitionElevLabel.setLabelFor((Component)this.jTransitionElevTxt);
        this.getContentPane().add((Component)jPanel, new RmaGridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 2, 5), 0, 0));
        jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)this.jRadio_ratioInflow, new RmaGridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 0, (Insets)serializable2, 0, 0));
        jPanel.add((Component)this.jRadio_avgInflowOutflow, new RmaGridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 18, 0, (Insets)serializable2, 0, 0));
        jPanel.add((Component)this.jRadio_peakRelease, new RmaGridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 18, 0, (Insets)serializable, 0, 0));
        jPanel.add((Component)this.jRadio_peakGate, new RmaGridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 18, 0, (Insets)serializable, 0, 0));
        serializable2 = new JPanel();
        ((Container)serializable2).setLayout(new GridBagLayout());
        ((Container)serializable2).add((Component)this.jRatioValueLabel, new RmaGridBagConstraints(0, 0, 1, 0, 0.0, 0.0, 18, 0, insets3, 0, 0));
        ((Container)serializable2).add((Component)this.jRatioValueTxt, new RmaGridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 2, insets, 35, 0));
        ((Container)serializable2).add((Component)this.jRatioValueLabel2, new RmaGridBagConstraints(2, 0, 1, 0, 0.0, 0.0, 18, 0, insets3, 0, 0));
        ((Container)serializable2).add((Component)this.jRatioPeriodTxt, new RmaGridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 18, 2, insets, 35, 0));
        ((Container)serializable2).add((Component)this.jRatioPeriodLabel, new RmaGridBagConstraints(4, 0, 1, 0, 0.0, 0.0, 18, 0, insets3, 0, 0));
        jPanel.add((Component)serializable2, new RmaGridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 18, 0, new Insets(0, 25, 10, 5), 0, 0));
        serializable2 = new JPanel();
        ((Container)serializable2).setLayout(new GridBagLayout());
        ((Container)serializable2).add((Component)this.jAvgPeriodLabel, new RmaGridBagConstraints(0, 0, 1, 0, 0.0, 0.0, 18, 0, insets3, 0, 0));
        ((Container)serializable2).add((Component)this.jAvgPeriodTxt, new RmaGridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 2, insets, 35, 0));
        ((Container)serializable2).add((Component)this.jAvgPeriodLabel2, new RmaGridBagConstraints(2, 0, 1, 0, 0.0, 0.0, 18, 0, insets3, 0, 0));
        jPanel.add((Component)serializable2, new RmaGridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 18, 0, new Insets(0, 25, 10, 5), 0, 0));
        this.getContentPane().add((Component)jPanel, new RmaGridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 18, 2, insets2, 0, 0));
        jPanel.setBorder(new TitledBorder("Release Options"));
        serializable2 = new JPanel();
        this.getContentPane().add((Component)serializable2, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 15, 2, insets3, 0, 0));
        ((Container)serializable2).add(this._ok_jB, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, (Insets)serializable, 20, 0));
        ((Container)serializable2).add(this._cancel_jB, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 2, (Insets)serializable, 10, 0));
        serializable = new ButtonGroup();
        ((ButtonGroup)serializable).add((AbstractButton)this.jRadio_peakGate);
        ((ButtonGroup)serializable).add((AbstractButton)this.jRadio_ratioInflow);
        ((ButtonGroup)serializable).add((AbstractButton)this.jRadio_avgInflowOutflow);
        ((ButtonGroup)serializable).add((AbstractButton)this.jRadio_peakRelease);
        this.jRadio_peakRelease.setSelected(true);
        this._ok_jB.addActionListener(this);
        this._cancel_jB.addActionListener(this);
        this.pack();
        serializable = this.getPreferredSize();
        this.setSize(((Dimension)serializable).width, ((Dimension)serializable).height);
        this.setDefaultSize(((Dimension)serializable).width, ((Dimension)serializable).height);
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        itemEvent.getSource();
        if (itemEvent.getStateChange() != 1) {
            return;
        }
    }

    @Override
    public void actionPerformed(ActionEvent object) {
        if ((object = ((EventObject)object).getSource()) == this._ok_jB) {
            this.ok_actionPerfomed();
            return;
        }
        if (object == this._cancel_jB) {
            this.cancel_actionPerfomed();
        }
    }

    void ok_actionPerfomed() {
        boolean bl = this.saveForm();
        if (bl) {
            this._okPressed = true;
            this.setVisible(false);
        }
    }

    void cancel_actionPerfomed() {
        this._okPressed = false;
        this.setVisible(false);
    }

    public boolean isOk() {
        return this._okPressed;
    }

    public void setData(InducedSurchargeOpRule inducedSurchargeOpRule) {
        if (inducedSurchargeOpRule == null) {
            return;
        }
        this._rule = inducedSurchargeOpRule;
        this.fillForm();
    }

    public void fillForm() {
        if (this._rule == null) {
            return;
        }
        this.jThresholdPeriodTxt.setValue(this._rule.getFallingPoolThresholdTime());
        ParamDouble paramDouble = new ParamDouble(this._rule.getTopOfFloodControlPool(), Parameter.PARAMID_ELEV, 1, 1);
        this.jTransitionElevTxt.setValue(paramDouble);
        this.jRatioValueTxt.setValue(this._rule.getRatio());
        this.jRatioPeriodTxt.setValue(this._rule.getRatioPeriod());
        this.jAvgPeriodTxt.setValue(this._rule.getInflowAvgPeriod());
        int n = this._rule.getFallingPoolOption();
        if (n == 0) {
            this.jRadio_ratioInflow.setSelected(true);
        } else if (n == 1) {
            this.jRadio_avgInflowOutflow.setSelected(true);
        } else if (n == 2) {
            this.jRadio_peakGate.setSelected(true);
        } else if (n == 3) {
            this.jRadio_peakRelease.setSelected(true);
        }
        this.setModified(false);
    }

    private boolean saveForm() {
        int n = -1;
        if (this.jThresholdPeriodTxt.getValueUndefined() == Double.NEGATIVE_INFINITY) {
            JOptionPane.showMessageDialog((Component)((Object)this), "The Time for Pool Decrease must be defined.", "Input Data Missing", 0);
            return false;
        }
        if (this.jTransitionElevTxt.getValueUndefined() == Double.NEGATIVE_INFINITY) {
            JOptionPane.showMessageDialog((Component)((Object)this), "The Falling Pool Transition Elevation must be defined.", "Input Data Missing", 0);
            return false;
        }
        if (this.jRadio_ratioInflow.isSelected()) {
            if (this.jRatioValueTxt.getValueUndefined() == Double.NEGATIVE_INFINITY || this.jRatioPeriodTxt.getValueUndefined() == Double.NEGATIVE_INFINITY) {
                JOptionPane.showMessageDialog((Component)((Object)this), "The Ratio of Inflow option must have all input fields defined.", "Input Data Missing", 0);
                return false;
            }
            n = 0;
        }
        if (this.jRadio_avgInflowOutflow.isSelected()) {
            if (this.jAvgPeriodTxt.getValueUndefined() == Double.NEGATIVE_INFINITY) {
                JOptionPane.showMessageDialog((Component)((Object)this), "The Average of Inflow option must the hours defined.", "Input Data Missing", 0);
                return false;
            }
            n = 1;
        }
        if (this.jRadio_peakGate.isSelected()) {
            n = 2;
        }
        if (this.jRadio_peakRelease.isSelected()) {
            n = 3;
        }
        this._rule.setFallingPoolOption(n);
        this._rule.setFallingPoolThresholdTime(this.jThresholdPeriodTxt.getValueUndefined());
        this._rule.setTopOfFloodControlPool(this.jTransitionElevTxt.getValueUndefined());
        this._rule.setRatio(this.jRatioValueTxt.getValueUndefined());
        this._rule.setRatioPeriod(this.jRatioPeriodTxt.getValueUndefined());
        this._rule.setInflowAvgPeriod(this.jAvgPeriodTxt.getValueUndefined());
        this.setModified(false);
        return true;
    }

    public boolean getOkPressed() {
        return this._okPressed;
    }

    boolean saveData() {
        return true;
    }

    public void setVisible(boolean bl) {
        if (bl) {
            this.setLocation();
        }
        super.setVisible(bl);
    }

    public static void a(String[] object) {
        try {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
        }
        catch (Exception exception) {}
        object = new ISFallingPoolDialog(null, false);
        InducedSurchargeOpRule inducedSurchargeOpRule = new InducedSurchargeOpRule();
        inducedSurchargeOpRule.setFallingPoolOption(1);
        inducedSurchargeOpRule.setInflowAvgPeriod(2.0);
        inducedSurchargeOpRule.setFallingPoolThresholdTime(3.5);
        ((ISFallingPoolDialog)object).setData(inducedSurchargeOpRule);
        ((ISFallingPoolDialog)object).setVisible(true);
        ((ISFallingPoolDialog)object).setData(null);
    }
}

