/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.client.SummaryWizardPanel;
import hec.clientapp.client.ClientApp;
import hec.clientapp.client.ClientWorkspace;
import hec.clientapp.model.Manager;
import hec.clientapp.model.SimulationRun;
import hec.clientapp.model.StreamAlignment;
import hec.clientapp.model.TSDataSet;
import hec.gui.WizardDialog;
import hec.gui.WizardPanel;
import hec.io.Identifier;
import hec.lang.ModelReference;
import hec.lang.NamedType;
import hec.model.AltItem;
import hec.rss.client.AssignStreamStationingPanel;
import hec.rss.client.NewAlternativePanel;
import hec.rss.client.NewNetworkPanel;
import hec.rss.client.PickWatershedWizardPanel;
import hec.rss.client.RSimNetworkMode;
import hec.rss.client.ResolveComputationPointsPanel;
import hec.rss.client.SelectManagerWizardPanel;
import hec.rss.model.DiversionElement;
import hec.rss.model.DivertedOutletElement;
import hec.rss.model.Element;
import hec.rss.model.JunctionElement;
import hec.rss.model.ReservoirElement;
import hec.rss.model.RssAlt;
import hec.rss.model.RssSimRun;
import hec.rss.model.RssSystem;
import hec.rss.model.RuleResolution;
import hec.supplemental.model.ProgramOrderItem;
import hec.watershed.model.ComputationPoint;
import hec.watershed.model.Condition;
import hec.watershed.model.ConditionDataList;
import hec.watershed.model.Diversion;
import hec.watershed.model.ModelAlt;
import hec.watershed.model.Reservoir;
import hec.watershed.model.Study;
import hec.watershed.model.StudyDataList;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.Rectangle;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.JOptionPane;
import mil.army.usace.hec.rmi.csinterface.RmiFileManager;
import rma.util.RMAIO;

public class ImportAlternativeDialog
extends WizardDialog {
    protected NewNetworkPanel _newNetworkPanel;
    protected NewAlternativePanel _newAlternativePanel;
    protected PickWatershedWizardPanel _selectWatershedPanel;
    protected SelectManagerWizardPanel _selectAlternativePanel;
    protected AssignStreamStationingPanel _assignStreamsPanel;
    protected ResolveComputationPointsPanel _resolveComputationPointsPanel;
    protected SummaryWizardPanel _summaryPanel;
    protected NamedType[] _selectedElements;
    protected ClientWorkspace _importFromWksp;
    protected RssAlt _importFromAlternative;
    protected RssSimRun _importFromSimRun;
    protected RssAlt _newAlternative;
    protected RssSystem _importFromNetwork;
    protected RssSystem _importToNetwork;
    protected StreamAlignment _streamAlignment;
    protected ConditionDataList _conditionList;
    protected boolean _canceled = false;
    protected boolean _initializedOk = this.init();

    public ImportAlternativeDialog(Frame frame, boolean bl) {
        super(frame, bl);
    }

    protected void buildControls() {
        super.buildControls();
        this.buildSelectWatershedPanel();
        this.buildSelectAlternativePanel();
        this.buildNewAlternativePanel();
        this.buildNewNetworkPanel();
        this.buildAssignElementsPanel();
        this.buildResolveComputationPointsPanel();
        this.buildSummaryPanel();
        this.pack();
        String string = ClientApp.app().getAppProp("ImportDialog.Width");
        String string2 = ClientApp.app().getAppProp("ImportDialog.Height");
        Object object = ClientApp.app().getAppProp("ImportDialog.X");
        Object object2 = ClientApp.app().getAppProp("ImportDialog.Y");
        int n = this.getWidth();
        int n2 = this.getHeight();
        if (string != null && string2 != null) {
            n = RMAIO.parseInt((String)string, (int)this.getWidth());
            n2 = RMAIO.parseInt((String)string2, (int)this.getHeight());
            this.setSize(n, n2);
        }
        ImportAlternativeDialog importAlternativeDialog = this;
        importAlternativeDialog.setLocationRelativeTo(importAlternativeDialog.getParent());
        if (object != null && object2 != null) {
            int n3 = RMAIO.parseInt((String)object, (int)this.getX());
            int n4 = RMAIO.parseInt((String)object2, (int)this.getY());
            object = this.getParent();
            object = object != null ? ((Component)object).getGraphicsConfiguration() : ClientApp.frame().getGraphicsConfiguration();
            object2 = new Rectangle(n3, n4, n, n2);
            if (((Rectangle)object2).intersects((Rectangle)(object = ((GraphicsConfiguration)object).getBounds()))) {
                this.setLocation(n3, n4);
            }
        }
        super.setTitle("Import Network Elements");
    }

    public void setTitle(String string) {
        string = String.valueOf(this.getCurrentStep());
        string = "Import Alternative Wizard - Step X of 7".replace('X', string.charAt(0));
        super.setTitle(string);
    }

    protected void buildSelectWatershedPanel() {
        this._selectWatershedPanel = new PickWatershedWizardPanel();
        this._selectWatershedPanel.setNextPanelName("SelectManager");
        this._selectWatershedPanel.setAppServer(ClientApp.app().getAppServer());
        ImportAlternativeDialog importAlternativeDialog = this;
        importAlternativeDialog.addWizardPanel(importAlternativeDialog._selectWatershedPanel);
    }

    protected void buildSelectAlternativePanel() {
        this._selectAlternativePanel = new SelectManagerWizardPanel(RssAlt.class.getName(), "rss", "Alternatives");
        this._selectAlternativePanel.setPanelTitle("Select the Alternative to Import");
        this._selectAlternativePanel.setBackPanelName("SelectWatershed");
        this._selectAlternativePanel.setNextPanelName("NewAlternative");
        ImportAlternativeDialog importAlternativeDialog = this;
        importAlternativeDialog.addWizardPanel(importAlternativeDialog._selectAlternativePanel);
    }

    protected void buildNewAlternativePanel() {
        this._newAlternativePanel = new NewAlternativePanel();
        this._newAlternativePanel.setBackPanelName("SelectManager");
        this._newAlternativePanel.setNextPanelName("NewNetwork");
        this._newAlternativePanel.setManagerType("rss", RssAlt.class.getName(), "ResSim Alternative", ".ralt");
        ImportAlternativeDialog importAlternativeDialog = this;
        importAlternativeDialog.addWizardPanel(importAlternativeDialog._newAlternativePanel);
    }

    protected void buildNewNetworkPanel() {
        this._newNetworkPanel = new NewNetworkPanel();
        this._newNetworkPanel.setBackPanelName("NewAlternative");
        this._newNetworkPanel.setNextPanelName("AssignStreams");
        this._newNetworkPanel.setManagerType("rss", RSimNetworkMode.NETWORK_CLASSNAME, "Reservoir Network", "rsys");
        ImportAlternativeDialog importAlternativeDialog = this;
        importAlternativeDialog.addWizardPanel(importAlternativeDialog._newNetworkPanel);
    }

    protected void buildAssignElementsPanel() {
        this._assignStreamsPanel = new AssignStreamStationingPanel();
        this._assignStreamsPanel.setBackPanelName("NewNetwork");
        this._assignStreamsPanel.setNextPanelName("ResolveComputationPoints");
        ImportAlternativeDialog importAlternativeDialog = this;
        importAlternativeDialog.addWizardPanel(importAlternativeDialog._assignStreamsPanel);
    }

    protected void buildResolveComputationPointsPanel() {
        this._resolveComputationPointsPanel = new ResolveComputationPointsPanel();
        this._resolveComputationPointsPanel.setBackPanelName("AssignStreams");
        this._resolveComputationPointsPanel.setNextPanelName("Summary");
        ImportAlternativeDialog importAlternativeDialog = this;
        importAlternativeDialog.addWizardPanel(importAlternativeDialog._resolveComputationPointsPanel);
    }

    protected void buildSummaryPanel() {
        this._summaryPanel = new SummaryWizardPanel();
        this._summaryPanel.setPanelTitle("Import Summary");
        this._summaryPanel.setBackPanelName("ResolveComputationPoints");
        ImportAlternativeDialog importAlternativeDialog = this;
        importAlternativeDialog.addWizardPanel((WizardPanel)importAlternativeDialog._summaryPanel);
    }

    protected int getCurrentStep() {
        WizardPanel wizardPanel = this.getCurrentPanel();
        if (wizardPanel == this._selectWatershedPanel) {
            return 1;
        }
        if (wizardPanel == this._selectAlternativePanel) {
            return 2;
        }
        if (wizardPanel == this._newAlternativePanel) {
            return 3;
        }
        if (wizardPanel == this._newNetworkPanel) {
            return 4;
        }
        if (wizardPanel == this._assignStreamsPanel) {
            return 5;
        }
        if (wizardPanel == this._resolveComputationPointsPanel) {
            return 6;
        }
        return 7;
    }

    protected void changingPanels(String string) {
        WizardPanel wizardPanel = this.getCurrentPanel();
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            if (wizardPanel == this._selectWatershedPanel && "SelectManager".equals(string)) {
                this.openWorkspace();
            } else if (wizardPanel == this._selectAlternativePanel && "NewAlternative".equals(string)) {
                if (this.openAlternative()) {
                    this._newAlternativePanel.setAlternativeName(this._importFromAlternative.getName());
                    this._newAlternativePanel.setAlternativeDescription(this._importFromAlternative.getDescription());
                } else {
                    this._newAlternativePanel.setAlternativeName("");
                    this._newAlternativePanel.setAlternativeDescription("");
                }
            } else if (wizardPanel == this._newAlternativePanel && "NewNetwork".equals(string)) {
                if (this.openNetwork()) {
                    this._newNetworkPanel.setNetworkName(this._importFromNetwork.getName());
                    this._newNetworkPanel.setNetworkDescription(this._importFromNetwork.getDescription());
                } else {
                    this._newNetworkPanel.setNetworkName("");
                    this._newNetworkPanel.setNetworkDescription("");
                }
            } else if (wizardPanel == this._newNetworkPanel && "AssignStreams".equals(string)) {
                string = ClientApp.Workspace();
                this._assignStreamsPanel.setWorkspace((ClientWorkspace)string);
                this._assignStreamsPanel.setNewNetworkName(this._newNetworkPanel.getNewNetworkName());
            } else if (wizardPanel == this._assignStreamsPanel && "ResolveComputationPoints".equals(string)) {
                this._assignStreamsPanel.saveImportNetworkStreams(true);
                string = ClientApp.Workspace();
                this._resolveComputationPointsPanel.setWorkspace((ClientWorkspace)string);
                this._resolveComputationPointsPanel.setNewNetworkName(this._newNetworkPanel.getNewNetworkName());
                this._resolveComputationPointsPanel.setImportFromNetwork(this._importFromNetwork);
            } else if (wizardPanel == this._resolveComputationPointsPanel && "Summary".equals(string)) {
                this.createSummaryText();
            }
            return;
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    protected boolean init() {
        Study study = null;
        ClientWorkspace clientWorkspace = ClientApp.Workspace();
        if (clientWorkspace == null) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Failed to Find the current watershed");
            return false;
        }
        StudyDataList studyDataList = (StudyDataList)clientWorkspace.getDataListContainer().getDataList(Study.class.getName());
        if (studyDataList != null) {
            study = (Study)studyDataList.getOpenStudy();
        }
        if (studyDataList == null || study == null) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Failed to Find the Study Data List");
            System.out.println("openStudy: Failed to find StudyDataList");
            return false;
        }
        studyDataList = (ConditionDataList)ClientApp.Workspace().getDataListContainer().getDataList(Condition.class.getName());
        StreamAlignment streamAlignment = null;
        Vector vector = clientWorkspace.getManagerIDList(StreamAlignment.class.getName());
        if (vector.size() <= 0) {
            JOptionPane.showMessageDialog((Component)((Object)this), "No available Stream Alignments");
            return false;
        }
        if ((vector = (Identifier)vector.elementAt(0)) != null && (streamAlignment = (StreamAlignment)clientWorkspace.openManager((Identifier)vector)) == null) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Failed to Open Stream Alignment");
            return false;
        }
        this.setWatershedLocation();
        this.setConfigurationList((ConditionDataList)studyDataList, study);
        this.setStreamAlignment(streamAlignment);
        return true;
    }

    protected void openWorkspace() {
        ClientWorkspace clientWorkspace = this._importFromWksp;
        this._importFromWksp = this._selectWatershedPanel.openSelectedWorkspace();
        if (clientWorkspace != this._importFromWksp) {
            this._selectAlternativePanel.setWorkspace(this._importFromWksp);
            this._assignStreamsPanel.setWorkspace(this._importFromWksp);
        }
    }

    protected boolean openAlternative() {
        boolean bl;
        block5: {
            block6: {
                String string;
                block4: {
                    Identifier identifier = this._selectAlternativePanel.getSelectedIdentifier();
                    if (identifier == null) {
                        return false;
                    }
                    ClientApp.Workspace();
                    string = this.getPaddedName(identifier.getName());
                    string = this._importFromWksp.getManagerIdentifier("rss", RssSimRun.class.getName(), string, ".simrun");
                    string.setDescription(identifier.getDescription() + " (Simulation Run)");
                    if (string == null) {
                        return false;
                    }
                    bl = false;
                    if (this._importFromAlternative == null) break block4;
                    if (identifier.equals((Object)this._importFromAlternative.getIdentifier())) break block5;
                    this._importFromWksp.unloadManager("rss", this._importFromSimRun.getIdentifier());
                    this._importFromWksp.unloadManager("rss", this._importFromAlternative.getIdentifier());
                    this._importFromSimRun = (RssSimRun)this._importFromWksp.openManager("rss", (Identifier)string);
                    if (this._importFromSimRun == null) {
                        return false;
                    }
                    this._importFromWksp.unloadManager("rss", this._importFromAlternative.getIdentifier());
                    break block6;
                }
                this._importFromSimRun = (RssSimRun)this._importFromWksp.openManager("rss", (Identifier)string);
                if (this._importFromSimRun == null) {
                    return false;
                }
            }
            this._importFromAlternative = this._importFromSimRun.getRssAlt();
            bl = true;
        }
        return bl;
    }

    protected String getPaddedName(String string) {
        if (string.length() < 10) {
            StringBuffer stringBuffer = new StringBuffer(string);
            for (int i = string.length(); i < 10; ++i) {
                stringBuffer.append("-");
            }
            return stringBuffer.toString();
        }
        return string;
    }

    protected boolean openNetwork() {
        if (this._importFromAlternative == null) {
            return false;
        }
        this._importFromNetwork = this._importFromAlternative.getSystem();
        this._assignStreamsPanel.setImportFromNetwork(this._importFromNetwork);
        this._assignStreamsPanel.setStreamAlignment(this._streamAlignment);
        return this._importFromNetwork != null;
    }

    protected void createNetwork() {
        this._newNetworkPanel.getNewNetworkName();
        this._newNetworkPanel.getNewNetworkDescription();
    }

    protected void dialogCanceled() {
        this._canceled = true;
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.closeWorkspace();
            return;
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    protected void dialogFinished() {
        Object object = this._newNetworkPanel.getNewNetworkName();
        int n = JOptionPane.showConfirmDialog((Component)((Object)this), "Proceeding with the Import operation will create a new network with\the name: " + (String)object + "\nand a new alternative with the name: " + this._newAlternativePanel.getNewAlternativeName() + "\nContinue?", "Continue with Import", 1);
        if (n == 0) {
            Cursor cursor = this.getCursor();
            try {
                this.setCursor(Cursor.getPredefinedCursor(3));
                this._assignStreamsPanel.saveImportNetworkStreams(true);
                Object object2 = this._resolveComputationPointsPanel.getComputationPointMap();
                Condition condition = this._resolveComputationPointsPanel.getSelectedConfiguration();
                ImportAlternativeDialog importAlternativeDialog = this;
                importAlternativeDialog.updateConfiguration(importAlternativeDialog._importFromNetwork, condition, (HashMap)object2);
                object2 = this._newNetworkPanel.getNewNetworkDescription();
                ImportAlternativeDialog importAlternativeDialog2 = this;
                object = importAlternativeDialog2.saveNetwork(importAlternativeDialog2._importFromNetwork, (String)object, (String)object2);
                if (object == null) {
                    JOptionPane.showMessageDialog((Component)((Object)this), "The reservoir network for the imported alternative was not saved.", "Save Network Error", 0);
                    return;
                }
                this._importFromAlternative.setSystemIndex(object.getIndex());
                object = this._newAlternativePanel.getNewAlternativeName();
                object2 = this._newAlternativePanel.getNewAlternativeDescription();
                ImportAlternativeDialog importAlternativeDialog3 = this;
                importAlternativeDialog3.saveAlternative(importAlternativeDialog3._importFromAlternative, (String)object, (String)object2, condition);
                this.closeWorkspace();
                this.setVisible(false);
            }
            finally {
                this.setCursor(cursor);
            }
        } else if (n == 1) {
            this.dialogCanceled();
        }
        this._canceled = false;
    }

    public boolean isCanceled() {
        return this._canceled;
    }

    protected void importSuccessMsg(StringBuffer stringBuffer, RuleResolution ruleResolution) {
        stringBuffer.append(ruleResolution.a.getElementType());
        stringBuffer.append(" <b>");
        stringBuffer.append(ruleResolution.a.getName());
        stringBuffer.append("</b> imported successfully from <b>");
        stringBuffer.append(ruleResolution.b.getName());
        stringBuffer.append("</b><br>");
    }

    protected void importFailedMsg(StringBuffer stringBuffer, RuleResolution ruleResolution) {
        stringBuffer.append("<font=+0 color=red>");
        stringBuffer.append(ruleResolution.a.getElementType());
        stringBuffer.append(" <b>");
        stringBuffer.append(ruleResolution.a.getName());
        stringBuffer.append("</b> failed to import from <b>");
        stringBuffer.append(ruleResolution.b.getName());
        stringBuffer.append("</b></font><br>");
    }

    protected void updateConfiguration(RssSystem rssSystem, Condition object, HashMap hashMap) {
        Object object2;
        Object object3;
        int n;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (rssSystem == null || object == null || hashMap == null) {
            return;
        }
        rssSystem.setConfigurationForImport((Condition)object);
        rssSystem.clearStreamAlignment();
        if (hashMap.keySet() == null) {
            return;
        }
        Object[] objectArray = hashMap.keySet().toArray();
        for (n = 0; n < objectArray.length; ++n) {
            object3 = objectArray[n];
            object = hashMap.get(object3);
            if (!(object3 instanceof JunctionElement)) continue;
            if (object instanceof ComputationPoint) {
                object = (ComputationPoint)object;
                object2 = (JunctionElement)object3;
                ((JunctionElement)object2).setComputationPoint((ComputationPoint)object);
                continue;
            }
            ((JunctionElement)object3).setComputationPoint(null);
            arrayList.add(object3);
        }
        for (n = 0; n < objectArray.length; ++n) {
            Reservoir reservoir;
            object3 = objectArray[n];
            object = hashMap.get(object3);
            if (object3 instanceof JunctionElement) continue;
            if (object3 instanceof ReservoirElement) {
                object2 = (ReservoirElement)object3;
                if (object instanceof Reservoir) {
                    reservoir = (Reservoir)object;
                    ((Element)object2).setName(reservoir.getName());
                    ((ReservoirElement)object2).setLabelPosition(reservoir.getLabelPosition());
                    object2.setDescription(reservoir.getDescription());
                } else {
                    ((ReservoirElement)object2).setReservoirProjectId(Long.MIN_VALUE);
                    arrayList.add(object3);
                }
            }
            if (object3 instanceof DiversionElement) {
                object2 = (DiversionElement)object3;
                if (object instanceof Diversion) {
                    reservoir = (Diversion)object;
                    ((Element)object2).setName(reservoir.getName());
                    object2.setDescription(reservoir.getDescription());
                    ((DiversionElement)object2).setDiversionProjectId(reservoir.getId());
                    continue;
                }
                ((DiversionElement)object2).setDiversionProjectId(Long.MIN_VALUE);
                arrayList.add(object3);
                continue;
            }
            if (object3 instanceof DivertedOutletElement) {
                object2 = (DivertedOutletElement)object3;
                if (!(object instanceof Diversion)) continue;
                reservoir = (Diversion)object;
                if (reservoir == null) {
                    ((DivertedOutletElement)object2).setDiversionProjectId(Long.MIN_VALUE);
                    continue;
                }
                ((Element)object2).setName(reservoir.getName());
                object2.setDescription(reservoir.getDescription());
                ((DivertedOutletElement)object2).setDiversionProjectId(reservoir.getId());
                continue;
            }
            arrayList.add(object3);
        }
        object2 = rssSystem.getElementVectorByClass(ReservoirElement.class.getName());
        for (int i = 0; i < ((Vector)object2).size(); ++i) {
            ReservoirElement reservoirElement = (ReservoirElement)((Vector)object2).get(i);
            reservoirElement.updateSegments();
        }
    }

    protected void saveAlternative(RssAlt object, String object2, String string, Condition condition) {
        this._newAlternative = null;
        ClientWorkspace clientWorkspace = ClientApp.Workspace();
        if (object == null || clientWorkspace == null || object2 == null || ((String)object2).length() <= 0) {
            return;
        }
        Object object3 = clientWorkspace.getManagerIdentifier("rss", RssAlt.class.getName(), (String)object2, ".ralt");
        if (object3 == null) {
            return;
        }
        TSDataSet tSDataSet = ((RssAlt)object).getInputTSDataSet();
        Identifier identifier = clientWorkspace.getManagerIdentifier("rss", TSDataSet.class.getName(), (String)object2, "fits");
        identifier.setDescription(string + " (TS Data Set)");
        identifier = (TSDataSet)this.copyManager((Manager)tSDataSet, identifier);
        ((RssAlt)object).setDataSetPath(identifier.getIdentifier().getPath());
        ((RssAlt)object).getObservedTSDataSet();
        object2 = clientWorkspace.getManagerIdentifier("rss", TSDataSet.class.getName(), (String)object2 + "Obs", "fits");
        object2.setDescription(string + " (Observed TS Data Set)");
        object2 = (TSDataSet)this.copyManager((Manager)tSDataSet, (Identifier)object2);
        ((RssAlt)object).setObservedDataSetPath(object2.getIdentifier().getPath());
        object3.setDescription(string);
        object2 = (RssAlt)this.copyManager((Manager)object, (Identifier)object3);
        if (object2 == null) {
            System.out.println("ImportAlternative: Alternative file NOT copied! - " + String.valueOf(object3));
            return;
        }
        string = new ModelReference(object2.getIndex(), object2.getClass().getName(), "rss");
        object3 = clientWorkspace.getManagerIdentifier("rss", ModelAlt.class.getName(), object2.getName(), ".malt");
        object3.setDescription(object2.getDescription() + " (Simulation)");
        tSDataSet = (ModelAlt)this.createManager((Identifier)object3);
        if (tSDataSet == null) {
            System.out.println("ImportAlternative: ModelAlt not created! - " + String.valueOf(object3));
            return;
        }
        tSDataSet.setModelRef((ModelReference)string);
        tSDataSet.setAltId(object.getName());
        ProgramOrderItem.RSS_MODEL.setIndex(1);
        tSDataSet.setProgramIndex(ProgramOrderItem.RSS_MODEL);
        if (condition != null) {
            tSDataSet.addConfiguration(condition);
        }
        clientWorkspace.saveManagerAs("rss", (Manager)tSDataSet, (Identifier)object3);
        object = this.getPaddedName(object2.getName());
        object = clientWorkspace.getManagerIdentifier("rss", RssSimRun.class.getName(), (String)object, ".simrun");
        object.setDescription(object2.getDescription() + " (Simulation Run)");
        string = (SimulationRun)this.createManager((Identifier)object);
        if (string == null) {
            System.out.println("ImportAlternative: RssSimRun not created! - " + String.valueOf(object));
            return;
        }
        object3 = new Vector();
        tSDataSet = new AltItem("rss", object2.getName(), 0, tSDataSet.getIndex());
        ((Vector)object3).add(tSDataSet);
        string.setAltList((Vector)object3);
        string.setIdentifier((Identifier)object);
        string.setUserName(object2.getName());
        if (condition != null) {
            string.setConfigurationId(condition.getId());
        }
        clientWorkspace.saveManagerAs("rss", (Manager)string, (Identifier)object);
        this._newAlternative = object2;
    }

    public RssAlt getNewAlternative() {
        return this._newAlternative;
    }

    protected RssSystem saveNetwork(RssSystem rssSystem, String string, String string2) {
        ClientWorkspace clientWorkspace = ClientApp.Workspace();
        string = clientWorkspace.getManagerIdentifier("rss", RSimNetworkMode.NETWORK_CLASSNAME, string, "rsys");
        string.setDescription(string2);
        rssSystem = (RssSystem)this.copyManager(rssSystem, (Identifier)string);
        return rssSystem;
    }

    protected Manager copyManager(Manager manager, Identifier identifier) {
        ClientWorkspace clientWorkspace = ClientApp.Workspace();
        RmiFileManager rmiFileManager = (RmiFileManager)ClientApp.app().getFileManager().getRemote();
        boolean bl = false;
        try {
            if (rmiFileManager.fileExists(identifier)) {
                bl = true;
            }
        }
        catch (RemoteException remoteException) {
            System.out.println("validForm: RMI Error checking existance of directory " + String.valueOf(identifier));
            return null;
        }
        if (!bl || (rmiFileManager = clientWorkspace.openManagerByName("rss", identifier.getClassName(), identifier.getName())) == null) {
            rmiFileManager = clientWorkspace.newManager("rss", identifier.getClassName());
        }
        rmiFileManager.setIdentifier(identifier);
        rmiFileManager.setName(identifier.getName());
        rmiFileManager.setDescription(identifier.getDescription());
        Identifier identifier2 = bl ? clientWorkspace.openRemoteFileID(identifier) : clientWorkspace.newRemoteFileID(identifier);
        String string = manager.getName();
        String string2 = manager.getDescription();
        Identifier identifier3 = manager.getIdentifier();
        manager.setName(identifier.getName());
        manager.setDescription(identifier.getDescription());
        if (manager instanceof RssSystem) {
            RssSystem rssSystem = (RssSystem)manager;
            rssSystem.setIdentifier(identifier);
            rssSystem.resetAndSaveOperations();
        }
        manager.writeFile(identifier2);
        manager.setName(string);
        manager.setDescription(string2);
        if (manager instanceof RssSystem) {
            manager.setIdentifier(identifier3);
        }
        int n = rmiFileManager.getIndex();
        rmiFileManager.readFile(identifier2);
        rmiFileManager.setIndex(n);
        boolean bl2 = clientWorkspace.saveManagerAs("rss", (Manager)rmiFileManager, identifier);
        if (!bl2) {
            return null;
        }
        return rmiFileManager;
    }

    protected Manager createManager(Identifier identifier) {
        ClientWorkspace clientWorkspace = ClientApp.Workspace();
        RmiFileManager rmiFileManager = (RmiFileManager)ClientApp.app().getFileManager().getRemote();
        boolean bl = false;
        try {
            if (rmiFileManager.fileExists(identifier)) {
                bl = true;
            }
        }
        catch (RemoteException remoteException) {
            System.out.println("validForm: RMI Error checking existance of directory " + String.valueOf(identifier));
            return null;
        }
        if (!bl || (rmiFileManager = clientWorkspace.openManagerByName("rss", identifier.getClassName(), identifier.getName())) == null) {
            rmiFileManager = clientWorkspace.newManager("rss", identifier.getClassName());
        }
        if (rmiFileManager == null) {
            return null;
        }
        rmiFileManager.setIdentifier(identifier);
        rmiFileManager.setName(identifier.getName());
        rmiFileManager.setDescription(identifier.getDescription());
        boolean bl2 = clientWorkspace.saveManagerAs("rss", (Manager)rmiFileManager, identifier);
        if (!bl2) {
            return null;
        }
        return rmiFileManager;
    }

    public void setWatershedLocation() {
        this._selectWatershedPanel.setSelectedWatershedLocation(ClientApp.app().getWatershedLocation());
        this._selectWatershedPanel.setSelectedWorkspace(ClientApp.Workspace().getIdentifier());
    }

    protected void closeWorkspace() {
        if (this._importFromWksp != null && this._importFromNetwork != null) {
            this._importFromWksp.unloadManager("rss", this._importFromNetwork.getIdentifier());
            this._importFromNetwork = null;
        }
        this._selectWatershedPanel.closeSelectedWorkspace();
        this._importFromWksp = null;
    }

    public void setNetwork(RssSystem rssSystem) {
        this._importToNetwork = rssSystem;
        this._importToNetwork.updateTSProxyList();
    }

    public void setStreamAlignment(StreamAlignment streamAlignment) {
        this._streamAlignment = streamAlignment;
    }

    public void setConfigurationList(ConditionDataList conditionDataList, Study study) {
        this._conditionList = conditionDataList;
        this._resolveComputationPointsPanel.setConfigurationList(conditionDataList, study);
    }

    protected void createSummaryText() {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        int n;
        StringBuffer stringBuffer = new StringBuffer(1000);
        stringBuffer.append("<html><h1> Summary</h1>");
        stringBuffer.append("<p>New Alternative: ");
        stringBuffer.append(this._newAlternativePanel.getNewAlternativeName());
        stringBuffer.append("<p>");
        stringBuffer.append("New Network: ");
        stringBuffer.append(this._newNetworkPanel.getNewNetworkName());
        stringBuffer.append("<p>");
        stringBuffer.append(" Import from Watershed: ");
        stringBuffer.append(this._importFromWksp.getTitleName());
        stringBuffer.append("<p>");
        stringBuffer.append(" Import from Alternative: ");
        stringBuffer.append(this._importFromAlternative.getName());
        stringBuffer.append("<p>");
        stringBuffer.append(" Import from Network: ");
        stringBuffer.append(this._importFromNetwork.getName());
        stringBuffer.append("<p>");
        Object object6 = this._assignStreamsPanel.getElementAssigmentsList();
        stringBuffer.append("<h1> Stream Mapping Summary</h1><b>");
        stringBuffer.append(" Element    Element Type       Old Stream Name               New Steam Name</b><p>");
        String string = "<font=+0 color=blue>";
        String string2 = "</font>";
        for (n = 0; n < object6.size(); ++n) {
            object5 = (Vector)object6.get(n);
            object4 = (String)((Vector)object5).get(0);
            object3 = (String)((Vector)object5).get(1);
            object2 = (String)((Vector)object5).get(2);
            object5 = (String)((Vector)object5).get(3);
            object = this.elementTypeString((String)object3);
            String string3 = (String)object + string + (String)object4 + string2 + " on Stream " + string + (String)object2 + string2 + " Mapped to Stream " + string + (String)object5 + string2;
            stringBuffer.append(string3);
            stringBuffer.append("<br>\n");
        }
        object6 = this._assignStreamsPanel.getElementsNotAssignedList();
        if (object6.size() > 0) {
            stringBuffer.append("<p><b>");
            stringBuffer.append(object6.size());
            stringBuffer.append(" Streams for these imported elements were not assigned</b><p>");
            stringBuffer.append("<font=+0 color=red>");
            string = "<font=+0 color=red>";
            for (n = 0; n < object6.size(); ++n) {
                object5 = (Vector)object6.get(n);
                object4 = (String)((Vector)object5).get(0);
                object3 = (String)((Vector)object5).get(1);
                object2 = (String)((Vector)object5).get(2);
                object5 = this.elementTypeString((String)object3);
                object = (String)object5 + string + (String)object4 + string2 + " from Stream " + string + (String)object2 + string2 + " Not Mapped";
                stringBuffer.append((String)object);
                stringBuffer.append("<br>\n");
            }
        }
        stringBuffer.append("<h1> Configuration Summary</h1>");
        stringBuffer.append("<p><b>");
        stringBuffer.append("Assigned Configuration for Network: </b>");
        Condition condition = this._resolveComputationPointsPanel.getSelectedConfiguration();
        if (condition != null) {
            condition.getName();
        }
        stringBuffer.append(condition);
        stringBuffer.append("<p>");
        object4 = this._resolveComputationPointsPanel.getAssignedList();
        if (object4 == null) {
            stringBuffer.append(" No Computation Points Assignments .<br>");
        } else {
            string = "<font=+0 color=blue>";
            string2 = "</font>";
            for (int i = 0; i < object4.size(); ++i) {
                object6 = (Vector)object4.get(i);
                object3 = (String)((Vector)object6).get(0);
                object2 = (String)((Vector)object6).get(1);
                object5 = (String)((Vector)object6).get(2);
                if (((String)object2).equalsIgnoreCase("junction")) {
                    object = "Junction " + string + (String)object3 + string2 + " Mapped to Computation Point " + string + (String)object5 + string2;
                } else {
                    if (((String)object2).length() <= 0) continue;
                    object6 = this.elementTypeString((String)object2);
                    object = (String)object6 + string + (String)object3 + string2 + " Mapped to " + string + (String)object5 + string2;
                }
                stringBuffer.append((String)object);
                stringBuffer.append("<br>\n");
            }
        }
        stringBuffer.append("<p><b>");
        stringBuffer.append("Elements Not Mapped: ");
        stringBuffer.append("</b><p>");
        object3 = this._resolveComputationPointsPanel.getNotAssignedList();
        if (object3 == null) {
            stringBuffer.append(" None .<br>");
        } else {
            string = "<font=+0 color=red>";
            string2 = "</font>";
            for (int i = 0; i < object3.size(); ++i) {
                object6 = (Vector)object3.get(i);
                object2 = (String)((Vector)object6).get(0);
                object5 = (String)((Vector)object6).get(1);
                if (((String)object5).length() <= 0) continue;
                object6 = this.elementTypeString((String)object5);
                object = (String)object6 + string + (String)object2 + string2 + " Not Mapped ";
                stringBuffer.append((String)object);
                stringBuffer.append("<br>\n");
            }
        }
        stringBuffer.append("<p><b>");
        stringBuffer.append("Computation Points Not Assigned: ");
        stringBuffer.append("</b><p>");
        object2 = this._resolveComputationPointsPanel.getUnusedCpList();
        if (object2 == null) {
            stringBuffer.append(" None .<br>");
        } else {
            string = "<font=+0 color=red>";
            string2 = "</font>";
            for (int i = 0; i < object2.size(); ++i) {
                Vector vector = (Vector)object2.get(i);
                object5 = (String)vector.get(0) + string + (String)vector.get(1) + string2 + " Not Assigned";
                stringBuffer.append((String)object5);
                stringBuffer.append("<br>\n");
            }
        }
        stringBuffer.append("</html>");
        this._summaryPanel.setSummaryText(stringBuffer.toString());
    }

    protected String elementTypeString(String string) {
        String string2 = "";
        if (string.equalsIgnoreCase("junction")) {
            string2 = "Junction ";
        } else if (string.equalsIgnoreCase("reservoir")) {
            string2 = "Reservoir ";
        } else if (string.equalsIgnoreCase("diversion")) {
            string2 = "Diversion ";
        } else if (string.equalsIgnoreCase("divertedoutlet")) {
            string2 = "Diverted Outlet ";
        } else if (string.equalsIgnoreCase("reach")) {
            string2 = "Reach ";
        }
        return string2;
    }

    public void setVisible(boolean bl) {
        if (!this._initializedOk) {
            this._canceled = true;
            return;
        }
        super.setVisible(bl);
        if (!bl) {
            ClientApp.app().putAppProp("ImportDialog.Width", String.valueOf(this.getWidth()));
            ClientApp.app().putAppProp("ImportDialog.Height", String.valueOf(this.getHeight()));
            ClientApp.app().putAppProp("ImportDialog.X", String.valueOf(this.getX()));
            ClientApp.app().putAppProp("ImportDialog.Y", String.valueOf(this.getY()));
        }
    }
}

