/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.client.SummaryWizardPanel;
import hec.clientapp.client.ClientApp;
import hec.clientapp.client.ClientWorkspace;
import hec.gui.ResultsDialog;
import hec.gui.WizardDialog;
import hec.gui.WizardPanel;
import hec.io.Identifier;
import hec.lang.NamedType;
import hec.rss.client.AssignNetworkElementsPanel;
import hec.rss.client.ResolveNetworkPanel;
import hec.rss.client.SelectElementsWizardPanel;
import hec.rss.client.SelectManagerWizardPanel;
import hec.rss.client.SelectWatershedWizardPanel;
import hec.rss.model.DiversionElement;
import hec.rss.model.DivertedOutletElement;
import hec.rss.model.Element;
import hec.rss.model.ElementAssignmentContainer;
import hec.rss.model.JunctionElement;
import hec.rss.model.ReachElement;
import hec.rss.model.ReservoirDamElement;
import hec.rss.model.ReservoirElement;
import hec.rss.model.ReservoirImport;
import hec.rss.model.RssSystem;
import hec.rss.model.RuleResolution;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Frame;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.swing.JOptionPane;
import rma.util.RMAIO;

public class ImportNetworkDialog
extends WizardDialog {
    protected SelectElementsWizardPanel _selectElementsPanel;
    protected SelectWatershedWizardPanel _selectWatershedPanel;
    protected SelectManagerWizardPanel _selectNetworkPanel;
    protected AssignNetworkElementsPanel _assignElementsPanel;
    protected ResolveNetworkPanel _resolveNetworkPanel;
    protected SummaryWizardPanel _summaryPanel;
    protected NamedType[] _selectedElements;
    protected ClientWorkspace _importFromWksp;
    protected RssSystem _importFromNetwork;
    protected RssSystem _importToNetwork;
    protected List<String> _svList = new ArrayList<String>();
    protected List<String> _gvList = new ArrayList<String>();

    public ImportNetworkDialog(Frame frame, boolean bl) {
        super(frame, bl);
    }

    protected void buildControls() {
        super.buildControls();
        this.buildSelectElementsPanel();
        this.buildSelectWatershedPanel();
        this.buildSelectNetworkPanel();
        this.buildAssignElementsPanel();
        this.buildResolveElementsPanel();
        this.buildSummaryPanel();
        this.pack();
        String string = ClientApp.app().getAppProp("ImportDialog.Width");
        String string2 = ClientApp.app().getAppProp("ImportDialog.Height");
        String string3 = ClientApp.app().getAppProp("ImportDialog.X");
        String string4 = ClientApp.app().getAppProp("ImportDialog.Y");
        if (string != null && string2 != null) {
            int n = RMAIO.parseInt((String)string, (int)this.getWidth());
            int n2 = RMAIO.parseInt((String)string2, (int)this.getHeight());
            this.setSize(n, n2);
        }
        ImportNetworkDialog importNetworkDialog = this;
        importNetworkDialog.setLocationRelativeTo(importNetworkDialog.getParent());
        if (string3 != null && string4 != null) {
            int n = RMAIO.parseInt((String)string3, (int)this.getX());
            int n3 = RMAIO.parseInt((String)string4, (int)this.getY());
            this.setLocation(n, n3);
        }
        super.setTitle("Import Element Properties");
    }

    public void setTitle(String string) {
        string = String.valueOf(this.getCurrentStep());
        string = "Import Element Properties Wizard - Step X of 6".replace('X', string.charAt(0));
        super.setTitle(string);
    }

    protected void buildSelectElementsPanel() {
        this._selectElementsPanel = new SelectElementsWizardPanel();
        this._selectElementsPanel.setNextPanelName("SelectWatershed");
        ImportNetworkDialog importNetworkDialog = this;
        importNetworkDialog.addWizardPanel(importNetworkDialog._selectElementsPanel);
    }

    protected void buildSelectWatershedPanel() {
        this._selectWatershedPanel = new SelectWatershedWizardPanel();
        this._selectWatershedPanel.setBackPanelName("SelectElements");
        this._selectWatershedPanel.setNextPanelName("SelectManager");
        this._selectWatershedPanel.setAppServer(ClientApp.app().getAppServer());
        ImportNetworkDialog importNetworkDialog = this;
        importNetworkDialog.addWizardPanel(importNetworkDialog._selectWatershedPanel);
    }

    protected void buildSelectNetworkPanel() {
        this._selectNetworkPanel = new SelectManagerWizardPanel(RssSystem.class.getName(), "rss", "Networks");
        this._selectNetworkPanel.setPanelTitle("Select the Network to Import Elements from");
        this._selectNetworkPanel.setBackPanelName("SelectWatershed");
        this._selectNetworkPanel.setNextPanelName("AssignElements");
        ImportNetworkDialog importNetworkDialog = this;
        importNetworkDialog.addWizardPanel(importNetworkDialog._selectNetworkPanel);
    }

    protected void buildAssignElementsPanel() {
        this._assignElementsPanel = new AssignNetworkElementsPanel();
        this._assignElementsPanel.setBackPanelName("SelectManager");
        this._assignElementsPanel.setNextPanelName("ResolveElements");
        ImportNetworkDialog importNetworkDialog = this;
        importNetworkDialog.addWizardPanel(importNetworkDialog._assignElementsPanel);
    }

    protected void buildResolveElementsPanel() {
        this._resolveNetworkPanel = new ResolveNetworkPanel();
        this._resolveNetworkPanel.setBackPanelName("AssignElements");
        this._resolveNetworkPanel.setNextPanelName("Summary");
        ImportNetworkDialog importNetworkDialog = this;
        importNetworkDialog.addWizardPanel(importNetworkDialog._resolveNetworkPanel);
    }

    protected void buildSummaryPanel() {
        this._summaryPanel = new SummaryWizardPanel();
        this._summaryPanel.setPanelTitle("Import Summary");
        this._summaryPanel.setBackPanelName("ResolveElements");
        ImportNetworkDialog importNetworkDialog = this;
        importNetworkDialog.addWizardPanel((WizardPanel)importNetworkDialog._summaryPanel);
    }

    protected int getCurrentStep() {
        WizardPanel wizardPanel = this.getCurrentPanel();
        if (wizardPanel == this._selectElementsPanel) {
            return 1;
        }
        if (wizardPanel == this._selectWatershedPanel) {
            return 2;
        }
        if (wizardPanel == this._selectNetworkPanel) {
            return 3;
        }
        if (wizardPanel == this._assignElementsPanel) {
            return 4;
        }
        if (wizardPanel == this._resolveNetworkPanel) {
            return 5;
        }
        return 6;
    }

    protected void changingPanels(String object) {
        WizardPanel wizardPanel = this.getCurrentPanel();
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            if (wizardPanel == this._selectElementsPanel && "SelectWatershed".equals(object)) {
                this._selectedElements = this._selectElementsPanel.getSelectedElements();
                this._assignElementsPanel.setSelectedElements(this._selectedElements);
                this._resolveNetworkPanel.setSelectedElements(this._selectedElements);
                this._selectWatershedPanel.setSelectedWatershedLocation(ClientApp.app().getWatershedLocation());
                this._selectWatershedPanel.setSelectedWorkspace(ClientApp.Workspace().getIdentifier());
            } else if (wizardPanel == this._selectWatershedPanel && "SelectManager".equals(object)) {
                this.openWorkspace();
            } else if (wizardPanel == this._selectNetworkPanel && "AssignElements".equals(object)) {
                this.openNetwork();
            } else if (wizardPanel == this._assignElementsPanel && "ResolveElements".equals(object)) {
                object = this._assignElementsPanel.getImportList();
                this._resolveNetworkPanel.setImportFromElements((List)object);
                this._resolveNetworkPanel.setImportToNetwork(this._importToNetwork);
            } else if (wizardPanel == this._resolveNetworkPanel && "Summary".equals(object)) {
                this.createSummaryText();
            }
            return;
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    protected void openWorkspace() {
        ClientWorkspace clientWorkspace = this._importFromWksp;
        this._importFromWksp = this._selectWatershedPanel.openSelectedWorkspace();
        if (clientWorkspace != this._importFromWksp) {
            this._selectNetworkPanel.setWorkspace(this._importFromWksp);
            this._assignElementsPanel.setWorkspace(this._importFromWksp);
            this._resolveNetworkPanel.setWorkspace(this._importFromWksp);
        }
    }

    protected void openNetwork() {
        block5: {
            Identifier identifier;
            block4: {
                identifier = this._selectNetworkPanel.getSelectedIdentifier();
                if (identifier == null) {
                    return;
                }
                if (this._importFromNetwork == null) break block4;
                if (identifier.equals((Object)this._importFromNetwork.getIdentifier())) break block5;
                this._importFromWksp.unloadManager("rss", this._importFromNetwork.getIdentifier());
            }
            this._importFromNetwork = (RssSystem)this._importFromWksp.openManager("rss", identifier);
        }
        this._assignElementsPanel.setImportFromNetwork(this._importFromNetwork);
        this._resolveNetworkPanel.setImportFromNetwork(this._importFromNetwork);
    }

    protected void dialogCanceled() {
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.closeWorkspace();
            return;
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    protected void dialogFinished() {
        int n = JOptionPane.showConfirmDialog((Component)((Object)this), "Proceeding with the Import operation will\nreplace ALL information in the selected Elements.\nContinue?", "Continue with Import", 0);
        if (n == 0) {
            Cursor cursor = this.getCursor();
            try {
                this.setCursor(Cursor.getPredefinedCursor(3));
                this.importElements();
                this.closeWorkspace();
                this.setVisible(false);
                return;
            }
            finally {
                this.setCursor(cursor);
            }
        }
    }

    protected void importSuccessMsg(StringBuffer stringBuffer, RuleResolution ruleResolution) {
        stringBuffer.append(ruleResolution.a.getElementType());
        stringBuffer.append(" <b>");
        stringBuffer.append(ruleResolution.a.getName());
        stringBuffer.append("</b> imported successfully from <b>");
        stringBuffer.append(ruleResolution.b.getName());
        stringBuffer.append("</b><br>");
    }

    protected void importFailedMsg(StringBuffer stringBuffer, RuleResolution ruleResolution) {
        stringBuffer.append("<font=+0 color=red>");
        stringBuffer.append(ruleResolution.a.getElementType());
        stringBuffer.append(" <b>");
        stringBuffer.append(ruleResolution.a.getName());
        stringBuffer.append("</b> failed to import from <b>");
        stringBuffer.append(ruleResolution.b.getName());
        stringBuffer.append("</b></font><br>");
    }

    protected void importElements() {
        boolean bl;
        StringBuffer stringBuffer = new StringBuffer(1024);
        List list = this._resolveNetworkPanel.getRuleResolutionList();
        RuleResolution ruleResolution = null;
        Element element = null;
        if (list == null) {
            System.out.println("importElements: no Elements to import");
            return;
        }
        HashMap<Object, ReservoirImport> hashMap = new HashMap<Object, ReservoirImport>();
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < list.size(); ++i) {
            block22: {
                try {
                    ReservoirImport reservoirImport;
                    Object object;
                    ruleResolution = (RuleResolution)list.get(i);
                    element = ruleResolution.a;
                    if (ruleResolution.b == null) {
                        System.out.println("importElements: no Element to import From for " + element.getElementType() + " " + String.valueOf(element));
                        stringBuffer.append("<font=+0 color=red> No Element to import from for ");
                        stringBuffer.append(element.getElementType());
                        stringBuffer.append(" <b>");
                        stringBuffer.append(element.getName());
                        stringBuffer.append("<b></font><br>");
                        continue;
                    }
                    if (element instanceof JunctionElement) {
                        bl = this.importJunction(ruleResolution);
                        break block22;
                    }
                    if (element instanceof ReachElement) {
                        bl = this.importReach(ruleResolution);
                        break block22;
                    }
                    if (element instanceof ReservoirElement) {
                        object = (ReservoirElement)element;
                        reservoirImport = (ReservoirImport)hashMap.get(object);
                        if (reservoirImport == null) {
                            reservoirImport = new ReservoirImport((ReservoirElement)object);
                            hashMap.put(object, reservoirImport);
                        }
                        reservoirImport.b.add(ruleResolution);
                        continue;
                    }
                    if (element instanceof DiversionElement) {
                        bl = this.importDiversion(ruleResolution);
                        break block22;
                    }
                    if (element instanceof ReservoirDamElement || element instanceof DivertedOutletElement) {
                        object = (ReservoirElement)element.getParent();
                        reservoirImport = (ReservoirImport)hashMap.get(object);
                        if (reservoirImport == null) {
                            reservoirImport = new ReservoirImport((ReservoirElement)object);
                            hashMap.put(object, reservoirImport);
                        }
                        reservoirImport.b.add(ruleResolution);
                        continue;
                    }
                    System.out.println("importElement: unhandled element type " + String.valueOf(ruleResolution.b.getClass()));
                    stringBuffer.append("<font=+0 color=red>Unknown Element type ");
                    stringBuffer.append(element.getElementType());
                    stringBuffer.append(" found during import process</font><br>");
                    continue;
                }
                catch (Exception exception) {
                    System.out.println("importElement: Exception importing element " + element.getElementType() + " " + String.valueOf(element));
                    exception.printStackTrace(System.out);
                    bl = false;
                }
            }
            if (bl) {
                this.importSuccessMsg(stringBuffer, ruleResolution);
                ++n;
                continue;
            }
            this.importFailedMsg(stringBuffer, ruleResolution);
            ++n2;
        }
        Collection collection = hashMap.values();
        for (ReservoirImport reservoirImport : collection) {
            int n3;
            bl = this.importReservoir(reservoirImport, stringBuffer);
            for (n3 = 0; n3 < reservoirImport.c.size(); ++n3) {
                if (this._svList.contains(reservoirImport.c.get(n3))) continue;
                this._svList.add(reservoirImport.c.get(n3).toString());
            }
            for (n3 = 0; n3 < reservoirImport.d.size(); ++n3) {
                if (this._gvList.contains(reservoirImport.d.get(n3))) continue;
                this._gvList.add(reservoirImport.d.get(n3).toString());
            }
            ruleResolution = reservoirImport.b.get(0);
            if (bl) {
                this.importSuccessMsg(stringBuffer, ruleResolution);
                ++n;
                continue;
            }
            this.importFailedMsg(stringBuffer, ruleResolution);
            ++n2;
        }
        if (n2 > 0) {
            stringBuffer.insert(0, "Failed to Import " + n2 + " Elements<br>");
        }
        stringBuffer.insert(0, "Imported " + n + " Elements<br>");
        stringBuffer.insert(0, "<html><h1>Import Results</h1>");
        System.out.println("importElements: imported " + n + " Elements");
        if (this._svList.size() != 0) {
            stringBuffer.append("<html><br><b>Caution: You may need to resolve the following imported State Variables:</b><br>");
            for (int i = 0; i < this._svList.size(); ++i) {
                stringBuffer.append("<html>" + this._svList.get(i).toString() + "<br>");
            }
        }
        if (this._gvList.size() != 0) {
            stringBuffer.append("<html><br><b>Caution: You may need to resolve the following imported Global Variables:</b><br>");
            for (int i = 0; i < this._svList.size(); ++i) {
                stringBuffer.append("<html>" + this._svList.get(i).toString() + "<br>");
            }
        }
        this._importToNetwork.cleanVectors();
        new ResultsDialog((Dialog)((Object)this), stringBuffer.toString());
    }

    protected boolean importJunction(RuleResolution ruleResolution) {
        System.out.println("importJunction: processing " + String.valueOf(ruleResolution.a));
        JunctionElement junctionElement = (JunctionElement)ruleResolution.a;
        return junctionElement.importFrom(ruleResolution);
    }

    protected boolean importReach(RuleResolution ruleResolution) {
        System.out.println("importReach: processing " + String.valueOf(ruleResolution.a));
        ReachElement reachElement = (ReachElement)ruleResolution.a;
        return reachElement.importFrom(ruleResolution);
    }

    protected boolean importDiversion(RuleResolution ruleResolution) {
        System.out.println("importDiversion: processing " + String.valueOf(ruleResolution.a));
        DiversionElement diversionElement = (DiversionElement)ruleResolution.a;
        return diversionElement.importFrom(ruleResolution);
    }

    protected boolean importReservoir(ReservoirImport reservoirImport, StringBuffer stringBuffer) {
        System.out.println("importReservoir: processing " + String.valueOf(reservoirImport.a));
        ReservoirElement reservoirElement = reservoirImport.a;
        return reservoirElement.importFrom(reservoirImport, stringBuffer);
    }

    protected void closeWorkspace() {
        if (this._importFromWksp != null && this._importFromNetwork != null) {
            this._importFromWksp.unloadManager("rss", this._importFromNetwork.getIdentifier());
            this._importFromNetwork = null;
        }
        this._selectWatershedPanel.closeSelectedWorkspace();
        this._importFromWksp = null;
    }

    public void setSelectedElements(NamedType[] namedTypeArray) {
        this._selectedElements = namedTypeArray;
        this._selectElementsPanel.setSelectedElements(namedTypeArray);
    }

    public void setNetwork(RssSystem rssSystem) {
        this._importToNetwork = rssSystem;
        this._importToNetwork.updateTSProxyList();
        this._assignElementsPanel.setImportInToNetwork(this._importToNetwork);
        this._selectElementsPanel.setImportIntoNetwork(this._importToNetwork);
    }

    protected void createSummaryText() {
        Element element;
        ElementAssignmentContainer elementAssignmentContainer;
        int n;
        StringBuffer stringBuffer = new StringBuffer(1000);
        stringBuffer.append("<html><h1> Summary</h1>");
        stringBuffer.append("<p>Current Network: ");
        stringBuffer.append(this._importToNetwork.getName());
        stringBuffer.append("<p> Import from Watershed: ");
        stringBuffer.append(this._importFromWksp.getTitleName());
        stringBuffer.append("<p> Import from Network: ");
        stringBuffer.append(this._importFromNetwork.getName());
        stringBuffer.append("<p>");
        List list = this._assignElementsPanel.getImportList();
        stringBuffer.append("<h1> Element Summary</h1><b>");
        stringBuffer.append(this._assignElementsPanel.getElementCount());
        stringBuffer.append(" elements selected, ");
        stringBuffer.append(list.size());
        stringBuffer.append(" elements being imported.</b><p>");
        for (n = 0; n < list.size(); ++n) {
            elementAssignmentContainer = (ElementAssignmentContainer)list.get(n);
            element = elementAssignmentContainer.a;
            if (element instanceof ReservoirDamElement || element instanceof DivertedOutletElement) {
                stringBuffer.append(element.getParent().getName());
                stringBuffer.append("'s ");
            }
            stringBuffer.append(element.getElementType());
            stringBuffer.append(" <font=+0 color=blue>");
            stringBuffer.append(elementAssignmentContainer.a.getName());
            stringBuffer.append("</font> imported from <font=+0 color=blue>");
            stringBuffer.append(elementAssignmentContainer.b.getName());
            stringBuffer.append("</font><br>\n");
        }
        list = this._assignElementsPanel.getNotImportedList();
        if (list.size() > 0) {
            stringBuffer.append("<p><b>");
            stringBuffer.append(list.size());
            stringBuffer.append(" elements not being imported</b><p>");
            stringBuffer.append("<font=+0 color=red>");
            for (n = 0; n < list.size(); ++n) {
                elementAssignmentContainer = (ElementAssignmentContainer)list.get(n);
                element = elementAssignmentContainer.a;
                if (element instanceof ReservoirDamElement || element instanceof DivertedOutletElement) {
                    stringBuffer.append(element.getParent().getName());
                    stringBuffer.append("'s ");
                }
                stringBuffer.append(element.getElementType());
                stringBuffer.append(" ");
                stringBuffer.append(elementAssignmentContainer.a.getName());
                stringBuffer.append("<br>\n");
            }
            stringBuffer.append("</font><br>");
        }
        stringBuffer.append("<h1> Rule Connectivity Summary</h1>");
        List list2 = this._resolveNetworkPanel.getRuleResolutionList();
        if (list2 == null) {
            stringBuffer.append(" No Rules need their connectivity resolved.<br>");
        } else {
            RuleResolution ruleResolution;
            int n2;
            boolean bl = true;
            int n3 = 0;
            int n4 = 0;
            for (n2 = 0; n2 < list2.size(); ++n2) {
                ruleResolution = (RuleResolution)list2.get(n2);
                if (ruleResolution.c == null || ruleResolution.c.c() == 5) continue;
                bl = false;
                ++n3;
            }
            if (bl) {
                stringBuffer.append(" No Rules need their connectivity resolved.<br>");
            } else {
                int n5;
                n2 = 0;
                for (n5 = 0; n5 < list2.size(); ++n5) {
                    ruleResolution = (RuleResolution)list2.get(n5);
                    if (ruleResolution.c == null) continue;
                    if (ruleResolution.d == null && ruleResolution.c.c() != 5) {
                        ++n2;
                        continue;
                    }
                    ++n4;
                }
                stringBuffer.append("<b>");
                stringBuffer.append(n3);
                stringBuffer.append(" Rules needed to have their connectivity resolved,<br> ");
                stringBuffer.append(n4);
                stringBuffer.append(" Rules with resolved connectivity being imported.</b><p>");
                for (n3 = 0; n3 < list2.size(); ++n3) {
                    ruleResolution = (RuleResolution)list2.get(n3);
                    if (ruleResolution.c == null) continue;
                    Element element2 = ruleResolution.a;
                    n5 = ruleResolution.d != null ? 1 : 0;
                    if (n5 == 0) continue;
                    stringBuffer.append("<font=+0 color=blue>");
                    stringBuffer.append(element2.getName());
                    if (n5 != 0) {
                        stringBuffer.append("'s </font> Rule ");
                    }
                    if (n5 != 0) {
                        stringBuffer.append("<font=+1 color=blue>");
                    }
                    stringBuffer.append(ruleResolution.c.a().toString());
                    if (n5 != 0) {
                        stringBuffer.append("</font>");
                        stringBuffer.append(" connectivity resolved to ");
                        stringBuffer.append("<font=+1 color=blue>");
                    }
                    if (ruleResolution.d != null) {
                        stringBuffer.append(ruleResolution.d.toString());
                        stringBuffer.append("</font>");
                    }
                    stringBuffer.append("<br>\n");
                }
                if (n2 > 0) {
                    stringBuffer.append("<p><b>");
                    stringBuffer.append(n2);
                    stringBuffer.append(" Rules have unresolved connectivity and will not be imported.</b><p> ");
                    for (n3 = 0; n3 < list2.size(); ++n3) {
                        ruleResolution = (RuleResolution)list2.get(n3);
                        if (ruleResolution.c == null) continue;
                        Element element3 = ruleResolution.a;
                        n5 = ruleResolution.d != null ? 1 : 0;
                        if (n5 != 0) continue;
                        stringBuffer.append("<font=+0 color=red>");
                        stringBuffer.append(element3.getName());
                        stringBuffer.append("'s Rule ");
                        stringBuffer.append(ruleResolution.c.a().toString());
                        stringBuffer.append(" connectivity is not resolved.");
                        stringBuffer.append("</font>");
                        stringBuffer.append("<br>\n");
                    }
                }
                if (n2 > 0) {
                    stringBuffer.append("<p><b>Rules needing their connectivity resolved will not be imported</b><br>");
                }
            }
        }
        stringBuffer.append("</html>");
        this._summaryPanel.setSummaryText(stringBuffer.toString());
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (!bl) {
            ClientApp.app().putAppProp("ImportDialog.Width", String.valueOf(this.getWidth()));
            ClientApp.app().putAppProp("ImportDialog.Height", String.valueOf(this.getHeight()));
            ClientApp.app().putAppProp("ImportDialog.X", String.valueOf(this.getX()));
            ClientApp.app().putAppProp("ImportDialog.Y", String.valueOf(this.getY()));
        }
    }
}

