/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.client.SummaryWizardPanel;
import hec.clientapp.client.ClientApp;
import hec.clientapp.client.ClientWorkspace;
import hec.clientapp.model.Manager;
import hec.clientapp.model.StreamAlignment;
import hec.gui.WizardDialog;
import hec.gui.WizardPanel;
import hec.io.Identifier;
import hec.lang.NamedType;
import hec.model.WatershedLocation;
import hec.rss.client.AssignStreamStationingPanel;
import hec.rss.client.NewNetworkPanel;
import hec.rss.client.RSimNetworkMode;
import hec.rss.client.ResolveComputationPointsPanel;
import hec.rss.client.SelectManagerWizardPanel;
import hec.rss.client.SelectWatershedWizardPanel;
import hec.rss.model.DiversionElement;
import hec.rss.model.DivertedOutletElement;
import hec.rss.model.Element;
import hec.rss.model.JunctionElement;
import hec.rss.model.ReservoirElement;
import hec.rss.model.RssSystem;
import hec.rss.model.RuleResolution;
import hec.watershed.model.ComputationPoint;
import hec.watershed.model.Condition;
import hec.watershed.model.ConditionDataList;
import hec.watershed.model.Diversion;
import hec.watershed.model.Reservoir;
import hec.watershed.model.Study;
import hec.watershed.model.StudyDataList;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.JOptionPane;
import mil.army.usace.hec.rmi.csinterface.RmiFileManager;
import rma.util.RMAIO;

public class ImportNetworkDialog2
extends WizardDialog {
    protected NewNetworkPanel _newNetworkPanel;
    protected SelectWatershedWizardPanel _selectWatershedPanel;
    protected SelectManagerWizardPanel _selectNetworkPanel;
    protected AssignStreamStationingPanel _assignStreamsPanel;
    protected ResolveComputationPointsPanel _resolveComputationPointsPanel;
    protected SummaryWizardPanel _summaryPanel;
    protected NamedType[] _selectedElements;
    protected ClientWorkspace _importFromWksp;
    protected RssSystem _importFromNetwork;
    protected RssSystem _importToNetwork;
    protected StreamAlignment _streamAlignment;
    protected ConditionDataList _conditionList;
    protected boolean _canceled = false;
    protected boolean _initializedOk = this.init();

    public ImportNetworkDialog2(Frame frame, boolean bl) {
        super(frame, bl);
    }

    protected void buildControls() {
        super.buildControls();
        this.buildSelectWatershedPanel();
        this.buildSelectNetworkPanel();
        this.buildNewNetworkPanel();
        this.buildAssignElementsPanel();
        this.buildResolveComputationPointsPanel();
        this.buildSummaryPanel();
        this.pack();
        String string = ClientApp.app().getAppProp("ImportDialog.Width");
        String string2 = ClientApp.app().getAppProp("ImportDialog.Height");
        String string3 = ClientApp.app().getAppProp("ImportDialog.X");
        String string4 = ClientApp.app().getAppProp("ImportDialog.Y");
        if (string != null && string2 != null) {
            int n = RMAIO.parseInt((String)string, (int)this.getWidth());
            int n2 = RMAIO.parseInt((String)string2, (int)this.getHeight());
            this.setSize(n, n2);
        }
        ImportNetworkDialog2 importNetworkDialog2 = this;
        importNetworkDialog2.setLocationRelativeTo(importNetworkDialog2.getParent());
        if (string3 != null && string4 != null) {
            int n = RMAIO.parseInt((String)string3, (int)this.getX());
            int n3 = RMAIO.parseInt((String)string4, (int)this.getY());
            this.setLocation(n, n3);
        }
        super.setTitle("Import Network Elements");
    }

    public void setTitle(String string) {
        string = String.valueOf(this.getCurrentStep());
        string = "Import Network Wizard - Step X of 6".replace('X', string.charAt(0));
        super.setTitle(string);
    }

    protected void buildSelectWatershedPanel() {
        this._selectWatershedPanel = new SelectWatershedWizardPanel();
        this._selectWatershedPanel.setNextPanelName("SelectManager");
        this._selectWatershedPanel.setAppServer(ClientApp.app().getAppServer());
        ImportNetworkDialog2 importNetworkDialog2 = this;
        importNetworkDialog2.addWizardPanel(importNetworkDialog2._selectWatershedPanel);
    }

    protected void buildSelectNetworkPanel() {
        this._selectNetworkPanel = new SelectManagerWizardPanel(RssSystem.class.getName(), "rss", "Networks");
        this._selectNetworkPanel.setPanelTitle("Select the Network to Import Elements from");
        this._selectNetworkPanel.setBackPanelName("SelectWatershed");
        this._selectNetworkPanel.setNextPanelName("NewNetwork");
        ImportNetworkDialog2 importNetworkDialog2 = this;
        importNetworkDialog2.addWizardPanel(importNetworkDialog2._selectNetworkPanel);
    }

    protected void buildNewNetworkPanel() {
        this._newNetworkPanel = new NewNetworkPanel();
        this._newNetworkPanel.setBackPanelName("SelectManager");
        this._newNetworkPanel.setNextPanelName("AssignStreams");
        this._newNetworkPanel.setManagerType("rss", RSimNetworkMode.NETWORK_CLASSNAME, "Reservoir Network", "rsys");
        ImportNetworkDialog2 importNetworkDialog2 = this;
        importNetworkDialog2.addWizardPanel(importNetworkDialog2._newNetworkPanel);
    }

    protected void buildAssignElementsPanel() {
        this._assignStreamsPanel = new AssignStreamStationingPanel();
        this._assignStreamsPanel.setBackPanelName("NewNetwork");
        this._assignStreamsPanel.setNextPanelName("ResolveComputationPoints");
        ImportNetworkDialog2 importNetworkDialog2 = this;
        importNetworkDialog2.addWizardPanel(importNetworkDialog2._assignStreamsPanel);
    }

    protected void buildResolveComputationPointsPanel() {
        this._resolveComputationPointsPanel = new ResolveComputationPointsPanel();
        this._resolveComputationPointsPanel.setBackPanelName("AssignStreams");
        this._resolveComputationPointsPanel.setNextPanelName("Summary");
        ImportNetworkDialog2 importNetworkDialog2 = this;
        importNetworkDialog2.addWizardPanel(importNetworkDialog2._resolveComputationPointsPanel);
    }

    protected void buildSummaryPanel() {
        this._summaryPanel = new SummaryWizardPanel();
        this._summaryPanel.setPanelTitle("Import Summary");
        this._summaryPanel.setBackPanelName("ResolveComputationPoints");
        ImportNetworkDialog2 importNetworkDialog2 = this;
        importNetworkDialog2.addWizardPanel((WizardPanel)importNetworkDialog2._summaryPanel);
    }

    protected boolean init() {
        Study study = null;
        ClientWorkspace clientWorkspace = ClientApp.Workspace();
        if (clientWorkspace == null) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Failed to Find the current watershed");
            return false;
        }
        StudyDataList studyDataList = (StudyDataList)clientWorkspace.getDataListContainer().getDataList(Study.class.getName());
        if (studyDataList != null) {
            study = (Study)studyDataList.getOpenStudy();
        }
        if (studyDataList == null || study == null) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Failed to Find the Study Data List");
            System.out.println("openStudy: Failed to find StudyDataList");
            return false;
        }
        studyDataList = (ConditionDataList)ClientApp.Workspace().getDataListContainer().getDataList(Condition.class.getName());
        StreamAlignment streamAlignment = null;
        Vector vector = clientWorkspace.getManagerIDList(StreamAlignment.class.getName());
        if (vector.size() <= 0) {
            JOptionPane.showMessageDialog((Component)((Object)this), "No available Stream Alignments");
            return false;
        }
        if ((vector = (Identifier)vector.elementAt(0)) != null && (streamAlignment = (StreamAlignment)clientWorkspace.openManager((Identifier)vector)) == null) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Failed to Open Stream Alignment");
            return false;
        }
        this.setWatershedLocation(ClientApp.app().getWatershedLocation(), ClientApp.Workspace().getIdentifier());
        this.setConfigurationList((ConditionDataList)studyDataList, study);
        this.setStreamAlignment(streamAlignment);
        return true;
    }

    protected int getCurrentStep() {
        WizardPanel wizardPanel = this.getCurrentPanel();
        if (wizardPanel == this._newNetworkPanel) {
            return 3;
        }
        if (wizardPanel == this._selectWatershedPanel) {
            return 1;
        }
        if (wizardPanel == this._selectNetworkPanel) {
            return 2;
        }
        if (wizardPanel == this._assignStreamsPanel) {
            return 4;
        }
        if (wizardPanel == this._resolveComputationPointsPanel) {
            return 5;
        }
        return 6;
    }

    protected void changingPanels(String string) {
        WizardPanel wizardPanel = this.getCurrentPanel();
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            if (wizardPanel == this._selectWatershedPanel && "SelectManager".equals(string)) {
                this.openWorkspace();
            } else if (wizardPanel == this._selectNetworkPanel && "NewNetwork".equals(string)) {
                this.openNetwork();
                this._newNetworkPanel.setNetworkName(this._importFromNetwork.getName());
                this._newNetworkPanel.setNetworkDescription(this._importFromNetwork.getDescription());
            } else if (wizardPanel == this._newNetworkPanel && "AssignStreams".equals(string)) {
                string = ClientApp.Workspace();
                this._assignStreamsPanel.setWorkspace((ClientWorkspace)string);
                this._assignStreamsPanel.setNewNetworkName(this._newNetworkPanel.getNewNetworkName());
            } else if (wizardPanel == this._assignStreamsPanel && "ResolveComputationPoints".equals(string)) {
                this._assignStreamsPanel.saveImportNetworkStreams(true);
                string = ClientApp.Workspace();
                this._resolveComputationPointsPanel.setWorkspace((ClientWorkspace)string);
                this._resolveComputationPointsPanel.setNewNetworkName(this._newNetworkPanel.getNewNetworkName());
                this._resolveComputationPointsPanel.setImportFromNetwork(this._importFromNetwork);
            } else if (wizardPanel == this._resolveComputationPointsPanel && "Summary".equals(string)) {
                this.createSummaryText();
            }
            return;
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    protected void openWorkspace() {
        ClientWorkspace clientWorkspace = this._importFromWksp;
        this._importFromWksp = this._selectWatershedPanel.openSelectedWorkspace();
        if (clientWorkspace != this._importFromWksp) {
            this._selectNetworkPanel.setWorkspace(this._importFromWksp);
            this._assignStreamsPanel.setWorkspace(this._importFromWksp);
        }
    }

    protected void openNetwork() {
        block5: {
            Identifier identifier;
            block4: {
                identifier = this._selectNetworkPanel.getSelectedIdentifier();
                if (identifier == null) {
                    return;
                }
                if (this._importFromNetwork == null) break block4;
                if (identifier.equals((Object)this._importFromNetwork.getIdentifier())) break block5;
                this._importFromWksp.unloadManager("rss", this._importFromNetwork.getIdentifier());
            }
            this._importFromNetwork = (RssSystem)this._importFromWksp.openManager("rss", identifier);
        }
        this._assignStreamsPanel.setImportFromNetwork(this._importFromNetwork);
        this._assignStreamsPanel.setStreamAlignment(this._streamAlignment);
    }

    protected void createNetwork() {
        this._newNetworkPanel.getNewNetworkName();
        this._newNetworkPanel.getNewNetworkDescription();
    }

    protected void dialogCanceled() {
        this._canceled = true;
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.closeWorkspace();
            return;
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    protected void dialogFinished() {
        String string = this._newNetworkPanel.getNewNetworkName();
        int n = JOptionPane.showConfirmDialog((Component)((Object)this), "Proceeding with the Import operation will create a new network with the name: " + string + "\nContinue?", "Continue with Import", 0);
        if (n == 0) {
            Cursor cursor = this.getCursor();
            try {
                this.setCursor(Cursor.getPredefinedCursor(3));
                this._assignStreamsPanel.saveImportNetworkStreams(true);
                Object object = this._resolveComputationPointsPanel.getComputationPointMap();
                Condition condition = this._resolveComputationPointsPanel.getSelectedConfiguration();
                ImportNetworkDialog2 importNetworkDialog2 = this;
                importNetworkDialog2.updateConfiguration(importNetworkDialog2._importFromNetwork, condition, (HashMap)object);
                object = this._newNetworkPanel.getNewNetworkDescription();
                ImportNetworkDialog2 importNetworkDialog22 = this;
                importNetworkDialog22.saveNetwork(importNetworkDialog22._importFromNetwork, string, (String)object);
                this.closeWorkspace();
                this.setVisible(false);
                return;
            }
            finally {
                this.setCursor(cursor);
            }
        }
    }

    protected void importSuccessMsg(StringBuffer stringBuffer, RuleResolution ruleResolution) {
        stringBuffer.append(ruleResolution.a.getElementType());
        stringBuffer.append(" <b>");
        stringBuffer.append(ruleResolution.a.getName());
        stringBuffer.append("</b> imported successfully from <b>");
        stringBuffer.append(ruleResolution.b.getName());
        stringBuffer.append("</b><br>");
    }

    protected void importFailedMsg(StringBuffer stringBuffer, RuleResolution ruleResolution) {
        stringBuffer.append("<font=+0 color=red>");
        stringBuffer.append(ruleResolution.a.getElementType());
        stringBuffer.append(" <b>");
        stringBuffer.append(ruleResolution.a.getName());
        stringBuffer.append("</b> failed to import from <b>");
        stringBuffer.append(ruleResolution.b.getName());
        stringBuffer.append("</b></font><br>");
    }

    protected void updateConfiguration(RssSystem rssSystem, Condition object, HashMap hashMap) {
        Object object2;
        Object object3;
        int n;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (rssSystem == null || object == null || hashMap == null) {
            return;
        }
        rssSystem.setConfigurationForImport((Condition)object);
        rssSystem.clearStreamAlignment();
        if (hashMap.keySet() == null) {
            return;
        }
        Object[] objectArray = hashMap.keySet().toArray();
        for (n = 0; n < objectArray.length; ++n) {
            object3 = objectArray[n];
            object = hashMap.get(object3);
            if (!(object3 instanceof JunctionElement)) continue;
            if (object instanceof ComputationPoint) {
                object = (ComputationPoint)object;
                object2 = (JunctionElement)object3;
                ((JunctionElement)object2).setComputationPoint((ComputationPoint)object);
                continue;
            }
            ((JunctionElement)object3).setComputationPoint(null);
            arrayList.add(object3);
        }
        for (n = 0; n < objectArray.length; ++n) {
            Reservoir reservoir;
            object3 = objectArray[n];
            object = hashMap.get(object3);
            if (object3 instanceof JunctionElement) continue;
            if (object3 instanceof ReservoirElement) {
                object2 = (ReservoirElement)object3;
                if (object instanceof Reservoir) {
                    reservoir = (Reservoir)object;
                    ((Element)object2).setName(reservoir.getName());
                    ((ReservoirElement)object2).setLabelPosition(reservoir.getLabelPosition());
                    object2.setDescription(reservoir.getDescription());
                } else {
                    ((ReservoirElement)object2).setReservoirProjectId(Long.MIN_VALUE);
                    arrayList.add(object3);
                }
            }
            if (object3 instanceof DiversionElement) {
                object2 = (DiversionElement)object3;
                if (object instanceof Diversion) {
                    reservoir = (Diversion)object;
                    ((Element)object2).setName(reservoir.getName());
                    object2.setDescription(reservoir.getDescription());
                    ((DiversionElement)object2).setDiversionProjectId(reservoir.getId());
                    continue;
                }
                ((DiversionElement)object2).setDiversionProjectId(Long.MIN_VALUE);
                arrayList.add(object3);
                continue;
            }
            if (object3 instanceof DivertedOutletElement) {
                object2 = (DivertedOutletElement)object3;
                if (!(object instanceof Diversion)) continue;
                reservoir = (Diversion)object;
                if (reservoir == null) {
                    ((DivertedOutletElement)object2).setDiversionProjectId(Long.MIN_VALUE);
                    continue;
                }
                ((Element)object2).setName(reservoir.getName());
                object2.setDescription(reservoir.getDescription());
                ((DivertedOutletElement)object2).setDiversionProjectId(reservoir.getId());
                continue;
            }
            arrayList.add(object3);
        }
        object2 = rssSystem.getElementVectorByClass(ReservoirElement.class.getName());
        for (int i = 0; i < ((Vector)object2).size(); ++i) {
            ReservoirElement reservoirElement = (ReservoirElement)((Vector)object2).get(i);
            reservoirElement.updateSegments();
        }
    }

    protected void saveNetwork(RssSystem rssSystem, String string, String string2) {
        ClientWorkspace clientWorkspace = ClientApp.Workspace();
        Identifier identifier = clientWorkspace.getManagerIdentifier("rss", RSimNetworkMode.NETWORK_CLASSNAME, string, "rsys");
        identifier.setDescription(string2);
        Object object = (RmiFileManager)ClientApp.app().getFileManager().getRemote();
        boolean bl = false;
        try {
            if (object.fileExists(identifier)) {
                bl = true;
            }
        }
        catch (RemoteException remoteException) {
            System.out.println("validForm: RMI Error checking existance of directory " + String.valueOf(identifier));
        }
        if (!bl || (object = (RssSystem)clientWorkspace.openManagerByName("rss", RSimNetworkMode.NETWORK_CLASSNAME, string)) == null) {
            object = (RssSystem)clientWorkspace.newManager("rss", RSimNetworkMode.NETWORK_CLASSNAME);
        }
        object.setIdentifier(identifier);
        object.setName(string);
        object.setDescription(string2);
        String string3 = rssSystem.getName();
        String string4 = rssSystem.getDescription();
        Identifier identifier2 = rssSystem.getIdentifier();
        rssSystem.setName(string);
        rssSystem.setDescription(string2);
        string = bl ? clientWorkspace.openRemoteFileID(identifier) : clientWorkspace.newRemoteFileID(identifier);
        rssSystem.setIdentifier(identifier);
        rssSystem.resetAndSaveOperations();
        rssSystem.writeFile((Identifier)string);
        rssSystem.setIdentifier(identifier2);
        rssSystem.setName(string3);
        rssSystem.setDescription(string4);
        int n = object.getIndex();
        ((RssSystem)object).readFile((Identifier)string);
        object.setIndex(n);
        clientWorkspace.saveManagerAs("rss", (Manager)object, identifier);
    }

    public void setWatershedLocation(WatershedLocation watershedLocation, Identifier identifier) {
        this._selectWatershedPanel.setSelectedWatershedLocation(ClientApp.app().getWatershedLocation());
        this._selectWatershedPanel.setSelectedWorkspace(ClientApp.Workspace().getIdentifier());
    }

    protected void closeWorkspace() {
        if (this._importFromWksp != null && this._importFromNetwork != null) {
            this._importFromWksp.unloadManager("rss", this._importFromNetwork.getIdentifier());
            this._importFromNetwork = null;
        }
        this._selectWatershedPanel.closeSelectedWorkspace();
        this._importFromWksp = null;
    }

    public void setNetwork(RssSystem rssSystem) {
        this._importToNetwork = rssSystem;
        this._importToNetwork.updateTSProxyList();
    }

    public void setStreamAlignment(StreamAlignment streamAlignment) {
        this._streamAlignment = streamAlignment;
    }

    public void setConfigurationList(ConditionDataList conditionDataList, Study study) {
        this._conditionList = conditionDataList;
        this._resolveComputationPointsPanel.setConfigurationList(conditionDataList, study);
    }

    protected void createSummaryText() {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        int n;
        StringBuffer stringBuffer = new StringBuffer(1000);
        stringBuffer.append("<html><h1> Summary</h1>");
        stringBuffer.append("<p>New Network: ");
        stringBuffer.append(this._newNetworkPanel.getNewNetworkName());
        stringBuffer.append("<p> Import from Watershed: ");
        stringBuffer.append(this._importFromWksp.getTitleName());
        stringBuffer.append("<p> Import from Network: ");
        stringBuffer.append(this._importFromNetwork.getName());
        stringBuffer.append("<p>");
        Object object6 = this._assignStreamsPanel.getElementAssigmentsList();
        stringBuffer.append("<h1> Stream Mapping Summary</h1><b>");
        stringBuffer.append(" Element    Element Type       Old Stream Name               New Steam Name</b><p>");
        String string = "<font=+0 color=blue>";
        String string2 = "</font>";
        for (n = 0; n < object6.size(); ++n) {
            object5 = (Vector)object6.get(n);
            object4 = (String)((Vector)object5).get(0);
            object3 = (String)((Vector)object5).get(1);
            object2 = (String)((Vector)object5).get(2);
            object5 = (String)((Vector)object5).get(3);
            object = this.elementTypeString((String)object3);
            String string3 = (String)object + string + (String)object4 + string2 + " on Stream " + string + (String)object2 + string2 + " Mapped to Stream " + string + (String)object5 + string2;
            stringBuffer.append(string3);
            stringBuffer.append("<br>\n");
        }
        object6 = this._assignStreamsPanel.getElementsNotAssignedList();
        if (object6.size() > 0) {
            stringBuffer.append("<p><b>");
            stringBuffer.append(object6.size());
            stringBuffer.append(" Streams for these imported elements were not assigned</b><p>");
            stringBuffer.append("<font=+0 color=red>");
            string = "<font=+0 color=red>";
            for (n = 0; n < object6.size(); ++n) {
                object5 = (Vector)object6.get(n);
                object4 = (String)((Vector)object5).get(0);
                object3 = (String)((Vector)object5).get(1);
                object2 = (String)((Vector)object5).get(2);
                object5 = this.elementTypeString((String)object3);
                object = (String)object5 + string + (String)object4 + string2 + " from Stream " + string + (String)object2 + string2 + " Not Mapped";
                stringBuffer.append((String)object);
                stringBuffer.append("<br>\n");
            }
        }
        stringBuffer.append("<h1> Configuration Summary</h1>");
        stringBuffer.append("<p><b>");
        stringBuffer.append("Assigned Configuration for Network: </b>");
        Condition condition = this._resolveComputationPointsPanel.getSelectedConfiguration();
        if (condition != null) {
            condition.getName();
        }
        stringBuffer.append(condition);
        stringBuffer.append("<p>");
        object4 = this._resolveComputationPointsPanel.getAssignedList();
        if (object4 == null) {
            stringBuffer.append(" No Computation Points Assignments .<br>");
        } else {
            string = "<font=+0 color=blue>";
            string2 = "</font>";
            for (int i = 0; i < object4.size(); ++i) {
                object6 = (Vector)object4.get(i);
                object3 = (String)((Vector)object6).get(0);
                object2 = (String)((Vector)object6).get(1);
                object5 = (String)((Vector)object6).get(2);
                if (((String)object2).equalsIgnoreCase("junction")) {
                    object = "Junction " + string + (String)object3 + string2 + " Mapped to Computation Point " + string + (String)object5 + string2;
                } else {
                    if (((String)object2).length() <= 0) continue;
                    object6 = this.elementTypeString((String)object2);
                    object = (String)object6 + string + (String)object3 + string2 + " Mapped to " + string + (String)object5 + string2;
                }
                stringBuffer.append((String)object);
                stringBuffer.append("<br>\n");
            }
        }
        stringBuffer.append("<p><b>");
        stringBuffer.append("Elements Not Mapped: ");
        stringBuffer.append("</b><p>");
        object3 = this._resolveComputationPointsPanel.getNotAssignedList();
        if (object3 == null) {
            stringBuffer.append(" None .<br>");
        } else {
            string = "<font=+0 color=red>";
            string2 = "</font>";
            for (int i = 0; i < object3.size(); ++i) {
                object6 = (Vector)object3.get(i);
                object2 = (String)((Vector)object6).get(0);
                object5 = (String)((Vector)object6).get(1);
                if (((String)object5).length() <= 0) continue;
                object6 = this.elementTypeString((String)object5);
                object = (String)object6 + string + (String)object2 + string2 + " Not Mapped ";
                stringBuffer.append((String)object);
                stringBuffer.append("<br>\n");
            }
        }
        stringBuffer.append("<p><b>");
        stringBuffer.append("Computation Points Not Assigned: ");
        stringBuffer.append("</b><p>");
        object2 = this._resolveComputationPointsPanel.getUnusedCpList();
        if (object2 == null) {
            stringBuffer.append(" None .<br>");
        } else {
            string = "<font=+0 color=red>";
            string2 = "</font>";
            for (int i = 0; i < object2.size(); ++i) {
                Vector vector = (Vector)object2.get(i);
                object5 = (String)vector.get(0) + string + (String)vector.get(1) + string2 + " Not Assigned";
                stringBuffer.append((String)object5);
                stringBuffer.append("<br>\n");
            }
        }
        stringBuffer.append("</html>");
        this._summaryPanel.setSummaryText(stringBuffer.toString());
    }

    protected String elementTypeString(String string) {
        String string2 = "";
        if (string.equalsIgnoreCase("junction")) {
            string2 = "Junction ";
        } else if (string.equalsIgnoreCase("reservoir")) {
            string2 = "Reservoir ";
        } else if (string.equalsIgnoreCase("diversion")) {
            string2 = "Diversion ";
        } else if (string.equalsIgnoreCase("divertedoutlet")) {
            string2 = "Diverted Outlet ";
        } else if (string.equalsIgnoreCase("reach")) {
            string2 = "Reach ";
        }
        return string2;
    }

    public void setVisible(boolean bl) {
        if (!this._initializedOk) {
            this._canceled = true;
            return;
        }
        super.setVisible(bl);
        if (!bl) {
            ClientApp.app().putAppProp("ImportDialog.Width", String.valueOf(this.getWidth()));
            ClientApp.app().putAppProp("ImportDialog.Height", String.valueOf(this.getHeight()));
            ClientApp.app().putAppProp("ImportDialog.X", String.valueOf(this.getX()));
            ClientApp.app().putAppProp("ImportDialog.Y", String.valueOf(this.getY()));
        }
    }

    public boolean isCanceled() {
        return this._canceled;
    }
}

