/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.rss.client.IndependentVariableDialog;
import hec.rss.client.IndependentVariableDialog$StateVariablePanel$1;
import hec.rss.client.IndependentVariableDialog$StateVariablePanel$2;
import hec.rss.client.IndependentVariableDialog$StateVariablePanel$3;
import hec.rss.client.IndependentVariableDialog$StateVariablePanel$4;
import hec.rss.client.IndependentVariableDialog$StateVariablePanel$StTableModel;
import hec.rss.client.TimeSeriesOptionsPanel;
import hec.rss.model.RssSystem;
import hec.rss.model.StateVariable;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.MouseListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableModel;
import rma.swing.RmaInsets;
import rma.swing.RmaJTable;
import rma.swing.RmaJTextField;
import rma.swing.table.RmaTableSorter;

public class IndependentVariableDialog$StateVariablePanel
extends JPanel {
    private String[] COLNAMES;
    private RmaJTable _stateVariableTable;
    private JButton _selectButton;
    private RmaJTextField _selectedValueTxt;
    private RmaTableSorter _sorter;
    private IndependentVariableDialog$StateVariablePanel$StTableModel _tableModel;
    private IndependentVariableDialog$StateVariablePanel$StTableModel _currentTableModel;
    private StateVariable _selectedStateVariable;
    private TimeSeriesOptionsPanel _tsOptionsPanel;
    final /* synthetic */ IndependentVariableDialog this$0;

    IndependentVariableDialog$StateVariablePanel(IndependentVariableDialog independentVariableDialog) {
        this.this$0 = independentVariableDialog;
        super(new GridBagLayout());
        this.COLNAMES = new String[]{"State Variable", "Parameter Name", "Parameter Type"};
        this.buildControls();
        this.addListeners();
    }

    protected void buildControls() {
        IndependentVariableDialog$StateVariablePanel independentVariableDialog$StateVariablePanel = this;
        this._stateVariableTable = new IndependentVariableDialog$StateVariablePanel$1(independentVariableDialog$StateVariablePanel, independentVariableDialog$StateVariablePanel);
        this._tableModel = new IndependentVariableDialog$StateVariablePanel$StTableModel(this);
        this._tableModel.getDataVector().clear();
        this._currentTableModel = this._tableModel;
        this._stateVariableTable.setModel((TableModel)((Object)this._tableModel));
        this._stateVariableTable.setEditable(false);
        this._stateVariableTable.setAddRemoveEnabled(false);
        this._stateVariableTable.setSelectionMode(0);
        this._stateVariableTable.setColumnSelectionAllowed(false);
        this._stateVariableTable.setCellSelectionEnabled(false);
        this._stateVariableTable.setRowSelectionAllowed(true);
        this._sorter = new RmaTableSorter(this._stateVariableTable.getModel());
        this._stateVariableTable.setModel((TableModel)this._sorter);
        this._sorter.addMouseListenerToHeaderInTable((JTable)this._stateVariableTable);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        IndependentVariableDialog$StateVariablePanel independentVariableDialog$StateVariablePanel2 = this;
        independentVariableDialog$StateVariablePanel2.add((Component)independentVariableDialog$StateVariablePanel2._stateVariableTable.getScrollPane(), gridBagConstraints);
        this._selectButton = new JButton("Select");
        this._selectButton.setMnemonic('S');
        this._selectButton.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        IndependentVariableDialog$StateVariablePanel independentVariableDialog$StateVariablePanel3 = this;
        independentVariableDialog$StateVariablePanel3.add((Component)independentVariableDialog$StateVariablePanel3._selectButton, gridBagConstraints);
        JLabel jLabel = new JLabel("Selected Model Time-Series");
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)5, (int)5);
        this.add((Component)jLabel, gridBagConstraints);
        this._selectedValueTxt = new RmaJTextField();
        this._selectedValueTxt.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)5, (int)5);
        IndependentVariableDialog$StateVariablePanel independentVariableDialog$StateVariablePanel4 = this;
        independentVariableDialog$StateVariablePanel4.add((Component)independentVariableDialog$StateVariablePanel4._selectedValueTxt, gridBagConstraints);
        this._tsOptionsPanel = new TimeSeriesOptionsPanel();
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 4;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.insets((int)25, (int)5, (int)0, (int)5);
        IndependentVariableDialog$StateVariablePanel independentVariableDialog$StateVariablePanel5 = this;
        independentVariableDialog$StateVariablePanel5.add((Component)independentVariableDialog$StateVariablePanel5._tsOptionsPanel, gridBagConstraints);
    }

    protected void addListeners() {
        this._stateVariableTable.getSelectionModel().addListSelectionListener(new IndependentVariableDialog$StateVariablePanel$2(this));
        this._stateVariableTable.addMouseListener((MouseListener)new IndependentVariableDialog$StateVariablePanel$3(this));
        this._selectButton.addActionListener(new IndependentVariableDialog$StateVariablePanel$4(this));
    }

    private void selectStateVariable() {
        int n = this._stateVariableTable.getSelectedRow();
        if (n == -1) {
            this._selectedValueTxt.setText("");
            return;
        }
        if ((n = this._sorter.getMappedRow(n)) == -1) {
            this._selectedValueTxt.setText("");
            return;
        }
        this._selectedStateVariable = this._currentTableModel.getStateVariableAt(n);
        this.setSelectedValueTxt();
    }

    public void disableAllFields(boolean bl) {
        this._stateVariableTable.setEnabled(!bl);
        this._selectedValueTxt.setEnabled(!bl);
        if (bl) {
            this._tsOptionsPanel.disableAllFields();
            return;
        }
        this._tsOptionsPanel.enableAllFields();
    }

    protected void setTSOptionVisible(boolean bl) {
        this._tsOptionsPanel.setVisible(bl);
    }

    public boolean isValidForm() {
        if (!this._tsOptionsPanel.isValidForm()) {
            return false;
        }
        String string = null;
        if (this._selectedStateVariable == null) {
            string = "No StateVariable Selected";
        }
        if (string != null) {
            JOptionPane.showMessageDialog(this, string, "Incomplete Form", 1);
        }
        return string == null;
    }

    public void clearPanel() {
        this._stateVariableTable.deleteCells();
        this._selectedStateVariable = null;
        this.setSelectedValueTxt();
        this._tsOptionsPanel.clearPanel();
    }

    public void setSelectedStateVariable(StateVariable stateVariable) {
        this._selectedStateVariable = stateVariable;
        this.setSelectedValueTxt();
        this._currentTableModel.setSelectedStateVariable(stateVariable);
    }

    public void setTimeSeriesOptions(String string, double d, double d2) {
        this._tsOptionsPanel.setTimeSeriesOptions(string, d, d2);
    }

    public StateVariable getSelectedStateVariable() {
        return this._selectedStateVariable;
    }

    public int getTimeSeriesOptionFunction() {
        return this._tsOptionsPanel.getFunctionType();
    }

    public double getTimeSeriesOptionLag() {
        return this._tsOptionsPanel.getLag();
    }

    public double getTimeSeriesOptionPeriod() {
        return this._tsOptionsPanel.getPeriod();
    }

    public void setNetwork(RssSystem rssSystem) {
        this._currentTableModel.setStateVariables(rssSystem.getStateVariableList());
        this._sorter.reallocateIndexes();
    }

    void setSelectedValueTxt() {
        if (this._selectedStateVariable == null) {
            this._selectedValueTxt.setText("");
            return;
        }
        this._selectedValueTxt.setText(this._selectedStateVariable.getName());
    }
}

