/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.clientapp.model.TSRecordProxy;
import hec.model.ModelVariable;
import hec.rss.client.IndependentVariableDialog$1;
import hec.rss.client.IndependentVariableDialog$2;
import hec.rss.client.IndependentVariableDialog$3;
import hec.rss.client.IndependentVariableDialog$GlobalVariablePanel;
import hec.rss.client.IndependentVariableDialog$ModelVariablePanel;
import hec.rss.client.IndependentVariableDialog$StateVariablePanel;
import hec.rss.client.IndependentVariableDialog$TimeSeriesPanel;
import hec.rss.client.IndependentVariableDialog$TwoVariablePanel;
import hec.rss.model.Element;
import hec.rss.model.IndependentVariable;
import hec.rss.model.RssModelVariableSet;
import hec.rss.model.RssSystem;
import hec.rss.model.StateVariable;
import hec.rss.model.globalvariable.GlobalVariable;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ItemListener;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import rma.swing.ButtonCmdPanel;
import rma.swing.ButtonCmdPanelListener;
import rma.swing.RmaInsets;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJDialog;
import rma.swing.RmaJPanel;
import rma.swing.list.RmaListModel;

public class IndependentVariableDialog
extends RmaJDialog {
    public static final String DATE_FUNCTION_TYPE = "Date";
    public static final String DATE_TIME_FUNCTION_TYPE = "Date and Time";
    public static final String MODEL_VARIABLE_FUNCTION_TYPE = "Model Variable";
    public static final String TIME_SERIES_FUNCTION_TYPE = "External Variable";
    public static final String STATE_VARIABLE_TYPE = "State Variable";
    public static final String TWO_VARIABLE_TYPE = "Two Variable";
    public static final String GLOBAL_VARIABLE_TYPE = "Global Variable";
    public static final int DIALOG_TYPE_RELEASE = 0;
    public static final int DIALOG_TYPE_ZONE = 1;
    public static final int DIALOG_TYPE_STAGE = 2;
    public static final int DIALOG_TYPE_OPSUPPORT = 3;
    public static final int DIALOG_TYPE_INDUCEDSURCHARGE = 4;
    protected static String[] a;
    protected static String[] b;
    protected static String[] c;
    protected static String[] d;
    protected static final String[] e;
    protected RmaJComboBox<String> _releaseFunctionCombo;
    private ButtonCmdPanel _cmdPanel;
    protected IndependentVariableDialog$ModelVariablePanel _modelVariablePanel;
    protected IndependentVariableDialog$TimeSeriesPanel _timeSeriesPanel;
    protected IndependentVariableDialog$StateVariablePanel _stateVariablePanel;
    protected IndependentVariableDialog$GlobalVariablePanel _globalVariablePanel;
    private IndependentVariableDialog$TwoVariablePanel _twoVariablePanel;
    private JPanel _cardPanel;
    private JLabel _variableTypeLabel;
    private RmaJPanel _extraPanel = null;
    private boolean _canceled;
    private RssSystem _network;
    private String _ivFunctionType = "Release";
    private boolean _isStorageZone = false;
    private boolean _isStage = false;
    private boolean _isOpSupport = false;
    private boolean _isInducedSurcharge = false;
    private boolean _isTimeSeries = false;
    private boolean _isTimeSeriesChecked = false;
    private int _yPosition = 0;
    private static Hashtable<Integer, ModelVariable> f;

    public IndependentVariableDialog(Dialog dialog, int n) {
        super(dialog);
        f = new Hashtable<Integer, ModelVariable>();
        f.put(112, RssModelVariableSet.getModelVariable(112));
        f.put(86, RssModelVariableSet.getModelVariable(86));
        f.put(102, RssModelVariableSet.getModelVariable(102));
        f.put(16, RssModelVariableSet.getModelVariable(16));
        f.put(47, RssModelVariableSet.getModelVariable(47));
        this.getContentPane().setLayout(new GridBagLayout());
        this.setDialogType(n);
    }

    public IndependentVariableDialog(Frame frame, boolean bl) {
        super(frame, bl);
        f = new Hashtable<Integer, ModelVariable>();
        f.put(112, RssModelVariableSet.getModelVariable(112));
        f.put(86, RssModelVariableSet.getModelVariable(86));
        f.put(102, RssModelVariableSet.getModelVariable(102));
        f.put(16, RssModelVariableSet.getModelVariable(16));
        f.put(47, RssModelVariableSet.getModelVariable(47));
        this.getContentPane().setLayout(new GridBagLayout());
        this.buildControls();
    }

    public IndependentVariableDialog(Dialog dialog, boolean bl) {
        super(dialog, bl);
        f = new Hashtable<Integer, ModelVariable>();
        f.put(112, RssModelVariableSet.getModelVariable(112));
        f.put(86, RssModelVariableSet.getModelVariable(86));
        f.put(102, RssModelVariableSet.getModelVariable(102));
        f.put(16, RssModelVariableSet.getModelVariable(16));
        f.put(47, RssModelVariableSet.getModelVariable(47));
        this.getContentPane().setLayout(new GridBagLayout());
        this.buildControls();
    }

    public IndependentVariableDialog(Dialog dialog, boolean bl, boolean bl2, String string) {
        super(dialog, bl);
        f = new Hashtable<Integer, ModelVariable>();
        f.put(112, RssModelVariableSet.getModelVariable(112));
        f.put(86, RssModelVariableSet.getModelVariable(86));
        f.put(102, RssModelVariableSet.getModelVariable(102));
        f.put(16, RssModelVariableSet.getModelVariable(16));
        f.put(47, RssModelVariableSet.getModelVariable(47));
        this._isStorageZone = true;
        this._isStage = false;
        this._isTimeSeries = bl2;
        this._ivFunctionType = string;
        this.getContentPane().setLayout(new GridBagLayout());
        this.buildControls();
    }

    public IndependentVariableDialog(Frame frame, boolean bl, int n, String string) {
        super(frame, bl);
        f = new Hashtable<Integer, ModelVariable>();
        f.put(112, RssModelVariableSet.getModelVariable(112));
        f.put(86, RssModelVariableSet.getModelVariable(86));
        f.put(102, RssModelVariableSet.getModelVariable(102));
        f.put(16, RssModelVariableSet.getModelVariable(16));
        f.put(47, RssModelVariableSet.getModelVariable(47));
        this.setDialogType(n);
        this._ivFunctionType = string;
        this.getContentPane().setLayout(new GridBagLayout());
        this.buildControls();
    }

    public IndependentVariableDialog(Dialog dialog, boolean bl, int n, String string) {
        super(dialog, bl);
        f = new Hashtable<Integer, ModelVariable>();
        f.put(112, RssModelVariableSet.getModelVariable(112));
        f.put(86, RssModelVariableSet.getModelVariable(86));
        f.put(102, RssModelVariableSet.getModelVariable(102));
        f.put(16, RssModelVariableSet.getModelVariable(16));
        f.put(47, RssModelVariableSet.getModelVariable(47));
        this.setDialogType(n);
        this._ivFunctionType = string;
        this.getContentPane().setLayout(new GridBagLayout());
        this.buildControls();
    }

    protected void setDialogType(int n) {
        if (n != 0) {
            if (n == 1) {
                this._isStorageZone = true;
                this._isStage = false;
                this._isOpSupport = false;
                this._isTimeSeries = true;
                this._isInducedSurcharge = false;
                return;
            }
            if (n == 2) {
                this._isStorageZone = false;
                this._isStage = true;
                this._isOpSupport = false;
                this._isInducedSurcharge = false;
                this._isTimeSeries = false;
                return;
            }
            if (n == 3) {
                this._isStorageZone = false;
                this._isStage = false;
                this._isOpSupport = true;
                this._isTimeSeries = false;
                this._isInducedSurcharge = false;
                return;
            }
            if (n == 4) {
                this._isStorageZone = false;
                this._isStage = false;
                this._isOpSupport = false;
                this._isInducedSurcharge = true;
                this._isTimeSeries = false;
                return;
            }
        }
        this._isStorageZone = false;
        this._isStage = false;
        this._isOpSupport = false;
        this._isTimeSeries = false;
        this._isInducedSurcharge = false;
    }

    protected void buildControls(RmaJPanel object) {
        this._extraPanel = object;
        object = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        object.gridy = this._yPosition++;
        object.gridwidth = 4;
        object.anchor = 18;
        object.fill = 2;
        object.insets = RmaInsets.insets((int)5, (int)5, (int)5, (int)5);
        this.getContentPane().add((Component)this._extraPanel, object);
        this.buildControls();
    }

    protected void buildControls() {
        this.setDefaultCloseOperation(0);
        this.setTitle("Independent Variable Definition");
        this._variableTypeLabel = new JLabel(this._ivFunctionType + " is a Function of :");
        this._variableTypeLabel.setDisplayedMnemonic('R');
        Object object = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        object.gridy = this._yPosition;
        object.gridwidth = 1;
        object.anchor = 17;
        object.fill = 0;
        object.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        this.getContentPane().add((Component)this._variableTypeLabel, object);
        object = a;
        if (this._isStorageZone) {
            object = b;
        } else if (this._isStage) {
            object = c;
        } else if (this._isOpSupport) {
            object = d;
        } else if (this._isInducedSurcharge) {
            object = e;
        }
        this._releaseFunctionCombo = new RmaJComboBox(object);
        this._variableTypeLabel.setLabelFor((Component)this._releaseFunctionCombo);
        object = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        object.gridy = this._yPosition++;
        object.gridwidth = 1;
        object.anchor = 17;
        object.fill = 2;
        object.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        this.getContentPane().add((Component)this._releaseFunctionCombo, object);
        this._cardPanel = new JPanel(new CardLayout());
        this._cardPanel.setBorder(BorderFactory.createEtchedBorder());
        object = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        object.gridy = this._yPosition++;
        object.gridwidth = 2;
        object.weightx = 1.0;
        object.weighty = 1.0;
        object.anchor = 18;
        object.fill = 1;
        object.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        this.getContentPane().add((Component)this._cardPanel, object);
        this._cmdPanel = new ButtonCmdPanel(12);
        object = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        object.gridy = this._yPosition;
        object.gridwidth = 2;
        object.anchor = 15;
        object.fill = 2;
        object.insets = RmaInsets.insets((int)5, (int)5, (int)5, (int)5);
        this.getContentPane().add((Component)this._cmdPanel, object);
        this._modelVariablePanel = new IndependentVariableDialog$ModelVariablePanel(this);
        this._timeSeriesPanel = new IndependentVariableDialog$TimeSeriesPanel(this);
        this._stateVariablePanel = new IndependentVariableDialog$StateVariablePanel(this);
        this._globalVariablePanel = new IndependentVariableDialog$GlobalVariablePanel(this);
        this._cardPanel.add(DATE_FUNCTION_TYPE, new JPanel());
        this._cardPanel.add(DATE_TIME_FUNCTION_TYPE, new JPanel());
        this._cardPanel.add(MODEL_VARIABLE_FUNCTION_TYPE, this._modelVariablePanel);
        this._cardPanel.add(TIME_SERIES_FUNCTION_TYPE, this._timeSeriesPanel);
        this._cardPanel.add(STATE_VARIABLE_TYPE, this._stateVariablePanel);
        this._cardPanel.add(GLOBAL_VARIABLE_TYPE, this._globalVariablePanel);
        if (this._isStorageZone || this._isStage) {
            this._twoVariablePanel = new IndependentVariableDialog$TwoVariablePanel(this);
            this._cardPanel.add(TWO_VARIABLE_TYPE, this._twoVariablePanel);
        }
        this._releaseFunctionCombo.addItemListener((ItemListener)new IndependentVariableDialog$1(this));
        this._cmdPanel.addCmdPanelListener((ButtonCmdPanelListener)new IndependentVariableDialog$2(this));
        this.pack();
        this.setLocation();
        this.registerEnterKey(false);
        this.registerEscapeKey(false);
        this.getRootPane().setDefaultButton(null);
        this.addWindowListener(new IndependentVariableDialog$3(this));
    }

    protected void setTSOptionVisible(boolean bl) {
        if (this._modelVariablePanel != null) {
            this._modelVariablePanel.setTSOptionVisible(bl);
        }
        if (this._stateVariablePanel != null) {
            this._stateVariablePanel.setTSOptionVisible(bl);
        }
        if (this._globalVariablePanel != null) {
            this._globalVariablePanel.setTSOptionVisible(bl);
        }
        if (this._timeSeriesPanel != null) {
            this._timeSeriesPanel.setTSOptionVisible(bl);
        }
    }

    protected void releasefunctionComboChanged() {
        String string = (String)this._releaseFunctionCombo.getSelectedItem();
        if (string == null) {
            string = a[0];
        }
        ((CardLayout)this._cardPanel.getLayout()).show(this._cardPanel, string);
    }

    public void setNetwork(RssSystem rssSystem) {
        this._modelVariablePanel.clearPanel();
        this._timeSeriesPanel.clearPanel();
        this._stateVariablePanel.clearPanel();
        this._globalVariablePanel.clearPanel();
        this._releaseFunctionCombo.setSelectedIndex(0);
        if (this._isStorageZone || this._isStage) {
            this._twoVariablePanel.clearPanel();
        }
        if (rssSystem == null) {
            return;
        }
        this._modelVariablePanel.setNetwork(rssSystem);
        this._stateVariablePanel.setNetwork(rssSystem);
        this._globalVariablePanel.setNetwork(rssSystem);
        if (this._isStorageZone || this._isStage) {
            this._twoVariablePanel.setNetwork(rssSystem);
        }
    }

    public void setElement(Element element) {
        this._modelVariablePanel.setElement(element);
    }

    public void setAllowableSelections(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        RmaListModel rmaListModel = new RmaListModel(false);
        for (int i = 0; i < stringArray.length; ++i) {
            for (int j = 0; j < a.length; ++j) {
                if (!stringArray[i].equalsIgnoreCase(a[j])) continue;
                rmaListModel.addElement((Object)a[j]);
            }
        }
        this._releaseFunctionCombo.setModel((ComboBoxModel)rmaListModel);
    }

    public void setExternalVariableName(String string) {
        this._timeSeriesPanel._nameTxt.setText(string);
        this._timeSeriesPanel._nameTxt.setEditable(false);
    }

    public void setVariableTypeLabel(String string, char c) {
        this._variableTypeLabel.setText(string);
        this._variableTypeLabel.setDisplayedMnemonic(c);
    }

    private int getIndependentVariableType() {
        String string = (String)this._releaseFunctionCombo.getSelectedItem();
        if (DATE_FUNCTION_TYPE.equals(string)) {
            return 0;
        }
        if (DATE_TIME_FUNCTION_TYPE.equals(string)) {
            return 1;
        }
        if (MODEL_VARIABLE_FUNCTION_TYPE.equals(string)) {
            return 2;
        }
        if (TIME_SERIES_FUNCTION_TYPE.equals(string)) {
            return 3;
        }
        if (STATE_VARIABLE_TYPE.equals(string)) {
            return 4;
        }
        if (TWO_VARIABLE_TYPE.equals(string)) {
            return 5;
        }
        if (GLOBAL_VARIABLE_TYPE.equals(string)) {
            return 6;
        }
        return -1;
    }

    public void setIndependentVariable(IndependentVariable independentVariable) {
        if (independentVariable == null) {
            this._releaseFunctionCombo.setSelectedItem((Object)DATE_FUNCTION_TYPE);
            return;
        }
        switch (independentVariable.getType()) {
            case 0: {
                this._releaseFunctionCombo.setSelectedItem((Object)DATE_FUNCTION_TYPE);
                break;
            }
            case 1: {
                this._releaseFunctionCombo.setSelectedItem((Object)DATE_TIME_FUNCTION_TYPE);
                break;
            }
            case 2: {
                this._releaseFunctionCombo.setSelectedItem((Object)MODEL_VARIABLE_FUNCTION_TYPE);
                Element element = null;
                TSRecordProxy tSRecordProxy = null;
                if (this._network != null) {
                    tSRecordProxy = this._network.getTSRecordProxy(independentVariable.getTSProxyName(), independentVariable.getModelVariableId());
                    element = this._network.getElement(independentVariable.getElementId());
                } else {
                    System.out.print("IndependentVariableDialog.setIndependentVariable: RssSystem not set yet");
                }
                this._modelVariablePanel.setSelectedTSProxy(tSRecordProxy, element);
                this._modelVariablePanel.setSelectedModelVariable(RssModelVariableSet.getModelVariable(independentVariable.getModelVariableId()));
                this._modelVariablePanel.setTimeSeriesOptions(independentVariable.getTimeSeriesFunction(), independentVariable.getTimeSeriesLag(), independentVariable.getTimeSeriesPeriod());
                this._modelVariablePanel.setSelectedValueTxt();
                break;
            }
            case 3: {
                this._releaseFunctionCombo.setSelectedItem((Object)TIME_SERIES_FUNCTION_TYPE);
                this._timeSeriesPanel.setTimeSeriesName(independentVariable.getTimeSeriesName());
                this._timeSeriesPanel.setTimeSeriesOptions(independentVariable.getTimeSeriesFunction(), independentVariable.getTimeSeriesLag(), independentVariable.getTimeSeriesPeriod());
                if (!this._isTimeSeries) break;
                if (independentVariable.isTSOptChecked()) {
                    this._isTimeSeriesChecked = true;
                    this._timeSeriesPanel.setTimeSeriesOptions(IndependentVariable.TS_FUNCTION_STRINGS[0], independentVariable.getTimeSeriesLag(), independentVariable.getTimeSeriesPeriod());
                    this._timeSeriesPanel._tsOptionsPanel.disableAllFields();
                }
                this._timeSeriesPanel.jDefineZoneWithTimeSeriesCheck.setSelected(independentVariable.isTSOptChecked());
                break;
            }
            case 5: {
                this._releaseFunctionCombo.setSelectedItem((Object)TWO_VARIABLE_TYPE);
                if (this._network != null) {
                    this._network.getTSRecordProxy(independentVariable.getTSProxyName(), independentVariable.getModelVariableId());
                    this._network.getElement(independentVariable.getElementId());
                } else {
                    System.out.print("IndependentVariableDialog.setIndependentVariable: RssSystem not set yet");
                }
                this._twoVariablePanel.setRowIndependentVariable(independentVariable.getRowVariable());
                this._twoVariablePanel.setColIndependentVariable(independentVariable.getColVariable());
                break;
            }
            case 4: {
                this._releaseFunctionCombo.setSelectedItem((Object)STATE_VARIABLE_TYPE);
                StateVariable stateVariable = this._network.getStateVariable(independentVariable.getStateVariableId());
                this._stateVariablePanel.setSelectedStateVariable(stateVariable);
                this._stateVariablePanel.setTimeSeriesOptions(independentVariable.getTimeSeriesFunction(), independentVariable.getTimeSeriesLag(), independentVariable.getTimeSeriesPeriod());
                break;
            }
            case 6: {
                this._releaseFunctionCombo.setSelectedItem((Object)GLOBAL_VARIABLE_TYPE);
                GlobalVariable globalVariable = this._network.getGlobalVariable(independentVariable.getGlobalVariableId());
                this._globalVariablePanel.setSelectedGlobalVariable(globalVariable);
                this._globalVariablePanel.setTimeSeriesOptions(independentVariable.getTimeSeriesFunction(), independentVariable.getTimeSeriesLag(), independentVariable.getTimeSeriesPeriod());
            }
        }
        this.releasefunctionComboChanged();
    }

    public IndependentVariable getIndependentVariable() {
        int n = this.getIndependentVariableType();
        IndependentVariable independentVariable = new IndependentVariable(n);
        switch (n) {
            case 2: {
                TSRecordProxy tSRecordProxy = this._modelVariablePanel.getSelectedTSProxy();
                Element element = this._modelVariablePanel.getSelectedElement();
                ModelVariable modelVariable = this._modelVariablePanel.getSelectedModelVariable();
                independentVariable.setModalVariableInfo(tSRecordProxy, element, modelVariable);
                independentVariable.setTimeSeriesOptions(this._modelVariablePanel.getTimeSeriesOptionFunction(), this._modelVariablePanel.getTimeSeriesOptionLag(), this._modelVariablePanel.getTimeSeriesOptionPeriod());
                break;
            }
            case 3: {
                if (this._isTimeSeriesChecked) {
                    independentVariable.setTimeSeriesOptions(true);
                }
                independentVariable.setTimeSeriesName(this._timeSeriesPanel.getTimeSeriesName());
                independentVariable.setTimeSeriesOptions(this._timeSeriesPanel.getTimeSeriesOptionFunction(), this._timeSeriesPanel.getTimeSeriesOptionLag(), this._timeSeriesPanel.getTimeSeriesOptionPeriod());
                break;
            }
            case 4: {
                independentVariable.setStateVariable(this._stateVariablePanel.getSelectedStateVariable());
                independentVariable.setTimeSeriesOptions(this._stateVariablePanel.getTimeSeriesOptionFunction(), this._stateVariablePanel.getTimeSeriesOptionLag(), this._stateVariablePanel.getTimeSeriesOptionPeriod());
                break;
            }
            case 5: {
                independentVariable.setTwoVariableRule(this._twoVariablePanel.getTwoVariableRowItem(), this._twoVariablePanel.getTwoVariableColItem());
                break;
            }
            case 6: {
                independentVariable.setGlobalVariable(this._globalVariablePanel.getSelectedGlobalVariable());
                independentVariable.setTimeSeriesOptions(this._globalVariablePanel.getTimeSeriesOptionFunction(), this._globalVariablePanel.getTimeSeriesOptionLag(), this._globalVariablePanel.getTimeSeriesOptionPeriod());
            }
        }
        return independentVariable;
    }

    public boolean isCanceled() {
        return this._canceled;
    }

    public boolean isTimeSeriesChecked() {
        return this._isTimeSeriesChecked;
    }

    protected boolean isValidDialog() {
        String string = (String)this._releaseFunctionCombo.getSelectedItem();
        if (DATE_FUNCTION_TYPE.equals(string)) {
            return true;
        }
        if (DATE_TIME_FUNCTION_TYPE.equals(string)) {
            return true;
        }
        if (MODEL_VARIABLE_FUNCTION_TYPE.equals(string)) {
            return this._modelVariablePanel.isValidForm();
        }
        if (TIME_SERIES_FUNCTION_TYPE.equals(string)) {
            return this._timeSeriesPanel.isValidForm();
        }
        if (STATE_VARIABLE_TYPE.equals(string)) {
            return this._stateVariablePanel.isValidForm();
        }
        if (TWO_VARIABLE_TYPE.equals(string)) {
            return this._twoVariablePanel.isValidForm();
        }
        if (GLOBAL_VARIABLE_TYPE.equals(string)) {
            return this._globalVariablePanel.isValidForm();
        }
        JOptionPane.showMessageDialog((Component)((Object)this), "No Release Function is selected", "Incomplete Form", 1);
        return false;
    }

    public void showTwoVariableEditColumn(boolean bl) {
        this._twoVariablePanel.showEditColumn(bl);
    }

    static {
        e = new String[]{MODEL_VARIABLE_FUNCTION_TYPE, TIME_SERIES_FUNCTION_TYPE};
        d = new String[]{MODEL_VARIABLE_FUNCTION_TYPE, STATE_VARIABLE_TYPE, GLOBAL_VARIABLE_TYPE, TIME_SERIES_FUNCTION_TYPE};
        a = new String[]{DATE_FUNCTION_TYPE, DATE_TIME_FUNCTION_TYPE, MODEL_VARIABLE_FUNCTION_TYPE, STATE_VARIABLE_TYPE, GLOBAL_VARIABLE_TYPE, TIME_SERIES_FUNCTION_TYPE};
        b = new String[]{DATE_FUNCTION_TYPE, DATE_TIME_FUNCTION_TYPE, MODEL_VARIABLE_FUNCTION_TYPE, STATE_VARIABLE_TYPE, TWO_VARIABLE_TYPE, GLOBAL_VARIABLE_TYPE, TIME_SERIES_FUNCTION_TYPE};
        c = new String[]{MODEL_VARIABLE_FUNCTION_TYPE, STATE_VARIABLE_TYPE, GLOBAL_VARIABLE_TYPE, TWO_VARIABLE_TYPE, TIME_SERIES_FUNCTION_TYPE};
    }
}

