/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.clientapp.client.ClientApp;
import hec.gfx2d.G2dPanel;
import hec.gfx2d.G2dPanelProp;
import hec.gfx2d.G2dPlotProp;
import hec.gfx2d.HotPlotDefaults;
import hec.gfx2d.PlotDefaults;
import hec.gfx2d.PlotDefaultsManager;
import hec.gfx2d.SimplePairedValuesData;
import hec.model.PairedValues;
import hec.model.PairedValuesTableModel;
import hec.rss.RssRmiWorkspace;
import hec.rss.client.ISFallingPoolDialog;
import hec.rss.client.InducedSurchargeAdvanceOptDialog;
import hec.rss.client.InducedSurchargeFunctionPanel$1;
import hec.rss.client.InducedSurchargeFunctionPanel$MyG2dPanel;
import hec.rss.client.InducedSurchargePlotDialog;
import hec.rss.client.InflowTimeSeriesOptionsDialog;
import hec.rss.client.InflowValuesForSurchargePlot;
import hec.rss.client.JOperationsPanel;
import hec.rss.client.OutletUsageOptionsDialog;
import hec.rss.client.ReservoirJFrame;
import hec.rss.model.InducedSurchargeOpRule;
import hec.rss.model.OpRule;
import hec.rss.model.OpRuleRef;
import hec.rss.model.ReservoirOp;
import hec.rss.server.RssComputeOptions;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.EventObject;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableModel;
import rma.swing.DefaultJPanel;
import rma.swing.RmaGridBagConstraints;
import rma.swing.RmaInsets;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJDecimalField;
import rma.swing.RmaJTable;
import rma.swing.event.TableUpdateEvent;
import rma.swing.print.PageText;
import rma.swing.table.RmaTableModel;

public class InducedSurchargeFunctionPanel
extends DefaultJPanel
implements ActionListener,
CellEditorListener {
    JLabel jLimitLabel = new JLabel("Limit Type");
    JLabel jInterpLabel = new JLabel("Interpolation Type:");
    JLabel jTableTitle = new JLabel("Induced Surcharge Envelope Curve");
    JButton jFallingPoolOptionsButton = new JButton("Edit Falling Pool Options...");
    JLabel jRecessionLabel = new JLabel("Time of Recession (hrs):");
    String[] colLabels = new String[]{"Elevation (%S)", "Release (%S)"};
    boolean[] colEditable = new boolean[]{true, true};
    RmaJTable jSurchargeCurveTable = new RmaJTable((Component)((Object)this));
    InducedSurchargeFunctionPanel$MyG2dPanel jFlowReleasePlot = new InducedSurchargeFunctionPanel$MyG2dPanel(this);
    RmaJComboBox jInterpCombo = new RmaJComboBox();
    JButton _inflowTimeSeriesOptionsButton = new JButton("Inflow Time Series Options...");
    JButton _advancedOptionsButton = new JButton("Advanced Options...");
    JButton _outletUsageOptionsButton = new JButton("Outlet Usage Options...");
    JPanel _buttonPanel = new JPanel();
    JPanel _rightPanel = new JPanel();
    SimplePairedValuesData _elevReleaseData = this.getElevReleaseData();
    JPanel jConstantsPanel = new JPanel();
    RmaJDecimalField jRecessionTxt = new RmaJDecimalField();
    JPanel jOptionsPanel = new JPanel();
    OpRuleRef _currentRuleRef = null;
    OutletUsageOptionsDialog _outletUsageDialog;
    InflowValuesForSurchargePlot _inflowValuesSurchargeDialog;
    InflowTimeSeriesOptionsDialog _inflowTimeSeriesOptionDialog;
    private JOperationsPanel _parent;

    public InducedSurchargeFunctionPanel() {
        super((LayoutManager)new GridBagLayout());
        this.buildControls();
    }

    protected void buildControls() {
        this.setName("InducedSurchargeFunctionPanel");
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.add(jPanel, new RmaGridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.jInterpLabel, new RmaGridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, RmaInsets.INSETS5500, 35, 0));
        for (int i = 0; i < PairedValues.INTERP_STRINGS.length - 1; ++i) {
            this.jInterpCombo.addItem((Object)PairedValues.INTERP_STRINGS[i]);
        }
        jPanel.add((Component)this.jInterpCombo, new RmaGridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 18, 2, RmaInsets.INSETS5550, 0, 0));
        jPanel.add((Component)this.jTableTitle, new RmaGridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 18, 0, RmaInsets.INSETS5500, 0, 0));
        this.jSurchargeCurveTable.setModel((TableModel)new PairedValuesTableModel(this.colLabels, this.colEditable));
        this.jSurchargeCurveTable.setUnitsHeaderRenderer();
        ((PairedValuesTableModel)this.jSurchargeCurveTable.getModel()).setShouldAddBlankRows(true);
        this.jSurchargeCurveTable.setDoubleCellEditor(0, false);
        this.jSurchargeCurveTable.setDoubleCellEditor(1, false);
        this.jSurchargeCurveTable.setNumRows(10);
        InducedSurchargeFunctionPanel inducedSurchargeFunctionPanel = this;
        inducedSurchargeFunctionPanel.add(inducedSurchargeFunctionPanel.jSurchargeCurveTable.getScrollPane(), new RmaGridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 18, 1, RmaInsets.INSETS5550, 0, 0));
        this._rightPanel.setLayout(new GridBagLayout());
        this._rightPanel.add((Component)((Object)this.jFlowReleasePlot), new RmaGridBagConstraints(0, 0, 1, 3, 1.0, 1.0, 12, 1, new Insets(0, 0, 0, 0), 0, 0));
        this._buttonPanel.setLayout(new GridBagLayout());
        this._buttonPanel.add((Component)this._inflowTimeSeriesOptionsButton, new RmaGridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 12, 2, new Insets(5, 5, 5, 5), 0, 0));
        this._buttonPanel.add((Component)this._advancedOptionsButton, new RmaGridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 12, 2, new Insets(0, 5, 5, 5), 0, 0));
        this._rightPanel.add((Component)this._buttonPanel, new RmaGridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 12, 1, new Insets(5, 5, 5, 5), 0, 0));
        InducedSurchargeFunctionPanel inducedSurchargeFunctionPanel2 = this;
        inducedSurchargeFunctionPanel2.add(inducedSurchargeFunctionPanel2._rightPanel, new RmaGridBagConstraints(1, 1, 1, 4, 0.0, 1.0, 12, 3, new Insets(5, 5, 5, 5), 0, 0));
        InducedSurchargeFunctionPanel inducedSurchargeFunctionPanel3 = this;
        inducedSurchargeFunctionPanel3.configureFlowPlot(inducedSurchargeFunctionPanel3.jFlowReleasePlot);
        Vector<SimplePairedValuesData> vector = new Vector<SimplePairedValuesData>();
        vector.addElement(this._elevReleaseData);
        this.jFlowReleasePlot.setPlotObjects(vector);
        this.jConstantsPanel.setLayout(new GridBagLayout());
        this.jConstantsPanel.add((Component)this.jRecessionLabel, new RmaGridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, RmaInsets.insets((int)2, (int)5, (int)0, (int)0), 0, 0));
        this.jConstantsPanel.add((Component)this.jRecessionTxt, new RmaGridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 2, RmaInsets.insets((int)2, (int)5, (int)0, (int)0), 20, 0));
        this.jOptionsPanel.setLayout(new GridBagLayout());
        this.jOptionsPanel.add((Component)this.jFallingPoolOptionsButton, new RmaGridBagConstraints(1, 0, 2, 1, 1.0, 0.0, 10, 0, RmaInsets.INSETS0555, 0, 0));
        InducedSurchargeFunctionPanel inducedSurchargeFunctionPanel4 = this;
        inducedSurchargeFunctionPanel4.add(inducedSurchargeFunctionPanel4.jConstantsPanel, new RmaGridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 6, 0), 0, 0));
        InducedSurchargeFunctionPanel inducedSurchargeFunctionPanel5 = this;
        inducedSurchargeFunctionPanel5.add(inducedSurchargeFunctionPanel5.jOptionsPanel, new RmaGridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.jSurchargeCurveTable.addCellEditorListener((CellEditorListener)this);
        this.jFallingPoolOptionsButton.addActionListener(this);
        this._inflowTimeSeriesOptionsButton.addActionListener(this);
        this._advancedOptionsButton.addActionListener(this);
        this._outletUsageOptionsButton.addActionListener(this);
        this.jInterpCombo.addItemListener((ItemListener)new InducedSurchargeFunctionPanel$1(this));
    }

    private void configureFlowPlot(G2dPanel g2dPanel) {
        PlotDefaults plotDefaults = PlotDefaultsManager.getDefaults();
        PlotDefaultsManager.setDefaults((PlotDefaults)new HotPlotDefaults());
        G2dPanelProp g2dPanelProp = new G2dPanelProp();
        new G2dPanelProp().hasTitle = false;
        g2dPanelProp.hasToolbar = false;
        g2dPanelProp.hasLegend = false;
        G2dPlotProp g2dPlotProp = new G2dPlotProp();
        new G2dPlotProp().hasXScroll = false;
        g2dPlotProp.hasYScroll = false;
        g2dPlotProp.x1AxisProp.name = "Release (%S)";
        g2dPlotProp.y1AxisProp.name = "Elevation (%S)";
        g2dPlotProp.y1AxisProp.isReversed = true;
        g2dPanelProp.addPlotProp(g2dPlotProp);
        g2dPanel.configurePanel(g2dPanelProp);
        PlotDefaultsManager.setDefaults((PlotDefaults)plotDefaults);
    }

    private SimplePairedValuesData getElevReleaseData() {
        SimplePairedValuesData simplePairedValuesData = new SimplePairedValuesData();
        new SimplePairedValuesData().xunits = "Release (%S)";
        simplePairedValuesData.yunits = "Elevation (%S)";
        PairedValues pairedValues = new PairedValues();
        pairedValues.setInterpolationType(0);
        simplePairedValuesData.setPlotXvsY(true);
        simplePairedValuesData.resetData();
        return simplePairedValuesData;
    }

    @Override
    public void editingCanceled(ChangeEvent changeEvent) {
    }

    @Override
    public void editingStopped(ChangeEvent changeEvent) {
        this.elevReleaseReplot();
    }

    public void tableDataChanged(TableUpdateEvent tableUpdateEvent) {
        this.elevReleaseReplot();
    }

    @Override
    public void actionPerformed(ActionEvent object) {
        if ((object = ((EventObject)object).getSource()) == this.jFallingPoolOptionsButton) {
            this.fallingPoolOptionsButton_ActionPerformed();
            return;
        }
        if (object == this._inflowTimeSeriesOptionsButton) {
            this.inflowTimeSeriesOption_ActionPerformed();
            return;
        }
        if (object == this._outletUsageOptionsButton) {
            this.outletUsageOptions_ActionPerformed();
            return;
        }
        if (object == this._advancedOptionsButton) {
            this.advancedOption_ActionPerformed();
        }
    }

    public void fallingPoolOptionsButton_ActionPerformed() {
        Object object = SwingUtilities.windowForComponent((Component)((Object)this));
        if (!(object instanceof ReservoirJFrame)) {
            return;
        }
        if (this._currentRuleRef == null) {
            return;
        }
        object = new ISFallingPoolDialog((Dialog)object, true);
        ((ISFallingPoolDialog)object).setData((InducedSurchargeOpRule)this._currentRuleRef.getRule());
        ((ISFallingPoolDialog)object).setVisible(true);
        if (!((ISFallingPoolDialog)object).isOk()) {
            return;
        }
        this.setModified(true);
    }

    private void inflowTimeSeriesOption_ActionPerformed() {
        Serializable serializable = SwingUtilities.windowForComponent((Component)((Object)this));
        if (!(serializable instanceof ReservoirJFrame)) {
            return;
        }
        if (this._currentRuleRef == null) {
            return;
        }
        this._inflowTimeSeriesOptionDialog = new InflowTimeSeriesOptionsDialog((Dialog)serializable, true);
        serializable = (InducedSurchargeOpRule)this._currentRuleRef.getRule();
        this._inflowTimeSeriesOptionDialog.fillForm((InducedSurchargeOpRule)serializable);
        this._inflowTimeSeriesOptionDialog.setVisible(true);
    }

    private void advancedOption_ActionPerformed() {
        Window window = SwingUtilities.windowForComponent((Component)((Object)this));
        if (!(window instanceof ReservoirJFrame)) {
            return;
        }
        Object object = ClientApp.Workspace();
        if (object == null) {
            return;
        }
        if ((object = (RssRmiWorkspace)object.getChildWorkspace("rss")) == null) {
            return;
        }
        try {
            object = object.getRssComputeOptions();
        }
        catch (RemoteException remoteException) {
            object = new StringBuffer("An error occurred while trying to get the ResSim Compute Options to the server.\n");
            ((StringBuffer)object).append(remoteException.getMessage());
            JOptionPane.showMessageDialog((Component)((Object)this), ((StringBuffer)object).toString(), "Error!", 0);
            return;
        }
        window = new InducedSurchargeAdvanceOptDialog((Dialog)window, true);
        ((InducedSurchargeAdvanceOptDialog)window).fill((RssComputeOptions)object);
        ((Dialog)window).setVisible(true);
        window.dispose();
    }

    private void inflowValuesSurchargePlot_ActionPerformed() {
        Serializable serializable = SwingUtilities.windowForComponent((Component)((Object)this));
        if (!(serializable instanceof ReservoirJFrame)) {
            return;
        }
        if (this._currentRuleRef == null) {
            return;
        }
        this._inflowValuesSurchargeDialog = new InflowValuesForSurchargePlot((Dialog)serializable, true);
        serializable = (InducedSurchargeOpRule)this._currentRuleRef.getRule();
        this._inflowValuesSurchargeDialog.fillForm((InducedSurchargeOpRule)serializable);
        this._inflowValuesSurchargeDialog.setVisible(true);
    }

    private void outletUsageOptions_ActionPerformed() {
        Serializable serializable = SwingUtilities.windowForComponent((Component)((Object)this));
        if (!(serializable instanceof ReservoirJFrame)) {
            return;
        }
        if (this._currentRuleRef == null) {
            return;
        }
        this._outletUsageDialog = new OutletUsageOptionsDialog((Dialog)serializable, true);
        this._outletUsageDialog.setReservoirOp((ReservoirOp)this._currentRuleRef.getRule().getOperationsElement().getElementOp());
        serializable = (InducedSurchargeOpRule)this._currentRuleRef.getRule();
        this._outletUsageDialog.fillForm((InducedSurchargeOpRule)serializable);
        this._outletUsageDialog.setVisible(true);
    }

    private void elevReleaseReplot() {
        Vector<SimplePairedValuesData> vector = new Vector<SimplePairedValuesData>();
        PairedValues pairedValues = new PairedValues();
        Object object = (RmaTableModel)this.jSurchargeCurveTable.getModel();
        if (!(object instanceof PairedValuesTableModel)) {
            return;
        }
        object = (PairedValuesTableModel)this.jSurchargeCurveTable.getModel();
        object.storeData(pairedValues);
        object = (String)this.jInterpCombo.getSelectedItem();
        this._elevReleaseData.setInterpolationType((String)object);
        this._elevReleaseData.setPlotXvsY(true);
        this._elevReleaseData.setData(pairedValues);
        this._elevReleaseData.calcPlotArrays();
        this._elevReleaseData.name = "Induced Surcharge Envelope";
        vector.addElement(this._elevReleaseData);
        this.jFlowReleasePlot.setPlotObjects(vector);
        this.jFlowReleasePlot.paintGfx();
    }

    private void plotSurchargeButton_ActionPerformed() {
        Object object = SwingUtilities.windowForComponent((Component)((Object)this));
        if (!(object instanceof ReservoirJFrame)) {
            return;
        }
        if (this._currentRuleRef == null) {
            return;
        }
        Object object2 = this._currentRuleRef.getRule();
        String string = ((OpRule)object2).getOperationsElement().getSystem().getNameForKeyString(((OpRule)object2).getController().getName());
        object2 = "Induced Surcharge Curves for: " + string + "   " + object2.getName();
        object = new InducedSurchargePlotDialog((Frame)((Component)object).getParent(), this, (String)object2, true);
        ((InducedSurchargePlotDialog)((Object)object)).setInducedSurchargeOpRule((InducedSurchargeOpRule)this._currentRuleRef.getRule());
        ((InducedSurchargePlotDialog)((Object)object)).setVisible(true);
    }

    public void setRuleRef(OpRuleRef opRuleRef) {
        if (opRuleRef == null) {
            return;
        }
        this._currentRuleRef = opRuleRef;
    }

    public boolean savePanel() {
        if (this._currentRuleRef == null) {
            return false;
        }
        InducedSurchargeOpRule inducedSurchargeOpRule = (InducedSurchargeOpRule)this._currentRuleRef.getRule();
        if (inducedSurchargeOpRule == null) {
            return false;
        }
        double d = this.jRecessionTxt.getValue();
        inducedSurchargeOpRule.setRecessionConstant(d);
        this.jSurchargeCurveTable.commitEdit(true);
        PairedValuesTableModel pairedValuesTableModel = (PairedValuesTableModel)this.jSurchargeCurveTable.getModel();
        PairedValues pairedValues = inducedSurchargeOpRule.getSurchargeCurve();
        pairedValuesTableModel.storeData(pairedValues);
        if (this.isVisible() && pairedValues.size() > 1 && !pairedValues.canInterpX()) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Induced Surcharge rule, " + inducedSurchargeOpRule.getName() + "'s elevation values must be a continuously increasing sequence.", "Error", 0);
            return false;
        }
        if (!inducedSurchargeOpRule.fallingPoolOptionsValid() && this.isShowing()) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Induced Surcharge rule, " + inducedSurchargeOpRule.getName() + "'s Falling Pool Options are not defined.", "Error", 0);
            return false;
        }
        return true;
    }

    public void fillPanel() {
        this.clearPanel();
        if (this._currentRuleRef == null) {
            return;
        }
        Object object = (InducedSurchargeOpRule)this._currentRuleRef.getRule();
        this.jRecessionTxt.setValue(((InducedSurchargeOpRule)object).getRecessionConstant());
        ((OpRule)object).getUnitSystem();
        object = ((InducedSurchargeOpRule)object).getSurchargeCurve();
        ((PairedValuesTableModel)this.jSurchargeCurveTable.getModel()).setPairedValues((PairedValues)object);
        object = new String("Workspace: " + ClientApp.Workspace().getTitleName());
        object = (String)object + "\n ResSim System: " + this._parent._reservoir.getSystem().getName();
        object = (String)object + "\n Reservoir: " + this._parent._reservoir.getName();
        object = (String)object + "\n Operation Set: " + this._parent._currentOpSet.getName();
        object = (String)object + "\n Induced Surcharge Rule: " + this._currentRuleRef.getName() + " \n ";
        object = new PageText((String)object, 0);
        this.jSurchargeCurveTable.setPrintTitle((PageText)object);
        this.elevReleaseReplot();
    }

    public void setParent(JPanel jPanel) {
        this._parent = (JOperationsPanel)((Object)jPanel);
    }

    public void clearPanel() {
        this.jInterpCombo.setSelectedIndex(0);
        this.jSurchargeCurveTable.clearCells();
        Vector vector = new Vector();
        this.jFlowReleasePlot.setPlotObjects(vector);
        this.jFlowReleasePlot.paintGfx();
        this.jFlowReleasePlot.revalidate();
    }
}

