/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.data.Parameter;
import hec.data.Units;
import hec.dataTable.HecDataTableFrame;
import hec.gfx2d.G2dDialog;
import hec.gfx2d.G2dPanel;
import hec.gfx2d.G2dPanelProp;
import hec.gfx2d.G2dPlotProp;
import hec.io.PairedDataContainer;
import hec.model.PairedValues;
import hec.rss.client.InducedSurchargeInflowsDialog;
import hec.rss.client.InducedSurchargePlotDialog$1;
import hec.rss.client.InducedSurchargePlotDialog$2;
import hec.rss.client.InducedSurchargePlotDialog$3;
import hec.rss.client.InducedSurchargePlotDialog$MyPairedDataSet;
import hec.rss.model.AdjustableFlow;
import hec.rss.model.Element;
import hec.rss.model.InducedSurchargeOpRule;
import hec.rss.model.OutletGroupElement;
import hec.rss.model.ReservoirDamElement;
import hec.rss.model.ReservoirElement;
import hec.rss.model.ReservoirUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import rma.swing.DefaultJPanel;
import rma.util.RMAConst;

public class InducedSurchargePlotDialog
extends G2dDialog {
    InducedSurchargeOpRule _rule;
    boolean _plotRateOfRise = false;
    boolean _showDischargeCapacity = true;
    JMenuItem _editInflows_Mi = new JMenuItem("Inflows for Curves ...");
    JCheckBoxMenuItem _plotRateOfRise_Mi = new JCheckBoxMenuItem("Plot Rate Of Rise", this._plotRateOfRise);
    JCheckBoxMenuItem _showCapacityCurve_Mi = new JCheckBoxMenuItem("Show Discharge Capacity", this._showDischargeCapacity);
    DefaultJPanel _parentPanel;
    private Vector _colorVec = null;
    private String _title;
    boolean _doPlot = false;
    private static Color[] a = new Color[]{Color.blue, Color.red};

    public InducedSurchargePlotDialog(Frame frame, DefaultJPanel defaultJPanel, String string, boolean bl) {
        super(frame, string, bl);
        this.setFrame(frame);
        this._title = string;
        this._parentPanel = defaultJPanel;
        this.addMenuComponents();
    }

    void addMenuComponents() {
        JMenuBar jMenuBar = this.getJMenuBar();
        JMenu jMenu = new JMenu("Options");
        jMenu.setMnemonic('O');
        jMenuBar.add(jMenu);
        this._editInflows_Mi.addActionListener(new InducedSurchargePlotDialog$1(this));
        jMenu.add(this._editInflows_Mi);
        this._plotRateOfRise_Mi.addItemListener(new InducedSurchargePlotDialog$2(this));
        jMenu.add(this._plotRateOfRise_Mi);
        this._showCapacityCurve_Mi.addItemListener(new InducedSurchargePlotDialog$3(this));
        jMenu.add(this._showCapacityCurve_Mi);
        this.setJMenuBar(jMenuBar);
    }

    void editInflowValues() {
        double d;
        double[] dArray;
        if (this._rule == null || this._rule.getSurchargeCurve() == null) {
            return;
        }
        InducedSurchargeInflowsDialog inducedSurchargeInflowsDialog = new InducedSurchargeInflowsDialog((Frame)((Object)this), true);
        if (this._plotRateOfRise) {
            inducedSurchargeInflowsDialog.setTitle("Specify Rate of Rise for Induced Surcharge");
        }
        if (this._plotRateOfRise) {
            dArray = this._rule.getPlotRateOfRiseValues();
            d = 0.0;
        } else {
            dArray = this._rule.getPlotInflowValues();
            PairedValues pairedValues = this._rule.getSurchargeCurve();
            d = pairedValues.getYValue(0);
        }
        double d2 = this._rule.getPlotRateOfRiseLookbackHours();
        inducedSurchargeInflowsDialog.fillForm(dArray, this._rule.getUnitSystem(), this._plotRateOfRise, d2, d);
        inducedSurchargeInflowsDialog.setVisible(true);
        if (inducedSurchargeInflowsDialog.isOk()) {
            if (this._plotRateOfRise) {
                this._rule.setPlotRateOfRiseValues(inducedSurchargeInflowsDialog.getTableValues());
                this._rule.setPlotRateOfRiseLookbackHours(inducedSurchargeInflowsDialog.getLookbackHours());
            } else {
                this._rule.setPlotInflowValues(inducedSurchargeInflowsDialog.getTableValues());
            }
            this._parentPanel.setModified(true);
            this.plotSurchargeCurves();
        }
    }

    public HecDataTableFrame tabulate(boolean bl) {
        HecDataTableFrame hecDataTableFrame = super.tabulate(true);
        hecDataTableFrame.setTitle(this._title);
        return hecDataTableFrame;
    }

    void rateOfRise_itemStateChanged(boolean bl) {
        this._plotRateOfRise = bl;
        if (this._plotRateOfRise) {
            this._editInflows_Mi.setText("Edit Rate Of Rise for Curves ...");
        } else {
            this._editInflows_Mi.setText("Edit Inflows for Curves ...");
        }
        if (this._plotRateOfRise != this._rule.useRateOfRise()) {
            this._parentPanel.setModified(true);
        }
        this.plotSurchargeCurves();
    }

    PairedDataContainer computeSurchargeCurves2() {
        int n;
        Object object;
        PairedValues pairedValues = this._rule.getSurchargeCurve();
        if (pairedValues == null || pairedValues.size() < 2) {
            return null;
        }
        double[] dArray = this._rule.getPlotInflowValues();
        if (this._plotRateOfRise) {
            dArray = this._rule.getPlotRateOfRiseValues();
        }
        int n2 = 1;
        if (dArray != null) {
            n2 = dArray.length + 1;
        }
        PairedDataContainer pairedDataContainer = new PairedDataContainer();
        new PairedDataContainer().yOrdinates = new double[n2][];
        pairedDataContainer.numberCurves = n2;
        pairedDataContainer.labelsUsed = true;
        pairedDataContainer.labels = new String[n2];
        pairedDataContainer.xparameter = pairedValues.getParamYString();
        pairedDataContainer.yparameter = pairedValues.getParamXString();
        pairedDataContainer.xunits = pairedValues.getParamYUnitsString();
        pairedDataContainer.yunits = pairedValues.getParamXUnitsString();
        pairedDataContainer.xtype = pairedValues.getParamYString();
        pairedDataContainer.ytype = pairedValues.getParamXString();
        if (n2 == 1) {
            pairedDataContainer.yOrdinates[0] = pairedValues.getXArray();
            pairedDataContainer.xOrdinates = pairedValues.getYArray();
            pairedDataContainer.numberOrdinates = pairedDataContainer.xOrdinates.length;
            pairedDataContainer.labels[0] = "Surcharge Envelope";
            return pairedDataContainer;
        }
        Arrays.sort(dArray);
        PairedValues pairedValues2 = pairedValues;
        double d = pairedValues2.getYValue(pairedValues2.size() - 1);
        double[] dArray2 = pairedValues.getYArray();
        if (!this._plotRateOfRise) {
            double[] dArray3 = new double[dArray2.length + dArray.length];
            object = new double[dArray2.length + dArray.length];
            System.arraycopy(dArray2, 0, dArray3, 0, dArray2.length);
            System.arraycopy(dArray, 0, dArray3, dArray2.length, dArray.length);
            Arrays.sort(dArray3);
            object[0] = (double[])dArray3[0];
            n = 1;
            for (int i = 1; i < dArray3.length; ++i) {
                if (!(object[n - 1] < dArray3[i]) || !(dArray3[i] <= d)) continue;
                object[n] = (double[])dArray3[i];
                ++n;
            }
            dArray2 = new double[n];
            System.arraycopy(object, 0, dArray2, 0, n);
        }
        int cfr_ignored_0 = dArray2.length;
        object = new double[n2][dArray2.length];
        for (n = 0; n < n2; ++n) {
            Arrays.fill(object[n], -3.4028234663852886E38);
        }
        for (n2 = 0; n2 < dArray.length; ++n2) {
            for (int i = 0; i < dArray2.length; ++i) {
                if (this._plotRateOfRise) {
                    double d2 = dArray[n2];
                    object[n2 + 1][i] = this._rule.getElevationForRateOfRise(d2, dArray2[i]);
                    if (RMAConst.isValidValue((double)object[n2 + 1][i])) continue;
                    object[n2 + 1][i] = -3.4028234663852886E38;
                    continue;
                }
                if (dArray2[i] <= dArray[n2]) {
                    object[n2 + 1][i] = this._rule.getElevationForInflowRelease(dArray[n2], dArray2[i]);
                    if (RMAConst.isValidValue((double)object[n2 + 1][i])) continue;
                    object[n2 + 1][i] = -3.4028234663852886E38;
                    continue;
                }
                object[n2 + 1][i] = pairedValues.getXValue(dArray2[i]);
            }
        }
        for (n2 = 0; n2 < dArray2.length; ++n2) {
            object[0][n2] = pairedValues.getXValue(dArray2[n2]);
        }
        pairedDataContainer.labels[0] = "Surcharge Envelope";
        n2 = this._rule.getUnitSystem();
        int n3 = this.getUnitDisplaySystem();
        int n4 = Parameter.PARAMID_FLOW;
        if (n2 != n3) {
            try {
                String string = Parameter.getUnitsStringForSystem((int)n4, (int)n2);
                String string2 = Parameter.getUnitsStringForSystem((int)n4, (int)n3);
                Units.getScalarFactor((String)string, (String)string2);
            }
            catch (Exception exception) {}
        }
        Object object2 = "";
        try {
            if (this._plotRateOfRise) {
                object2 = Parameter.getUnitsStringForSystem((int)Parameter.PARAMID_ELEV, (int)n3);
                object2 = (String)object2 + "/hr";
            } else {
                object2 = Parameter.getUnitsStringForSystem((int)Parameter.PARAMID_FLOW, (int)n3);
            }
        }
        catch (Exception exception) {}
        NumberFormat numberFormat = NumberFormat.getInstance();
        if (this._plotRateOfRise) {
            numberFormat.setMaximumFractionDigits(3);
        } else {
            numberFormat.setMaximumFractionDigits(0);
            if (n3 == 2) {
                numberFormat.setMaximumFractionDigits(1);
            }
        }
        for (n3 = 0; n3 < dArray.length; ++n3) {
            pairedDataContainer.labels[n3 + 1] = numberFormat.format(dArray[n3]) + " " + (String)object2;
        }
        pairedDataContainer.xOrdinates = dArray2;
        pairedDataContainer.numberOrdinates = dArray2.length;
        pairedDataContainer.yOrdinates = object;
        return pairedDataContainer;
    }

    List computeSurchargeCurves3() {
        Object object = this._rule.getSurchargeCurve();
        if (object == null || object.size() < 2) {
            return null;
        }
        this.getCapacityCurve();
        double[] dArray = this._rule.getPlotInflowValues();
        if (this._plotRateOfRise) {
            dArray = this._rule.getPlotRateOfRiseValues();
        }
        int n = 1;
        if (dArray != null) {
            n = dArray.length + 1;
        }
        int n2 = this._rule.getUnitSystem();
        int n3 = this.getUnitDisplaySystem();
        int n4 = Parameter.PARAMID_FLOW;
        if (n2 != n3) {
            try {
                String string = Parameter.getUnitsStringForSystem((int)n4, (int)n2);
                String string2 = Parameter.getUnitsStringForSystem((int)n4, (int)n3);
                Units.getScalarFactor((String)string, (String)string2);
            }
            catch (Exception exception) {}
        }
        Object object2 = "";
        try {
            if (this._plotRateOfRise) {
                object2 = Parameter.getUnitsStringForSystem((int)Parameter.PARAMID_ELEV, (int)n3);
                object2 = (String)object2 + "/hr";
            } else {
                object2 = Parameter.getUnitsStringForSystem((int)Parameter.PARAMID_FLOW, (int)n3);
            }
        }
        catch (Exception exception) {}
        NumberFormat numberFormat = NumberFormat.getInstance();
        if (this._plotRateOfRise) {
            numberFormat.setMaximumFractionDigits(3);
        } else {
            numberFormat.setMaximumFractionDigits(0);
            if (n3 == 2) {
                numberFormat.setMaximumFractionDigits(1);
            }
        }
        PairedDataContainer pairedDataContainer = new PairedDataContainer();
        new PairedDataContainer().yOrdinates = new double[1][1];
        pairedDataContainer.xOrdinates = new double[1];
        pairedDataContainer.numberOrdinates = 1;
        pairedDataContainer.numberCurves = 1;
        pairedDataContainer.labelsUsed = true;
        pairedDataContainer.labels = new String[1];
        pairedDataContainer.labels[0] = "dummy";
        pairedDataContainer.xparameter = object.getParamYString();
        pairedDataContainer.yparameter = object.getParamXString();
        pairedDataContainer.xunits = object.getParamYUnitsString();
        pairedDataContainer.yunits = object.getParamXUnitsString();
        pairedDataContainer.xtype = object.getParamYString();
        pairedDataContainer.ytype = object.getParamXString();
        Object object3 = new PairedDataContainer();
        pairedDataContainer.clone(object3);
        object3.yOrdinates = new double[1][];
        object3.yOrdinates[0] = object.getXArray();
        object3.xOrdinates = object.getYArray();
        object3.numberOrdinates = object3.xOrdinates.length;
        object3.labels[0] = "Surcharge Envelope";
        ArrayList<PairedDataContainer> arrayList = new ArrayList<PairedDataContainer>(n);
        arrayList.add((PairedDataContainer)object3);
        if (n == 1) {
            return arrayList;
        }
        Arrays.sort(dArray);
        PairedValues pairedValues = object;
        pairedValues.getYValue(pairedValues.size() - 1);
        object = object.getYArray();
        if (!this._plotRateOfRise) {
            for (int i = 0; i < dArray.length; ++i) {
                int n5;
                int n6 = 0;
                for (n5 = 0; n5 < ((PairedValues)object).length; ++n5) {
                    if (object[n5] < dArray[i]) {
                        ++n6;
                        continue;
                    }
                    Object object4 = object;
                    if (!(dArray[i] < object4[((PairedValues)object4).length - 1])) break;
                    ++n6;
                    break;
                }
                double[] dArray2 = new double[n6];
                object3 = new double[n6];
                for (n5 = 0; n5 < ((PairedValues)object).length; ++n5) {
                    if (!(object[n5] < dArray[i])) {
                        Object object5 = object;
                        if (!(dArray[i] < object5[((PairedValues)object5).length - 1])) break;
                        dArray2[n5] = dArray[i];
                        break;
                    }
                    dArray2[n5] = (double)object[n5];
                }
                for (n5 = 0; n5 < dArray2.length; ++n5) {
                    object3[n5] = (PairedDataContainer)this._rule.getElevationForInflowRelease(dArray[i], dArray2[n5]);
                }
                PairedDataContainer pairedDataContainer2 = new PairedDataContainer();
                pairedDataContainer.clone(pairedDataContainer2);
                pairedDataContainer2.xOrdinates = dArray2;
                pairedDataContainer2.numberOrdinates = dArray2.length;
                pairedDataContainer2.yOrdinates[0] = (double[])object3;
                String string = "Inflow=" + numberFormat.format(dArray[i]) + " " + (String)object2;
                pairedDataContainer2.labels[0] = string;
                arrayList.add(pairedDataContainer2);
            }
        } else {
            for (int i = 0; i < dArray.length; ++i) {
                Object object6 = (double[])object.clone();
                object3 = new double[((double[])object6).length];
                for (int j = 0; j < ((PairedValues)object).length; ++j) {
                    double d = dArray[i];
                    object3[j] = (PairedDataContainer)this._rule.getElevationForRateOfRise(d, object6[j]);
                    if (RMAConst.isValidValue((double)object3[j])) continue;
                    object3[j] = (PairedDataContainer)-3.4028234663852886E38;
                }
                PairedDataContainer pairedDataContainer3 = new PairedDataContainer();
                pairedDataContainer.clone(pairedDataContainer3);
                pairedDataContainer3.xOrdinates = object6;
                pairedDataContainer3.numberOrdinates = ((double[])object6).length;
                pairedDataContainer3.yOrdinates[0] = (double[])object3;
                object6 = "Rate of Rise=" + numberFormat.format(dArray[i]) + " " + (String)object2;
                pairedDataContainer3.labels[0] = object6;
                arrayList.add(pairedDataContainer3);
            }
        }
        return arrayList;
    }

    private PairedDataContainer getCapacityCurve() {
        Object object = this._rule.getController().getReleaseElement();
        PairedDataContainer pairedDataContainer = new PairedDataContainer();
        new PairedDataContainer().labelsUsed = true;
        pairedDataContainer.labels = new String[]{"Discharge Capacity"};
        if (object instanceof ReservoirElement || object instanceof ReservoirDamElement || object instanceof OutletGroupElement) {
            if ((object = ReservoirUtilities.a((Element)object)) == null) {
                return null;
            }
            double[] dArray = object.getXArray();
            double[] dArray2 = object.getYArray(2);
            pairedDataContainer.xparameter = object.getParamYString();
            pairedDataContainer.yparameter = object.getParamXString();
            pairedDataContainer.xunits = object.getParamYUnitsString();
            pairedDataContainer.yunits = object.getParamXUnitsString();
            pairedDataContainer.xtype = object.getParamYString();
            pairedDataContainer.ytype = object.getParamXString();
            pairedDataContainer.xOrdinates = dArray2;
            pairedDataContainer.numberOrdinates = dArray2.length;
            pairedDataContainer.numberCurves = 1;
            pairedDataContainer.yOrdinates = new double[1][];
            pairedDataContainer.yOrdinates[0] = dArray;
            System.out.println("\n\nusing release element\n\n");
        } else {
            if (!((object = ((Element)object).getFunction()) instanceof AdjustableFlow)) {
                return null;
            }
            object = (AdjustableFlow)object;
            PairedValues pairedValues = ((AdjustableFlow)object).getCapacityValues();
            double[] dArray = pairedValues.getXArray();
            object = pairedValues.getYArray();
            pairedDataContainer.xparameter = pairedValues.getParamYString();
            pairedDataContainer.yparameter = pairedValues.getParamXString();
            pairedDataContainer.xunits = pairedValues.getParamYUnitsString();
            pairedDataContainer.yunits = pairedValues.getParamXUnitsString();
            pairedDataContainer.xtype = pairedValues.getParamYString();
            pairedDataContainer.ytype = pairedValues.getParamXString();
            pairedDataContainer.xOrdinates = (double[])object;
            pairedDataContainer.numberOrdinates = ((Object)object).length;
            pairedDataContainer.numberCurves = 1;
            pairedDataContainer.yOrdinates = new double[1][];
            pairedDataContainer.yOrdinates[0] = dArray;
            System.out.println("\n\nusing AdjustableFlow\n\n");
        }
        return pairedDataContainer;
    }

    PairedDataContainer limitReleaseCurves(PairedDataContainer pairedDataContainer, PairedDataContainer pairedDataContainer2) {
        double[] dArray = pairedDataContainer.yOrdinates[0];
        double[] dArray2 = new double[dArray.length];
        int n = 0;
        int n2 = pairedDataContainer2.xOrdinates.length;
        for (int i = 0; i < dArray.length; ++i) {
            double d;
            while (n < n2 - 2 && pairedDataContainer2.yOrdinates[0][n + 1] < dArray[i]) {
                ++n;
            }
            double d2 = pairedDataContainer2.xOrdinates[n];
            double d3 = pairedDataContainer2.xOrdinates[n + 1];
            double d4 = pairedDataContainer2.yOrdinates[0][n];
            double d5 = pairedDataContainer2.yOrdinates[0][n + 1];
            dArray2[i] = d = (dArray[i] - d4) / (d5 - d4) * (d3 - d2) + d2;
            if (!(d < pairedDataContainer.xOrdinates[i])) continue;
            pairedDataContainer.xOrdinates[i] = d;
        }
        return null;
    }

    public void setVisible(boolean bl) {
        if (bl) {
            this.fillForm();
        }
        super.setVisible(bl);
    }

    public void fillForm() {
        if (this._rule == null) {
            return;
        }
        this._doPlot = false;
        this._plotRateOfRise_Mi.setSelected(this._rule.useRateOfRise());
        this._doPlot = true;
        InducedSurchargePlotDialog inducedSurchargePlotDialog = this;
        inducedSurchargePlotDialog.rateOfRise_itemStateChanged(inducedSurchargePlotDialog._rule.useRateOfRise());
    }

    private void configurePlot0() {
        G2dPanel g2dPanel = this.getPlotpanel();
        G2dPanelProp g2dPanelProp = g2dPanel.getProperties();
        G2dPlotProp g2dPlotProp = new G2dPlotProp();
        new G2dPlotProp().x1AxisProp.name = "Release";
        g2dPlotProp.y1AxisProp.name = "Elevation";
        g2dPanelProp.addPlotProp(g2dPlotProp);
        g2dPanel.configurePanel(g2dPanelProp);
    }

    private void configurePlot() {
        G2dPanel g2dPanel = this.getPlotpanel();
        g2dPanel.clearPanel();
        G2dPanelProp g2dPanelProp = g2dPanel.getProperties();
        G2dPlotProp g2dPlotProp = new G2dPlotProp();
        new G2dPlotProp().x1AxisProp.name = "Release (%S)";
        g2dPlotProp.y1AxisProp.name = "Elevation (%S)";
        g2dPanelProp.addPlotProp(g2dPlotProp);
        g2dPanel.configurePanel(g2dPanelProp);
    }

    protected void plotSurchargeCurves() {
        Object object;
        if (this._rule == null) {
            return;
        }
        if (!this._doPlot) {
            return;
        }
        List list = this.computeSurchargeCurves3();
        if (list == null || list.size() <= 0) {
            return;
        }
        G2dPanel g2dPanel = this.getPlotpanel();
        g2dPanel.clearPanel();
        PairedDataContainer pairedDataContainer = null;
        if (this._showDischargeCapacity) {
            pairedDataContainer = this.getCapacityCurve();
        }
        Vector<PairedDataContainer> vector = new Vector<PairedDataContainer>();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            object = (PairedDataContainer)list.get(i);
            PairedDataContainer pairedDataContainer2 = new PairedDataContainer();
            new PairedDataContainer().numberCurves = 1;
            pairedDataContainer2.xOrdinates = (double[])object.xOrdinates.clone();
            pairedDataContainer2.numberOrdinates = pairedDataContainer2.xOrdinates.length;
            pairedDataContainer2.yOrdinates = new double[1][];
            pairedDataContainer2.yOrdinates[0] = object.yOrdinates[0];
            pairedDataContainer2.labels = new String[1];
            pairedDataContainer2.labels[0] = object.labels[0];
            pairedDataContainer2.labelsUsed = true;
            pairedDataContainer2.xparameter = object.xparameter;
            pairedDataContainer2.yparameter = object.yparameter;
            pairedDataContainer2.xunits = object.xunits;
            pairedDataContainer2.yunits = object.yunits;
            pairedDataContainer2.xtype = "UNT";
            pairedDataContainer2.ytype = "UNT";
            if (i > 0 && pairedDataContainer != null) {
                this.limitReleaseCurves(pairedDataContainer2, pairedDataContainer);
            }
            object = new InducedSurchargePlotDialog$MyPairedDataSet(this, pairedDataContainer2);
            vector.add((PairedDataContainer)object);
        }
        Vector<Color> vector2 = new Vector<Color>();
        vector2.add(a[0]);
        if (this._showDischargeCapacity && pairedDataContainer != null) {
            pairedDataContainer.xtype = "UNT";
            pairedDataContainer.ytype = "UNT";
            object = new PairedDataContainer();
            new PairedDataContainer().xOrdinates = pairedDataContainer.xOrdinates;
            object.numberOrdinates = pairedDataContainer.xOrdinates.length;
            object.yOrdinates = new double[1][];
            object.yOrdinates[0] = pairedDataContainer.yOrdinates[0];
            object.labels = pairedDataContainer.labels;
            object.labelsUsed = pairedDataContainer.labelsUsed;
            object.numberCurves = pairedDataContainer.numberCurves;
            object.xparameter = pairedDataContainer.xparameter;
            object.yparameter = pairedDataContainer.yparameter;
            object.xunits = pairedDataContainer.xunits;
            object.yunits = pairedDataContainer.yunits;
            object.xtype = "UNT";
            object.ytype = "UNT";
            object.switchXyAxis = false;
            object = new InducedSurchargePlotDialog$MyPairedDataSet(this, (PairedDataContainer)object);
            vector.add((PairedDataContainer)object);
            vector2.add(a[1]);
        }
        g2dPanel.buildComponents(vector, vector2);
        this.getContentPane().add((Component)g2dPanel, "Center");
        InducedSurchargePlotDialog.setUnitSystem((int)this.getUnitDisplaySystem());
    }

    public void setInducedSurchargeOpRule(InducedSurchargeOpRule inducedSurchargeOpRule) {
        this._rule = inducedSurchargeOpRule;
    }
}

