/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.rss.client.InflowMultiplierEditor$1;
import hec.rss.client.InflowMultiplierEditor$2;
import hec.rss.client.InflowMultiplierEditor$3;
import hec.rss.client.InflowMultiplierEditor$4;
import hec.rss.client.InflowMultiplierEditor$5;
import hec.rss.client.InflowMultiplierEditor$6;
import hec.rss.client.InflowMultiplierEditor$7;
import hec.rss.client.InflowMultiplierEditor$8;
import hec.rss.client.InflowMultiplierEditor$LocalFlow;
import hec.rss.client.InflowMultiplierEditor$ShowProductsWindow;
import hec.rss.model.Element;
import hec.rss.model.InflowLocationFactor;
import hec.rss.model.JunctionElement;
import hec.rss.model.RssAlt;
import hec.rss.model.RssSystem;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.RowSorter;
import javax.swing.border.Border;
import javax.swing.table.TableRowSorter;
import rma.swing.ButtonCmdPanel;
import rma.swing.ButtonCmdPanelListener;
import rma.swing.EnabledJPanel;
import rma.swing.RmaInsets;
import rma.swing.RmaJCheckBox;
import rma.swing.RmaJDecimalField;
import rma.swing.RmaJDialog;
import rma.swing.RmaJRadioButton;
import rma.swing.RmaJTable;
import rma.swing.table.RmaTableModel;
import rma.util.RMAIO;

public class InflowMultiplierEditor
extends RmaJDialog {
    private static String a = "Inflow Multipliers";
    private RssAlt _alt;
    private RmaJCheckBox _useInflowMultiplierCheck;
    private RmaJRadioButton _globalRadio;
    private RmaJDecimalField _globalMultiFld;
    private RmaJRadioButton _multiLocationRadio;
    private RmaJTable _locationTable;
    private ButtonCmdPanel _cmdPanel;
    protected boolean _canceled;
    private EnabledJPanel _compPanel;
    private RmaJDialog _altEditor;
    private JButton _restoreDefaultBtn;
    private JButton _showProductBtn;
    private InflowMultiplierEditor$ShowProductsWindow _spw;

    public InflowMultiplierEditor(RmaJDialog rmaJDialog, RssAlt rssAlt) {
        super((Dialog)rmaJDialog, a, true);
        this._alt = rssAlt;
        this._altEditor = rmaJDialog;
        this.buildControls();
        this.addListeners();
        this.fillForm();
        this.pack();
        InflowMultiplierEditor inflowMultiplierEditor = this;
        inflowMultiplierEditor.setLocationRelativeTo(inflowMultiplierEditor.getParent());
    }

    private void buildControls() {
        this.getContentPane().setLayout(new GridBagLayout());
        Serializable serializable = new JLabel("The Inflow Multiplier(s) will be applied to each inflow time series to increase or decrease the entering flows");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this.getContentPane().add((Component)serializable, gridBagConstraints);
        this._useInflowMultiplierCheck = new RmaJCheckBox("Use Inflow Multipliers");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this.getContentPane().add((Component)this._useInflowMultiplierCheck, gridBagConstraints);
        this._compPanel = new EnabledJPanel((LayoutManager)new GridBagLayout());
        this._compPanel.setBorder((Border)BorderFactory.createTitledBorder(""));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this.getContentPane().add((Component)this._compPanel, gridBagConstraints);
        serializable = new JPanel(new GridBagLayout());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this._compPanel.add((Component)serializable, (Object)gridBagConstraints);
        this._globalRadio = new RmaJRadioButton("Global Multiplier");
        this._globalRadio.setMnemonic('G');
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        ((Container)serializable).add((Component)this._globalRadio, gridBagConstraints);
        this._globalMultiFld = new RmaJDecimalField();
        this._globalMultiFld.setValue(1.0);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        ((Container)serializable).add((Component)this._globalMultiFld, gridBagConstraints);
        serializable = new JPanel(new GridBagLayout());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this._compPanel.add((Component)serializable, (Object)gridBagConstraints);
        this._multiLocationRadio = new RmaJRadioButton("Multipliers by Location");
        this._multiLocationRadio.setMnemonic('m');
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        ((Container)serializable).add((Component)this._multiLocationRadio, gridBagConstraints);
        InflowMultiplierEditor inflowMultiplierEditor = this;
        this._locationTable = new InflowMultiplierEditor$1(inflowMultiplierEditor, (Component)((Object)inflowMultiplierEditor), new String[]{"Junction", "Local Flow Name", "Multiplier"});
        Object object = (RmaTableModel)this._locationTable.getModel();
        object.setColumnClass(0, Object.class);
        object.setColumnClass(1, Object.class);
        object.setColumnClass(2, Double.class);
        object = new TableRowSorter<RmaTableModel>((RmaTableModel)object);
        this._locationTable.setRowSorter((RowSorter)object);
        this._locationTable.setAddRemoveEnabled(false);
        this._locationTable.setDoubleCellEditor(2);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        ((Container)serializable).add(this._locationTable.getScrollPane(), gridBagConstraints);
        serializable = new JPanel(new GridBagLayout());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5555;
        this.getContentPane().add((Component)serializable, gridBagConstraints);
        this._restoreDefaultBtn = new JButton("Restore Defaults");
        this._restoreDefaultBtn.setMnemonic('R');
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        ((Container)serializable).add(this._restoreDefaultBtn, gridBagConstraints);
        this._showProductBtn = new JButton("Show Product");
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        ((Container)serializable).add(this._showProductBtn, gridBagConstraints);
        this._cmdPanel = new ButtonCmdPanel(12);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5555;
        this.getContentPane().add((Component)this._cmdPanel, gridBagConstraints);
        serializable = new ButtonGroup();
        ((ButtonGroup)serializable).add((AbstractButton)this._globalRadio);
        ((ButtonGroup)serializable).add((AbstractButton)this._multiLocationRadio);
        this._compPanel.setEnabled(false);
        this.radioSelectionChangedAction();
    }

    private void addListeners() {
        InflowMultiplierEditor$2 inflowMultiplierEditor$2 = new InflowMultiplierEditor$2(this);
        this._globalRadio.addActionListener((ActionListener)inflowMultiplierEditor$2);
        this._multiLocationRadio.addActionListener((ActionListener)inflowMultiplierEditor$2);
        this._cmdPanel.addCmdPanelListener((ButtonCmdPanelListener)new InflowMultiplierEditor$3(this));
        this._useInflowMultiplierCheck.addActionListener((ActionListener)new InflowMultiplierEditor$4(this));
        this._showProductBtn.addActionListener(new InflowMultiplierEditor$5(this));
        this._restoreDefaultBtn.addActionListener(new InflowMultiplierEditor$6(this));
        this._locationTable.getModel().addTableModelListener(new InflowMultiplierEditor$7(this));
        this._globalMultiFld.getDocument().addDocumentListener(new InflowMultiplierEditor$8(this));
    }

    protected void repaintProductWindow() {
        if (this._spw == null || !this._spw.isVisible()) {
            return;
        }
        this._spw._productsTable.repaint();
    }

    protected void showProductsAction() {
        this._locationTable.commitEdit(true);
        InflowMultiplierEditor inflowMultiplierEditor = this;
        this._spw = new InflowMultiplierEditor$ShowProductsWindow(inflowMultiplierEditor, inflowMultiplierEditor, this._locationTable);
        this._spw.setVisible(true);
    }

    protected void restoreDefaultsAction() {
        int n = this._locationTable.getRowCount();
        this._locationTable.commitEdit(true);
        for (int i = 0; i < n; ++i) {
            this._locationTable.setValueAt((Object)1.0, i, 2);
        }
    }

    protected void useInflowCheckAction() {
        this._compPanel.setEnabled(this._useInflowMultiplierCheck.isSelected());
        boolean bl = this._globalRadio.isSelected();
        if (!this._useInflowMultiplierCheck.isSelected()) {
            bl = false;
        }
        this._globalMultiFld.setEnabled(bl);
        this._locationTable.repaint();
        this.repaintProductWindow();
    }

    protected boolean userEnteredValues() {
        int n;
        boolean bl;
        block4: {
            block3: {
                this._locationTable.commitEdit(true);
                bl = true;
                if (!this._globalRadio.isSelected()) break block3;
                if (this._globalMultiFld.getValue() == 1.0) break block4;
                bl = false;
                break block4;
            }
            n = this._locationTable.getRowCount();
            for (int i = 0; i < n; ++i) {
                if (RMAIO.parseDouble((Object)this._locationTable.getValueAt(i, 2)) == 1.0) continue;
                bl = false;
                break;
            }
        }
        if (bl && this._useInflowMultiplierCheck.isSelected()) {
            InflowMultiplierEditor inflowMultiplierEditor = this;
            n = JOptionPane.showConfirmDialog((Component)((Object)inflowMultiplierEditor), "<html>The <b>" + inflowMultiplierEditor._useInflowMultiplierCheck.getText() + "</b> is selected but only default values are entered.<br>Continuing will unselect " + this._useInflowMultiplierCheck.getText(), "Defaults Specified", 2);
            if (n != 0) {
                return false;
            }
            this._useInflowMultiplierCheck.doClick(0);
        }
        return true;
    }

    protected void radioSelectionChangedAction() {
        this._locationTable.commitEdit(true);
        boolean bl = this._globalRadio.isSelected();
        if (!this._useInflowMultiplierCheck.isSelected()) {
            bl = false;
        }
        this._globalMultiFld.setEnabled(bl);
        this._locationTable.repaint();
        this.repaintProductWindow();
    }

    public void saveForm() {
        if (this._alt == null) {
            return;
        }
        this._alt.setUsingInflowFactors(this._useInflowMultiplierCheck.isSelected());
        if (this._globalRadio.isSelected()) {
            this._alt.setInflowFactorType(0);
        } else {
            this._alt.setInflowFactorType(1);
        }
        this._alt.setGlobalInflowFactor(this._globalMultiFld.getValue());
        int n = this._locationTable.getRowCount();
        ArrayList<InflowLocationFactor> arrayList = new ArrayList<InflowLocationFactor>();
        for (int i = 0; i < n; ++i) {
            Object object = (JunctionElement)this._locationTable.getValueAt(i, 0);
            String string = ((Element)object).getSystem().getKeyStringForObject(object);
            object = (InflowMultiplierEditor$LocalFlow)this._locationTable.getValueAt(i, 1);
            Object object2 = this._locationTable.getValueAt(i, 2);
            double d = object2 instanceof Double ? (Double)object2 : RMAIO.parseDouble((Object)object2);
            object = new InflowLocationFactor(string, ((InflowMultiplierEditor$LocalFlow)object).toString(), d);
            arrayList.add((InflowLocationFactor)object);
        }
        this._alt.setLocationInflowFactors(arrayList);
        this._alt.setModified(true);
        this.setModified(false);
    }

    private void fillForm() {
        JunctionElement junctionElement;
        int n;
        this._locationTable.deleteCells();
        if (this._alt == null) {
            return;
        }
        List<InflowLocationFactor> list = this._alt.getSystem();
        ((RssSystem)((Object)list)).setAlternative(this._alt);
        list = ((RssSystem)((Object)list)).getElementVectorByClass(JunctionElement.class);
        int n2 = list.size();
        for (n = 0; n < n2; ++n) {
            junctionElement = (JunctionElement)list.get(n);
            Vector vector = junctionElement.getLocalFlowVector();
            int n3 = vector.size();
            if (n3 == 0) continue;
            for (int i = 0; i < n3; ++i) {
                String[] stringArray = (String[])vector.get(i);
                Vector<Object> vector2 = new Vector<Object>(3);
                vector2.add(junctionElement);
                vector2.add(new InflowMultiplierEditor$LocalFlow(this, stringArray));
                vector2.add(1.0);
                this._locationTable.appendRow(vector2);
            }
        }
        this._useInflowMultiplierCheck.setSelected(this._alt.isUsingInflowFactors());
        n = this._alt.getInflowFactorType();
        if (n == 1) {
            this._multiLocationRadio.setSelected(true);
        } else {
            this._globalRadio.setSelected(true);
        }
        this.radioSelectionChangedAction();
        this.useInflowCheckAction();
        double d = this._alt.getGlobalInflowFactor();
        this._globalMultiFld.setValue(d);
        list = this._alt.getLocationInflowFactors();
        int n4 = this._locationTable.getRowCount();
        int n5 = list.size();
        for (int i = 0; i < n5; ++i) {
            InflowLocationFactor inflowLocationFactor = list.get(i);
            if (inflowLocationFactor == null) continue;
            for (n = 0; n < n4; ++n) {
                junctionElement = (JunctionElement)this._locationTable.getValueAt(n, 0);
                Object object = junctionElement.getSystem().getKeyStringForObject(junctionElement);
                if (!((String)object).equals(inflowLocationFactor.getJunctionId()) || !((InflowMultiplierEditor$LocalFlow)(object = (InflowMultiplierEditor$LocalFlow)this._locationTable.getValueAt(n, 1))).toString().equalsIgnoreCase(inflowLocationFactor.getLocalFlowName())) continue;
                this._locationTable.setValueAt((Object)inflowLocationFactor.getFactor(), n, 2);
            }
        }
        this.setModified(false);
    }

    public boolean isCanceled() {
        return this._canceled;
    }

    public boolean hasDefaultInflows() {
        return this._useInflowMultiplierCheck.isSelected();
    }

    public void setModified(boolean bl) {
        super.setModified(bl);
        if (bl) {
            this.setTitle(a + "*");
            return;
        }
        this.setTitle(a);
    }
}

