/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.rss.client.InflowTimeSeriesOptionsDialog$1;
import hec.rss.client.InflowTimeSeriesOptionsDialog$2;
import hec.rss.client.InflowTimeSeriesOptionsDialog$ToolTipRenderer;
import hec.rss.model.IndependentVariable;
import hec.rss.model.InducedSurchargeOpRule;
import hec.rss.model.InflowTimeSeriesOptionModel;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ItemListener;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.ListCellRenderer;
import rma.swing.ButtonCmdPanel;
import rma.swing.ButtonCmdPanelListener;
import rma.swing.RmaInsets;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJDecimalField;

public class InflowTimeSeriesOptionsDialog
extends JDialog {
    private String[] FUNCTION_VALUES = IndependentVariable.TS_FUNCTION_STRINGS;
    private String[] FUNCTION_TOOLTIPS = new String[]{"Uses value at current compute time step", "Uses value at end of last time step", "Uses value offset number of hours prior to the current time step", "<html>Averages the value of the given number of hours starting<br>with <b>offset</b> number of hours prior to current time step</html>", "<html>Maximum value over the given number of hours starting<br>the <b>offset</b> number of hours prior to the current time step</html>", "<html>Minimum value over the given number of hours starting<br>the <b>offset</b> number of hours prior to the current time step</html>"};
    private boolean[][] ENABLED_STATES = new boolean[][]{{false, false}, {false, false}, {true, false}, {true, true}, {true, true}, {true, true}};
    private RmaJComboBox _functionCombo;
    private ButtonCmdPanel _OkCancelPanel;
    private RmaJDecimalField _lagFld;
    private RmaJDecimalField _periodFld;
    private InflowTimeSeriesOptionModel _inflowModel;
    private InducedSurchargeOpRule _rule;
    private IndependentVariable _independentVariable;

    InflowTimeSeriesOptionsDialog(Dialog dialog, boolean bl) {
        super(dialog, bl);
        this.buildControls();
    }

    public void setTimeSeriesOptions(String string, double d, double d2) {
        this._functionCombo.setSelectedItem((Object)string);
        if (this._lagFld.isEnabled()) {
            this._lagFld.setValue(d * -1.0);
        }
        if (this._periodFld.isEnabled()) {
            this._periodFld.setValue(d2);
        }
    }

    public void fillForm(InducedSurchargeOpRule inducedSurchargeOpRule) {
        this._rule = inducedSurchargeOpRule;
        if (this._rule.getIndependentVariable() != null) {
            this._independentVariable = this._rule.getIndependentVariable();
            this._functionCombo.setSelectedItem((Object)this._independentVariable.getTimeSeriesFunction());
            if (this._independentVariable.getTimeSeriesLag() != Double.NEGATIVE_INFINITY) {
                this._lagFld.setValue(-1.0 * this._independentVariable.getTimeSeriesLag());
            }
            if (this._independentVariable.getTimeSeriesPeriod() != Double.NEGATIVE_INFINITY) {
                this._periodFld.setValue(this._independentVariable.getTimeSeriesPeriod());
            }
        }
        this._rule.setIndependentVariable(this._independentVariable);
    }

    public void save() {
        this._independentVariable.setTimeSeriesOptions(this._functionCombo.getSelectedIndex(), this.getLag(), this.getPeriod());
    }

    protected void buildControls() {
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Inflow Time Series Options");
        JLabel jLabel = new JLabel("Function:");
        jLabel.setDisplayedMnemonic('u');
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        this.getContentPane().add((Component)jLabel, gridBagConstraints);
        this._functionCombo = new RmaJComboBox((Object[])this.FUNCTION_VALUES);
        this._functionCombo.setRenderer((ListCellRenderer)new InflowTimeSeriesOptionsDialog$ToolTipRenderer(this));
        this._functionCombo.setToolTipText("");
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        this.getContentPane().add((Component)this._functionCombo, gridBagConstraints);
        jLabel = new JLabel("Offset (hours):");
        jLabel.setDisplayedMnemonic('O');
        jLabel.setToolTipText("Number of hours forward (+) or back (-) from current timestep (0)");
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        this.getContentPane().add((Component)jLabel, gridBagConstraints);
        this._lagFld = new RmaJDecimalField();
        jLabel.setLabelFor((Component)this._lagFld);
        this._lagFld.setToolTipText("Number of hours forward (+) or back (-) from current timestep (0)");
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        this.getContentPane().add((Component)this._lagFld, gridBagConstraints);
        jLabel = new JLabel("Period (hours):");
        jLabel.setDisplayedMnemonic('P');
        jLabel.setToolTipText("Number of hours back from the Offset");
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        this.getContentPane().add((Component)jLabel, gridBagConstraints);
        this._periodFld = new RmaJDecimalField();
        this._periodFld.setMinValue(0.0);
        this._periodFld.setToolTipText("Number of hours back from the Offset");
        jLabel.setLabelFor((Component)this._periodFld);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        this.getContentPane().add((Component)this._periodFld, gridBagConstraints);
        this._functionCombo.addItemListener((ItemListener)new InflowTimeSeriesOptionsDialog$1(this));
        this._OkCancelPanel = new ButtonCmdPanel(12);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        this.getContentPane().add((Component)this._OkCancelPanel, gridBagConstraints);
        this._OkCancelPanel.addCmdPanelListener((ButtonCmdPanelListener)new InflowTimeSeriesOptionsDialog$2(this));
        this.pack();
        InflowTimeSeriesOptionsDialog inflowTimeSeriesOptionsDialog = this;
        inflowTimeSeriesOptionsDialog.setLocationRelativeTo(inflowTimeSeriesOptionsDialog.getParent());
        this.functionComboSelected();
    }

    protected void functionComboSelected() {
        int n = this._functionCombo.getSelectedIndex();
        if (n == -1) {
            this._lagFld.setEnabled(false);
            this._periodFld.setEnabled(false);
            return;
        }
        boolean[] blArray = this.ENABLED_STATES[n];
        this._lagFld.setEnabled(blArray[0]);
        this._periodFld.setEnabled(blArray[1]);
    }

    int getFunctionType() {
        return this._functionCombo.getSelectedIndex();
    }

    double getLag() {
        return -1.0 * this._lagFld.getValue();
    }

    double getPeriod() {
        return this._periodFld.getValue();
    }

    boolean isValidForm() {
        String string = null;
        if (this._lagFld.isEnabled() && this._lagFld.getText().length() == 0) {
            string = "Please enter an Offset amount";
        } else if (this._periodFld.isEnabled() && this._periodFld.getText().length() == 0) {
            string = "Please enter a Period amount";
        }
        if (string != null) {
            JOptionPane.showMessageDialog(this, string, "Incomplete Form", 1);
        }
        return string == null;
    }
}

