/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.rss.client.IndependentVariableDialog;
import hec.rss.client.InflowTimeSeriesVariableOptionsDialog$1;
import hec.rss.client.InflowTimeSeriesVariableOptionsDialog$2;
import hec.rss.client.InflowTimeSeriesVariableOptionsDialog$3;
import hec.rss.client.InflowTimeSeriesVariableOptionsDialog$ToolTipRenderer;
import hec.rss.model.IndependentVariable;
import hec.rss.model.InducedSurchargeOpRule;
import hec.rss.model.InflowTimeSeriesOptionModel;
import hec.rss.model.RssTSLocationObject;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import rma.swing.ButtonCmdPanel;
import rma.swing.RmaInsets;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJDecimalField;
import rma.swing.RmaJPanel;
import rma.swing.RmaJRadioButton;

public class InflowTimeSeriesVariableOptionsDialog
extends IndependentVariableDialog {
    private String[] INFLOW_FUNCTION_VALUES = IndependentVariable.TS_FUNCTION_STRINGS;
    private String[] INFLOW_FUNCTION_TOOLTIPS = new String[]{"Uses value at current compute time step", "Uses value at end of last time step", "Uses value offset number of hours prior to the current time step", "<html>Averages the value of the given number of hours starting<br>with the <b>offset</b> number of hours prior to current time step</html>", "<html>Maximum value over the given number of hours starting<br>the <b>offset</b> number of hours prior to the current time step</html>", "<html>Minimum value over the given number of hours starting<br>the <b>offset</b> number of hours prior to the current time step</html>"};
    private boolean[][] INFLOW_ENABLED_STATES = new boolean[][]{{false, false}, {false, false}, {true, false}, {true, true}, {true, true}, {true, true}};
    private RmaJComboBox _functionCombo;
    private ButtonCmdPanel _OkCancelPanel;
    private RmaJDecimalField _lagFld;
    private RmaJDecimalField _periodFld;
    private InflowTimeSeriesOptionModel _inflowModel;
    private InducedSurchargeOpRule _rule;
    private IndependentVariable _independentVariable;
    private IndependentVariable _independentTableVariable;
    private RmaJRadioButton _useDefaultInflowRadio;
    private RmaJRadioButton _userSelectedRadio;
    private RmaJPanel _inflowPanel;

    InflowTimeSeriesVariableOptionsDialog(Dialog dialog, boolean bl, int n) {
        super(dialog, n);
        super.setModal(bl);
        this.buildUIControls();
        this.setTitle("Inflow Time Series Options");
    }

    public void setTimeSeriesOptions(String string, double d, double d2) {
        this._functionCombo.setSelectedItem((Object)string);
        if (this._lagFld.isEnabled()) {
            this._lagFld.setValue(d);
        }
        if (this._periodFld.isEnabled()) {
            this._periodFld.setValue(d2);
        }
    }

    public void fillForm(InducedSurchargeOpRule inducedSurchargeOpRule) {
        this._rule = inducedSurchargeOpRule;
        if (this._rule.getIndependentVariable() != null) {
            this._independentVariable = this._rule.getIndependentVariable();
            this._functionCombo.setSelectedItem((Object)this._independentVariable.getTimeSeriesFunction());
            if (this._independentVariable.getTimeSeriesLag() != Double.NEGATIVE_INFINITY) {
                this._lagFld.setValue(this._independentVariable.getTimeSeriesLag());
            }
            if (this._independentVariable.getTimeSeriesPeriod() != Double.NEGATIVE_INFINITY) {
                this._periodFld.setValue(this._independentVariable.getTimeSeriesPeriod());
            }
        }
        this._userSelectedRadio.setSelected(this._rule.useTableLookupIndependentVariable());
        if (this._rule.getTableLookupIndependentVariable() != null) {
            this._independentTableVariable = this._rule.getTableLookupIndependentVariable();
            InflowTimeSeriesVariableOptionsDialog inflowTimeSeriesVariableOptionsDialog = this;
            super.setNetwork(((RssTSLocationObject)inflowTimeSeriesVariableOptionsDialog._rule).getSystem());
            this.selectLookupTypeAction();
            InflowTimeSeriesVariableOptionsDialog inflowTimeSeriesVariableOptionsDialog2 = this;
            super.setIndependentVariable(inflowTimeSeriesVariableOptionsDialog2._independentTableVariable);
        }
        if (!this._rule.useTableLookupIndependentVariable()) {
            this.selectLookupTypeAction();
        }
    }

    private void savePanel() {
        this._independentVariable.setTimeSeriesOptions(this._functionCombo.getSelectedIndex(), this._lagFld.getValue(), this._periodFld.getValue());
        this._rule.setIndependentVariable(this._independentVariable);
        this._rule.setUseTableLookupIndependentVariable(this._userSelectedRadio.isSelected());
        if (this._userSelectedRadio.isSelected()) {
            this._rule.setTableLookupIndependentVariable(super.getIndependentVariable());
        }
    }

    @Override
    protected boolean isValidDialog() {
        if (this._userSelectedRadio.isSelected()) {
            return super.isValidDialog();
        }
        return true;
    }

    protected void buildUIControls() {
        this._inflowPanel = new InflowTimeSeriesVariableOptionsDialog$1(this, new GridBagLayout());
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder("Inflow Time Series Options"));
        Object object = new JLabel("Function:");
        ((JLabel)object).setDisplayedMnemonic('u');
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        jPanel.add((Component)object, gridBagConstraints);
        this._functionCombo = new RmaJComboBox((Object[])this.INFLOW_FUNCTION_VALUES);
        this._functionCombo.setRenderer((ListCellRenderer)new InflowTimeSeriesVariableOptionsDialog$ToolTipRenderer(this));
        this._functionCombo.setToolTipText("");
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        jPanel.add((Component)this._functionCombo, gridBagConstraints);
        object = new JLabel("Offset (hours):");
        ((JLabel)object).setDisplayedMnemonic('O');
        ((JComponent)object).setToolTipText("Number of hours forward (+) or back (-) from current timestep (0)");
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        jPanel.add((Component)object, gridBagConstraints);
        this._lagFld = new RmaJDecimalField();
        ((JLabel)object).setLabelFor((Component)this._lagFld);
        this._lagFld.setToolTipText("Number of hours forward (+) or back (-) from current timestep (0)");
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        jPanel.add((Component)this._lagFld, gridBagConstraints);
        object = new JLabel("Period (hours):");
        ((JLabel)object).setDisplayedMnemonic('P');
        ((JComponent)object).setToolTipText("Number of hours back from the Offset");
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        jPanel.add((Component)object, gridBagConstraints);
        this._periodFld = new RmaJDecimalField();
        this._periodFld.setMinValue(0.0);
        this._periodFld.setToolTipText("Number of hours back from the Offset");
        ((JLabel)object).setLabelFor((Component)this._periodFld);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        jPanel.add((Component)this._periodFld, gridBagConstraints);
        this._functionCombo.addItemListener((ItemListener)new InflowTimeSeriesVariableOptionsDialog$2(this));
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)0, (int)0, (int)0, (int)0);
        this._inflowPanel.add((Component)jPanel, (Object)gridBagConstraints);
        jPanel = new JPanel(new GridBagLayout());
        object = new JLabel("Variable for ESRD Lookup:");
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.insets((int)8, (int)0, (int)0, (int)0);
        jPanel.add((Component)object, gridBagConstraints);
        this._useDefaultInflowRadio = new RmaJRadioButton("Inflow (Default)", true);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        jPanel.add((Component)this._useDefaultInflowRadio, gridBagConstraints);
        this._userSelectedRadio = new RmaJRadioButton("User Selected (below)");
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        jPanel.add((Component)this._userSelectedRadio, gridBagConstraints);
        object = new ButtonGroup();
        ((ButtonGroup)object).add((AbstractButton)this._useDefaultInflowRadio);
        ((ButtonGroup)object).add((AbstractButton)this._userSelectedRadio);
        object = new InflowTimeSeriesVariableOptionsDialog$3(this);
        this._useDefaultInflowRadio.addActionListener((ActionListener)object);
        this._userSelectedRadio.addActionListener((ActionListener)object);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS0000;
        this._inflowPanel.add((Component)jPanel, (Object)gridBagConstraints);
        InflowTimeSeriesVariableOptionsDialog inflowTimeSeriesVariableOptionsDialog = this;
        super.buildControls(inflowTimeSeriesVariableOptionsDialog._inflowPanel);
        InflowTimeSeriesVariableOptionsDialog inflowTimeSeriesVariableOptionsDialog2 = this;
        inflowTimeSeriesVariableOptionsDialog2.setLocationRelativeTo(inflowTimeSeriesVariableOptionsDialog2.getParent());
        this.functionComboSelected();
    }

    private void selectLookupTypeAction() {
        if (this._useDefaultInflowRadio.isSelected()) {
            this._releaseFunctionCombo.setEnabled(false);
            this._modelVariablePanel.disableAllFields(true);
            this._timeSeriesPanel.disableAllFields(true);
            this._stateVariablePanel.disableAllFields(true);
            return;
        }
        this._releaseFunctionCombo.setEnabled(true);
        this._modelVariablePanel.disableAllFields(false);
        this._timeSeriesPanel.disableAllFields(false);
        this._stateVariablePanel.disableAllFields(false);
    }

    protected void functionComboSelected() {
        int n = this._functionCombo.getSelectedIndex();
        if (n == -1) {
            this._lagFld.setEnabled(false);
            this._periodFld.setEnabled(false);
            return;
        }
        boolean[] blArray = this.INFLOW_ENABLED_STATES[n];
        this._lagFld.setEnabled(blArray[0]);
        this._periodFld.setEnabled(blArray[1]);
    }

    int getFunctionType() {
        return this._functionCombo.getSelectedIndex();
    }

    double getLag() {
        return this._lagFld.getValue();
    }

    double getPeriod() {
        return this._periodFld.getValue();
    }

    boolean isValidForm() {
        String string = null;
        if (this._lagFld.isEnabled() && this._lagFld.getText().length() == 0) {
            string = "Please enter an Offset amount";
        } else if (this._periodFld.isEnabled() && this._periodFld.getText().length() == 0) {
            string = "Please enter a Period amount";
        }
        if (string != null) {
            JOptionPane.showMessageDialog((Component)((Object)this), string, "Incomplete Form", 1);
        }
        return string == null;
    }
}

