/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.clientapp.client.ClientApp;
import hec.data.ParamDouble;
import hec.data.Parameter;
import hec.model.ParamDoubleTableModel;
import hec.rss.client.InflowValuesForSurchargePlot$1;
import hec.rss.model.InducedSurchargeOpRule;
import hec.rss.model.ReservoirOp;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.Vector;
import javax.swing.table.TableModel;
import rma.swing.ButtonCmdPanel;
import rma.swing.ButtonCmdPanelListener;
import rma.swing.RmaInsets;
import rma.swing.RmaJDialog;
import rma.swing.RmaJTable;
import rma.util.RMAIO;

public class InflowValuesForSurchargePlot
extends RmaJDialog {
    ReservoirOp _resOp;
    private ButtonCmdPanel _cmdPanel;
    private RmaJTable _inflowTable;
    private InducedSurchargeOpRule _rule;

    public InflowValuesForSurchargePlot(Dialog dialog, boolean bl) {
        super(dialog, bl);
        this.buildControls();
    }

    public void fillForm(InducedSurchargeOpRule object) {
        int n;
        this._rule = object;
        int n2 = 0;
        double[] dArray = ((InducedSurchargeOpRule)object).getInflowValues();
        object = dArray;
        if (dArray != null) {
            n2 = ((Object)object).length;
        }
        Object[][] objectArray = new Object[n2][1];
        ((ParamDoubleTableModel)this._inflowTable.getModel()).setUnitSystem(this._rule.getUnitSystem());
        for (n = 0; n < n2; ++n) {
            Object object2 = object[n];
            if (object2 == Double.NEGATIVE_INFINITY) continue;
            objectArray[n][0] = new ParamDouble((double)object2, Parameter.PARAMID_FLOW, this._rule.getUnitSystem());
            ((ParamDoubleTableModel)this._inflowTable.getModel()).setData(objectArray);
            if (this._inflowTable.getRowCount() < 10) {
                int n3 = 10 - this._inflowTable.getRowCount();
                this._inflowTable.appendRows(n3);
                continue;
            }
            this._inflowTable.appendRows(2);
        }
        if (n2 == 0) {
            n = 10 - this._inflowTable.getRowCount();
            this._inflowTable.appendRows(n);
        }
    }

    public void save() {
        this._inflowTable.commitEdit(true);
        Vector vector = this._inflowTable.getCells();
        vector.trimToSize();
        double[] dArray = new double[vector.size()];
        int n = vector.size();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            Vector vector2 = (Vector)vector.elementAt(i);
            double d = RMAIO.parseDouble(vector2.elementAt(0));
            if (d == Double.NEGATIVE_INFINITY) continue;
            dArray[i] = d;
            ++n2;
        }
        double[] dArray2 = new double[n2];
        for (int i = 0; i < n2; ++i) {
            dArray2[i] = dArray[i];
        }
        this._rule.setInflowValues(dArray2);
    }

    private void buildControls() {
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Inflow Values for Surcharge Plot");
        Object object = new String[]{"Inflow (%S)"};
        this._inflowTable = new RmaJTable((Component)((Object)this));
        this._inflowTable.setRowHeight(10);
        object = new ParamDoubleTableModel(object, new int[]{Parameter.PARAMID_FLOW}, new boolean[]{true});
        this._inflowTable.setRowHeight(15);
        ClientApp.app();
        object.setUnitSystem(ClientApp.Workspace().getUnitSystem());
        this._inflowTable.setModel((TableModel)object);
        this._inflowTable.setDoubleCellEditor(0, true);
        this._inflowTable.setPrecision(2);
        this._inflowTable.setUnitsHeaderRenderer();
        object = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        object.gridy = 0;
        object.gridwidth = 1;
        object.weightx = 1.0;
        object.weighty = 1.0;
        object.anchor = 18;
        object.fill = 1;
        object.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        this.getContentPane().add((Component)this._inflowTable.getScrollPane(), object);
        this._cmdPanel = new ButtonCmdPanel(12);
        object = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        object.gridy = 1;
        object.gridwidth = 1;
        object.anchor = 15;
        object.fill = 2;
        object.insets = RmaInsets.insets((int)10, (int)5, (int)10, (int)10);
        this.getContentPane().add((Component)this._cmdPanel, object);
        this._cmdPanel.addCmdPanelListener((ButtonCmdPanelListener)new InflowValuesForSurchargePlot$1(this));
        this.setSize(250, 200);
        InflowValuesForSurchargePlot inflowValuesForSurchargePlot = this;
        inflowValuesForSurchargePlot.setLocationRelativeTo(inflowValuesForSurchargePlot.getParent());
    }
}

