/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.clientapp.client.ClientApp;
import hec.data.ParamDouble;
import hec.data.Parameter;
import hec.rss.model.IntakeGeometry;
import hec.rss.model.IntakeOpening;
import hec.rss.model.IntakeOpeningType;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.Serializable;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.JFrame;
import javax.swing.JPanel;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJDecimalField;
import rma.swing.RmaJLabel;
import rma.swing.RmaJRadioButton;
import rma.swing.list.RmaListModel;

public class IntakeGeometryPanel
extends JPanel {
    private RmaJRadioButton _rectangleRadioButton;
    private RmaJDecimalField _lengthTextField;
    private RmaJDecimalField _widthTextField;
    private RmaJRadioButton _circularRadioButton;
    private RmaJDecimalField _diameterTextField;
    private RmaJDecimalField _invertElevationTextField;
    private RmaJComboBox<IntakeOpening> _opensFromComboBox;

    public IntakeGeometryPanel() {
        this.initComponents();
    }

    private void initComponents() {
        this.setBorder(BorderFactory.createTitledBorder("Intake Geometry"));
        new GridBagConstraints();
        this.setLayout(new GridBagLayout());
        this._rectangleRadioButton = new RmaJRadioButton("Rectangular");
        this._rectangleRadioButton.setMargin(new Insets(0, 0, 0, 0));
        Serializable serializable = new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0);
        IntakeGeometryPanel intakeGeometryPanel = this;
        intakeGeometryPanel.add((Component)intakeGeometryPanel._rectangleRadioButton, serializable);
        RmaJLabel rmaJLabel = new RmaJLabel("Height (%S):");
        serializable = new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 25, 0, 0), 0, 0);
        this.add((Component)rmaJLabel, serializable);
        this._lengthTextField = new RmaJDecimalField();
        rmaJLabel.setLabelFor((Component)this._lengthTextField);
        serializable = new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0);
        IntakeGeometryPanel intakeGeometryPanel2 = this;
        intakeGeometryPanel2.add((Component)intakeGeometryPanel2._lengthTextField, serializable);
        rmaJLabel = new RmaJLabel("Width (%S):");
        serializable = new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 25, 0, 0), 0, 0);
        this.add((Component)rmaJLabel, serializable);
        this._widthTextField = new RmaJDecimalField();
        rmaJLabel.setLabelFor((Component)this._widthTextField);
        serializable = new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0);
        IntakeGeometryPanel intakeGeometryPanel3 = this;
        intakeGeometryPanel3.add((Component)intakeGeometryPanel3._widthTextField, serializable);
        this._circularRadioButton = new RmaJRadioButton("Circular");
        this._circularRadioButton.setMargin(new Insets(0, 0, 0, 0));
        serializable = new GridBagConstraints(0, 3, 2, 1, 1.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0);
        IntakeGeometryPanel intakeGeometryPanel4 = this;
        intakeGeometryPanel4.add((Component)intakeGeometryPanel4._circularRadioButton, serializable);
        rmaJLabel = new RmaJLabel("Diameter (%S):");
        serializable = new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 25, 0, 0), 0, 0);
        this.add((Component)rmaJLabel, serializable);
        this._diameterTextField = new RmaJDecimalField();
        rmaJLabel.setLabelFor((Component)this._diameterTextField);
        serializable = new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0);
        IntakeGeometryPanel intakeGeometryPanel5 = this;
        intakeGeometryPanel5.add((Component)intakeGeometryPanel5._diameterTextField, serializable);
        rmaJLabel = new RmaJLabel("Invert Elevation (%S):");
        serializable = new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0);
        this.add((Component)rmaJLabel, serializable);
        this._invertElevationTextField = new RmaJDecimalField();
        rmaJLabel.setLabelFor((Component)this._invertElevationTextField);
        serializable = new GridBagConstraints(1, 5, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0);
        IntakeGeometryPanel intakeGeometryPanel6 = this;
        intakeGeometryPanel6.add((Component)intakeGeometryPanel6._invertElevationTextField, serializable);
        rmaJLabel = new RmaJLabel("Opens From:");
        serializable = new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 0), 0, 0);
        this.add((Component)rmaJLabel, serializable);
        this._opensFromComboBox = new RmaJComboBox((ComboBoxModel)new RmaListModel(false, (Object[])new IntakeOpening[]{IntakeOpening.Top, IntakeOpening.Bottom, IntakeOpening.Center}));
        this._opensFromComboBox.setModifiable(true);
        rmaJLabel.setLabelFor(this._opensFromComboBox);
        serializable = new GridBagConstraints(1, 6, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0);
        IntakeGeometryPanel intakeGeometryPanel7 = this;
        intakeGeometryPanel7.add((Component)intakeGeometryPanel7._opensFromComboBox, serializable);
        this._circularRadioButton.addActionListener(actionEvent -> this.radioSelectionChanged());
        this._rectangleRadioButton.addActionListener(actionEvent -> this.radioSelectionChanged());
        this._circularRadioButton.setSelected(false);
        this._rectangleRadioButton.setSelected(true);
        serializable = new ButtonGroup();
        ((ButtonGroup)serializable).add((AbstractButton)this._circularRadioButton);
        ((ButtonGroup)serializable).add((AbstractButton)this._rectangleRadioButton);
        this.radioSelectionChanged();
    }

    private void radioSelectionChanged() {
        this._lengthTextField.setEnabled(this._rectangleRadioButton.isSelected());
        this._widthTextField.setEnabled(this._rectangleRadioButton.isSelected());
        this._diameterTextField.setEnabled(!this._rectangleRadioButton.isSelected());
    }

    public void setOpensFromComboBoxEnabled(boolean bl) {
        this._opensFromComboBox.setEnabled(bl);
        this._opensFromComboBox.setSelectedItem((Object)"Top");
    }

    public void clearForm() {
        this._lengthTextField.setText("");
        this._widthTextField.setText("");
        this._diameterTextField.setText("");
        this._invertElevationTextField.setText("");
        this._opensFromComboBox.setSelectedItem((Object)IntakeOpening.Top);
    }

    public void fillForm(IntakeGeometry object) {
        ClientApp.app();
        int n = ClientApp.Workspace().getUnitSystem();
        this._lengthTextField.setValue(new ParamDouble(((IntakeGeometry)object).getRectangularLength(), Parameter.PARAMID_LENGTH, n));
        this._widthTextField.setValue(new ParamDouble(((IntakeGeometry)object).getRectangularWidth(), Parameter.PARAMID_LENGTH, n));
        this._diameterTextField.setValue(new ParamDouble(((IntakeGeometry)object).getCircularDiameter(), Parameter.PARAMID_LENGTH, n));
        this._invertElevationTextField.setValue(new ParamDouble(((IntakeGeometry)object).getInvertElevation(), Parameter.PARAMID_LENGTH, n));
        this._opensFromComboBox.setSelectedItem((Object)((IntakeGeometry)object).getOpening());
        object = ((IntakeGeometry)object).getIntakeOpeningType();
        this._rectangleRadioButton.setSelected(((Enum)object).equals((Object)IntakeOpeningType.Rectangular));
        this._circularRadioButton.setSelected(((Enum)object).equals((Object)IntakeOpeningType.Circular));
        this.radioSelectionChanged();
    }

    public void saveForm(IntakeGeometry intakeGeometry) {
        if (intakeGeometry == null) {
            return;
        }
        intakeGeometry.setRectangularLength(this._lengthTextField.getParamValue().getValue());
        intakeGeometry.setRectangularWidth(this._widthTextField.getParamValue().getValue());
        intakeGeometry.setCircularDiameter(this._diameterTextField.getParamValue().getValue());
        intakeGeometry.setInvertElevation(this._invertElevationTextField.getParamValue().getValue());
        intakeGeometry.setOpening((IntakeOpening)((Object)this._opensFromComboBox.getSelectedItem()));
        intakeGeometry.setIntakeOpeningType(this._rectangleRadioButton.isSelected() ? IntakeOpeningType.Rectangular : IntakeOpeningType.Circular);
    }

    public static void a(String[] object) {
        object = new IntakeGeometryPanel();
        JFrame jFrame = new JFrame();
        jFrame.getContentPane().setLayout(new BorderLayout());
        jFrame.getContentPane().add((Component)object, "Center");
        jFrame.setLocation(250, 250);
        jFrame.pack();
        jFrame.setVisible(true);
    }
}

