/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.clientapp.client.ClientApp;
import hec.data.ParamDouble;
import hec.data.Parameter;
import hec.gfx2d.G2dPanel;
import hec.gfx2d.G2dPanelProp;
import hec.gfx2d.G2dPlotProp;
import hec.gfx2d.HotPlotDefaults;
import hec.gfx2d.PlotDefaults;
import hec.gfx2d.PlotDefaultsManager;
import hec.model.PairedValues;
import hec.model.PairedValuesExt;
import hec.model.PairedValuesExtTableModel;
import hec.model.PairedValuesTableModel;
import hec.rss.RssRmiWorkspace;
import hec.rss.client.GateOpeningsDialog;
import hec.rss.client.IntakeGeometryPanel;
import hec.rss.client.JControllerCardPanel$1;
import hec.rss.client.JControllerCardPanel$2;
import hec.rss.client.JControllerCardPanel$3;
import hec.rss.client.JControllerCardPanel$CapacityExtTableModel;
import hec.rss.client.JControllerCardPanel$CapacityPairedValuesTableModel;
import hec.rss.client.JControllerCardPanel$OutletTableHeaderRender;
import hec.rss.client.PhysicalTreeCardPanel;
import hec.rss.client.PhysicalTreeCardPanel$PhysicalG2dPanel;
import hec.rss.client.RSimTreeNode;
import hec.rss.gfx2d.SimpleJTableData;
import hec.rss.model.AdjustableFlow;
import hec.rss.model.AdjustableParameter;
import hec.rss.model.Dam;
import hec.rss.model.Element;
import hec.rss.model.Function;
import hec.rss.model.IntakeGeometry;
import hec.rss.model.ReservoirElement;
import hec.rss.server.RssAdvancedOptions;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.List;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import rma.swing.RmaGridBagConstraints;
import rma.swing.RmaJDecimalField;
import rma.swing.RmaJIntegerField;
import rma.swing.RmaJLabel;
import rma.swing.RmaJTable;
import rma.swing.event.ReflectMultiListener;
import rma.swing.event.TableChangeListener;
import rma.swing.print.PageText;
import rma.swing.table.ColumnGroup;
import rma.swing.table.GroupableTableHeader;
import rma.util.RMAIO;

public class JControllerCardPanel
extends PhysicalTreeCardPanel
implements CellEditorListener {
    String[] _labels = new String[]{"Elevation\n(%S)", "Max Capacity\n(%S)", "Total Max\nCapacity"};
    String _units = "%S";
    AdjustableFlow _adjustableFlow = null;
    Dam _dam = null;
    RmaJLabel _jRatePanelLabel = new RmaJLabel("Physical Limitations:");
    RmaJLabel _jMaxIncreaseLabel = new RmaJLabel("Max Rate of Increase (%S/hr)");
    RmaJDecimalField _jMaxIncreaseTxt = new JControllerCardPanel$1(this);
    RmaJLabel _jMaxDecreaseLabel = new RmaJLabel("Max Rate of Decrease (%S/hr)");
    RmaJDecimalField _jMaxDecreaseTxt = new RmaJDecimalField();
    RmaJLabel _jNumGatesLabel = new RmaJLabel("Number of Gates of this type");
    RmaJIntegerField _jNumGatesTxt = new RmaJIntegerField();
    RmaJTable _jTableComposite = new RmaJTable((Component)((Object)this));
    PhysicalTreeCardPanel$PhysicalG2dPanel _jCapacityPlot = new PhysicalTreeCardPanel$PhysicalG2dPanel(this, "Release Capacity: ");
    SimpleJTableData _capacityTableData = this.getValuePlotArray();
    IntakeGeometryPanel _intakeGeometryPanel;
    JButton _gateSpecButton = new JButton("Edit Gate Settings");
    JControllerCardPanel$CapacityPairedValuesTableModel _capacityTableModel;
    JControllerCardPanel$CapacityExtTableModel _capacityExtTableModel;
    protected ReflectMultiListener _listener;

    public JControllerCardPanel() {
        this.setLayout(new GridBagLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        JControllerCardPanel jControllerCardPanel = this;
        this._capacityTableModel = new JControllerCardPanel$CapacityPairedValuesTableModel(jControllerCardPanel, jControllerCardPanel._labels, new boolean[]{true, true});
        this._capacityTableModel.setShouldAddBlankRows(true);
        this._jTableComposite.setModel((TableModel)((Object)this._capacityTableModel));
        this._jTableComposite.setUnitsHeaderRenderer();
        this._jTableComposite.setTableHeader((JTableHeader)new GroupableTableHeader(this._jTableComposite.getColumnModel()));
        this._jTableComposite.addTableChangeListener((TableChangeListener)new JControllerCardPanel$2(this));
        this._jTableComposite.setDoubleCellEditor();
        this._jTableComposite.setNumRows(20);
        JControllerCardPanel jControllerCardPanel2 = this;
        jControllerCardPanel2.configurePlotPanel(jControllerCardPanel2._jCapacityPlot);
        Serializable serializable = new Vector<SimpleJTableData>();
        serializable.addElement(this._capacityTableData);
        this._jCapacityPlot.setPlotObjects((List)((Object)serializable));
        serializable = this._jTableComposite.getScrollPane();
        this._intakeGeometryPanel = new IntakeGeometryPanel();
        Insets insets = new Insets(0, 0, 0, 0);
        Insets insets2 = new Insets(0, 0, 5, 0);
        jPanel.add((Component)this._jRatePanelLabel, new RmaGridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, INSETS5505, 0, 0));
        jPanel.add((Component)this._jMaxIncreaseLabel, new RmaGridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, INSETS5505, 0, 0));
        jPanel.add((Component)this._jMaxDecreaseLabel, new RmaGridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, INSETS5505, 0, 0));
        jPanel.add((Component)this._jMaxIncreaseTxt, new RmaGridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 18, 2, insets, 0, 0));
        jPanel.add((Component)this._jMaxDecreaseTxt, new RmaGridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 18, 2, insets, 0, 0));
        JControllerCardPanel jControllerCardPanel3 = this;
        jControllerCardPanel3.add((Component)jControllerCardPanel3._jNumGatesLabel, new RmaGridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, INSETS5505, 0, 0));
        JControllerCardPanel jControllerCardPanel4 = this;
        jControllerCardPanel4.add((Component)jControllerCardPanel4._jNumGatesTxt, new RmaGridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 2, insets, 0, 0));
        this.add((Component)serializable, new RmaGridBagConstraints(0, 1, 2, 2, 1.0, 1.0, 18, 1, INSETS5500, 0, 0));
        this.add(jPanel, new RmaGridBagConstraints(0, 3, 2, 1, 1.0, 0.0, 18, 2, insets2, 0, 0));
        JControllerCardPanel jControllerCardPanel5 = this;
        jControllerCardPanel5.add((Component)((Object)jControllerCardPanel5._jCapacityPlot), new RmaGridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 18, 0, INSETS5505, 120, 120));
        JControllerCardPanel jControllerCardPanel6 = this;
        jControllerCardPanel6.add(jControllerCardPanel6._intakeGeometryPanel, new RmaGridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 11, 0, INSETS5505, 0, 0));
        JControllerCardPanel jControllerCardPanel7 = this;
        jControllerCardPanel7.add(jControllerCardPanel7._gateSpecButton, new RmaGridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 15, 0, INSETS5555, 0, 0));
        this._listener = new ReflectMultiListener();
        this._jTableComposite.addCellEditorListener((CellEditorListener)this);
        JControllerCardPanel jControllerCardPanel8 = this;
        this._gateSpecButton.addActionListener((ActionListener)this._listener.add((Object)jControllerCardPanel8, (Object)jControllerCardPanel8._gateSpecButton, "editGateOpenings"));
        this._jMaxIncreaseLabel.setDisplayedMnemonic('I');
        this._jMaxDecreaseLabel.setDisplayedMnemonic('D');
        this._jMaxIncreaseLabel.setLabelFor((Component)this._jMaxIncreaseTxt);
        this._jMaxDecreaseLabel.setLabelFor((Component)this._jMaxDecreaseTxt);
        this._jNumGatesLabel.setLabelFor((Component)this._jNumGatesTxt);
        this._jNumGatesTxt.getDocument().addDocumentListener(new JControllerCardPanel$3(this));
    }

    public String getTabname() {
        return "Outlet";
    }

    @Override
    public void fillPanel(ReservoirElement object, RSimTreeNode object2) {
        super.fillPanel((ReservoirElement)object, (RSimTreeNode)object2);
        if (object2 == null) {
            return;
        }
        object = ((RSimTreeNode)object2).d();
        if (object == null || !(((Element)object).getFunction() instanceof AdjustableFlow)) {
            return;
        }
        this._adjustableFlow = (AdjustableFlow)((Element)object).getFunction();
        if (this._adjustableFlow == null) {
            return;
        }
        object2 = ((Function)this._adjustableFlow).findAdjParam("Flow");
        if (object2 != null) {
            ParamDouble paramDouble = new ParamDouble();
            ((AdjustableParameter)object2).getMaxRateOfIncrease(paramDouble);
            this._jMaxIncreaseTxt.setValue(paramDouble);
            ((AdjustableParameter)object2).getMaxRateOfDecrease(paramDouble);
            this._jMaxDecreaseTxt.setValue(paramDouble);
            this._jNumGatesTxt.setValue(this._adjustableFlow.getGateCount());
            this.fillCompositeTable();
            ClientApp.app();
            object2 = new String("Workspace: " + ClientApp.Workspace().getTitleName());
            object2 = (String)object2 + "\n ResSim System: " + this._currentReservoir.getSystem().getName();
            object2 = (String)object2 + "\n Reservoir: " + this._currentReservoir.getName();
            object2 = (String)object2 + "\n Controlled Outlets: " + object.getName() + " \n ";
            object = new PageText((String)object2, 0);
            this._jTableComposite.setPrintTitle((PageText)object);
            ClientApp.app();
            object = (RssRmiWorkspace)ClientApp.Workspace().getChildWorkspace("rss");
            try {
                object = object.getRssAdvancedOptions();
                this._intakeGeometryPanel.setVisible(((RssAdvancedOptions)object).hasWaterQuality());
            }
            catch (RemoteException remoteException) {
                object = remoteException;
                remoteException.printStackTrace();
            }
            object = this._adjustableFlow.getIntakeGeometry();
            this._intakeGeometryPanel.fillForm((IntakeGeometry)object);
        }
    }

    private void fillCompositeTable() {
        if (!this._adjustableFlow.hasMultipleGateSettings()) {
            PairedValues pairedValues = this._adjustableFlow.getCapacityValues();
            if (pairedValues != null) {
                this._capacityTableModel.setPairedValues(pairedValues);
                this._jTableComposite.setModel((TableModel)((Object)this._capacityTableModel));
                this._jTableComposite.setAutoResizeMode(2);
                this._jTableComposite.setUnitsHeaderRenderer();
                this._jTableComposite.setDoubleCellEditor();
                GroupableTableHeader groupableTableHeader = (GroupableTableHeader)this._jTableComposite.getTableHeader();
                groupableTableHeader.removeAllColumnGroups();
                this.replot();
            }
            return;
        }
        Object object = this._adjustableFlow.getCapacityValuesBySetting();
        if (object != null) {
            Object object2 = this._adjustableFlow.getGateSettings();
            String[] stringArray = new String[((double[])object2).length + 2];
            boolean[] blArray = new boolean[((double[])object2).length + 2];
            int n = this._adjustableFlow.getGateSettingsParamId();
            int[] nArray = new int[((double[])object2).length + 1];
            for (int i = 0; i < ((double[])object2).length + 1; ++i) {
                stringArray[i] = i == 0 ? "Elevation\n(%S)" : RMAIO.setPrecision2((double)object2[i - 1], (int)2);
                blArray[i] = true;
                nArray[i] = i == 0 ? Parameter.PARAMID_ELEV : n;
            }
            stringArray[stringArray.length - 1] = "Total\nMax Capacity";
            blArray[blArray.length - 1] = false;
            this._capacityExtTableModel = new JControllerCardPanel$CapacityExtTableModel(this, stringArray, (PairedValuesExt)object, blArray);
            this._capacityExtTableModel.setColumnParameters(nArray);
            this._jTableComposite.setModel((TableModel)((Object)this._capacityExtTableModel));
            if (stringArray.length > 3) {
                this._jTableComposite.setAutoResizeMode(0);
            } else {
                this._jTableComposite.setAutoResizeMode(2);
            }
            GroupableTableHeader groupableTableHeader = (GroupableTableHeader)this._jTableComposite.getTableHeader();
            object = this._jTableComposite.getColumnModel();
            object2 = new ColumnGroup((TableCellRenderer)((Object)new JControllerCardPanel$OutletTableHeaderRender(this)), "Max Capacity (%S)\n For Gate Setting (%S)");
            for (int i = 1; i < object.getColumnCount(); ++i) {
                object2.add((Object)object.getColumn(i));
            }
            groupableTableHeader.addColumnGroup((ColumnGroup)object2);
            this._jTableComposite.setUnitsHeaderRenderer();
            this._jTableComposite.setDoubleCellEditor();
            this.calcMaxValues();
            this.replot();
        }
    }

    private void calcMaxValues() {
        int n = this._jTableComposite.getColumnCount();
        int n2 = this._jTableComposite.getRowCount();
        for (int i = 0; i < n2; ++i) {
            this._jTableComposite.getValueAt(i, n - 1);
        }
    }

    public void refresh() {
    }

    @Override
    public boolean savePanel() {
        if (this._adjustableFlow == null) {
            return false;
        }
        Object object = ((Function)this._adjustableFlow).findAdjParam("Flow");
        ((AdjustableParameter)object).setMaxRateOfIncrease(this._jMaxIncreaseTxt.getParamValue());
        ((AdjustableParameter)object).setMaxRateOfDecrease(this._jMaxDecreaseTxt.getParamValue());
        this._adjustableFlow.setGateCount(this._jNumGatesTxt.getTextAsInteger());
        object = this._jTableComposite.getCellEditor();
        if (object != null) {
            object.stopCellEditing();
        }
        if (!this._adjustableFlow.hasMultipleGateSettings()) {
            object = new PairedValues();
            ((PairedValuesTableModel)this._jTableComposite.getModel()).storeData((PairedValues)object);
            if (object.size() > 1 && !object.canInterpX()) {
                JOptionPane.showMessageDialog((Component)((Object)this), "Elevation values must be a continuously increasing sequence.", "Elevation Curve Error", 2);
                return false;
            }
            this._adjustableFlow.setCapacityValues((PairedValues)object);
        } else {
            object = new PairedValuesExt();
            ((PairedValuesExtTableModel)this._jTableComposite.getModel()).storeData((PairedValuesExt)object);
            if (object.size() > 1 && !object.canInterpX()) {
                JOptionPane.showMessageDialog((Component)((Object)this), "Elevation values must be a continuously increasing sequence.", "Elevation Curve Error", 2);
                return false;
            }
            int n = this._jTableComposite.getColumnCount();
            String[] stringArray = new String[n - 1];
            for (int i = 0; i < n - 1; ++i) {
                stringArray[i] = this._jTableComposite.getColumnName(i);
            }
            object.setCurveLabels(stringArray);
            this._adjustableFlow.setCapacityValuesBySetting((PairedValuesExt)object);
        }
        this._intakeGeometryPanel.saveForm(this._adjustableFlow.getIntakeGeometry());
        this.refresh();
        return true;
    }

    SimpleJTableData getValuePlotArray() {
        SimpleJTableData simpleJTableData = new SimpleJTableData();
        new SimpleJTableData().xunits = "Capacity (" + this._units + ")";
        simpleJTableData.yunits = "Elev (" + this._units + ")";
        simpleJTableData.setXAxisType(0);
        simpleJTableData.setData(null, -1, -1);
        return simpleJTableData;
    }

    void configurePlotPanel(G2dPanel g2dPanel) {
        PlotDefaults plotDefaults = PlotDefaultsManager.getDefaults();
        PlotDefaultsManager.setDefaults((PlotDefaults)new HotPlotDefaults());
        G2dPanelProp g2dPanelProp = new G2dPanelProp();
        new G2dPanelProp().hasTitle = false;
        g2dPanelProp.hasToolbar = false;
        g2dPanelProp.hasLegend = false;
        G2dPlotProp g2dPlotProp = new G2dPlotProp();
        new G2dPlotProp().hasXScroll = false;
        g2dPlotProp.hasYScroll = false;
        g2dPlotProp.x1AxisProp.name = "Capacity (" + this._units + ")";
        g2dPlotProp.y1AxisProp.name = "Elev (" + this._units + ")";
        g2dPlotProp.y1AxisProp.isReversed = true;
        g2dPanelProp.addPlotProp(g2dPlotProp);
        g2dPanel.setVisible(false);
        try {
            g2dPanel.configurePanel(g2dPanelProp);
        }
        finally {
            g2dPanel.setVisible(true);
        }
        PlotDefaultsManager.setDefaults((PlotDefaults)plotDefaults);
    }

    @Override
    public void editingCanceled(ChangeEvent changeEvent) {
    }

    @Override
    public void editingStopped(ChangeEvent changeEvent) {
        this.replot();
        int n = ClientApp.app().getClientUnitSystem();
        this._jCapacityPlot.setDisplayUnitsSystem(n);
    }

    public RmaJTable getCapacityTable() {
        return this._jTableComposite;
    }

    public void replot() {
        this.plotCapacity();
    }

    public void clearPanel() {
    }

    private void plotCapacity() {
        this._jCapacityPlot.clearPanel();
        JControllerCardPanel jControllerCardPanel = this;
        jControllerCardPanel.configurePlotPanel(jControllerCardPanel._jCapacityPlot);
        Vector<SimpleJTableData> vector = new Vector<SimpleJTableData>();
        SimpleJTableData simpleJTableData = this.getValuePlotArray();
        int n = this._jTableComposite.getColumnModel().getColumnCount() - 1;
        int[] nArray = new int[n];
        for (int i = 1; i < this._jTableComposite.getColumnModel().getColumnCount(); ++i) {
            nArray[i - 1] = i;
        }
        simpleJTableData.setMultipleColumnData(this._jTableComposite, nArray, new int[]{0});
        vector.addElement(simpleJTableData);
        this._jCapacityPlot.setPlotObjects(vector);
    }

    public void editGateOpenings() {
        if (this._adjustableFlow == null) {
            return;
        }
        GateOpeningsDialog gateOpeningsDialog = new GateOpeningsDialog(this._parent, true);
        gateOpeningsDialog.fillForm(this._adjustableFlow);
        gateOpeningsDialog.setVisible(true);
        if (gateOpeningsDialog.isOk() && gateOpeningsDialog.saveForm()) {
            this.fillCompositeTable();
            this.setModified(true);
        }
    }
}

