/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.data.ParamDouble;
import hec.data.Parameter;
import hec.model.PairedValuesExt;
import hec.rss.client.PairedValuesExtPanel;
import hec.rss.client.PhysicalTreeCardPanel;
import hec.rss.client.RSimTreeNode;
import hec.rss.model.Dam;
import hec.rss.model.Junction;
import hec.rss.model.ReservoirDamElement;
import hec.rss.model.ReservoirElement;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import rma.swing.RmaGridBagConstraints;
import rma.swing.RmaJDecimalField;
import rma.swing.RmaJLabel;
import rma.swing.table.RmaTableModel;
import rma.util.RMAIO;

public class JDamCardPanel
extends PhysicalTreeCardPanel {
    String units = "";
    Dam _dam;
    Junction _junc;
    JPanel _damPanel = new JPanel();
    RmaJLabel elevationLabel;
    RmaJLabel lengthLabel;
    RmaJDecimalField elevationTxt;
    RmaJDecimalField jTxtFieldLength;
    PairedValuesExtPanel _compositeReleasePanel = new PairedValuesExtPanel(new String[]{"Elevation\n(%S)", "Controlled\n(%S)", "Uncontrolled\n(%S)", "Total\n(%S)"}, new String[]{"Elevation\n(%S)", "Flow\n(%S)", "Flow\n(%S)", "Flow\n(%S)"}, new int[]{Parameter.PARAMID_ELEV, Parameter.PARAMID_FLOW, Parameter.PARAMID_FLOW, Parameter.PARAMID_FLOW}, true);

    @Override
    public void createControls() {
        if (((PhysicalTreeCardPanel)this).areControlsCreated()) {
            return;
        }
        this.setLayout(new GridBagLayout());
        this._damPanel.setLayout(new GridBagLayout());
        this.elevationLabel = new RmaJLabel("Elevation at top of dam (%S)");
        this.elevationLabel.setDisplayedMnemonic('p');
        this.lengthLabel = new RmaJLabel("Length at top of dam (%S)");
        this.lengthLabel.setDisplayedMnemonic('L');
        this.elevationTxt = new RmaJDecimalField();
        this.elevationTxt.setPrecision(2);
        this.elevationLabel.setLabelFor((Component)this.elevationTxt);
        this.jTxtFieldLength = new RmaJDecimalField();
        this.jTxtFieldLength.setPrecision(3);
        this.lengthLabel.setLabelFor((Component)this.jTxtFieldLength);
        this._damPanel.add((Component)this.elevationLabel, new RmaGridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, INSETS5500, 0, 0));
        this._damPanel.add((Component)this.lengthLabel, new RmaGridBagConstraints(0, 1, 1, 1, 0.0, 1.0, 18, 0, INSETS5500, 0, 0));
        this._damPanel.add((Component)this.elevationTxt, new RmaGridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 2, INSETS5500, 0, 0));
        this._damPanel.add((Component)this.jTxtFieldLength, new RmaGridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 18, 2, INSETS5500, 0, 0));
        this._damPanel.add((Component)new JPanel(), new RmaGridBagConstraints(2, 0, 1, 2, 0.0, 0.0, 18, 2, INSETS5500, 160, 0));
        JDamCardPanel jDamCardPanel = this;
        jDamCardPanel.add(jDamCardPanel._damPanel, new RmaGridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 2, INSETS5500, 0, 0));
        this._compositeReleasePanel.setBorder(BorderFactory.createTitledBorder("Composite Release Capacity"));
        JDamCardPanel jDamCardPanel2 = this;
        jDamCardPanel2.add(jDamCardPanel2._compositeReleasePanel, new RmaGridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 1, INSETS5500, 0, 0));
        this._compositeReleasePanel.setEnabled(false);
        this._controlsCreated = true;
        this.setModified(false);
    }

    @Override
    public boolean areControlsCreated() {
        return this._controlsCreated;
    }

    public void itemStateChanged(ItemEvent itemEvent) {
    }

    @Override
    public void fillPanel(ReservoirElement reservoirElement, RSimTreeNode object) {
        super.fillPanel(reservoirElement, (RSimTreeNode)object);
        if (!this._controlsCreated) {
            ((PhysicalTreeCardPanel)this).createControls();
        }
        if (object == null) {
            return;
        }
        if ((object = ((RSimTreeNode)object).d()) == null || !(object instanceof ReservoirDamElement)) {
            return;
        }
        this._dam = ((ReservoirDamElement)object).getDamFunction();
        if (this._dam == null) {
            return;
        }
        this._junc = ((ReservoirDamElement)object).getTailwaterFunction();
        if (this._junc == null) {
            return;
        }
        if (this._currentReservoir == null) {
            return;
        }
        String[] stringArray = new ParamDouble();
        this._dam.getTopOfDam((ParamDouble)stringArray);
        this.elevationTxt.setValue((ParamDouble)stringArray);
        this._dam.getWidthOfDam((ParamDouble)stringArray);
        this.jTxtFieldLength.setValue((ParamDouble)stringArray);
        stringArray = new String[]{"Controlled Release Capacity", "Uncontrolled Release Capacity", "Total Release Capacity"};
        this._compositeReleasePanel.setPopupPlotLegendNames(stringArray);
        this._compositeReleasePanel.setPopupPlotTitle("Release Capacity: " + reservoirElement.getName() + "-" + object.getName());
        reservoirElement = ((ReservoirDamElement)object).getCompositeRelease();
        this._compositeReleasePanel.fillForm((PairedValuesExt)reservoirElement);
        this._compositeReleasePanel.setEnabled(false);
        this.setModified(false);
        reservoirElement = this._compositeReleasePanel.getTable();
        int n = Integer.getInteger("Dam.TablePrecision", 2);
        reservoirElement.setPrecision(n);
        RmaTableModel cfr_ignored_0 = (RmaTableModel)reservoirElement.getModel();
    }

    public void clearPanel() {
        this.elevationTxt.setText("");
        this.jTxtFieldLength.setText("");
    }

    @Override
    public boolean savePanel() {
        if (!((PhysicalTreeCardPanel)this).areControlsCreated()) {
            return true;
        }
        new Vector();
        if (this._dam == null || this._junc == null) {
            RMAIO.postError((Component)((Object)this), (String)"Data Error!  NULL Data object");
            return false;
        }
        this._dam.setTopOfDam(this.elevationTxt.getParamValue());
        this._dam.setWidthOfDam(this.jTxtFieldLength.getParamValue());
        return true;
    }
}

