/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.data.ParamDouble;
import hec.data.Parameter;
import hec.gfx2d.G2dPanel;
import hec.gfx2d.G2dPanelProp;
import hec.gfx2d.G2dPlotProp;
import hec.gfx2d.HotPlotDefaults;
import hec.gfx2d.PlotDefaults;
import hec.gfx2d.PlotDefaultsManager;
import hec.gfx2d.SimpleJTableStepData;
import hec.heclib.util.HecTime;
import hec.model.PairedValuesTableModel;
import hec.rss.client.JEvaporationCardPanel$1;
import hec.rss.client.JEvaporationCardPanel$2;
import hec.rss.client.JEvaporationCardPanel$3;
import hec.rss.client.PhysicalTreeCardPanel;
import hec.rss.client.PhysicalTreeCardPanel$PhysicalG2dPanel;
import hec.rss.client.RSimTreeNode;
import hec.rss.model.Element;
import hec.rss.model.ReservoirElement;
import hec.rss.model.Storage;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.event.CellEditorListener;
import javax.swing.table.TableModel;
import rma.swing.RmaGridBagConstraints;
import rma.swing.RmaJRadioButton;
import rma.swing.RmaJTable;
import rma.util.RMAConst;
import rma.util.RMAIO;

public class JEvaporationCardPanel
extends PhysicalTreeCardPanel {
    Storage _storage;
    SimpleJTableStepData _evapData = this.getEvapData();
    RmaJRadioButton avgEvapRadio;
    RmaJRadioButton tsEvapRadio;
    RmaJTable avgEvapTable;
    PhysicalTreeCardPanel$PhysicalG2dPanel avgEvapPlot;

    public JEvaporationCardPanel() {
        JEvaporationCardPanel jEvaporationCardPanel = this;
        jEvaporationCardPanel.buildEvaporationPanel((JPanel)((Object)jEvaporationCardPanel));
    }

    void buildEvaporationPanel(JPanel serializable) {
        ((Container)serializable).setLayout(new GridBagLayout());
        this.avgEvapRadio = new RmaJRadioButton("Monthly Total Evaporation");
        this.avgEvapRadio.setMnemonic('M');
        Object object = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        object.gridy = 0;
        object.gridwidth = 1;
        object.weightx = 1.0;
        object.anchor = 18;
        object.fill = 0;
        object.insets = new Insets(0, 5, 0, 0);
        ((Container)serializable).add((Component)this.avgEvapRadio, object);
        object = new String[]{"Month", "Evap(%S)"};
        Object[][] objectArray = new Object[][]{{"Jan", ""}, {"Feb", ""}, {"Mar", ""}, {"Apr", ""}, {"May", ""}, {"Jun", ""}, {"Jul", ""}, {"Aug", ""}, {"Sep", ""}, {"Oct", ""}, {"Nov", ""}, {"Dec", ""}};
        this.avgEvapTable = new RmaJTable((Component)serializable, objectArray, object);
        this.avgEvapTable.setModel((TableModel)new PairedValuesTableModel((String[])object, new boolean[]{true, true}));
        ((PairedValuesTableModel)this.avgEvapTable.getModel()).setShouldAddBlankRows(false);
        this.avgEvapTable.setPasteAddsRows(false);
        this.avgEvapTable.setColumnEnabled(false, 0);
        this.avgEvapTable.setAddRemoveEnabled(false);
        this.avgEvapTable.setDoubleCellEditor(1);
        this.avgEvapTable.setUnitsHeaderRenderer();
        this.avgEvapTable.clearColors();
        this.avgEvapTable.setColumnBackground(0, Color.lightGray);
        this.avgEvapTable.setHorizontalAlignment(0, 0);
        ((Container)serializable).add(this.avgEvapTable.getScrollPane(), new RmaGridBagConstraints(0, 1, 1, 2, 1.0, 1.0, 18, 1, new Insets(0, 30, 0, 0), 0, 0));
        this.avgEvapPlot = new PhysicalTreeCardPanel$PhysicalG2dPanel(this, "Monthly Evaporation: ");
        ((Container)serializable).add((Component)((Object)this.avgEvapPlot), new RmaGridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 1, INSETS5555, 100, 100));
        JEvaporationCardPanel jEvaporationCardPanel = this;
        jEvaporationCardPanel.configureEvapPlot(jEvaporationCardPanel.avgEvapPlot);
        object = new Vector<SimpleJTableStepData>();
        object.addElement(this._evapData);
        this.avgEvapPlot.setPlotObjects((List)object);
        this.tsEvapRadio = new RmaJRadioButton("Evaporation Time Series");
        this.tsEvapRadio.setMnemonic('S');
        ((Container)serializable).add((Component)this.tsEvapRadio, new RmaGridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        serializable = new ButtonGroup();
        ((ButtonGroup)serializable).add((AbstractButton)this.avgEvapRadio);
        ((ButtonGroup)serializable).add((AbstractButton)this.tsEvapRadio);
        this.avgEvapRadio.addActionListener((ActionListener)new JEvaporationCardPanel$1(this));
        this.tsEvapRadio.addActionListener((ActionListener)new JEvaporationCardPanel$2(this));
        this.avgEvapTable.addCellEditorListener((CellEditorListener)new JEvaporationCardPanel$3(this));
        this.avgEvapRadio.setModifiable(false);
        this.avgEvapRadio.doClick();
        this.avgEvapRadio.setModifiable(true);
        this._controlsCreated = true;
        this.setModified(false);
    }

    private void configureEvapPlot(G2dPanel g2dPanel) {
        PlotDefaults plotDefaults = PlotDefaultsManager.getDefaults();
        PlotDefaultsManager.setDefaults((PlotDefaults)new HotPlotDefaults());
        G2dPanelProp g2dPanelProp = new G2dPanelProp();
        new G2dPanelProp().hasTitle = false;
        g2dPanelProp.hasToolbar = false;
        g2dPanelProp.hasLegend = false;
        G2dPlotProp g2dPlotProp = new G2dPlotProp();
        new G2dPlotProp().hasXScroll = false;
        g2dPlotProp.hasYScroll = false;
        g2dPlotProp.x1AxisProp.name = "Minutes";
        g2dPlotProp.x1AxisProp.type = 1;
        g2dPlotProp.y1AxisProp.name = "Evap(%S)";
        g2dPlotProp.x1AxisProp.numTicLabelLayers = 1;
        g2dPlotProp.hasX1Label = false;
        g2dPlotProp.y1AxisProp.isReversed = true;
        g2dPlotProp.x1AxisProp.isDefaultLimits = false;
        HecTime hecTime = new HecTime("01 January");
        g2dPlotProp.x1AxisProp.min = hecTime.value();
        hecTime = new HecTime("31 December");
        g2dPlotProp.x1AxisProp.max = hecTime.value();
        g2dPanelProp.addPlotProp(g2dPlotProp);
        g2dPanel.configurePanel(g2dPanelProp);
        PlotDefaultsManager.setDefaults((PlotDefaults)plotDefaults);
    }

    @Override
    public void fillPanel(ReservoirElement object, RSimTreeNode rSimTreeNode) {
        super.fillPanel((ReservoirElement)object, rSimTreeNode);
        if (!this._controlsCreated) {
            this.createControls();
        }
        if (rSimTreeNode == null) {
            return;
        }
        object = rSimTreeNode.d();
        if (object == null) {
            return;
        }
        if (!(((Element)object).getFunction() instanceof Storage)) {
            return;
        }
        this._storage = (Storage)((Element)object).getFunction();
        if (this._currentReservoir == null) {
            return;
        }
        this.setIgnoreModifiedEvents(true);
        this.avgEvapTable.commitEdit(true);
        object = new Object[][]{{"Jan", ""}, {"Feb", ""}, {"Mar", ""}, {"Apr", ""}, {"May", ""}, {"Jun", ""}, {"Jul", ""}, {"Aug", ""}, {"Sep", ""}, {"Oct", ""}, {"Nov", ""}, {"Dec", ""}};
        this.avgEvapTable.setCells((Object[][])object);
        this.avgEvapTable.setNumRows(12);
        if (this._storage.getEvapType() == 0) {
            this.avgEvapRadio.setModifiable(false);
            this.avgEvapRadio.doClick(0);
            this.avgEvapRadio.setModifiable(true);
            object = this._storage.getMonthlyEvap();
            new ParamDouble();
            if (object != null) {
                for (int i = 0; i < ((Object)object).length; ++i) {
                    if (!RMAConst.isUndefinedValue((double)object[i])) {
                        this.avgEvapTable.setCell((Object)new ParamDouble((double)object[i], Parameter.PARAMID_EVAP, this._storage.getUnitSystem(), 2), i, 1);
                        continue;
                    }
                    this.avgEvapTable.setCell((Object)new ParamDouble(0.0, Parameter.PARAMID_EVAP, this._storage.getUnitSystem(), 1), i, 1);
                }
                this.evapReplot();
            }
        } else {
            this.tsEvapRadio.setModifiable(false);
            this.tsEvapRadio.doClick(0);
            this.tsEvapRadio.setModifiable(true);
            for (int i = 0; i < this.avgEvapTable.getNumRows(); ++i) {
                this.avgEvapTable.setCell((Object)new ParamDouble(0.0, Parameter.PARAMID_EVAP, this._storage.getUnitSystem(), 1), i, 1);
            }
        }
        this.evapReplot();
        this.setIgnoreModifiedEvents(false);
    }

    @Override
    public boolean savePanel() {
        if (!this.areControlsCreated()) {
            return true;
        }
        if (this._storage == null || this._currentReservoir == null) {
            return false;
        }
        this.avgEvapTable.commitEdit(true);
        if (this.avgEvapRadio.isSelected()) {
            this._storage.setEvapType(0);
            Vector vector = this.avgEvapTable.getCells();
            double[] dArray = new double[12];
            for (int i = 0; i < dArray.length && i < vector.size(); ++i) {
                if (vector.elementAt(i) == null || ((Vector)vector.elementAt(i)).size() < 2) continue;
                Object e = ((Vector)vector.elementAt(i)).elementAt(1);
                dArray[i] = RMAIO.parseDouble((String)e.toString());
            }
            this._storage.setMonthlyEvap(dArray);
            this._storage.setEvapType(0);
        } else {
            this._storage.setEvapType(1);
        }
        return true;
    }

    private void evapReplot() {
        this._evapData.clearData();
        this._evapData.name = "Evaporation";
        this._evapData.setData(this.avgEvapTable, 0, 1);
    }

    private SimpleJTableStepData getEvapData() {
        SimpleJTableStepData simpleJTableStepData = new SimpleJTableStepData();
        new SimpleJTableStepData().xunits = "Minutes";
        simpleJTableStepData.yunits = "Evap(%S)";
        simpleJTableStepData.setXAxisType(1);
        simpleJTableStepData.setYParameterId(Parameter.PARAMID_EVAP);
        simpleJTableStepData.setData(null, -1, -1);
        return simpleJTableStepData;
    }
}

