/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.clientapp.client.ClientApp;
import hec.data.ParamDouble;
import hec.data.Parameter;
import hec.gfx2d.G2dPanel;
import hec.gfx2d.G2dPanelProp;
import hec.gfx2d.G2dPlotProp;
import hec.gfx2d.HotPlotDefaults;
import hec.gfx2d.PlotDefaults;
import hec.gfx2d.PlotDefaultsManager;
import hec.gfx2d.SimpleJTableStepData;
import hec.gfx2d.SimpleSeasonalData;
import hec.gui.NameDescriptionPanel;
import hec.model.SeasonalRecord;
import hec.model.SeasonalRecordTableModel;
import hec.rss.client.DayOfWeekMultiplierJDialog;
import hec.rss.client.JFirmEnergyRulePanel$1;
import hec.rss.client.JFirmEnergyRulePanel$2;
import hec.rss.client.JFirmEnergyRulePanel$3;
import hec.rss.client.JFirmEnergyRulePanel$4;
import hec.rss.client.JFirmEnergyRulePanel$MyG2dPanel;
import hec.rss.client.JOperationsPanel;
import hec.rss.client.PowerGenerationDialog;
import hec.rss.client.PowerGenerationReqDlg;
import hec.rss.client.ReservoirJFrame;
import hec.rss.client.TimeOfDayMultiplierJDialog;
import hec.rss.model.DayOfWeekMultiplier;
import hec.rss.model.FirmEnergyOpRule;
import hec.rss.model.OpRule;
import hec.rss.model.OpRuleRef;
import hec.rss.model.PowerGenerationOptions;
import hec.rss.model.ScheduledHydropowerOpRule;
import hec.rss.model.TimeOfDayMultiplier;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemListener;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.EventObject;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableModel;
import javax.swing.text.Document;
import rma.swing.DefaultJPanel;
import rma.swing.RmaGridBagConstraints;
import rma.swing.RmaInsets;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJDialog;
import rma.swing.RmaJTable;
import rma.swing.event.TableChangeListener;
import rma.swing.event.TableUpdateEvent;
import rma.swing.table.RmaTableModel;
import rma.swing.text.DssPathnamePartDocument;
import rma.util.RMAConst;
import rma.util.RMAIO;

public class JFirmEnergyRulePanel
extends DefaultJPanel
implements FocusListener,
ItemListener,
CellEditorListener,
TableChangeListener {
    RmaJTable _monthlyTable;
    RmaJTable _seasonalTable;
    JFirmEnergyRulePanel$MyG2dPanel _monthlyPlot;
    SimpleJTableStepData _firmEnergyData;
    SimpleSeasonalData m_seasonalPlotData;
    JLabel _firmEnergyRuleLabel = new JLabel("Hydropower - Schedule Rule:");
    NameDescriptionPanel jNameDescPanel = new NameDescriptionPanel(8L);
    OpRuleRef _currentRuleRef = null;
    DefaultJPanel _parent = null;
    RmaJComboBox _firmEnergyRequirementCombo;
    String _oldRuleName = "";
    JPanel _cardPanel = new JPanel(new CardLayout());
    JPanel _notePanel = new JPanel();
    String _currentCard = "";
    double[] _plantFacData;
    double[] _dailyTotalData;
    double[] _weeklyTotalData;
    double[] _monthlyTotalData;
    double[][] _tableData = new double[][]{this._plantFacData, this._dailyTotalData, this._weeklyTotalData, this._monthlyTotalData};
    MessageFormat m_labelFormat = new MessageFormat("{0} Total\n(MWh)");
    SeasonalRecordTableModel m_seasonalTableModel = new SeasonalRecordTableModel(new String[]{" \nDate", this.m_labelFormat.format(new String[]{"Weekly"})}, new boolean[]{true, true});
    private static final String a = new String("MWH");
    private static final String b = new String("Plant Factor");
    private String _firm_choice = new String(a);
    private Object[][] _data = new Object[][]{{"Jan", ""}, {"Feb", ""}, {"Mar", ""}, {"Apr", ""}, {"May", ""}, {"Jun", ""}, {"Jul", ""}, {"Aug", ""}, {"Sep", ""}, {"Oct", ""}, {"Nov", ""}, {"Dec", ""}};

    public JFirmEnergyRulePanel() {
        this.createPanel();
    }

    public void createPanel() {
        this.setLayout(new GridBagLayout());
        new RmaGridBagConstraints();
        Serializable serializable = new JPanel(new GridBagLayout());
        RmaGridBagConstraints rmaGridBagConstraints = new RmaGridBagConstraints();
        new RmaGridBagConstraints().gridx = 0;
        rmaGridBagConstraints.gridy = 0;
        rmaGridBagConstraints.gridwidth = 3;
        rmaGridBagConstraints.gridheight = 1;
        rmaGridBagConstraints.weightx = 0.0;
        rmaGridBagConstraints.weighty = 0.0;
        rmaGridBagConstraints.fill = 1;
        rmaGridBagConstraints.anchor = 18;
        rmaGridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)5, (int)5);
        this.add((Component)serializable, rmaGridBagConstraints);
        this.jNameDescPanel.setNameEditable(false);
        this.jNameDescPanel.setNameDocument((Document)new DssPathnamePartDocument());
        this.jNameDescPanel.setNameLabel(this._firmEnergyRuleLabel.getText());
        rmaGridBagConstraints = new RmaGridBagConstraints();
        new RmaGridBagConstraints().gridx = 0;
        rmaGridBagConstraints.gridy = 0;
        rmaGridBagConstraints.gridwidth = 1;
        rmaGridBagConstraints.gridheight = 1;
        rmaGridBagConstraints.weightx = 0.0;
        rmaGridBagConstraints.weighty = 0.0;
        rmaGridBagConstraints.insets = RmaInsets.insets((int)5, (int)0, (int)0, (int)0);
        rmaGridBagConstraints.anchor = 18;
        ((Container)serializable).add((Component)this.jNameDescPanel, rmaGridBagConstraints);
        rmaGridBagConstraints = new RmaGridBagConstraints();
        new RmaGridBagConstraints().gridx = 2;
        rmaGridBagConstraints.gridy = 0;
        rmaGridBagConstraints.gridwidth = 2;
        rmaGridBagConstraints.weightx = 1.0;
        rmaGridBagConstraints.weighty = 0.0;
        rmaGridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        rmaGridBagConstraints.anchor = 18;
        rmaGridBagConstraints.fill = 2;
        ((Container)serializable).add(new JLabel(), rmaGridBagConstraints);
        serializable = new JLabel("Power Generation Requirement");
        rmaGridBagConstraints = new RmaGridBagConstraints();
        new RmaGridBagConstraints().gridx = 0;
        rmaGridBagConstraints.gridy = 1;
        rmaGridBagConstraints.weightx = 0.0;
        rmaGridBagConstraints.weighty = 0.0;
        rmaGridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        rmaGridBagConstraints.anchor = 18;
        this.add((Component)serializable, rmaGridBagConstraints);
        serializable = new JButton("Options...");
        rmaGridBagConstraints.set(1, 1, 1, 1, 1.0, 0.0, 18, 0, RmaInsets.INSETS5505, 0, 0);
        this.add((Component)serializable, rmaGridBagConstraints);
        ((AbstractButton)serializable).addActionListener(new JFirmEnergyRulePanel$1(this));
        rmaGridBagConstraints = new RmaGridBagConstraints();
        new RmaGridBagConstraints().gridx = 0;
        rmaGridBagConstraints.gridy = 2;
        rmaGridBagConstraints.gridwidth = 2;
        rmaGridBagConstraints.gridheight = 5;
        rmaGridBagConstraints.weightx = 1.0;
        rmaGridBagConstraints.weighty = 1.0;
        rmaGridBagConstraints.anchor = 18;
        rmaGridBagConstraints.fill = 1;
        rmaGridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)5, (int)5);
        JFirmEnergyRulePanel jFirmEnergyRulePanel = this;
        jFirmEnergyRulePanel.add(jFirmEnergyRulePanel._cardPanel, rmaGridBagConstraints);
        rmaGridBagConstraints = new String[]{" \nMonth", this._firm_choice};
        JFirmEnergyRulePanel jFirmEnergyRulePanel2 = this;
        this._monthlyTable = new RmaJTable((Component)((Object)jFirmEnergyRulePanel2), jFirmEnergyRulePanel2._data, (Object[])rmaGridBagConstraints);
        this._monthlyTable.setColumnEnabled(false, 0);
        this._monthlyTable.setAddRemoveEnabled(false);
        this._monthlyTable.setDoubleCellEditor(1);
        this._monthlyTable.setUnitsHeaderRenderer();
        this._monthlyTable.clearColors();
        this._monthlyTable.setHorizontalAlignment(0, 0);
        this._cardPanel.setSize(this._monthlyTable.getWidth(), this._monthlyTable.getHeight());
        rmaGridBagConstraints = this._monthlyTable.getPreferredSize();
        this._monthlyTable.setPreferredScrollableViewportSize(new Dimension(250, rmaGridBagConstraints.height));
        this._cardPanel.add((Component)new JScrollPane((Component)this._monthlyTable), "Monthly");
        serializable = new SeasonalRecord();
        serializable.setUnitSystem(ClientApp.Workspace().getUnitSystem());
        this.m_seasonalTableModel.setSeasonalRecord((SeasonalRecord)serializable, "01JAN");
        this._seasonalTable = new RmaJTable((Component)((Object)this));
        this._seasonalTable.addCellEditorListener((CellEditorListener)new JFirmEnergyRulePanel$2(this));
        this._seasonalTable.setPreferredScrollableViewportSize(new Dimension(250, rmaGridBagConstraints.height));
        this._seasonalTable.setModel((TableModel)this.m_seasonalTableModel);
        this._seasonalTable.setMlHeaderRenderer();
        this._seasonalTable.setDoubleCellEditor(1);
        this._seasonalTable.setDateCellEditor(0, "DDMMM");
        this._seasonalTable.setCellEnabled(false, 0, 0);
        this._seasonalTable.setAddRemoveEnabled(false);
        this._seasonalTable.addCellEditorListener((CellEditorListener)this);
        this._seasonalTable.addTableChangeListener((TableChangeListener)this);
        this._cardPanel.add((Component)new JScrollPane((Component)this._seasonalTable), "Seasonal");
        serializable = new JLabel("*Note: Plant Factors should be entered in terms of decimal fractions (e.g., 0.25).");
        rmaGridBagConstraints = new RmaGridBagConstraints();
        new RmaGridBagConstraints().gridx = 0;
        rmaGridBagConstraints.gridy = 0;
        rmaGridBagConstraints.weightx = 0.0;
        rmaGridBagConstraints.weighty = 1.0;
        rmaGridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        rmaGridBagConstraints.anchor = 18;
        this._notePanel.add((Component)serializable, rmaGridBagConstraints);
        rmaGridBagConstraints = new RmaGridBagConstraints();
        new RmaGridBagConstraints().gridx = 0;
        rmaGridBagConstraints.gridy = 7;
        rmaGridBagConstraints.gridwidth = 3;
        rmaGridBagConstraints.gridheight = 1;
        rmaGridBagConstraints.weightx = 0.0;
        rmaGridBagConstraints.weighty = 1.0;
        rmaGridBagConstraints.insets = RmaInsets.insets((int)5, (int)0, (int)5, (int)5);
        rmaGridBagConstraints.anchor = 11;
        rmaGridBagConstraints.fill = 1;
        JFirmEnergyRulePanel jFirmEnergyRulePanel3 = this;
        jFirmEnergyRulePanel3.add(jFirmEnergyRulePanel3._notePanel, rmaGridBagConstraints);
        ((CardLayout)this._cardPanel.getLayout()).show(this._cardPanel, "Monthly");
        this._currentCard = "Monthly";
        this._monthlyTable.addCellEditorListener((CellEditorListener)new JFirmEnergyRulePanel$3(this));
        rmaGridBagConstraints = new RmaGridBagConstraints();
        this._monthlyPlot = new JFirmEnergyRulePanel$MyG2dPanel(this);
        rmaGridBagConstraints.gridx = 2;
        rmaGridBagConstraints.gridy = 1;
        rmaGridBagConstraints.gridwidth = 2;
        rmaGridBagConstraints.gridheight = 2;
        rmaGridBagConstraints.weightx = 0.0;
        rmaGridBagConstraints.weighty = 0.0;
        rmaGridBagConstraints.fill = 0;
        rmaGridBagConstraints.ipadx = 100;
        rmaGridBagConstraints.ipady = 100;
        rmaGridBagConstraints.anchor = 18;
        rmaGridBagConstraints.insets = RmaInsets.insets((int)0, (int)0, (int)0, (int)0);
        JFirmEnergyRulePanel jFirmEnergyRulePanel4 = this;
        jFirmEnergyRulePanel4.add((Component)((Object)jFirmEnergyRulePanel4._monthlyPlot), rmaGridBagConstraints);
        JFirmEnergyRulePanel jFirmEnergyRulePanel5 = this;
        jFirmEnergyRulePanel5.configureMonthlyPlot(jFirmEnergyRulePanel5._monthlyPlot);
        this._firmEnergyData = this.getMonthlyData();
        this.m_seasonalPlotData = this.getSeasonalPlotData();
        serializable = new Vector<SimpleJTableStepData>();
        ((Vector)serializable).addElement(this._firmEnergyData);
        this._monthlyPlot.setPlotObjects((List)((Object)serializable));
        serializable = new JButton("Power Generation Pattern...");
        rmaGridBagConstraints.set(2, 3, 1, 1, 0.0, 0.0, 11, 11, RmaInsets.INSETS5505, 0, 0);
        this.add((Component)serializable, rmaGridBagConstraints);
        ((AbstractButton)serializable).addActionListener(new JFirmEnergyRulePanel$4(this));
    }

    public void tableDataChanged(TableUpdateEvent tableUpdateEvent) {
        this._monthlyTable.commitEdit(true);
        this._seasonalTable.commitEdit(true);
        if (tableUpdateEvent.getChangeReason() == TableUpdateEvent.PASTE || tableUpdateEvent.getChangeReason() == TableUpdateEvent.CUT) {
            this.monthlyReplot();
        }
    }

    protected void showGenerationPatternDlg() {
        Window window = SwingUtilities.windowForComponent((Component)((Object)this));
        PowerGenerationDialog powerGenerationDialog = window instanceof JFrame ? new PowerGenerationDialog((JFrame)window, "Power Generation Pattern", true) : new PowerGenerationDialog((JDialog)window, "Power Generation Pattern", true);
        powerGenerationDialog.pack();
        powerGenerationDialog.setLocationRelativeTo(window);
        powerGenerationDialog.fillPanel(((FirmEnergyOpRule)this._currentRuleRef.getRule()).getPowerPatternContainer());
        powerGenerationDialog.setVisible(true);
        if (powerGenerationDialog.isCanceled()) {
            return;
        }
        this.setModified(powerGenerationDialog.isModified());
    }

    protected void showSystemGenerationReqDialog() {
        Serializable serializable = SwingUtilities.windowForComponent((Component)((Object)this));
        PowerGenerationReqDlg powerGenerationReqDlg = serializable instanceof JFrame ? new PowerGenerationReqDlg((JFrame)serializable, "Power Generation Requirement", true) : new PowerGenerationReqDlg((JDialog)serializable, "Power Generation Requirement", true);
        powerGenerationReqDlg.pack();
        powerGenerationReqDlg.setLocationRelativeTo((Component)serializable);
        serializable = (FirmEnergyOpRule)this._currentRuleRef.getRule();
        int n = ((ScheduledHydropowerOpRule)serializable).getPowerReqSpecification();
        this.saveMonthlyTable((FirmEnergyOpRule)serializable);
        powerGenerationReqDlg.setHydropowerRule((PowerGenerationOptions)((Object)serializable));
        powerGenerationReqDlg.fillPanel();
        powerGenerationReqDlg.setVisible(true);
        if (powerGenerationReqDlg.isCanceled()) {
            return;
        }
        this._firm_choice = ((ScheduledHydropowerOpRule)serializable).getPowerReqSpecification() == 10 ? b : a;
        if (((ScheduledHydropowerOpRule)serializable).getPowerReqSpecification() != n) {
            this.setMonthlyTable((FirmEnergyOpRule)serializable);
        }
        this.setTableColumnLabel(((ScheduledHydropowerOpRule)serializable).getPowerReqSpecification());
        if (((ScheduledHydropowerOpRule)serializable).getRequirementVariation() == 0) {
            ((CardLayout)this._cardPanel.getLayout()).show(this._cardPanel, "Monthly");
            this._currentCard = "Monthly";
        } else {
            ((CardLayout)this._cardPanel.getLayout()).show(this._cardPanel, "Seasonal");
            this._currentCard = "Seasonal";
        }
        this.monthlyReplot();
        this.setModified(true);
    }

    protected void setTableColumnLabel(int n) {
        String string = null;
        String string2 = null;
        boolean bl = false;
        if (n == 10) {
            string = " \nPlant Factor - Monthly Total*";
            string2 = " \nPlant Factor - Season Total*";
            bl = true;
            this._notePanel.setVisible(true);
        } else if (n == 11) {
            string = this.m_labelFormat.format(new String[]{"Daily"});
            this._notePanel.setVisible(false);
        } else if (n == 13) {
            string = this.m_labelFormat.format(new String[]{"Monthly"});
            this._notePanel.setVisible(false);
        } else if (n == 12) {
            string = this.m_labelFormat.format(new String[]{"Weekly"});
            this._notePanel.setVisible(false);
        } else if (n == 14) {
            string = this.m_labelFormat.format(new String[]{"Seasonal"});
            this._notePanel.setVisible(false);
        }
        if (bl) {
            ((RmaTableModel)this._monthlyTable.getModel()).setColumnName(1, string);
            this.m_seasonalTableModel.setColumnName(1, string2);
            this._monthlyTable.getColumnModel().getColumn(1).setHeaderValue(string);
            this._seasonalTable.getColumnModel().getColumn(1).setHeaderValue(string2);
        } else {
            ((RmaTableModel)this._monthlyTable.getModel()).setColumnName(1, string);
            this.m_seasonalTableModel.setColumnName(1, string);
            this._monthlyTable.getColumnModel().getColumn(1).setHeaderValue(string);
            this._seasonalTable.getColumnModel().getColumn(1).setHeaderValue(string);
        }
        this._monthlyTable.getTableHeader().revalidate();
        this._seasonalTable.getTableHeader().revalidate();
        this._monthlyTable.getTableHeader().repaint();
        this._seasonalTable.getTableHeader().repaint();
    }

    public void fillPanel() {
        if (this._currentRuleRef == null) {
            return;
        }
        this.clearPanel();
        Serializable serializable = (FirmEnergyOpRule)this._currentRuleRef.getRule();
        this._oldRuleName = serializable.getName();
        this.jNameDescPanel.setName(serializable.getName());
        this.jNameDescPanel.setDescription(serializable.getDescription());
        if (serializable.getPowerReqSpecification() == 10) {
            this._firm_choice = b;
            this._notePanel.setVisible(true);
        }
        if (serializable.getRequirementVariation() == 0) {
            ((CardLayout)this._cardPanel.getLayout()).show(this._cardPanel, "Monthly");
            this._currentCard = "Monthly";
        } else {
            ((CardLayout)this._cardPanel.getLayout()).show(this._cardPanel, "Seasonal");
            this._currentCard = "Seasonal";
        }
        this.initMonthlyTables((FirmEnergyOpRule)serializable);
        SeasonalRecord seasonalRecord = serializable.getSeasonalPowerRequirement();
        ((SeasonalRecordTableModel)this._seasonalTable.getModel()).setSeasonalRecord(seasonalRecord, "01JAN");
        this.setTableColumnLabel(serializable.getPowerReqSpecification());
        serializable = SwingUtilities.windowForComponent((Component)((Object)this));
        ((RmaJDialog)serializable).updateUnitSystem((Container)((Object)this));
        this.setModified(false);
        this.monthlyReplot();
    }

    private void saveMonthlyTable(FirmEnergyOpRule firmEnergyOpRule) {
        int n;
        this._monthlyTable.commitEdit(true);
        double[] dArray = new double[12];
        for (n = 0; n < 12; ++n) {
            dArray[n] = RMAIO.parseDouble((Object)this._monthlyTable.getCell(n, 1));
        }
        n = firmEnergyOpRule.getPowerReqSpecification();
        switch (n) {
            case 10: {
                this._tableData[0] = dArray;
                return;
            }
            case 11: {
                this._tableData[1] = dArray;
                return;
            }
            case 12: {
                this._tableData[2] = dArray;
                return;
            }
            case 13: {
                this._tableData[3] = dArray;
            }
        }
    }

    private void initMonthlyTables(FirmEnergyOpRule firmEnergyOpRule) {
        Object object = new double[12];
        for (int i = 0; i < this._tableData.length; ++i) {
            this._tableData[i] = object;
        }
        double[] dArray = firmEnergyOpRule.getMonthlyEnergyRequirements();
        int n = firmEnergyOpRule.getPowerReqSpecification();
        switch (n) {
            case 10: {
                this._tableData[0] = dArray;
                break;
            }
            case 11: {
                this._tableData[1] = dArray;
                break;
            }
            case 12: {
                this._tableData[2] = dArray;
                break;
            }
            case 13: {
                this._tableData[3] = dArray;
            }
        }
        n = this._currentRuleRef.getRule().getUnitSystem();
        this._monthlyTable.commitEdit(true);
        for (int i = 0; i < 12; ++i) {
            this._monthlyTable.setCell(this._data[i][0], i, 0);
            object = new ParamDouble(dArray[i], -1, n);
            this._monthlyTable.setCell(object, i, 1);
        }
    }

    private void setMonthlyTable(FirmEnergyOpRule firmEnergyOpRule) {
        this._monthlyTable.commitEdit(true);
        int n = firmEnergyOpRule.getUnitSystem();
        double[] dArray = new double[12];
        int n2 = firmEnergyOpRule.getPowerReqSpecification();
        switch (n2) {
            case 10: {
                dArray = this._tableData[0];
                break;
            }
            case 11: {
                dArray = this._tableData[1];
                break;
            }
            case 12: {
                dArray = this._tableData[2];
                break;
            }
            case 13: {
                dArray = this._tableData[3];
            }
        }
        for (int i = 0; i < 12; ++i) {
            this._monthlyTable.setCell(this._data[i][0], i, 0);
            ParamDouble paramDouble = new ParamDouble(dArray[i], -1, n);
            this._monthlyTable.setCell((Object)paramDouble, i, 1);
        }
    }

    public boolean savePanel() {
        if (this._currentRuleRef == null) {
            return false;
        }
        if (this.jNameDescPanel.getName().equals("")) {
            RMAIO.postError((Component)((Object)this), (String)"Cannot have an empty rule name!");
            return false;
        }
        FirmEnergyOpRule firmEnergyOpRule = (FirmEnergyOpRule)this._currentRuleRef.getRule();
        if (firmEnergyOpRule == null) {
            return false;
        }
        this._currentRuleRef.getRule().setName(this.jNameDescPanel.getName());
        this._currentRuleRef.setName(this.jNameDescPanel.getName());
        this._oldRuleName = this.jNameDescPanel.getName();
        firmEnergyOpRule.setDescription(this.jNameDescPanel.getDescription());
        this._monthlyTable.commitEdit(true);
        double[] dArray = new double[12];
        for (int i = 0; i < 12; ++i) {
            dArray[i] = RMAIO.parseDouble((Object)this._monthlyTable.getCell(i, 1));
        }
        firmEnergyOpRule.setMonthlyEnergyRequirements(dArray);
        this._seasonalTable.commitEdit(true);
        SeasonalRecord seasonalRecord = new SeasonalRecord();
        ((SeasonalRecordTableModel)this._seasonalTable.getModel()).storeData(seasonalRecord);
        firmEnergyOpRule.setSeasonalPowerRequirement(seasonalRecord);
        if (this._firm_choice.equals(b)) {
            firmEnergyOpRule.setUsePlantFactor(true);
        } else {
            firmEnergyOpRule.setUsePlantFactor(false);
        }
        firmEnergyOpRule.setModified(true);
        this.setModified(false);
        return true;
    }

    private void convertTable(String string, String object) {
        if (string.equals(object)) {
            return;
        }
        if (this._currentRuleRef == null) {
            return;
        }
        this._monthlyTable.commitEdit(true);
        object = (FirmEnergyOpRule)this._currentRuleRef.getRule();
        int n = ((OpRule)object).getUnitSystem();
        for (int i = 0; i < 12; ++i) {
            ParamDouble paramDouble;
            double d = ((ScheduledHydropowerOpRule)object).getMonthlyEnergyCapacity(i);
            double d2 = RMAIO.parseDouble((Object)this._monthlyTable.getCell(i, 1));
            if (!RMAConst.isValidValue((double)d2) || !RMAConst.isValidValue((double)d)) {
                paramDouble = new ParamDouble(Double.NEGATIVE_INFINITY, -1, n);
            } else {
                double d3 = string.equals(a) ? d / 100.0 : 100.0 / d;
                paramDouble = new ParamDouble(d2 * d3, -1, n);
            }
            this._monthlyTable.setCell((Object)paramDouble, i, 1);
        }
    }

    private SimpleJTableStepData getMonthlyData() {
        SimpleJTableStepData simpleJTableStepData = new SimpleJTableStepData();
        new SimpleJTableStepData().xunits = "minutes";
        simpleJTableStepData.yunits = this._firm_choice;
        simpleJTableStepData.setXAxisType(1);
        simpleJTableStepData.setYParameterId(Parameter.PARAMID_ENERGY);
        simpleJTableStepData.setData(this._monthlyTable, -1, -1);
        return simpleJTableStepData;
    }

    private SimpleSeasonalData getSeasonalPlotData() {
        SimpleSeasonalData simpleSeasonalData = new SimpleSeasonalData();
        new SimpleSeasonalData().xunits = "minutes";
        simpleSeasonalData.yunits = this._firm_choice;
        simpleSeasonalData.setYParameterId(Parameter.PARAMID_ENERGY);
        return simpleSeasonalData;
    }

    private void configureMonthlyPlot(G2dPanel g2dPanel) {
        PlotDefaults plotDefaults = PlotDefaultsManager.getDefaults();
        PlotDefaultsManager.setDefaults((PlotDefaults)new HotPlotDefaults());
        G2dPanelProp g2dPanelProp = new G2dPanelProp();
        new G2dPanelProp().hasTitle = false;
        g2dPanelProp.hasToolbar = false;
        g2dPanelProp.hasLegend = false;
        G2dPlotProp g2dPlotProp = new G2dPlotProp();
        new G2dPlotProp().hasXScroll = false;
        g2dPlotProp.hasYScroll = false;
        g2dPlotProp.x1AxisProp.name = "minutes";
        g2dPlotProp.x1AxisProp.type = 1;
        g2dPlotProp.y1AxisProp.name = this._firm_choice;
        g2dPlotProp.x1AxisProp.numTicLabelLayers = 1;
        g2dPlotProp.hasX1Label = false;
        g2dPlotProp.y1AxisProp.isReversed = true;
        g2dPlotProp.x1AxisProp.isDefaultLimits = false;
        g2dPanelProp.addPlotProp(g2dPlotProp);
        g2dPanel.configurePanel(g2dPanelProp);
        PlotDefaultsManager.setDefaults((PlotDefaults)plotDefaults);
    }

    public void editHourOfDayMultiplier() {
        boolean bl;
        Object object = SwingUtilities.windowForComponent((Component)((Object)this));
        if (!(object instanceof ReservoirJFrame)) {
            return;
        }
        Object object2 = "Hour of Day Weighting";
        object = new TimeOfDayMultiplierJDialog((Dialog)object, (String)object2, true);
        object2 = this._currentRuleRef.getRule();
        TimeOfDayMultiplier timeOfDayMultiplier = ((OpRule)object2).getTimeOfDayMultiplier();
        boolean bl2 = bl = timeOfDayMultiplier == null || timeOfDayMultiplier.isDefaults() || timeOfDayMultiplier.isAllZeroes();
        if (timeOfDayMultiplier == null) {
            timeOfDayMultiplier = new TimeOfDayMultiplier();
        }
        ((TimeOfDayMultiplierJDialog)object).setData(timeOfDayMultiplier);
        ((TimeOfDayMultiplierJDialog)object).setColumnLabels(new String[]{"Time of Day", "Weighting Factor"});
        ((TimeOfDayMultiplierJDialog)object).setVisible(true);
        if (!((TimeOfDayMultiplierJDialog)object).isCanceled()) {
            timeOfDayMultiplier = ((TimeOfDayMultiplierJDialog)object).getData();
            if (!bl || !timeOfDayMultiplier.isDefaults() && !timeOfDayMultiplier.isAllZeroes()) {
                this.setModified(true);
            }
            if (timeOfDayMultiplier.isDefaults() || timeOfDayMultiplier.isAllZeroes()) {
                timeOfDayMultiplier = null;
            }
            ((OpRule)object2).setTimeOfDayMultiplier(timeOfDayMultiplier);
        }
    }

    void editDayOfWeekMultiplier() {
        boolean bl;
        Object object = SwingUtilities.windowForComponent((Component)((Object)this));
        if (!(object instanceof ReservoirJFrame)) {
            return;
        }
        Object object2 = "Day of Week Weighting";
        object = new DayOfWeekMultiplierJDialog((Dialog)object, (String)object2, true);
        object2 = this._currentRuleRef.getRule();
        if (object2 == null) {
            return;
        }
        DayOfWeekMultiplier dayOfWeekMultiplier = ((OpRule)object2).getMultiplier();
        boolean bl2 = bl = dayOfWeekMultiplier == null || dayOfWeekMultiplier.isDefaults();
        if (dayOfWeekMultiplier == null) {
            dayOfWeekMultiplier = new DayOfWeekMultiplier();
        }
        ((DayOfWeekMultiplierJDialog)((Object)object)).setData(dayOfWeekMultiplier);
        ((DayOfWeekMultiplierJDialog)((Object)object)).setColumnLabels(new String[]{"Day", "Weighting Factor"});
        ((DayOfWeekMultiplierJDialog)((Object)object)).setVisible(true);
        if (!((DayOfWeekMultiplierJDialog)((Object)object)).isCanceled()) {
            dayOfWeekMultiplier = ((DayOfWeekMultiplierJDialog)((Object)object)).getData();
            if (!bl || !dayOfWeekMultiplier.isDefaults()) {
                this.setModified(true);
            }
            if (dayOfWeekMultiplier.isDefaults()) {
                dayOfWeekMultiplier = null;
            }
            ((OpRule)object2).setMultiplier(dayOfWeekMultiplier);
        }
    }

    public void setRuleRef(OpRuleRef opRuleRef) {
        if (opRuleRef == null) {
            return;
        }
        if (this.isModified()) {
            this.savePanel();
        }
        this._currentRuleRef = opRuleRef;
        this.fillPanel();
    }

    public void setParent(JPanel jPanel) {
        this._parent = (JOperationsPanel)((Object)jPanel);
    }

    @Override
    public void editingStopped(ChangeEvent changeEvent) {
        this.monthlyReplot();
    }

    @Override
    public void editingCanceled(ChangeEvent changeEvent) {
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        this.monthlyReplot();
    }

    @Override
    public void focusLost(FocusEvent object) {
        if ((object = ((EventObject)object).getSource()) == this.jNameDescPanel.getName()) {
            if (this.jNameDescPanel.getName().equals("")) {
                this.jNameDescPanel.setName(this._currentRuleRef.getRule().getName());
                RMAIO.postError((Component)((Object)this), (String)"Cannot have a blank Rule Name!");
                return;
            }
            this._currentRuleRef.getRule().setName(this.jNameDescPanel.getName());
            this._currentRuleRef.setName(this.jNameDescPanel.getName());
            ((JOperationsPanel)this._parent).treeDataChanged(0, this._oldRuleName, this.jNameDescPanel.getName());
        }
    }

    private void monthlyReplot() {
        this._monthlyPlot.setVisible(false);
        JFirmEnergyRulePanel jFirmEnergyRulePanel = this;
        jFirmEnergyRulePanel.configureMonthlyPlot(jFirmEnergyRulePanel._monthlyPlot);
        Vector<Object> vector = new Vector<Object>();
        if (this._currentCard.equals("Monthly")) {
            this._firmEnergyData.clearData();
            this._firmEnergyData.name = "Energy Requirement";
            this._firmEnergyData.lineStyleName = "POWER-REQUIRED";
            this._firmEnergyData.setData(this._monthlyTable, 0, 1);
            this._firmEnergyData.yunits = this._firm_choice;
            vector.add(this._firmEnergyData);
        } else {
            SeasonalRecord seasonalRecord = new SeasonalRecord();
            ((SeasonalRecordTableModel)this._seasonalTable.getModel()).storeData(seasonalRecord);
            this.m_seasonalPlotData.setPlotYears(1);
            this.m_seasonalPlotData.setData(seasonalRecord);
            vector.add(this.m_seasonalPlotData);
        }
        this._monthlyPlot.setPlotObjects(vector);
        this._monthlyPlot.setVisible(true);
    }

    public void deselectPanel() {
        if (this.isModified()) {
            this.savePanel();
        }
    }

    public void clearPanel() {
    }
}

