/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.clientapp.client.ClientApp;
import hec.gfx2d.G2dPanel;
import hec.gfx2d.G2dPanelProp;
import hec.gfx2d.G2dPlotProp;
import hec.gfx2d.HotPlotDefaults;
import hec.gfx2d.PlotDefaults;
import hec.gfx2d.PlotDefaultsManager;
import hec.gfx2d.SimpleSeasonalData;
import hec.heclib.util.HecTime;
import hec.model.SeasonalRecord;
import hec.model.SeasonalRecordTableModel;
import hec.rss.RssRmiWorkspace;
import hec.rss.client.DayOfWeekMultiplierJDialog;
import hec.rss.client.JFlowLimitRulePanel$1;
import hec.rss.client.JFlowLimitRulePanel$2;
import hec.rss.client.JOperationsPanel;
import hec.rss.model.DayOfWeekMultiplier;
import hec.rss.model.FlowLimitOpRule;
import hec.rss.model.OpRule;
import hec.rss.model.OpRuleRef;
import hec.rss.model.RssNode;
import hec.rss.model.reports.AltInputReportInfc;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.rmi.RemoteException;
import java.util.EventObject;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableModel;
import rma.lang.Modifiable;
import rma.swing.DefaultJPanel;
import rma.swing.RmaGridBagConstraints;
import rma.swing.RmaJCalendarField;
import rma.swing.RmaJCheckBox;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJDssPathPartField;
import rma.swing.RmaJTable;
import rma.swing.RmaJTextField;
import rma.swing.print.PageText;
import rma.util.RMAIO;

public class JFlowLimitRulePanel
extends DefaultJPanel
implements ActionListener,
FocusListener,
CellEditorListener,
Modifiable {
    Insets INSETS5505 = new Insets(5, 5, 0, 5);
    Insets INSETS5500 = new Insets(5, 5, 0, 0);
    Insets INSETS5550 = new Insets(5, 5, 5, 0);
    Insets INSETS5555 = new Insets(5, 5, 5, 5);
    Insets INSETS0000 = new Insets(0, 0, 0, 0);
    SimpleSeasonalData _storageZonePlotArray;
    OpRuleRef _currentRuleRef;
    String _oldRuleName = "";
    DefaultJPanel _parent = null;
    JLabel jLocationLabel = new JLabel("Location");
    RmaJComboBox jLocationCombo = new RmaJComboBox();
    JLabel jLimitTypeLabel = new JLabel("Limit Type");
    RmaJComboBox jLimitTypeCombo = new RmaJComboBox();
    JLabel jInterpTypeLabel = new JLabel("Interpolation Type");
    RmaJComboBox jInterpTypeCombo = new RmaJComboBox();
    JLabel jStorageLabel = new JLabel("Flow Limit Rule");
    JLabel jDescriptionLabel = new JLabel("Description");
    JLabel jStartYearLabel = new JLabel("Starting Year");
    JPanel jNameDescPanel = new JPanel();
    JPanel jTablePanel = new JPanel();
    JPanel jBottomPanel = new JPanel();
    JCheckBox jMultiplierCheck = new JCheckBox("Day of Week Multiplier");
    JButton jMultiplierButton = new JButton("Edit");
    RmaJTextField jStorageZoneTxt = new RmaJDssPathPartField();
    RmaJTextField jDescriptionTxt = new RmaJTextField();
    RmaJCalendarField jStartYearTxt = new RmaJCalendarField("YYYY", "");
    RmaJCheckBox jMultiYearCheck = new RmaJCheckBox("Allow Multi-year Seasonal Data");
    String[] colLabels = new String[]{"Date", "Flow (%S)"};
    RmaJTable jStorageZoneTable;
    G2dPanel storageZonePlot = new G2dPanel();

    public JFlowLimitRulePanel() {
        this.setLayout(new GridBagLayout());
        this.jStorageZoneTxt.setModifiable(false);
        this.jStorageZoneTxt.setEditable(false);
        this.jNameDescPanel.setLayout(new GridBagLayout());
        this.jNameDescPanel.add((Component)this.jStorageLabel, new RmaGridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, this.INSETS5500, 0, 0));
        this.jNameDescPanel.add((Component)this.jDescriptionLabel, new RmaGridBagConstraints(0, 1, 1, 1, 0.0, 1.0, 18, 0, this.INSETS5500, 0, 0));
        this.jNameDescPanel.add((Component)this.jStorageZoneTxt, new RmaGridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 2, this.INSETS5500, 0, 0));
        this.jNameDescPanel.add((Component)new JLabel(), new RmaGridBagConstraints(2, 0, 2, 1, 1.0, 0.0, 18, 2, this.INSETS5505, 0, 0));
        this.jNameDescPanel.add((Component)this.jDescriptionTxt, new RmaGridBagConstraints(1, 1, 3, 1, 1.0, 1.0, 18, 2, this.INSETS5555, 0, 0));
        this.jTablePanel.setLayout(new GridBagLayout());
        this.jTablePanel.add((Component)this.jLimitTypeLabel, new RmaGridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, this.INSETS5500, 0, 0));
        this.jTablePanel.add((Component)this.jLimitTypeCombo, new RmaGridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 2, this.INSETS5505, 0, 0));
        this.jTablePanel.add((Component)this.jInterpTypeLabel, new RmaGridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, this.INSETS5500, 0, 0));
        this.jTablePanel.add((Component)this.jInterpTypeCombo, new RmaGridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 18, 2, this.INSETS5505, 0, 0));
        this.jTablePanel.add((Component)this.jLocationLabel, new RmaGridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, this.INSETS5500, 0, 0));
        this.jTablePanel.add((Component)this.jLocationCombo, new RmaGridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 18, 2, this.INSETS5505, 0, 0));
        JFlowLimitRulePanel jFlowLimitRulePanel = this;
        this.jStorageZoneTable = new JFlowLimitRulePanel$1(jFlowLimitRulePanel, (Component)((Object)jFlowLimitRulePanel));
        this.jStorageZoneTable.setModel((TableModel)new SeasonalRecordTableModel(new String[]{"Date", "Flow (%S)"}, new boolean[]{true, true}));
        this.jStorageZoneTable.setUnitsHeaderRenderer();
        this.jStorageZoneTable.setDoubleCellEditor(1);
        this.jStorageZoneTable.setDateCellEditor(0, "DDMMM");
        this.jStorageZoneTable.setHorizontalAlignment(2, 0);
        this.jStorageZoneTable.setHorizontalAlignment(4, 1);
        this.jStorageZoneTable.setNumRows(10);
        this.jStorageZoneTable.setCellEnabled(false, 0, 0);
        this.jStorageZoneTable.setCellBackground(0, 0, Color.lightGray);
        this.jStorageZoneTable.getScrollPane().setVerticalScrollBarPolicy(22);
        this.jStorageZoneTable.getScrollPane().setHorizontalScrollBarPolicy(30);
        this.jTablePanel.add((Component)this.jStorageZoneTable.getScrollPane(), new RmaGridBagConstraints(0, 3, 2, 1, 1.0, 1.0, 18, 1, this.INSETS5505, 0, 0));
        this.storageZonePlot.setBackground(Color.lightGray);
        JFlowLimitRulePanel jFlowLimitRulePanel2 = this;
        jFlowLimitRulePanel2.configurePlotPanel(jFlowLimitRulePanel2.storageZonePlot);
        Vector<SimpleSeasonalData> vector = new Vector<SimpleSeasonalData>();
        this._storageZonePlotArray = this.getStorageZonePlotArray();
        vector.addElement(this._storageZonePlotArray);
        this.storageZonePlot.setPlotObjects(vector);
        this.jTablePanel.add((Component)this.storageZonePlot, new RmaGridBagConstraints(3, 0, 1, 4, 0.0, 1.0, 12, 0, this.INSETS5555, 150, 150));
        this.jBottomPanel.setLayout(new GridBagLayout());
        this.jBottomPanel.add((Component)this.jMultiplierCheck, new RmaGridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 16, 0, this.INSETS5550, 0, 0));
        this.jBottomPanel.add((Component)this.jMultiplierButton, new RmaGridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 16, 0, this.INSETS5555, 10, 0));
        JFlowLimitRulePanel jFlowLimitRulePanel3 = this;
        jFlowLimitRulePanel3.add(jFlowLimitRulePanel3.jNameDescPanel, new RmaGridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 2, this.INSETS0000, 0, 0));
        JFlowLimitRulePanel jFlowLimitRulePanel4 = this;
        jFlowLimitRulePanel4.add(jFlowLimitRulePanel4.jTablePanel, new RmaGridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 1, this.INSETS0000, 0, 0));
        JFlowLimitRulePanel jFlowLimitRulePanel5 = this;
        jFlowLimitRulePanel5.add(jFlowLimitRulePanel5.jBottomPanel, new RmaGridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 18, 2, this.INSETS0000, 0, 0));
        this.jLimitTypeCombo.addItem((Object)"Minimum Flow");
        this.jLimitTypeCombo.addItem((Object)"Maximum Flow");
        this.jLocationCombo.addItem((Object)"Reservoir Release");
        this.jLocationCombo.addItem((Object)"Reservoir Tailwater");
        for (int i = 0; i < SeasonalRecord.INTERP_STRINGS.length; ++i) {
            this.jInterpTypeCombo.addItem((Object)SeasonalRecord.INTERP_STRINGS[i]);
        }
        this.jStorageZoneTable.addCellEditorListener((CellEditorListener)this);
        this.jMultiYearCheck.addActionListener((ActionListener)this);
        this.jLocationCombo.addItemListener((ItemListener)((Object)this));
        this.jLimitTypeCombo.addItemListener((ItemListener)((Object)this));
        this.jInterpTypeCombo.addItemListener((ItemListener)((Object)this));
        this.jStorageZoneTxt.addFocusListener((FocusListener)this);
        this.jMultiplierButton.addActionListener(this);
        this.jMultiplierCheck.addActionListener(new JFlowLimitRulePanel$2(this));
    }

    public void setDownstreamLocationComboModel(Vector vector) {
        this.jLocationCombo.removeItemListener((ItemListener)((Object)this));
        this.jLocationCombo.setModel(new DefaultComboBoxModel(vector));
        this.jLocationCombo.addItemListener((ItemListener)((Object)this));
    }

    public void itemStateChanged(ItemEvent object) {
        if (((ItemEvent)object).getStateChange() == 2) {
            return;
        }
        if ((object = ((EventObject)object).getSource()) == this.jLocationCombo) {
            this.setModified(true);
            return;
        }
        if (object == this.jLimitTypeCombo) {
            this.setModified(true);
            return;
        }
        if (object == this.jInterpTypeCombo) {
            this.setModified(true);
            this.replot();
        }
    }

    @Override
    public void editingCanceled(ChangeEvent changeEvent) {
    }

    @Override
    public void editingStopped(ChangeEvent changeEvent) {
        this.setModified(true);
        this.replot();
    }

    @Override
    public void actionPerformed(ActionEvent object) {
        if ((object = ((EventObject)object).getSource()) == this.jMultiYearCheck) {
            this.MultiYearCheck_ActionPerformed();
            return;
        }
        if (object == this.jMultiplierButton) {
            this.MultiplierButton_ActionPerformed();
        }
    }

    private void jMultiplierCheck_Action() {
        if (this._currentRuleRef == null) {
            this.jMultiplierCheck.setSelected(false);
            return;
        }
        AltInputReportInfc altInputReportInfc = (FlowLimitOpRule)this._currentRuleRef.getRule();
        if (altInputReportInfc == null) {
            this.jMultiplierCheck.setSelected(false);
            return;
        }
        if ((altInputReportInfc = ((OpRule)altInputReportInfc).getMultiplier()) == null || ((DayOfWeekMultiplier)altInputReportInfc).isDefaults()) {
            this.jMultiplierCheck.setSelected(false);
            return;
        }
        this.jMultiplierCheck.setSelected(true);
    }

    private void MultiplierButton_ActionPerformed() {
        Object object = SwingUtilities.windowForComponent((Component)((Object)this));
        if (object instanceof Dialog) {
            Object object2 = "Day of Week Multiplier";
            object = new DayOfWeekMultiplierJDialog((Dialog)object, (String)object2, true);
            object2 = (FlowLimitOpRule)this._currentRuleRef.getRule();
            if (((OpRule)object2).getMultiplier() == null) {
                ((OpRule)object2).setMultiplier(new DayOfWeekMultiplier());
            }
            ((DayOfWeekMultiplierJDialog)((Object)object)).setData(((OpRule)object2).getMultiplier());
            ((DayOfWeekMultiplierJDialog)((Object)object)).setVisible(true);
            if (!((DayOfWeekMultiplierJDialog)((Object)object)).isCanceled()) {
                this.setModified(true);
            }
            if ((object = ((OpRule)object2).getMultiplier()) == null || ((DayOfWeekMultiplier)object).isDefaults()) {
                this.jMultiplierCheck.setSelected(false);
                return;
            }
            this.jMultiplierCheck.setSelected(true);
        }
    }

    private void MultiYearCheck_ActionPerformed() {
        if (this.jMultiYearCheck.isSelected()) {
            this.jStartYearTxt.setEnabled(true);
            return;
        }
        this.jStartYearTxt.setEnabled(false);
    }

    public void setRuleRef(OpRuleRef opRuleRef) {
        if (opRuleRef == null) {
            return;
        }
        if (this.isModified()) {
            this.savePanel();
        }
        this._currentRuleRef = opRuleRef;
        this.fillPanel();
    }

    public void fillPanel() {
        RssNode rssNode;
        Object object;
        if (this._currentRuleRef == null) {
            return;
        }
        Object object2 = "";
        try {
            ClientApp.app();
            object = ClientApp.Workspace();
            HecTime hecTime = ((RssRmiWorkspace)object.getChildWorkspace("rss")).getStartOfWaterYear();
            object2 = hecTime.date(104);
            object2 = ((String)object2).substring(0, 5);
        }
        catch (RemoteException remoteException) {
            System.out.println("Error Setting water year start - " + remoteException.getMessage());
            System.out.println("Resuming as normal");
        }
        object = (FlowLimitOpRule)this._currentRuleRef.getRule();
        this.clearPanel();
        this.jStorageZoneTxt.setText(object.getName());
        this.jDescriptionTxt.setText(object.getDescription());
        this._oldRuleName = object.getName();
        this.jLimitTypeCombo.removeItemListener((ItemListener)((Object)this));
        if (((FlowLimitOpRule)object).getLimitType() == -1) {
            this.jLimitTypeCombo.setSelectedIndex(0);
        } else {
            this.jLimitTypeCombo.setSelectedIndex(1);
        }
        this.jLimitTypeCombo.addItemListener((ItemListener)((Object)this));
        this.jLocationCombo.removeItemListener((ItemListener)((Object)this));
        int n = ((FlowLimitOpRule)object).getRssNodeIndex();
        if (n < 0) {
            this.jLocationCombo.setSelectedIndex(0);
        } else {
            int n2;
            int n3 = this.jLocationCombo.getItemCount();
            for (n2 = 1; n2 < n3; ++n2) {
                rssNode = (RssNode)this.jLocationCombo.getItemAt(n2);
                if (rssNode.getIndex() != n) continue;
                this.jLocationCombo.setSelectedIndex(n2);
                break;
            }
            if (n2 == n3) {
                this.jLocationCombo.setSelectedIndex(0);
            }
        }
        this.jLocationCombo.addItemListener((ItemListener)((Object)this));
        SeasonalRecord seasonalRecord = ((FlowLimitOpRule)object).getSeasonalRecord();
        ((SeasonalRecordTableModel)this.jStorageZoneTable.getModel()).setSeasonalRecord(seasonalRecord, (String)object2);
        this.jInterpTypeCombo.removeItemListener((ItemListener)((Object)this));
        this.jInterpTypeCombo.setSelectedIndex(((FlowLimitOpRule)object).getInterpolationType());
        this.jInterpTypeCombo.addItemListener((ItemListener)((Object)this));
        ClientApp.app();
        Object object3 = new String("Workspace: " + ClientApp.Workspace().getTitleName());
        object3 = (String)object3 + "\n ResSim System: " + ((JOperationsPanel)this._parent)._reservoir.getSystem().getName();
        object3 = (String)object3 + "\n Reservoir: " + ((JOperationsPanel)this._parent)._reservoir.getName();
        object3 = (String)object3 + "\n Operation Set: " + ((JOperationsPanel)this._parent)._currentOpSet.getName();
        object3 = (String)object3 + "\n Flow Limit Rule: " + this._currentRuleRef.getName() + " \n ";
        rssNode = new PageText((String)object3, 0);
        this.jStorageZoneTable.setPrintTitle((PageText)rssNode);
        this.replot();
        object2 = ((OpRule)object).getMultiplier();
        if (object2 == null || ((DayOfWeekMultiplier)object2).isDefaults()) {
            this.jMultiplierCheck.setSelected(false);
        } else {
            this.jMultiplierCheck.setSelected(true);
        }
        this.setModified(false);
    }

    public void refresh() {
    }

    public boolean savePanel() {
        if (this._currentRuleRef == null) {
            return false;
        }
        if (this.jStorageZoneTxt.getText().equals("")) {
            RMAIO.postError((Component)((Object)this), (String)"Cannot have an empty rule name!");
            return false;
        }
        FlowLimitOpRule flowLimitOpRule = (FlowLimitOpRule)this._currentRuleRef.getRule();
        this._currentRuleRef.getRule().setName(this.jStorageZoneTxt.getText());
        this._currentRuleRef.setName(this.jStorageZoneTxt.getText());
        this._oldRuleName = this.jStorageZoneTxt.getText();
        flowLimitOpRule.setDescription(this.jDescriptionTxt.getText());
        if (this.jLimitTypeCombo.getSelectedIndex() == 0) {
            flowLimitOpRule.setLimitType(-1);
        } else {
            flowLimitOpRule.setLimitType(1);
        }
        Object object = this.jLocationCombo.getSelectedItem();
        if (object instanceof RssNode) {
            flowLimitOpRule.setRssNodeIndex(((RssNode)object).getIndex());
        } else {
            flowLimitOpRule.setRssNodeIndex(-1);
        }
        flowLimitOpRule.setInterpolationType(this.jInterpTypeCombo.getSelectedIndex());
        this.jStorageZoneTable.commitEdit(true);
        object = (SeasonalRecordTableModel)this.jStorageZoneTable.getModel();
        object.storeData(flowLimitOpRule.getSeasonalRecord());
        this.setModified(false);
        return true;
    }

    public void clearPanel() {
        this.jStorageZoneTable.clearCells();
        this.jStorageZoneTxt.setText("");
        this.jDescriptionTxt.setText("");
        this.jMultiYearCheck.setSelected(false);
        this.jStartYearTxt.setEnabled(false);
    }

    private SimpleSeasonalData getStorageZonePlotArray() {
        SimpleSeasonalData simpleSeasonalData = new SimpleSeasonalData();
        new SimpleSeasonalData().xunits = "Date";
        simpleSeasonalData.yunits = "Flow";
        simpleSeasonalData.setData(new int[0], new double[0]);
        return simpleSeasonalData;
    }

    private void configurePlotPanel(G2dPanel g2dPanel) {
        PlotDefaults plotDefaults = PlotDefaultsManager.getDefaults();
        PlotDefaultsManager.setDefaults((PlotDefaults)new HotPlotDefaults());
        G2dPanelProp g2dPanelProp = new G2dPanelProp();
        new G2dPanelProp().hasTitle = false;
        g2dPanelProp.hasToolbar = false;
        g2dPanelProp.hasLegend = false;
        G2dPlotProp g2dPlotProp = new G2dPlotProp();
        new G2dPlotProp().hasXScroll = false;
        g2dPlotProp.hasYScroll = false;
        g2dPlotProp.x1AxisProp.name = "Minutes";
        g2dPlotProp.x1AxisProp.type = 2;
        g2dPlotProp.y1AxisProp.name = "Flow";
        g2dPlotProp.x1AxisProp.numTicLabelLayers = 1;
        g2dPlotProp.hasX1Label = false;
        g2dPlotProp.y1AxisProp.isReversed = true;
        g2dPlotProp.x1AxisProp.isDefaultLimits = false;
        g2dPlotProp.x1AxisProp.min = 0.0;
        g2dPlotProp.x1AxisProp.max = 525600.0;
        g2dPanelProp.addPlotProp(g2dPlotProp);
        g2dPanel.configurePanel(g2dPanelProp);
        PlotDefaultsManager.setDefaults((PlotDefaults)plotDefaults);
    }

    public void replot() {
        this.plotRule();
    }

    private void plotRule() {
        new Vector();
        SeasonalRecord seasonalRecord = new SeasonalRecord();
        Object object = (SeasonalRecordTableModel)this.jStorageZoneTable.getModel();
        object.storeData(seasonalRecord);
        object = (String)this.jInterpTypeCombo.getSelectedItem();
        this._storageZonePlotArray.setPlotYears(1);
        this._storageZonePlotArray.setInterpolationType((String)object);
        this._storageZonePlotArray.setData(seasonalRecord);
        this.storageZonePlot.paintGfx();
    }

    public void setParent(JPanel jPanel) {
        this._parent = (JOperationsPanel)((Object)jPanel);
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
    }

    @Override
    public void focusLost(FocusEvent object) {
        if ((object = ((EventObject)object).getSource()) == this.jStorageZoneTxt) {
            if (this.jStorageZoneTxt.getText().equals("")) {
                this.jStorageZoneTxt.setText(this._currentRuleRef.getRule().getName());
                RMAIO.postError((Component)((Object)this), (String)"Cannot have a blank Rule Name!");
                return;
            }
            this._currentRuleRef.getRule().setName(this.jStorageZoneTxt.getText());
            this._currentRuleRef.setName(this.jStorageZoneTxt.getText());
            ((JOperationsPanel)this._parent).treeDataChanged(0, this._oldRuleName, this.jStorageZoneTxt.getText());
        }
    }

    public void deselectPanel() {
        if (this.isModified()) {
            this.savePanel();
        }
    }
}

