/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.heclib.util.HecTime;
import hec.rss.RssRmiWorkspace;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.rmi.RemoteException;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import rma.swing.DefaultJPanel;
import rma.swing.RmaGridBagConstraints;
import rma.swing.RmaJCalendarField;

public class JGlobalUnitsPanel
extends DefaultJPanel {
    private int _unitType;
    private HecTime _waterYear;
    private RssRmiWorkspace _wksp;
    JLabel unitsLbl = new JLabel("Unit System");
    JLabel waterYearLbl = new JLabel("Start of Water Year");
    JComboBox unitsCombo = new JComboBox();
    RmaJCalendarField waterYearTxt = new RmaJCalendarField("DDMMM", "");

    public JGlobalUnitsPanel() {
        Insets insets = new Insets(5, 5, 0, 0);
        new Insets(5, 5, 5, 5);
        this.setLayout(new GridBagLayout());
        JGlobalUnitsPanel jGlobalUnitsPanel = this;
        jGlobalUnitsPanel.add(jGlobalUnitsPanel.waterYearLbl, new RmaGridBagConstraints(0, 1, 1, 1, 0.0, 1.0, 18, 0, insets, 0, 0));
        JGlobalUnitsPanel jGlobalUnitsPanel2 = this;
        jGlobalUnitsPanel2.add((Component)jGlobalUnitsPanel2.waterYearTxt, new RmaGridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 18, 2, new Insets(5, 5, 5, 200), 0, 0));
        this.setName("ResSim Options");
        this.unitsLbl.setDisplayedMnemonic('U');
        this.unitsLbl.setLabelFor(this.unitsCombo);
        this.waterYearLbl.setDisplayedMnemonic('S');
        this.waterYearLbl.setLabelFor((Component)this.waterYearTxt);
    }

    public void setData(RssRmiWorkspace rssRmiWorkspace) {
        this._wksp = rssRmiWorkspace;
    }

    public void fillPanel() {
        this.clearPanel();
        try {
            this._waterYear = this._wksp.getStartOfWaterYear();
        }
        catch (RemoteException remoteException) {
            System.out.println("Error getting global workspace data!");
            System.out.println(remoteException.getMessage());
            return;
        }
        String string = this._waterYear.date(104);
        string = string.substring(0, 5);
        this.waterYearTxt.setText(string);
    }

    public void clearPanel() {
        this.waterYearTxt.setText("");
    }

    public void refresh() {
    }

    public boolean savePanel() {
        try {
            this._wksp.setStartOfWaterYear(this.waterYearTxt.getText());
            return true;
        }
        catch (RemoteException remoteException) {
            System.out.println("Error Saving RSS Global Units");
            System.out.println(remoteException.getMessage());
            return false;
        }
    }
}

