/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.gui.NameDescriptionPanel;
import hec.rss.client.ESRDCurvesPanel;
import hec.rss.client.InducedSurchargeFunctionPanel;
import hec.rss.client.JInducedSurchargeRulePanel$1;
import hec.rss.client.JOperationsPanel;
import hec.rss.model.InducedSurchargeOpRule;
import hec.rss.model.OpRuleRef;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.Serializable;
import java.util.EventObject;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.text.Document;
import rma.swing.DefaultJPanel;
import rma.swing.RmaGridBagConstraints;
import rma.swing.RmaInsets;
import rma.swing.RmaJDialog;
import rma.swing.RmaJRadioButton;
import rma.swing.text.DssPathnamePartDocument;
import rma.util.RMAIO;

public class JInducedSurchargeRulePanel
extends DefaultJPanel
implements ActionListener,
FocusListener,
ItemListener {
    JLabel jRuleLabel = new JLabel("Induced Surcharge Rule:");
    NameDescriptionPanel jNameDescPanel = new NameDescriptionPanel(8L);
    Insets INSETS5555 = new Insets(5, 5, 5, 5);
    Insets INSETS5500 = new Insets(5, 5, 0, 0);
    Insets INSETS5505 = new Insets(5, 5, 0, 5);
    Insets INSETS5550 = new Insets(5, 5, 5, 0);
    Insets INSETS0505 = new Insets(0, 5, 0, 5);
    Insets INSETS2500 = new Insets(2, 5, 0, 0);
    String xUnits = "";
    String yUnits = "";
    String _oldRuleName = "";
    OpRuleRef _currentRuleRef = null;
    DefaultJPanel _parent = null;
    private InducedSurchargeFunctionPanel _inducedSurchageFunctionPanel;
    private JPanel _cardPanel;
    private RmaJRadioButton _useInducedSurchargeRadio;
    private RmaJRadioButton _specifyESRDCurvesRadio;
    private ESRDCurvesPanel _esrdCurvesPanel;

    public JInducedSurchargeRulePanel() {
        this.buildControls();
    }

    protected void buildControls() {
        this.setLayout(new GridBagLayout());
        this.jNameDescPanel.setNameEditable(false);
        this.jNameDescPanel.setNameDocument((Document)new DssPathnamePartDocument());
        this.jNameDescPanel.setNameLabel(this.jRuleLabel.getText());
        JInducedSurchargeRulePanel jInducedSurchargeRulePanel = this;
        jInducedSurchargeRulePanel.add((Component)jInducedSurchargeRulePanel.jNameDescPanel, new RmaGridBagConstraints(0, 0, 3, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        Object object = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this.add((Component)object, gridBagConstraints);
        this._useInducedSurchargeRadio = new RmaJRadioButton("Use Induced Surcharge Function", true);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        ((Container)object).add((Component)this._useInducedSurchargeRadio, gridBagConstraints);
        this._specifyESRDCurvesRadio = new RmaJRadioButton("Specify the ESRD Curves");
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        ((Container)object).add((Component)this._specifyESRDCurvesRadio, gridBagConstraints);
        this._cardPanel = new JPanel(new CardLayout());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        JInducedSurchargeRulePanel jInducedSurchargeRulePanel2 = this;
        jInducedSurchargeRulePanel2.add(jInducedSurchargeRulePanel2._cardPanel, gridBagConstraints);
        this._inducedSurchageFunctionPanel = new InducedSurchargeFunctionPanel();
        this._esrdCurvesPanel = new ESRDCurvesPanel();
        this._cardPanel.add((Component)((Object)this._inducedSurchageFunctionPanel), this._inducedSurchageFunctionPanel.getName());
        this._cardPanel.add((Component)((Object)this._esrdCurvesPanel), this._esrdCurvesPanel.getName());
        object = new ButtonGroup();
        ((ButtonGroup)object).add((AbstractButton)this._useInducedSurchargeRadio);
        ((ButtonGroup)object).add((AbstractButton)this._specifyESRDCurvesRadio);
        object = new JInducedSurchargeRulePanel$1(this);
        this._useInducedSurchargeRadio.addActionListener((ActionListener)object);
        this._specifyESRDCurvesRadio.addActionListener((ActionListener)object);
    }

    protected void selectInputTypeAction() {
        if (this._useInducedSurchargeRadio.isSelected()) {
            ((CardLayout)this._cardPanel.getLayout()).show(this._cardPanel, this._inducedSurchageFunctionPanel.getName());
            return;
        }
        ((CardLayout)this._cardPanel.getLayout()).show(this._cardPanel, this._esrdCurvesPanel.getName());
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
    }

    public void fillPanel() {
        if (this._currentRuleRef == null) {
            return;
        }
        this.clearPanel();
        Serializable serializable = (InducedSurchargeOpRule)this._currentRuleRef.getRule();
        this._oldRuleName = serializable.getName();
        this.jNameDescPanel.setName(serializable.getName());
        this.jNameDescPanel.setDescription(serializable.getDescription());
        this._inducedSurchageFunctionPanel.fillPanel();
        this._esrdCurvesPanel.fillPanel();
        if (serializable.getUseUserDefinedIsCurves()) {
            this._specifyESRDCurvesRadio.doClick(0);
        } else {
            this._useInducedSurchargeRadio.doClick(0);
        }
        serializable = SwingUtilities.windowForComponent((Component)((Object)this));
        ((RmaJDialog)serializable).updateUnitSystem((Container)((Object)this));
        this.setModified(false);
    }

    public void clearPanel() {
        this._inducedSurchageFunctionPanel.clearPanel();
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
    }

    public void refresh() {
    }

    public boolean savePanel() {
        boolean bl;
        if (this._currentRuleRef == null) {
            return false;
        }
        if (this.jNameDescPanel.getName().equals("")) {
            RMAIO.postError((Component)((Object)this), (String)"Cannot have an empty rule name!");
            return false;
        }
        InducedSurchargeOpRule inducedSurchargeOpRule = (InducedSurchargeOpRule)this._currentRuleRef.getRule();
        if (inducedSurchargeOpRule == null) {
            return false;
        }
        this._currentRuleRef.getRule().setName(this.jNameDescPanel.getName());
        this._currentRuleRef.setName(this.jNameDescPanel.getName());
        this._oldRuleName = this.jNameDescPanel.getName();
        inducedSurchargeOpRule.setDescription(this.jNameDescPanel.getDescription());
        if (this._inducedSurchageFunctionPanel.isShowing() && !(bl = this._inducedSurchageFunctionPanel.savePanel())) {
            return false;
        }
        if (this._esrdCurvesPanel.isShowing() && !(bl = this._esrdCurvesPanel.savePanel())) {
            return false;
        }
        inducedSurchargeOpRule.setUseUserDefinedIsCurves(this._specifyESRDCurvesRadio.isSelected());
        this.setModified(false);
        return true;
    }

    public void setRuleRef(OpRuleRef opRuleRef) {
        if (opRuleRef == null) {
            return;
        }
        if (this.isModified()) {
            this.savePanel();
        }
        this._currentRuleRef = opRuleRef;
        this._inducedSurchageFunctionPanel.setRuleRef(this._currentRuleRef);
        this._esrdCurvesPanel.setRuleRef(this._currentRuleRef);
        this.fillPanel();
    }

    public void setParent(JPanel jPanel) {
        this._parent = (JOperationsPanel)((Object)jPanel);
        this._inducedSurchageFunctionPanel.setParent(jPanel);
        this._esrdCurvesPanel.setParent(jPanel);
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
    }

    @Override
    public void focusLost(FocusEvent object) {
        if ((object = ((EventObject)object).getSource()) == this.jNameDescPanel.getName()) {
            if (this.jNameDescPanel.getName().equals("")) {
                this.jNameDescPanel.setName(this._currentRuleRef.getRule().getName());
                RMAIO.postError((Component)((Object)this), (String)"Cannot have a blank Rule Name!");
                return;
            }
            this._currentRuleRef.getRule().setName(this.jNameDescPanel.getName());
            this._currentRuleRef.setName(this.jNameDescPanel.getName());
            ((JOperationsPanel)this._parent).treeDataChanged(0, this._oldRuleName, this.jNameDescPanel.getName());
        }
    }

    public boolean deselectISPanel() {
        boolean bl = true;
        if (this.isModified()) {
            bl = this.savePanel();
        }
        return bl;
    }

    public void deselectPanel() {
        this.deselectISPanel();
    }
}

