/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.clientapp.client.ClientApp;
import hec.gfx2d.G2dPanel;
import hec.gfx2d.G2dPanelProp;
import hec.gfx2d.G2dPlotProp;
import hec.gfx2d.HotPlotDefaults;
import hec.gfx2d.PlotDefaults;
import hec.gfx2d.PlotDefaultsManager;
import hec.gfx2d.SimplePairedValuesData;
import hec.model.PairedValues;
import hec.model.PairedValuesTableModel;
import hec.rss.client.JInputTSBasedRulePanel$1;
import hec.rss.client.JInputTSBasedRulePanel$2;
import hec.rss.client.JOperationsPanel;
import hec.rss.client.ReservoirJFrame;
import hec.rss.client.RisingFallingCondDialog;
import hec.rss.model.InputTSBasedOpRule;
import hec.rss.model.OpRuleRef;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.Serializable;
import java.util.EventObject;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableModel;
import rma.swing.DefaultJPanel;
import rma.swing.RmaGridBagConstraints;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJDialog;
import rma.swing.RmaJDssPathPartField;
import rma.swing.RmaJTable;
import rma.swing.RmaJTextField;
import rma.swing.print.PageText;
import rma.util.RMAIO;

public class JInputTSBasedRulePanel
extends DefaultJPanel
implements ActionListener,
FocusListener,
ItemListener,
CellEditorListener {
    Insets INSETS5555 = new Insets(5, 5, 5, 5);
    Insets INSETS5500 = new Insets(5, 5, 0, 0);
    Insets INSETS5505 = new Insets(5, 5, 0, 5);
    Insets INSETS5550 = new Insets(5, 5, 5, 0);
    String xUnits = new String("");
    String yUnits = new String("");
    String _oldRuleName = "";
    SimplePairedValuesData _elevReleaseData = this.getElevReleaseData();
    OpRuleRef _currentRuleRef = null;
    DefaultJPanel _parent = null;
    RmaJTextField jInputNameTxt = new RmaJTextField();
    RmaJTextField jParameterNameTxt = new RmaJTextField();
    RmaJComboBox jLimitCombo = new RmaJComboBox();
    RmaJComboBox jInterpCombo = new RmaJComboBox();
    RmaJTextField jRuleTxt = new RmaJDssPathPartField();
    RmaJTextField jRuleDescTxt = new RmaJTextField();
    String[] colLabels = new String[]{"Elevation (%S)", "Release (%S)"};
    boolean[] colEditable = new boolean[]{true, true};
    RmaJTable jParameterReleaseTable = new RmaJTable((Component)((Object)this));
    G2dPanel jFlowReleasePlot = new G2dPanel();
    JLabel jInputNameLabel = new JLabel("Input Name");
    JLabel jParameterNameLabel = new JLabel("Parameter Name");
    JLabel jLimitLabel = new JLabel("Limit Type");
    JLabel jInterpLabel = new JLabel("Interpolation Type");
    JLabel jRuleLabel = new JLabel("TS Parameter Based Release Rule");
    JLabel jDescriptionLabel = new JLabel("Description");
    JPanel jNameDescPanel = new JPanel();
    JPanel jRisingFallingOptPanel = new JPanel();
    JCheckBox jRisingFallingCheck = new JCheckBox("Apply Rising / Falling Cond");
    JButton jRisingFallingButton = new JButton("Edit");

    public JInputTSBasedRulePanel() {
        UIManager.getColor("text");
        UIManager.getFont("TextField.font");
        this.setLayout(new GridBagLayout());
        this.jRuleTxt.setModifiable(false);
        this.jRuleTxt.setEditable(false);
        this.jNameDescPanel.setLayout(new GridBagLayout());
        this.jNameDescPanel.add((Component)this.jRuleLabel, new RmaGridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 18, 0, this.INSETS5500, 0, 0));
        this.jNameDescPanel.add((Component)this.jDescriptionLabel, new RmaGridBagConstraints(0, 1, 1, 1, 0.0, 1.0, 18, 0, this.INSETS5500, 0, 0));
        this.jNameDescPanel.add((Component)this.jRuleTxt, new RmaGridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 18, 2, this.INSETS5500, 0, 0));
        this.jNameDescPanel.add((Component)new JLabel(), new RmaGridBagConstraints(4, 0, 1, 1, 1.0, 0.0, 18, 2, this.INSETS5505, 0, 0));
        this.jNameDescPanel.add((Component)this.jRuleDescTxt, new RmaGridBagConstraints(1, 1, 4, 1, 1.0, 1.0, 18, 2, this.INSETS5555, 0, 0));
        JInputTSBasedRulePanel jInputTSBasedRulePanel = this;
        jInputTSBasedRulePanel.add(jInputTSBasedRulePanel.jNameDescPanel, new RmaGridBagConstraints(0, 0, 3, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.add(jPanel, new RmaGridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.jInputNameLabel, new RmaGridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, this.INSETS5500, 0, 0));
        jPanel.add((Component)this.jInputNameTxt, new RmaGridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 18, 2, this.INSETS5505, 0, 0));
        jPanel.add((Component)this.jParameterNameLabel, new RmaGridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, this.INSETS5500, 0, 0));
        jPanel.add((Component)this.jParameterNameTxt, new RmaGridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 18, 2, this.INSETS5505, 0, 0));
        jPanel.add((Component)this.jLimitLabel, new RmaGridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, this.INSETS5500, 0, 0));
        this.jLimitCombo.addItem((Object)"Minimum Flow");
        this.jLimitCombo.addItem((Object)"Maximum Flow");
        this.jLimitCombo.addItem((Object)"Specified Flow");
        jPanel.add((Component)this.jLimitCombo, new RmaGridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 18, 2, this.INSETS5505, 0, 0));
        jPanel.add((Component)this.jInterpLabel, new RmaGridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 18, 0, this.INSETS5550, 0, 0));
        for (int i = 0; i < PairedValues.INTERP_STRINGS.length; ++i) {
            this.jInterpCombo.addItem((Object)PairedValues.INTERP_STRINGS[i]);
        }
        jPanel.add((Component)this.jInterpCombo, new RmaGridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 18, 2, this.INSETS5555, 0, 0));
        this.jParameterReleaseTable.setModel((TableModel)new PairedValuesTableModel(this.colLabels, this.colEditable));
        this.jParameterReleaseTable.setUnitsHeaderRenderer();
        this.jParameterReleaseTable.setDoubleCellEditor(0, false);
        this.jParameterReleaseTable.setDoubleCellEditor(1, false);
        this.jParameterReleaseTable.setNumRows(10);
        JInputTSBasedRulePanel jInputTSBasedRulePanel2 = this;
        jInputTSBasedRulePanel2.add(jInputTSBasedRulePanel2.jParameterReleaseTable.getScrollPane(), new RmaGridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 18, 1, this.INSETS5550, 0, 0));
        JInputTSBasedRulePanel jInputTSBasedRulePanel3 = this;
        jInputTSBasedRulePanel3.add((Component)jInputTSBasedRulePanel3.jFlowReleasePlot, new RmaGridBagConstraints(1, 1, 1, 3, 0.0, 0.0, 12, 0, new Insets(5, 5, 5, 5), 150, 150));
        JInputTSBasedRulePanel jInputTSBasedRulePanel4 = this;
        jInputTSBasedRulePanel4.configureFlowPlot(jInputTSBasedRulePanel4.jFlowReleasePlot);
        Vector<SimplePairedValuesData> vector = new Vector<SimplePairedValuesData>();
        vector.addElement(this._elevReleaseData);
        this.jFlowReleasePlot.setPlotObjects(vector);
        this.jRisingFallingOptPanel.setLayout(new GridBagLayout());
        this.jRisingFallingOptPanel.add((Component)this.jRisingFallingCheck, new RmaGridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 16, 0, new Insets(0, 5, 2, 10), 0, 0));
        this.jRisingFallingOptPanel.add((Component)this.jRisingFallingButton, new RmaGridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 16, 0, new Insets(0, 5, 2, 5), 10, 0));
        JInputTSBasedRulePanel jInputTSBasedRulePanel5 = this;
        jInputTSBasedRulePanel5.add(jInputTSBasedRulePanel5.jRisingFallingOptPanel, new RmaGridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 18, 2, INSETS0000, 0, 0));
        this.jParameterReleaseTable.addCellEditorListener((CellEditorListener)this);
        this.jRuleTxt.addFocusListener((FocusListener)this);
        this.jParameterNameTxt.addFocusListener((FocusListener)this);
        this.jRisingFallingButton.addActionListener(this);
        this.jInterpCombo.addItemListener((ItemListener)new JInputTSBasedRulePanel$1(this));
        this.jLimitCombo.addItemListener((ItemListener)new JInputTSBasedRulePanel$2(this));
    }

    @Override
    public void editingCanceled(ChangeEvent changeEvent) {
    }

    @Override
    public void editingStopped(ChangeEvent changeEvent) {
        this.paramReleaseReplot();
    }

    @Override
    public void actionPerformed(ActionEvent object) {
        if ((object = ((EventObject)object).getSource()) == this.jRisingFallingButton) {
            this.risingFallingButton_ActionPerformed();
        }
    }

    public void risingFallingButton_ActionPerformed() {
        Object object = SwingUtilities.windowForComponent((Component)((Object)this));
        if (!(object instanceof ReservoirJFrame)) {
            return;
        }
        if (this._currentRuleRef == null) {
            return;
        }
        object = new RisingFallingCondDialog((Dialog)object, true);
        ((RisingFallingCondDialog)object).fillForm(this._currentRuleRef.getRule());
        object.setVisible(true);
        if (((RisingFallingCondDialog)object).isOk()) {
            this.setModified(true);
        }
    }

    public void fillPanel() {
        if (this._currentRuleRef == null) {
            return;
        }
        this.clearPanel();
        Serializable serializable = (InputTSBasedOpRule)this._currentRuleRef.getRule();
        this._oldRuleName = serializable.getName();
        this.jRuleTxt.setText(serializable.getName());
        this.jRuleDescTxt.setText(serializable.getDescription());
        if (serializable.getLimitType() == -1) {
            this.jLimitCombo.setSelectedIndex(0);
        } else if (serializable.getLimitType() == 1) {
            this.jLimitCombo.setSelectedIndex(1);
        } else {
            this.jLimitCombo.setSelectedIndex(2);
        }
        String[] stringArray = serializable.getParameterValueRelease();
        PairedValuesTableModel pairedValuesTableModel = (PairedValuesTableModel)this.jParameterReleaseTable.getModel();
        pairedValuesTableModel.setPairedValues((PairedValues)stringArray);
        ClientApp.app();
        stringArray = new String("Workspace: " + ClientApp.Workspace().getTitleName());
        stringArray = (String)stringArray + "\n ResSim System: " + ((JOperationsPanel)this._parent)._reservoir.getSystem().getName();
        stringArray = (String)stringArray + "\n Reservoir: " + ((JOperationsPanel)this._parent)._reservoir.getName();
        stringArray = (String)stringArray + "\n Operation Set: " + ((JOperationsPanel)this._parent)._currentOpSet.getName();
        stringArray = (String)stringArray + "\n Elevation Release Rule: " + this._currentRuleRef.getName() + " \n ";
        stringArray = new PageText((String)stringArray, 0);
        this.jParameterReleaseTable.setPrintTitle((PageText)stringArray);
        this.jInputNameTxt.setText(serializable.getInputName());
        this.jParameterNameTxt.setText(serializable.getParameterName());
        String[] stringArray2 = new String[2];
        stringArray = stringArray2;
        stringArray2[1] = pairedValuesTableModel.getColumnName(1);
        stringArray[0] = serializable.getParameterName();
        pairedValuesTableModel.setColumnNames(stringArray);
        this.jParameterReleaseTable.setColumnLabels(stringArray);
        this.paramReleaseReplot();
        this.jInterpCombo.setSelectedIndex(serializable.getInterpolationType());
        this.jRisingFallingCheck.removeItemListener(this);
        this.jRisingFallingCheck.setSelected(serializable.getEnableRiseFallCondition());
        this.jRisingFallingCheck.addItemListener(this);
        serializable = SwingUtilities.windowForComponent((Component)((Object)this));
        ((RmaJDialog)serializable).updateUnitSystem((Container)((Object)this));
        this.setModified(false);
    }

    public void clearPanel() {
        this.jInterpCombo.setSelectedIndex(0);
        this.jLimitCombo.setSelectedIndex(0);
        this.jParameterReleaseTable.clearCells();
        Vector vector = new Vector();
        this.jFlowReleasePlot.setPlotObjects(vector);
        this.jFlowReleasePlot.paintGfx();
        this.jFlowReleasePlot.revalidate();
    }

    @Override
    public void itemStateChanged(ItemEvent object) {
        if ((object = ((EventObject)object).getSource()) == this.jRisingFallingCheck) {
            this.risingFallingCheck_itemStateChanged();
        }
    }

    public void risingFallingCheck_itemStateChanged() {
        this.setModified(true);
    }

    public void refresh() {
    }

    public boolean savePanel() {
        if (this._currentRuleRef == null) {
            return false;
        }
        if (this.jRuleTxt.getText().equals("")) {
            RMAIO.postError((Component)((Object)this), (String)"Cannot have an empty rule name!");
            return false;
        }
        InputTSBasedOpRule inputTSBasedOpRule = (InputTSBasedOpRule)this._currentRuleRef.getRule();
        if (inputTSBasedOpRule == null) {
            return false;
        }
        this._currentRuleRef.getRule().setName(this.jRuleTxt.getText());
        this._currentRuleRef.setName(this.jRuleTxt.getText());
        this._oldRuleName = this.jRuleTxt.getText();
        inputTSBasedOpRule.setDescription(this.jRuleDescTxt.getText());
        if (this.jLimitCombo.getSelectedIndex() == 0) {
            inputTSBasedOpRule.setLimitType(-1);
        } else if (this.jLimitCombo.getSelectedIndex() == 1) {
            inputTSBasedOpRule.setLimitType(1);
        } else {
            inputTSBasedOpRule.setLimitType(0);
        }
        inputTSBasedOpRule.setInterpolationType(this.jInterpCombo.getSelectedIndex());
        this.jParameterReleaseTable.commitEdit(true);
        PairedValuesTableModel pairedValuesTableModel = (PairedValuesTableModel)this.jParameterReleaseTable.getModel();
        pairedValuesTableModel.storeData(inputTSBasedOpRule.getParameterValueRelease());
        inputTSBasedOpRule.setInputName(this.jInputNameTxt.getText());
        inputTSBasedOpRule.setParameterName(this.jParameterNameTxt.getText());
        inputTSBasedOpRule.setEnableRiseFallCondition(this.jRisingFallingCheck.isSelected());
        this.setModified(false);
        return true;
    }

    private void paramReleaseReplot() {
        Vector<SimplePairedValuesData> vector = new Vector<SimplePairedValuesData>();
        PairedValues pairedValues = new PairedValues();
        Object object = (PairedValuesTableModel)this.jParameterReleaseTable.getModel();
        if (!(object instanceof PairedValuesTableModel)) {
            return;
        }
        object.storeData(pairedValues);
        JInputTSBasedRulePanel jInputTSBasedRulePanel = this;
        jInputTSBasedRulePanel.configureFlowPlot(jInputTSBasedRulePanel.jFlowReleasePlot);
        object = (String)this.jInterpCombo.getSelectedItem();
        this._elevReleaseData.setInterpolationType((String)object);
        object = "Elevation";
        if (this.jParameterReleaseTable != null) {
            object = this.jParameterReleaseTable.getColumnName(0);
        }
        this._elevReleaseData.yunits = object;
        this._elevReleaseData.resetData();
        this._elevReleaseData.setPlotXvsY(true);
        this._elevReleaseData.setData(pairedValues);
        vector.addElement(this._elevReleaseData);
        this.jFlowReleasePlot.setPlotObjects(vector);
        this.jFlowReleasePlot.paintGfx();
        this.jFlowReleasePlot.revalidate();
    }

    private void configureFlowPlot(G2dPanel g2dPanel) {
        PlotDefaults plotDefaults = PlotDefaultsManager.getDefaults();
        PlotDefaultsManager.setDefaults((PlotDefaults)new HotPlotDefaults());
        G2dPanelProp g2dPanelProp = new G2dPanelProp();
        new G2dPanelProp().hasTitle = false;
        g2dPanelProp.hasToolbar = false;
        g2dPanelProp.hasLegend = false;
        String string = "Elevation";
        if (this.jParameterReleaseTable != null) {
            string = this.jParameterReleaseTable.getColumnName(0);
        }
        G2dPlotProp g2dPlotProp = new G2dPlotProp();
        new G2dPlotProp().hasXScroll = false;
        g2dPlotProp.hasYScroll = false;
        g2dPlotProp.x1AxisProp.name = "Release (%S)";
        g2dPlotProp.y1AxisProp.name = string;
        g2dPlotProp.y1AxisProp.isReversed = true;
        g2dPanelProp.addPlotProp(g2dPlotProp);
        g2dPanel.configurePanel(g2dPanelProp);
        PlotDefaultsManager.setDefaults((PlotDefaults)plotDefaults);
    }

    public void setRuleRef(OpRuleRef opRuleRef) {
        if (opRuleRef == null) {
            return;
        }
        if (this.isModified()) {
            this.savePanel();
        }
        this._currentRuleRef = opRuleRef;
        this.fillPanel();
    }

    private SimplePairedValuesData getElevReleaseData() {
        SimplePairedValuesData simplePairedValuesData = new SimplePairedValuesData();
        new SimplePairedValuesData().xunits = "Release (%S)";
        String string = "Elevation";
        if (this.jParameterReleaseTable != null) {
            string = this.jParameterReleaseTable.getColumnName(0);
        }
        simplePairedValuesData.yunits = string;
        string = new PairedValues();
        string.setInterpolationType(0);
        simplePairedValuesData.setPlotXvsY(true);
        simplePairedValuesData.resetData();
        return simplePairedValuesData;
    }

    public void setParent(JPanel jPanel) {
        this._parent = (JOperationsPanel)((Object)jPanel);
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
    }

    @Override
    public void focusLost(FocusEvent object) {
        if ((object = object.getSource()) == this.jRuleTxt) {
            if (this.jRuleTxt.getText().equals("")) {
                this.jRuleTxt.setText(this._currentRuleRef.getRule().getName());
                RMAIO.postError((Component)((Object)this), (String)"Cannot have a blank Rule Name!");
                return;
            }
            this._currentRuleRef.getRule().setName(this.jRuleTxt.getText());
            this._currentRuleRef.setName(this.jRuleTxt.getText());
            ((JOperationsPanel)this._parent).treeDataChanged(0, this._oldRuleName, this.jRuleTxt.getText());
            return;
        }
        if (object == this.jParameterNameTxt) {
            object = new String[2];
            PairedValuesTableModel pairedValuesTableModel = (PairedValuesTableModel)this.jParameterReleaseTable.getModel();
            object[1] = pairedValuesTableModel.getColumnName(1);
            object[0] = this.jParameterNameTxt.getText();
            pairedValuesTableModel.setColumnNames(object);
            this.jParameterReleaseTable.setColumnLabels(object);
            this.paramReleaseReplot();
            object = SwingUtilities.windowForComponent((Component)((Object)this));
            ((RmaJDialog)object).updateUnitSystem((Container)((Object)this));
        }
    }

    public void deselectPanel() {
        if (this.isModified()) {
            this.savePanel();
        }
    }
}

