/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.clientapp.client.ClientApp;
import hec.gfx2d.G2dPanel;
import hec.gfx2d.G2dPanelProp;
import hec.gfx2d.G2dPlotProp;
import hec.gfx2d.HotPlotDefaults;
import hec.gfx2d.PlotDefaults;
import hec.gfx2d.PlotDefaultsManager;
import hec.model.PairedValues;
import hec.model.PairedValuesTableModel;
import hec.rss.client.JLeakageCardPanel$1;
import hec.rss.client.PhysicalTreeCardPanel;
import hec.rss.client.PhysicalTreeCardPanel$PhysicalG2dPanel;
import hec.rss.client.RSimTreeNode;
import hec.rss.gfx2d.SimpleJTableData;
import hec.rss.model.Dam;
import hec.rss.model.ReservoirDamElement;
import hec.rss.model.ReservoirElement;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.util.List;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.CellEditorListener;
import javax.swing.table.TableModel;
import rma.swing.RmaGridBagConstraints;
import rma.swing.RmaJTable;
import rma.swing.print.PageText;

public class JLeakageCardPanel
extends PhysicalTreeCardPanel {
    Dam _dam;
    SimpleJTableData _leakData = this.getLeakData();
    RmaJTable reLeakTable;
    PhysicalTreeCardPanel$PhysicalG2dPanel reLeakPlot;

    public JLeakageCardPanel() {
        JLeakageCardPanel jLeakageCardPanel = this;
        jLeakageCardPanel.buildSeepagePanel((JPanel)((Object)jLeakageCardPanel));
    }

    void buildSeepagePanel(JPanel serializable) {
        serializable.setLayout(new GridBagLayout());
        String[] stringArray = new JLabel("Leakage as a function of Reservior Elevation");
        serializable.add((Component)stringArray, new RmaGridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, INSETS5500, 0, 0));
        stringArray = new String[]{"Elevation (%S)", "Leakage(%S)"};
        this.reLeakTable = new RmaJTable((Component)serializable);
        this.reLeakTable.setModel((TableModel)new PairedValuesTableModel(stringArray, new boolean[]{true, true}));
        this.reLeakTable.setUnitsHeaderRenderer();
        ((PairedValuesTableModel)this.reLeakTable.getModel()).setShouldAddBlankRows(true);
        this.reLeakTable.setDoubleCellEditor();
        serializable.add(this.reLeakTable.getScrollPane(), new RmaGridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 1, INSETS5550, 0, 0));
        this.reLeakPlot = new PhysicalTreeCardPanel$PhysicalG2dPanel(this, "Leakage Curve: ");
        serializable.add((Component)((Object)this.reLeakPlot), new RmaGridBagConstraints(1, 1, 1, 1, 0.0, 1.0, 18, 0, INSETS5555, 100, 100));
        JLeakageCardPanel jLeakageCardPanel = this;
        jLeakageCardPanel.configureLeakPlot(jLeakageCardPanel.reLeakPlot);
        serializable = new Vector<SimpleJTableData>();
        ((Vector)serializable).addElement(this._leakData);
        this.reLeakPlot.setPlotObjects((List)((Object)serializable));
        this.reLeakTable.addCellEditorListener((CellEditorListener)new JLeakageCardPanel$1(this));
        this._controlsCreated = true;
    }

    private SimpleJTableData getLeakData() {
        SimpleJTableData simpleJTableData = new SimpleJTableData();
        new SimpleJTableData().xunits = "Leakage(%S)";
        simpleJTableData.yunits = "Elev(%S)";
        simpleJTableData.setData(null, -1, -1);
        return simpleJTableData;
    }

    @Override
    public void fillPanel(ReservoirElement object, RSimTreeNode rSimTreeNode) {
        super.fillPanel((ReservoirElement)object, rSimTreeNode);
        if (!this._controlsCreated) {
            this.createControls();
        }
        if (rSimTreeNode == null) {
            return;
        }
        object = rSimTreeNode.d();
        if (object == null || !(object instanceof ReservoirDamElement)) {
            return;
        }
        this._dam = ((ReservoirDamElement)object).getDamFunction();
        if (this._dam == null) {
            return;
        }
        if (this._currentReservoir == null) {
            return;
        }
        this.reLeakTable.commitEdit(true);
        ((PairedValuesTableModel)this.reLeakTable.getModel()).setPairedValues(this._dam.getLeakageValues());
        this.leakReplot();
        ClientApp.app();
        object = new String("Workspace: " + ClientApp.Workspace().getTitleName());
        object = (String)object + "\n ResSim System: " + this._currentReservoir.getSystem().getName();
        object = (String)object + "\n Reservoir: " + this._currentReservoir.getName();
        object = new String((String)object + "\n Loss Type: Leakage \n ");
        object = new PageText((String)object, 0);
        this.reLeakTable.setPrintTitle((PageText)object);
        this.setModified(false);
    }

    @Override
    public boolean savePanel() {
        if (!this.areControlsCreated()) {
            return true;
        }
        if (this._dam == null || this._currentReservoir == null) {
            return false;
        }
        this.reLeakTable.commitEdit(true);
        PairedValues pairedValues = new PairedValues();
        ((PairedValuesTableModel)this.reLeakTable.getModel()).storeData(pairedValues);
        this._dam.setLeakageValues(pairedValues);
        return true;
    }

    private void configureLeakPlot(G2dPanel g2dPanel) {
        PlotDefaults plotDefaults = PlotDefaultsManager.getDefaults();
        PlotDefaultsManager.setDefaults((PlotDefaults)new HotPlotDefaults());
        G2dPanelProp g2dPanelProp = new G2dPanelProp();
        new G2dPanelProp().hasTitle = false;
        g2dPanelProp.hasToolbar = false;
        g2dPanelProp.hasLegend = false;
        G2dPlotProp g2dPlotProp = new G2dPlotProp();
        new G2dPlotProp().hasXScroll = false;
        g2dPlotProp.hasYScroll = false;
        g2dPlotProp.x1AxisProp.name = "Leakage(%S)";
        g2dPlotProp.y1AxisProp.name = "Elev(%S)";
        g2dPlotProp.y1AxisProp.isReversed = true;
        g2dPanelProp.addPlotProp(g2dPlotProp);
        g2dPanel.configurePanel(g2dPanelProp);
        PlotDefaultsManager.setDefaults((PlotDefaults)plotDefaults);
    }

    private void leakReplot() {
        this._leakData.setData(this.reLeakTable, 1, 0);
        this._leakData.name = "Leakage";
        Vector<SimpleJTableData> vector = new Vector<SimpleJTableData>();
        vector.addElement(this._leakData);
        this.reLeakPlot.setPlotObjects(vector);
        this.reLeakPlot.paintGfx();
        this.reLeakPlot.revalidate();
    }
}

