/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.data.Parameter;
import hec.model.PairedValuesExt;
import hec.rss.client.PairedValuesExtPanel;
import hec.rss.client.PhysicalTreeCardPanel;
import hec.rss.client.RSimTreeNode;
import hec.rss.model.DivertedOutletElement;
import hec.rss.model.OutletGroupElement;
import hec.rss.model.ReservoirElement;
import java.awt.GridBagLayout;
import javax.swing.BorderFactory;
import rma.swing.RmaGridBagConstraints;
import rma.swing.table.RmaTableModel;

public class JOutletGroupCardPanel
extends PhysicalTreeCardPanel {
    PairedValuesExtPanel _compositeReleasePanel = new PairedValuesExtPanel(new String[]{"Elevation (%S)", "Controlled (%S)", "Uncontrolled (%S)", "Total (%S)"}, new String[]{"Elevation (%S)", "Flow (%S)", "Flow (%S)", "Flow (%S)"}, new int[]{Parameter.PARAMID_ELEV, Parameter.PARAMID_FLOW, Parameter.PARAMID_FLOW, Parameter.PARAMID_FLOW}, true);

    @Override
    public void createControls() {
        if (((PhysicalTreeCardPanel)this).areControlsCreated()) {
            return;
        }
        this.setLayout(new GridBagLayout());
        this._compositeReleasePanel.setBorder(BorderFactory.createTitledBorder("Composite Release Capacity"));
        JOutletGroupCardPanel jOutletGroupCardPanel = this;
        jOutletGroupCardPanel.add(jOutletGroupCardPanel._compositeReleasePanel, new RmaGridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 1, INSETS5500, 0, 0));
        this._compositeReleasePanel.setEnabled(false);
        this._controlsCreated = true;
        this.setModified(false);
    }

    @Override
    public boolean areControlsCreated() {
        return this._controlsCreated;
    }

    @Override
    public void fillPanel(ReservoirElement reservoirElement, RSimTreeNode object) {
        super.fillPanel(reservoirElement, (RSimTreeNode)object);
        if (!this._controlsCreated) {
            ((PhysicalTreeCardPanel)this).createControls();
        }
        if (object == null) {
            return;
        }
        if ((object = ((RSimTreeNode)object).d()) == null) {
            return;
        }
        String[] stringArray = new String[]{"Controlled Release Capacity", "Uncontrolled Release Capacity", "Total Release Capacity"};
        this._compositeReleasePanel.setPopupPlotLegendNames(stringArray);
        this._compositeReleasePanel.setPopupPlotTitle("Release Capacity: " + reservoirElement.getName() + "-" + object.getName());
        if (object instanceof OutletGroupElement) {
            reservoirElement = ((OutletGroupElement)object).getCompositeRelease();
            this._compositeReleasePanel.fillForm((PairedValuesExt)reservoirElement);
        } else if (object instanceof DivertedOutletElement) {
            reservoirElement = ((DivertedOutletElement)object).getCompositeRelease();
            this._compositeReleasePanel.fillForm((PairedValuesExt)reservoirElement);
        }
        this._compositeReleasePanel.setEnabled(false);
        reservoirElement = this._compositeReleasePanel.getTable();
        reservoirElement.setPrecision(1);
        RmaTableModel cfr_ignored_0 = (RmaTableModel)reservoirElement.getModel();
        this.setModified(false);
    }

    public void clearPanel() {
    }

    @Override
    public boolean savePanel() {
        if (!((PhysicalTreeCardPanel)this).areControlsCreated()) {
            return true;
        }
        return true;
    }
}

