/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.clientapp.client.ClientApp;
import hec.geometry.AxisProp;
import hec.gfx2d.G2dPanel;
import hec.gfx2d.G2dPanelProp;
import hec.gfx2d.G2dPlotProp;
import hec.gfx2d.HotPlotDefaults;
import hec.gfx2d.PlotDefaults;
import hec.gfx2d.PlotDefaultsManager;
import hec.gfx2d.SimplePairedValuesData;
import hec.lang.NamedType;
import hec.model.PairedValues;
import hec.model.PairedValuesTableModel;
import hec.model.SeasonalRecord;
import hec.rss.client.JOperationsPanel;
import hec.rss.client.JPowerGuideCurveRulePanel$1;
import hec.rss.client.JPowerGuideCurveRulePanel$MyG2dPanel;
import hec.rss.client.PowerGenerationDialog;
import hec.rss.model.OpRuleRef;
import hec.rss.model.PowerGuideCurveOpRule;
import hec.rss.model.StorageZone;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableModel;
import rma.swing.DefaultJPanel;
import rma.swing.RmaGridBagConstraints;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJDescriptionField;
import rma.swing.RmaJDialog;
import rma.swing.RmaJTable;
import rma.swing.RmaJTextField;
import rma.swing.list.RmaListModel;
import rma.swing.print.PageText;
import rma.util.RMAConst;
import rma.util.RMAIO;

public class JPowerGuideCurveRulePanel
extends DefaultJPanel
implements ActionListener,
FocusListener,
ItemListener,
CellEditorListener {
    Insets INSETS5555 = new Insets(5, 5, 5, 5);
    Insets INSETS5500 = new Insets(5, 5, 0, 0);
    Insets INSETS5505 = new Insets(5, 5, 0, 5);
    Insets INSETS5550 = new Insets(5, 5, 5, 0);
    String xUnits = new String("");
    String yUnits = new String("");
    String _oldRuleName = "";
    Vector _storageZoneList;
    OpRuleRef _currentRuleRef = null;
    SimplePairedValuesData _plantFactorData = this.getStorageVsPlantFactorData();
    DefaultJPanel _parent = null;
    RmaJComboBox jLimitCombo = new RmaJComboBox();
    RmaJComboBox jTopZoneCombo = new RmaJComboBox();
    RmaJComboBox jBottomZoneCombo = new RmaJComboBox();
    RmaJComboBox jInterpCombo = new RmaJComboBox();
    RmaJTextField jRuleTxt = new RmaJTextField();
    RmaJDescriptionField jRuleDescTxt = new RmaJDescriptionField();
    String[] colLabels = new String[]{"% Power Storage", "Plant Factor (%)"};
    boolean[] colEditable = new boolean[]{true, true};
    RmaJTable jPowerGuideCurveTable = new RmaJTable((Component)((Object)this));
    JPowerGuideCurveRulePanel$MyG2dPanel jPlantFactorPlot = new JPowerGuideCurveRulePanel$MyG2dPanel(this);
    JLabel jTopZoneLabel = new JLabel("Zone at Top of Power Pool:");
    JLabel jBottomZoneLabel = new JLabel("Zone at Bottom of Power Pool:");
    JLabel jRuleLabel = new JLabel("Hydropower - Power Guide Curve Rule:");
    JLabel jDescriptionLabel = new JLabel("Description:");
    JPanel jNameDescPanel = new JPanel();
    JPanel jOptionsPanel = new JPanel();
    JCheckBox jPowerBelowPoolCheck = new JCheckBox("Generate Power below Power Pool");

    public JPowerGuideCurveRulePanel() {
        this.setLayout(new GridBagLayout());
        this.jRuleTxt.setModifiable(false);
        this.jRuleTxt.setEditable(false);
        Object object = new RmaGridBagConstraints();
        this.jNameDescPanel.setLayout(new GridBagLayout());
        this.jNameDescPanel.add((Component)this.jRuleLabel, new RmaGridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 18, 0, this.INSETS5500, 0, 0));
        this.jNameDescPanel.add((Component)this.jRuleTxt, new RmaGridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 18, 2, this.INSETS5500, 0, 0));
        this.jNameDescPanel.add((Component)new JLabel(), new RmaGridBagConstraints(4, 0, 1, 1, 1.0, 0.0, 18, 2, this.INSETS5505, 0, 0));
        this.jNameDescPanel.add((Component)this.jDescriptionLabel, new RmaGridBagConstraints(0, 1, 1, 1, 0.0, 1.0, 18, 0, this.INSETS5500, 0, 0));
        this.jNameDescPanel.add((Component)this.jRuleDescTxt, new RmaGridBagConstraints(1, 1, 4, 1, 1.0, 1.0, 18, 2, this.INSETS5555, 0, 0));
        object.set(0, 0, 2, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0);
        JPowerGuideCurveRulePanel jPowerGuideCurveRulePanel = this;
        jPowerGuideCurveRulePanel.add(jPowerGuideCurveRulePanel.jNameDescPanel, object);
        JPanel jPanel = new JPanel(new GridBagLayout());
        object.set(0, 0, 1, 1, 0.0, 0.0, 18, 0, this.INSETS5500, 0, 0);
        jPanel.add((Component)this.jTopZoneLabel, object);
        object.set(1, 0, 1, 1, 1.0, 0.0, 18, 2, this.INSETS5505, 0, 0);
        jPanel.add((Component)this.jTopZoneCombo, object);
        object.set(0, 1, 1, 1, 0.0, 0.0, 18, 0, this.INSETS5500, 0, 0);
        jPanel.add((Component)this.jBottomZoneLabel, object);
        object.set(1, 1, 1, 1, 1.0, 0.0, 18, 2, this.INSETS5505, 0, 0);
        jPanel.add((Component)this.jBottomZoneCombo, object);
        object.set(0, 1, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0);
        this.add(jPanel, object);
        this.jPowerGuideCurveTable.setModel((TableModel)new PairedValuesTableModel(this.colLabels, this.colEditable));
        this.jPowerGuideCurveTable.setUnitsHeaderRenderer();
        this.jPowerGuideCurveTable.setDoubleCellEditor(0, false);
        this.jPowerGuideCurveTable.setDoubleCellEditor(1, false);
        ((PairedValuesTableModel)this.jPowerGuideCurveTable.getModel()).setShouldAddBlankRows(true);
        this.jPowerGuideCurveTable.setNumRows(10);
        JPowerGuideCurveRulePanel jPowerGuideCurveRulePanel2 = this;
        jPowerGuideCurveRulePanel2.add(jPowerGuideCurveRulePanel2.jPowerGuideCurveTable.getScrollPane(), new RmaGridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 18, 1, this.INSETS5555, 0, 0));
        jPanel = new JPanel(new GridBagLayout());
        object.set(1, 1, 1, 2, 0.0, 1.0, 12, 3, new Insets(0, 0, 0, 0), 0, 0);
        this.add(jPanel, object);
        object.set(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 5, 0, 5), 150, 120);
        jPanel.add((Component)((Object)this.jPlantFactorPlot), object);
        JButton jButton = new JButton("Power Generation Pattern...");
        object.set(0, 1, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 5, 0, 5), 0, 0);
        jPanel.add((Component)jButton, object);
        jButton.addActionListener(new JPowerGuideCurveRulePanel$1(this));
        JPowerGuideCurveRulePanel jPowerGuideCurveRulePanel3 = this;
        jPowerGuideCurveRulePanel3.configureFlowPlot(jPowerGuideCurveRulePanel3.jPlantFactorPlot);
        object = new Vector<SimplePairedValuesData>();
        object.addElement(this._plantFactorData);
        this.jPlantFactorPlot.setPlotObjects((List)object);
        this.jPowerGuideCurveTable.addCellEditorListener((CellEditorListener)this);
        this.jPowerGuideCurveTable.addCellEditorListener((CellEditorListener)this);
        JPowerGuideCurveRulePanel jPowerGuideCurveRulePanel4 = this;
        jPowerGuideCurveRulePanel4.addFocusListener(jPowerGuideCurveRulePanel4);
        this.jTopZoneCombo.addItemListener((ItemListener)this);
        this.jBottomZoneCombo.addItemListener((ItemListener)this);
    }

    @Override
    public void editingCanceled(ChangeEvent changeEvent) {
    }

    @Override
    public void editingStopped(ChangeEvent changeEvent) {
        this.plantFactorReplot();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        actionEvent.getSource();
    }

    protected void showGenerationPatternDlg() {
        Window window = SwingUtilities.windowForComponent((Component)((Object)this));
        PowerGenerationDialog powerGenerationDialog = window instanceof JFrame ? new PowerGenerationDialog((JFrame)window, "Power Generation Pattern", true) : new PowerGenerationDialog((JDialog)window, "Power Generation Pattern", true);
        powerGenerationDialog.pack();
        powerGenerationDialog.setLocationRelativeTo(window);
        powerGenerationDialog.fillPanel(((PowerGuideCurveOpRule)this._currentRuleRef.getRule()).getPowerPatternContainer());
        powerGenerationDialog.setVisible(true);
        if (powerGenerationDialog.isCanceled()) {
            return;
        }
        this.setModified(powerGenerationDialog.isModified());
    }

    public void fillPanel() {
        StorageZone storageZone;
        Vector vector;
        if (this._currentRuleRef == null) {
            return;
        }
        this.clearPanel();
        Object object = (PowerGuideCurveOpRule)this._currentRuleRef.getRule();
        this._oldRuleName = object.getName();
        this.jRuleTxt.setText(object.getName());
        this.jRuleDescTxt.setText(object.getDescription());
        NamedType namedType = ((JOperationsPanel)this._parent)._currentOpSet;
        this._storageZoneList = vector = namedType.getSortedZoneVector();
        if (vector == null) {
            return;
        }
        vector = (Vector)vector.clone();
        RmaListModel rmaListModel = new RmaListModel(false, (Collection)vector);
        this.jTopZoneCombo.setModel((ComboBoxModel)rmaListModel);
        rmaListModel = new RmaListModel(false, (Collection)vector);
        this.jBottomZoneCombo.setModel((ComboBoxModel)rmaListModel);
        int n = ((PowerGuideCurveOpRule)object).getTopPowerPoolStorageZoneId();
        int n2 = -1;
        if (n != Integer.MIN_VALUE && (storageZone = namedType.getZone(n)) != null) {
            n2 = this.getZoneListPosition(storageZone.getName());
        }
        int n3 = ((PowerGuideCurveOpRule)object).getBottomPowerPoolStorageZoneId();
        int n4 = -1;
        if (n3 != Integer.MIN_VALUE && (namedType = namedType.getZone(n3)) != null) {
            n4 = this.getZoneListPosition(namedType.getName());
        }
        this.jTopZoneCombo.setSelectedIndex(n2);
        this.jBottomZoneCombo.setSelectedIndex(n4);
        namedType = ((PowerGuideCurveOpRule)object).getPowerGuideCurve();
        ((PairedValuesTableModel)this.jPowerGuideCurveTable.getModel()).setPairedValues((PairedValues)namedType);
        ClientApp.app();
        object = new String("Workspace: " + ClientApp.Workspace().getTitleName());
        object = (String)object + "\n ResSim System: " + ((JOperationsPanel)this._parent)._reservoir.getSystem().getName();
        object = (String)object + "\n Reservoir: " + ((JOperationsPanel)this._parent)._reservoir.getName();
        object = (String)object + "\n Operation Set: " + ((JOperationsPanel)this._parent)._currentOpSet.getName();
        object = (String)object + "\n Hydropower - Power Guide Curve Rule: " + this._currentRuleRef.getName() + " \n ";
        object = new PageText((String)object, 0);
        this.jPowerGuideCurveTable.setPrintTitle((PageText)object);
        object = SwingUtilities.windowForComponent((Component)((Object)this));
        ((RmaJDialog)object).updateUnitSystem((Container)((Object)this));
        this.setModified(false);
        this.plantFactorReplot();
    }

    private int getZoneListPosition(String string) {
        if (this._storageZoneList == null || this._storageZoneList.size() <= 0 || string == null || string.length() <= 0) {
            return -1;
        }
        for (int i = 0; i < this._storageZoneList.size(); ++i) {
            StorageZone storageZone = (StorageZone)this._storageZoneList.elementAt(i);
            if (!string.equalsIgnoreCase(storageZone.getName())) continue;
            return i;
        }
        return -1;
    }

    public void clearPanel() {
        this.jBottomZoneCombo.removeAllItems();
        this.jTopZoneCombo.removeAllItems();
        this.jTopZoneCombo.setSelectedIndex(-1);
        this.jBottomZoneCombo.setSelectedIndex(-1);
        this.jPowerGuideCurveTable.clearCells();
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (itemEvent.getStateChange() == 2) {
            return;
        }
        if (object == this.jTopZoneCombo) {
            this.zoneCombo_itemStateChanged();
            return;
        }
        if (object == this.jBottomZoneCombo) {
            this.zoneCombo_itemStateChanged();
        }
    }

    public void zoneCombo_itemStateChanged() {
        this.setModified(true);
    }

    public void refresh() {
    }

    public boolean savePanel() {
        if (this._currentRuleRef == null) {
            return false;
        }
        if (this.jRuleTxt.getText().equals("")) {
            RMAIO.postError((Component)((Object)this), (String)"Cannot have an empty rule name!");
            return false;
        }
        PowerGuideCurveOpRule powerGuideCurveOpRule = (PowerGuideCurveOpRule)this._currentRuleRef.getRule();
        if (powerGuideCurveOpRule == null) {
            return false;
        }
        this._currentRuleRef.getRule().setName(this.jRuleTxt.getText());
        this._currentRuleRef.setName(this.jRuleTxt.getText());
        this._oldRuleName = this.jRuleTxt.getText();
        powerGuideCurveOpRule.setDescription(this.jRuleDescTxt.getText());
        int n = this.jTopZoneCombo.getSelectedIndex();
        int n2 = this.jBottomZoneCombo.getSelectedIndex();
        if (n >= 0 && n2 >= 0 && n > n2) {
            JOptionPane.showMessageDialog((Component)((Object)this), "The Top of Power Pool zone is below the\nBottom of Power Pool zone.", "Power Pool Zone Error", 2);
        }
        if (n >= 0 && n2 >= 0 && n == n2) {
            JOptionPane.showMessageDialog((Component)((Object)this), "The Top Power Pool zone is the same\nas the Bottom Power Pool zone.", "Power Pool Zone Error", 2);
        }
        StorageZone storageZone = (StorageZone)this.jTopZoneCombo.getSelectedItem();
        StorageZone storageZone2 = (StorageZone)this.jBottomZoneCombo.getSelectedItem();
        int n3 = Integer.MIN_VALUE;
        if (storageZone != null) {
            n3 = storageZone.getIndex();
        }
        int n4 = Integer.MIN_VALUE;
        if (storageZone2 != null) {
            n4 = storageZone2.getIndex();
        }
        powerGuideCurveOpRule.setTopPowerPoolStorageZoneId(n3);
        powerGuideCurveOpRule.setBottomPowerPoolStorageZoneId(n4);
        this.jPowerGuideCurveTable.commitEdit(true);
        PairedValuesTableModel pairedValuesTableModel = (PairedValuesTableModel)this.jPowerGuideCurveTable.getModel();
        storageZone2 = new PairedValues();
        pairedValuesTableModel.storeData((PairedValues)storageZone2);
        powerGuideCurveOpRule.setPowerGuideCurve((PairedValues)storageZone2);
        this.setModified(false);
        return true;
    }

    private void plantFactorReplot() {
        new Vector();
        AxisProp axisProp = (AxisProp)this.jPowerGuideCurveTable.getModel();
        if (!(axisProp instanceof PairedValuesTableModel)) {
            return;
        }
        axisProp = new PairedValues();
        PairedValuesTableModel pairedValuesTableModel = (PairedValuesTableModel)this.jPowerGuideCurveTable.getModel();
        pairedValuesTableModel.storeData((PairedValues)axisProp);
        if (axisProp.size() < 2) {
            return;
        }
        this.jPlantFactorPlot.setVisible(false);
        this._plantFactorData.setInterpolationType("Linear");
        this._plantFactorData.setPlotXvsY(true);
        this._plantFactorData.setData((PairedValues)axisProp);
        this._plantFactorData.name = "Hydropower - Power Guide Curve";
        this._plantFactorData.lineStyleName = "POWER-REQUIRED";
        axisProp = this.jPlantFactorPlot.getViewports();
        if (axisProp != null) {
            AxisProp axisProp2;
            AxisProp axisProp3;
            pairedValuesTableModel = this.jPlantFactorPlot.getViewportAxisTics(axisProp[0], 2);
            AxisProp axisProp4 = pairedValuesTableModel.getAxis().getAxisProp();
            if (axisProp3.getMaxScaleValue() < 100.0) {
                axisProp4.setMaxScaleValue(100.0);
            }
            if (axisProp4.getMinScaleValue() > 0.0) {
                axisProp4.setMinScaleValue(0.0);
            }
            pairedValuesTableModel.getAxis().setAxisProp(axisProp4);
            pairedValuesTableModel = this.jPlantFactorPlot.getViewportAxisTics(axisProp[0], 0);
            axisProp = pairedValuesTableModel.getAxis().getAxisProp();
            if (axisProp2.getMinScaleValue() > 0.0) {
                axisProp.setMinScaleValue(0.0);
            }
            pairedValuesTableModel.getAxis().setAxisProp(axisProp);
        }
        this.jPlantFactorPlot.setVisible(true);
    }

    private void configureFlowPlot(G2dPanel g2dPanel) {
        PlotDefaults plotDefaults = PlotDefaultsManager.getDefaults();
        PlotDefaultsManager.setDefaults((PlotDefaults)new HotPlotDefaults());
        G2dPanelProp g2dPanelProp = new G2dPanelProp();
        new G2dPanelProp().hasTitle = false;
        g2dPanelProp.hasToolbar = false;
        g2dPanelProp.hasLegend = false;
        G2dPlotProp g2dPlotProp = new G2dPlotProp();
        new G2dPlotProp().hasXScroll = false;
        g2dPlotProp.hasYScroll = false;
        g2dPlotProp.x1AxisProp.name = "Plant Factor (%)";
        g2dPlotProp.y1AxisProp.name = "% Power Storage";
        g2dPlotProp.y1AxisProp.isReversed = true;
        g2dPanelProp.addPlotProp(g2dPlotProp);
        g2dPanel.configurePanel(g2dPanelProp);
        PlotDefaultsManager.setDefaults((PlotDefaults)plotDefaults);
    }

    public void setRuleRef(OpRuleRef opRuleRef) {
        if (opRuleRef == null) {
            return;
        }
        if (this.isModified()) {
            this.savePanel();
        }
        this._currentRuleRef = opRuleRef;
        this.fillPanel();
    }

    private SimplePairedValuesData getStorageVsPlantFactorData() {
        SimplePairedValuesData simplePairedValuesData = new SimplePairedValuesData();
        new SimplePairedValuesData().xunits = "Plant Factor (%)";
        simplePairedValuesData.yunits = "% Power Storage";
        PairedValues pairedValues = new PairedValues();
        pairedValues.setInterpolationType(0);
        simplePairedValuesData.setPlotXvsY(true);
        simplePairedValuesData.resetData();
        return simplePairedValuesData;
    }

    public void setParent(JPanel jPanel) {
        this._parent = (JOperationsPanel)((Object)jPanel);
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        this.plantFactorReplot();
    }

    @Override
    public void focusLost(FocusEvent object) {
        if ((object = ((EventObject)object).getSource()) == this.jRuleTxt.getText()) {
            if (this.jRuleTxt.getText().equals("")) {
                this.jRuleTxt.setText(this._currentRuleRef.getRule().getName());
                RMAIO.postError((Component)((Object)this), (String)"Cannot have a blank Rule Name!");
                return;
            }
            this._currentRuleRef.getRule().setName(this.jRuleTxt.getText());
            this._currentRuleRef.setName(this.jRuleTxt.getText());
            ((JOperationsPanel)this._parent).treeDataChanged(0, this._oldRuleName, this.jRuleTxt.getText());
        }
    }

    public void deselectPanel() {
        if (this.isModified()) {
            this.savePanel();
        }
    }

    private boolean seasonalMultiplierIsDefault(SeasonalRecord object) {
        if (object == null) {
            return true;
        }
        double[] dArray = object.getDataArray();
        object = dArray;
        if (dArray != null && ((SeasonalRecord)object).length > 0) {
            for (int i = 1; i < ((SeasonalRecord)object).length; ++i) {
                if (object[i] == object[i - 1]) continue;
                return false;
            }
            if (RMAConst.isValidValue((double)object[0]) && object[0] != 0.0 && object[0] != 1.0) {
                return false;
            }
        }
        return true;
    }
}

