/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.gui.PanelSelector;
import hec.rss.client.JControllerCardPanel;
import hec.rss.client.OperatingLimitsPanel;
import hec.rss.client.PhysicalTreeCardPanel;
import hec.rss.client.PlantCapacityPanel;
import hec.rss.client.PlantEfficiencyPanel;
import hec.rss.client.PlantHydLossesPanel;
import hec.rss.client.PlantStationUsePanel;
import hec.rss.client.RSimTreeNode;
import hec.rss.model.AdjustableFlow;
import hec.rss.model.PowerPlant;
import hec.rss.model.ReservoirElement;
import java.awt.Component;
import java.awt.GridBagLayout;
import javax.swing.JTabbedPane;
import rma.swing.RmaGridBagConstraints;
import rma.swing.RmaJDialog;

public class JPowerPlantCardPanel
extends PhysicalTreeCardPanel {
    JControllerCardPanel _outletPanel;
    PlantCapacityPanel _capacityPanel;
    PlantEfficiencyPanel _efficiencyPanel;
    PlantStationUsePanel _stationUsePanel;
    PlantHydLossesPanel _hydLossesPanel;
    OperatingLimitsPanel _opLimitsPanel;
    PanelSelector _panelSelector;
    PowerPlant _powerPlant;
    JTabbedPane _tabbedPane;

    public JPowerPlantCardPanel() {
        this.buildComponents();
    }

    @Override
    public void fillPanel(ReservoirElement element, RSimTreeNode rSimTreeNode) {
        super.fillPanel((ReservoirElement)element, rSimTreeNode);
        if (!this._controlsCreated) {
            this.createControls();
        }
        element = rSimTreeNode.d();
        AdjustableFlow adjustableFlow = (AdjustableFlow)element.getFunction();
        element = (ReservoirElement)element.getTopParent();
        this.fillPanel(adjustableFlow.getPowerPlant(), (ReservoirElement)element, rSimTreeNode);
    }

    protected void fillPanel(PowerPlant powerPlant, ReservoirElement reservoirElement, RSimTreeNode rSimTreeNode) {
        String string = this.getFullName();
        this._powerPlant = powerPlant;
        ((PhysicalTreeCardPanel)this._outletPanel).fillPanel(reservoirElement, rSimTreeNode);
        this._capacityPanel.fillPanel(this._powerPlant);
        this._efficiencyPanel.fillPanel(this._powerPlant, string);
        this._stationUsePanel.fillPanel(this._powerPlant, string);
        this._hydLossesPanel.fillPanel(this._powerPlant, string);
        this._opLimitsPanel.fillPanel(this._powerPlant);
    }

    @Override
    public boolean savePanel() {
        if (!this.areControlsCreated()) {
            return true;
        }
        ((PhysicalTreeCardPanel)this._outletPanel).savePanel();
        this._capacityPanel.savePanel();
        this._efficiencyPanel.savePanel();
        this._stationUsePanel.savePanel();
        this._hydLossesPanel.savePanel();
        this._opLimitsPanel.savePanel();
        return true;
    }

    void buildComponents() {
        this.setLayout(new GridBagLayout());
        this._outletPanel = new JControllerCardPanel();
        this._capacityPanel = new PlantCapacityPanel();
        this._efficiencyPanel = new PlantEfficiencyPanel();
        this._stationUsePanel = new PlantStationUsePanel();
        this._hydLossesPanel = new PlantHydLossesPanel();
        this._opLimitsPanel = new OperatingLimitsPanel();
        this._tabbedPane = new JTabbedPane();
        this._tabbedPane.add(this._outletPanel.getTabname(), (Component)((Object)this._outletPanel));
        this._tabbedPane.add(this._capacityPanel.getTabname(), (Component)((Object)this._capacityPanel));
        this._tabbedPane.add(this._efficiencyPanel.getTabname(), (Component)((Object)this._efficiencyPanel));
        this._tabbedPane.add(this._stationUsePanel.getTabname(), (Component)((Object)this._stationUsePanel));
        this._tabbedPane.add(this._hydLossesPanel.getTabname(), (Component)((Object)this._hydLossesPanel));
        this._tabbedPane.add(this._opLimitsPanel.getTabname(), (Component)((Object)this._opLimitsPanel));
        JPowerPlantCardPanel jPowerPlantCardPanel = this;
        jPowerPlantCardPanel.add(jPowerPlantCardPanel._tabbedPane, new RmaGridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, INSETS5555, 0, 0));
        this._controlsCreated = true;
        this.setModified(false);
    }

    @Override
    public void setParent(RmaJDialog rmaJDialog) {
        super.setParent(rmaJDialog);
        this._outletPanel.setParent(this._parent);
    }
}

