/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.clientapp.client.ClientApp;
import hec.data.Parameter;
import hec.data.Units;
import hec.heclib.util.HecTime;
import hec.rss.client.JPrescribedOpRulePanel;
import hec.rss.model.PrescribedOpItem;
import hec.rss.model.RssTSLocationObject;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.JOptionPane;
import rma.swing.table.AbstractRmaTableModel;
import rma.util.RMAIO;

class JPrescribedOpRulePanel$PrescribedTableModel
extends AbstractRmaTableModel {
    private List<PrescribedOpItem> _data = new ArrayList<PrescribedOpItem>();
    private Map<PrescribedOpItem, Map<String, Double>> _opValueStore = new HashMap<PrescribedOpItem, Map<String, Double>>();
    final /* synthetic */ JPrescribedOpRulePanel this$0;

    public JPrescribedOpRulePanel$PrescribedTableModel(JPrescribedOpRulePanel jPrescribedOpRulePanel, String[] stringArray) {
        this.this$0 = jPrescribedOpRulePanel;
        this.m_columnNames = stringArray;
    }

    public List<PrescribedOpItem> getData() {
        ArrayList<PrescribedOpItem> arrayList = new ArrayList<PrescribedOpItem>(this._data.size());
        for (int i = 0; i < this._data.size(); ++i) {
            arrayList.add(this._data.get(i).clone());
        }
        return arrayList;
    }

    public void setData(List<PrescribedOpItem> list) {
        this._data.clear();
        if (list != null) {
            this._data.addAll(list);
            for (int i = 0; i < this._data.size(); ++i) {
                PrescribedOpItem prescribedOpItem = this._data.get(i);
                HecTime hecTime = prescribedOpItem.getStartTime();
                if (hecTime != null) {
                    hecTime.showTimeAsBeginningOfDay(true);
                }
                PrescribedOpItem prescribedOpItem2 = prescribedOpItem;
                this.setValueColMapData(prescribedOpItem2, prescribedOpItem2.getValue(), i, false);
            }
        }
        this.fireTableDataChanged();
    }

    public int getRowCount() {
        return this._data.size();
    }

    public Object getValueAt(int n, int n2) {
        if (n < 0 || n >= this._data.size()) {
            return null;
        }
        if (n2 < 0 || n2 >= this.m_columnNames.length) {
            return null;
        }
        PrescribedOpItem prescribedOpItem = this._data.get(n);
        switch (n2) {
            case 0: {
                return n + 1;
            }
            case 1: {
                Object object = prescribedOpItem.getStartTime();
                if (object == null) {
                    return null;
                }
                object = object.dateAndTime(4);
                object = RMAIO.removeChar((String)object, (char)',');
                object = RMAIO.removeChar((String)object, (char)':');
                return object;
            }
            case 2: {
                Object object = prescribedOpItem.getEndTime();
                if (object == null) {
                    return null;
                }
                object = object.dateAndTime(4);
                object = RMAIO.removeChar((String)object, (char)',');
                object = RMAIO.removeChar((String)object, (char)':');
                return object;
            }
            case 3: {
                return prescribedOpItem.getOpCodeString();
            }
            case 4: {
                int n3;
                boolean bl = prescribedOpItem.isValueNotUsed();
                n = bl ? 1 : 0;
                if (bl) {
                    return null;
                }
                double d = prescribedOpItem.getValue();
                n = prescribedOpItem.getUnitsParamId();
                n2 = ((RssTSLocationObject)this.this$0._currentRuleRef.getRule()).getSystem().getUnitSystem();
                if (n2 == (n3 = ClientApp.frame().getDisplayUnitSystem()) || n == -1) {
                    return d;
                }
                try {
                    return Units.convertUnits((double)d, (int)n, (int)n2, (int)n3);
                }
                catch (Exception exception) {
                    System.out.println("getValueAt:conversion error " + String.valueOf(exception));
                    return d;
                }
            }
            case 5: {
                n = prescribedOpItem.getUnitsParamId();
                try {
                    String string = Parameter.getUnitsStringForSystem((int)n, (int)ClientApp.frame().getDisplayUnitSystem());
                    if ("undef".equalsIgnoreCase(string)) {
                        return "";
                    }
                    return string;
                }
                catch (Exception exception) {
                    return "";
                }
            }
        }
        return null;
    }

    public PrescribedOpItem getPrescribedOpItem(int n) {
        return this._data.get(n);
    }

    public void setValueAt(Object object, int n, int n2) {
        if (n < 0 || n >= this._data.size()) {
            return;
        }
        if (n2 < 0 || n2 >= this.m_columnNames.length) {
            return;
        }
        if (object == null) {
            object = "";
        }
        PrescribedOpItem prescribedOpItem = this._data.get(n);
        switch (n2) {
            case 0: {
                break;
            }
            case 1: {
                HecTime hecTime = new HecTime();
                hecTime.showTimeAsBeginningOfDay(true);
                hecTime.set(object.toString());
                if (n > 0) {
                    HecTime hecTime2 = this.getStartTimeAt(n - 1);
                    if (hecTime.isDefined() && hecTime2 != null && hecTime2.isDefined() && hecTime.lessThanEqualTo(hecTime2)) {
                        if (this.this$0.shouldShowMessage()) {
                            JOptionPane.showMessageDialog((Component)((Object)this.this$0), "Start times must be in increasing order.", "Invalid Start Date", 2);
                        }
                        return;
                    }
                    this.checkTableTimes(n, false);
                }
                if (prescribedOpItem.getEndTime() != null && prescribedOpItem.getEndTime().isDefined() && !hecTime.lessThanEqualTo(prescribedOpItem.getEndTime())) {
                    if (this.this$0.shouldShowMessage()) {
                        JOptionPane.showMessageDialog((Component)((Object)this.this$0), "Start Date/Time must be before End Date/time", "Invalid Date", 2);
                    }
                    return;
                }
                prescribedOpItem.setStartTime(hecTime);
                break;
            }
            case 2: {
                HecTime hecTime = this.this$0.checkEndDateTime(object, n);
                if (hecTime != null && prescribedOpItem.getStartTime() != null && prescribedOpItem.getStartTime().isDefined() && !hecTime.greaterThanEqualTo(prescribedOpItem.getStartTime())) {
                    if (this.this$0.shouldShowMessage()) {
                        JOptionPane.showMessageDialog((Component)((Object)this.this$0), "End Date/Time must be after Start Date/time", "Invalid Date", 2);
                    }
                    return;
                }
                prescribedOpItem.setEndTime(hecTime);
                break;
            }
            case 3: {
                Double d = this.setOpColMapData(prescribedOpItem, object);
                prescribedOpItem.setOpCodeString(object.toString());
                prescribedOpItem.setValue(d);
                break;
            }
            case 4: {
                double d = this.setValueColMapData(prescribedOpItem, object, n, true);
                prescribedOpItem.setValue(d);
            }
        }
        this.fireTableCellUpdated(n, n2);
        if (n2 == 3) {
            this.fireTableCellUpdated(n, 4);
            this.fireTableCellUpdated(n, 5);
        }
    }

    private double setValueColMapData(PrescribedOpItem prescribedOpItem, Object object, int n, boolean bl) {
        int n2;
        Map<String, Double> map = this._opValueStore.get(prescribedOpItem);
        if (map == null) {
            map = new HashMap<String, Double>();
            this._opValueStore.put(prescribedOpItem, map);
        }
        double d = RMAIO.parseDouble((Object)object);
        int n3 = prescribedOpItem.getUnitsParamId();
        int n4 = ((RssTSLocationObject)this.this$0._currentRuleRef.getRule()).getSystem().getUnitSystem();
        if (n4 != (n2 = ClientApp.frame().getDisplayUnitSystem()) && n3 != -1 && bl) {
            try {
                double d2;
                d = d2 = Units.convertUnits((double)d, (int)n3, (int)n2, (int)n4);
            }
            catch (Exception exception) {
                System.out.println("setValueAt:conversion error " + String.valueOf(exception));
            }
        }
        map.put((String)this.getValueAt(n, 3), d);
        return d;
    }

    private Double setOpColMapData(PrescribedOpItem serializable, Object object) {
        Map<String, Double> map = this._opValueStore.get(serializable);
        if (map == null) {
            map = new HashMap<String, Double>();
            this._opValueStore.put((PrescribedOpItem)serializable, map);
            map.put(object.toString(), 0.0);
        }
        if ((serializable = map.get(object.toString())) == null) {
            serializable = Double.valueOf(0.0);
        }
        return serializable;
    }

    public boolean checkTableTimes(int n, boolean bl) {
        if (!this.this$0.shouldShowMessage()) {
            return true;
        }
        int n2 = this.getRowCount();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int objectArray = 0; objectArray < n2 - 1; ++objectArray) {
            PrescribedOpItem prescribedOpItem = this._data.get(objectArray);
            PrescribedOpItem prescribedOpItem2 = this._data.get(objectArray + 1);
            HecTime hecTime = prescribedOpItem.getStartTime();
            HecTime hecTime2 = prescribedOpItem2.getStartTime();
            if (hecTime != null && hecTime2 != null && hecTime.isDefined() && hecTime2.isDefined() && !prescribedOpItem.getStartTime().lessThanEqualTo(prescribedOpItem2.getStartTime()) && objectArray != n) {
                JOptionPane.showMessageDialog((Component)((Object)this.this$0), "Start times must be in increasing order.\nRow " + (objectArray + 1) + " start time is not earilier or equal to row " + (objectArray + 2), "Invalid Start Date", 2);
                return false;
            }
            if (!prescribedOpItem.isEndTimeReqd() || (hecTime = prescribedOpItem.getEndTime()) != null && hecTime.isDefined()) continue;
            arrayList.add(objectArray + 1);
        }
        if (arrayList.size() > 0) {
            Object[] objectArray = arrayList.toArray();
            String string = Arrays.toString(objectArray);
            string = RMAIO.removeChar((String)string, (char)'[');
            string = RMAIO.removeChar((String)string, (char)']');
            string = RMAIO.removeChar((String)string, (char)' ');
            string = string.replace(',', '\n');
            JOptionPane.showMessageDialog((Component)((Object)this.this$0), "Missing end date for row(s):\n" + string, "Missing End Date", 2);
        }
        return true;
    }

    private HecTime getStartTimeAt(int n) {
        if (n < 0 || n >= this._data.size()) {
            return null;
        }
        PrescribedOpItem prescribedOpItem = this._data.get(n);
        return prescribedOpItem.getStartTime();
    }

    public void addRow(Vector cloneable) {
        cloneable = new PrescribedOpItem();
        this._data.add((PrescribedOpItem)cloneable);
        JPrescribedOpRulePanel$PrescribedTableModel jPrescribedOpRulePanel$PrescribedTableModel = this;
        jPrescribedOpRulePanel$PrescribedTableModel.fireTableRowsInserted(jPrescribedOpRulePanel$PrescribedTableModel._data.size(), this._data.size());
    }

    public void clearAll() {
        this._data.clear();
        this._opValueStore.clear();
        this.fireTableDataChanged();
    }

    public void deleteRow(int n) {
        PrescribedOpItem prescribedOpItem = this._data.get(n);
        this._opValueStore.remove(prescribedOpItem);
        this._data.remove(n);
        int n2 = n;
        this.fireTableRowsDeleted(n2, n2);
    }

    public boolean isCellEditable(int n, int n2) {
        if (n2 == 0 || n2 == 5) {
            return false;
        }
        PrescribedOpItem prescribedOpItem = this._data.get(n);
        if (prescribedOpItem == null) {
            return true;
        }
        if (n2 == 4) {
            return !prescribedOpItem.isValueNotUsed();
        }
        return true;
    }

    public void insertRow(int n, Vector cloneable) {
        cloneable = new PrescribedOpItem();
        this._data.add(n, (PrescribedOpItem)cloneable);
        int n2 = n;
        this.fireTableRowsInserted(n2, n2);
    }
}

