/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.heclib.util.HecTime;
import hec.rss.client.JOperationsPanel;
import hec.rss.client.JPrescribedOpRulePanel$1;
import hec.rss.client.JPrescribedOpRulePanel$2;
import hec.rss.client.JPrescribedOpRulePanel$3;
import hec.rss.client.JPrescribedOpRulePanel$4;
import hec.rss.client.JPrescribedOpRulePanel$5;
import hec.rss.client.JPrescribedOpRulePanel$6;
import hec.rss.client.JPrescribedOpRulePanel$PrescribedTableModel;
import hec.rss.model.OpRuleRef;
import hec.rss.model.PrescribedOpItem;
import hec.rss.model.PrescribedOpRule;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemListener;
import java.util.EventObject;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.table.TableModel;
import rma.swing.DefaultJPanel;
import rma.swing.RmaInsets;
import rma.swing.RmaJDescriptionField;
import rma.swing.RmaJTable;
import rma.swing.RmaJTextField;
import rma.util.RMAIO;

public class JPrescribedOpRulePanel
extends DefaultJPanel
implements FocusListener,
ItemListener {
    private OpRuleRef _currentRuleRef = null;
    private DefaultJPanel _parent = null;
    private RmaJTextField _jRuleTxt;
    private RmaJDescriptionField _jRuleDescTxt;
    private JLabel _jRuleLabel;
    private JPanel _jNameDescPanel;
    private RmaJTable _jRuleTable;
    private JButton _jAddRowBtn;
    private JButton _jDeleteRowBtn;
    private JPrescribedOpRulePanel$PrescribedTableModel _jRuleTableModel;
    private String _oldRuleName = "";
    private String[] _headers;
    private JButton _jInsertRowBtn;
    private boolean _fillingPanel;
    private boolean _clearingTable;

    public JPrescribedOpRulePanel() {
        super((LayoutManager)new GridBagLayout());
        this.buildControls();
        this.addListeners();
    }

    protected void buildControls() {
        this._jNameDescPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        JPrescribedOpRulePanel jPrescribedOpRulePanel = this;
        jPrescribedOpRulePanel.add(jPrescribedOpRulePanel._jNameDescPanel, gridBagConstraints);
        this._jRuleLabel = new JLabel("Prescribed Release Rule");
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        JComponent jComponent = new JLabel("Rule Name:");
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this._jNameDescPanel.add((Component)jComponent, gridBagConstraints);
        this._jRuleTxt = new JPrescribedOpRulePanel$1(this);
        this._jRuleTxt.setEditable(false);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this._jNameDescPanel.add((Component)this._jRuleTxt, gridBagConstraints);
        jComponent = new JLabel("Description:");
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this._jNameDescPanel.add((Component)jComponent, gridBagConstraints);
        this._jRuleDescTxt = new RmaJDescriptionField();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this._jNameDescPanel.add((Component)this._jRuleDescTxt, gridBagConstraints);
        this._headers = new String[]{"Index", "Start Date/Time", "End Date/Time", "Operator", "Value", "Units"};
        JPrescribedOpRulePanel jPrescribedOpRulePanel2 = this;
        this._jRuleTable = new JPrescribedOpRulePanel$2(jPrescribedOpRulePanel2, (Component)((Object)jPrescribedOpRulePanel2), this._headers);
        this._jRuleTable.setRowHeight(this._jRuleTable.getRowHeight() + 5);
        this.initTable();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        JPrescribedOpRulePanel jPrescribedOpRulePanel3 = this;
        jPrescribedOpRulePanel3.add(jPrescribedOpRulePanel3._jRuleTable.getScrollPane(), gridBagConstraints);
        jComponent = new JPanel(new GridBagLayout());
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this.add(jComponent, gridBagConstraints);
        this._jAddRowBtn = new JButton("Append Row");
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        jComponent.add((Component)this._jAddRowBtn, gridBagConstraints);
        this._jInsertRowBtn = new JButton("Insert Row(s)");
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        jComponent.add((Component)this._jInsertRowBtn, gridBagConstraints);
        this._jDeleteRowBtn = new JButton("Delete Row");
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        jComponent.add((Component)this._jDeleteRowBtn, gridBagConstraints);
        this.tableSelectedAction();
    }

    private void initTable() {
        JPrescribedOpRulePanel jPrescribedOpRulePanel = this;
        this._jRuleTableModel = new JPrescribedOpRulePanel$PrescribedTableModel(jPrescribedOpRulePanel, jPrescribedOpRulePanel._headers);
        this._jRuleTable.setModel((TableModel)((Object)this._jRuleTableModel));
        this._jRuleTable.setHorizontalAlignment(0, 0);
        this._jRuleTable.setDateTimeCellEditor(1);
        this._jRuleTable.setDateTimeCellEditor(2);
        this._jRuleTable.setComboBoxEditor(3, new Object[0]);
        this._jRuleTable.setDoubleCellEditor(4);
        this._jRuleTable.setColumnWidths(new int[]{48, 110, 110, 100, 70, 70});
    }

    private String getTableToolTip(int n, int n2) {
        PrescribedOpItem prescribedOpItem;
        if (n2 == 3 && this._jRuleTableModel != null && (prescribedOpItem = this._jRuleTableModel.getData().get(n)) != null) {
            return prescribedOpItem.getOpCodeDescription();
        }
        return null;
    }

    private void addListeners() {
        this._jRuleTxt.addFocusListener((FocusListener)this);
        this._jAddRowBtn.addActionListener(new JPrescribedOpRulePanel$3(this));
        this._jDeleteRowBtn.addActionListener(new JPrescribedOpRulePanel$4(this));
        this._jInsertRowBtn.addActionListener(new JPrescribedOpRulePanel$5(this));
        this._jRuleTable.getSelectionModel().addListSelectionListener(new JPrescribedOpRulePanel$6(this));
    }

    protected void tableSelectedAction() {
        int n = this._jRuleTable.getSelectedRow();
        this._jDeleteRowBtn.setEnabled(n >= 0);
    }

    protected void deleteRowAction() {
        int[] nArray = this._jRuleTable.getSelectedRows();
        if (nArray == null || nArray.length == 0) {
            this.tableSelectedAction();
            return;
        }
        int n = JOptionPane.showConfirmDialog((Component)((Object)this), "OK to delete the selected rows?", "Confirm Delete", 0);
        if (n != 0) {
            return;
        }
        this._jRuleTable.deleteRow();
    }

    protected void addRowAction() {
        this._jRuleTable.appendRow();
    }

    protected void insertRowAction() {
        this._jRuleTable.insertRow();
    }

    public void fillPanel() {
        if (this._currentRuleRef == null) {
            return;
        }
        this.clearPanel();
        Object object = (PrescribedOpRule)this._currentRuleRef.getRule();
        this._oldRuleName = object.getName();
        Object[] objectArray = ((PrescribedOpRule)object).getOperators();
        this._jRuleTable.setComboBoxEditor(3, objectArray);
        this._jRuleTxt.setText(object.getName());
        this._jRuleDescTxt.setText(object.getDescription());
        object = ((PrescribedOpRule)object).getOpItemList();
        this._jRuleTableModel.setData((List<PrescribedOpItem>)object);
        if (this._jRuleTable.getRowCount() == 0) {
            this._jRuleTable.setNumRows(1);
        }
        this.setModified(false);
    }

    public void refresh() {
    }

    private boolean shouldShowMessage() {
        Window window = SwingUtilities.windowForComponent((Component)((Object)this));
        return window.isVisible() && !this._clearingTable;
    }

    public boolean savePanel() {
        int n;
        if (!this._fillingPanel) {
            n = this._jRuleTableModel.getRowCount();
            for (int i = 0; i < n; ++i) {
                JPrescribedOpRulePanel jPrescribedOpRulePanel = this;
                if (jPrescribedOpRulePanel.checkEndDateTime(jPrescribedOpRulePanel._jRuleTable.getValueAt(i, 2), i) != null) continue;
                return false;
            }
        }
        n = this._jRuleTableModel.checkTableTimes(-1, true) ? 1 : 0;
        this._jRuleTable.commitEdit(true);
        PrescribedOpRule prescribedOpRule = (PrescribedOpRule)this._currentRuleRef.getRule();
        if (prescribedOpRule == null) {
            return false;
        }
        this._currentRuleRef.getRule().setName(this._jRuleTxt.getText());
        this._currentRuleRef.setName(this._jRuleTxt.getText());
        this._oldRuleName = this._jRuleTxt.getText();
        prescribedOpRule.setDescription(this._jRuleDescTxt.getText());
        prescribedOpRule.setOpItemList(this._jRuleTableModel.getData());
        if (n != 0) {
            this.setModified(false);
            return true;
        }
        return false;
    }

    public void clearPanel() {
        this._jRuleLabel.setText("");
        this._jRuleDescTxt.clearPerformed();
        this.initTable();
    }

    public void setRuleRef(OpRuleRef opRuleRef) {
        if (opRuleRef == null) {
            return;
        }
        this._fillingPanel = true;
        try {
            if (this.isModified()) {
                this.savePanel();
            }
            this._currentRuleRef = opRuleRef;
            this.fillPanel();
            return;
        }
        finally {
            this._fillingPanel = false;
        }
    }

    public void setParent(JPanel jPanel) {
        this._parent = (JOperationsPanel)((Object)jPanel);
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
    }

    @Override
    public void focusLost(FocusEvent object) {
        if ((object = ((EventObject)object).getSource()) == this._jRuleTxt) {
            if (this._jRuleTxt.getText().equals("")) {
                this._jRuleTxt.setText(this._currentRuleRef.getRule().getName());
                RMAIO.postError((Component)((Object)this), (String)"Cannot have a blank Rule Name!");
                return;
            }
            this._currentRuleRef.getRule().setName(this._jRuleTxt.getText());
            this._currentRuleRef.setName(this._jRuleTxt.getText());
            ((JOperationsPanel)this._parent).treeDataChanged(0, this._oldRuleName, this._jRuleTxt.getText());
        }
    }

    public void deselectPanel() {
        if (this.isModified()) {
            this.savePanel();
        }
    }

    private HecTime checkEndDateTime(Object object, int n) {
        HecTime hecTime = new HecTime();
        if (object == null) {
            object = "";
        }
        hecTime.set(object.toString());
        if (!hecTime.isDefined()) {
            object = this._jRuleTableModel.getPrescribedOpItem(n);
            ((PrescribedOpItem)object).setEndTime(hecTime);
            if (((PrescribedOpItem)object).isEndTimeReqd() && this.shouldShowMessage()) {
                JOptionPane.showMessageDialog((Component)this._parent, "End time is required for a Delta Elev or Target Elev prescription.\nIf left blank, the prescription will be ignored by the compute", "Missing End Time", 2);
                return null;
            }
        }
        return hecTime;
    }
}

