/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.clientapp.client.ClientApp;
import hec.data.ParamDouble;
import hec.data.Parameter;
import hec.gfx2d.G2dPanel;
import hec.gfx2d.HotPlotDefaults;
import hec.gfx2d.PlotDefaults;
import hec.gfx2d.PlotDefaultsManager;
import hec.gfx2d.PlotLayout;
import hec.gfx2d.ViewportLayout;
import hec.model.PairedValuesTableModel;
import hec.rss.RssRmiWorkspace;
import hec.rss.client.IntakeGeometryPanel;
import hec.rss.client.JPumpCardPanel$1;
import hec.rss.client.JPumpCardPanel$2;
import hec.rss.client.JPumpCardPanel$3;
import hec.rss.client.JPumpCardPanel$4;
import hec.rss.client.JPumpCardPanel$5;
import hec.rss.client.JPumpCardPanel$6;
import hec.rss.client.JPumpCardPanel$OperatingLimitTableModel;
import hec.rss.client.PhysicalTreeCardPanel;
import hec.rss.client.RSimTreeNode;
import hec.rss.gfx2d.SimpleJTableData;
import hec.rss.model.AdjustableFlow;
import hec.rss.model.IntakeGeometry;
import hec.rss.model.Pump;
import hec.rss.model.ReservoirElement;
import hec.rss.server.RssAdvancedOptions;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import java.rmi.RemoteException;
import javax.swing.ComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.event.CellEditorListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import rma.swing.RmaGridBagConstraints;
import rma.swing.RmaInsets;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJDecimalField;
import rma.swing.RmaJIntegerField;
import rma.swing.RmaJLabel;
import rma.swing.RmaJTable;
import rma.swing.list.RmaListModel;
import rma.swing.table.RowHeaderRenderer;

public class JPumpCardPanel
extends PhysicalTreeCardPanel {
    Pump m_pump = null;
    IntakeGeometryPanel m_intakeGeometryPanel = new IntakeGeometryPanel();
    JPanel m_capacityCardPanel = new JPanel(new CardLayout());
    RmaJComboBox m_capacityComboBox = new RmaJComboBox((ComboBoxModel)new RmaListModel(false, (Object[])new String[]{"Constant", "Function of Operating Head"}));
    RmaJIntegerField m_numPumpsTxt = new RmaJIntegerField();
    RmaJDecimalField m_constantCapacityTxt = new RmaJDecimalField();
    IntakeGeometryPanel intakeGeometryPanel = new IntakeGeometryPanel();
    RmaJTable m_operatingLimitsTable;
    RmaJTable m_pumpCapacityTable;
    G2dPanel m_pumpCapacityPlot;
    SimpleJTableData m_pumpCapacityPlotData;

    public JPumpCardPanel() {
        JPumpCardPanel jPumpCardPanel = this;
        this.m_operatingLimitsTable = new JPumpCardPanel$1(jPumpCardPanel, (Component)((Object)jPumpCardPanel));
        JPumpCardPanel jPumpCardPanel2 = this;
        this.m_pumpCapacityTable = new JPumpCardPanel$2(jPumpCardPanel2, (Component)((Object)jPumpCardPanel2));
        this.m_pumpCapacityPlot = new JPumpCardPanel$3(this);
        this.m_pumpCapacityPlotData = new SimpleJTableData();
        this.buildControls();
    }

    private void buildControls() {
        this.setLayout(new GridBagLayout());
        JPanel jPanel = new JPanel(new GridBagLayout());
        RmaGridBagConstraints rmaGridBagConstraints = new RmaGridBagConstraints();
        rmaGridBagConstraints.set(0, 0, 1, 1, 1.0, 0.0, 18, 2, RmaInsets.INSETS5505, 0, 100);
        this.add(jPanel, rmaGridBagConstraints);
        JComponent jComponent = new JLabel("Number of Pumps");
        rmaGridBagConstraints.set(0, 0, 1, 1, 0.0, 0.0, 17, 0, RmaInsets.INSETS5500, 0, 0);
        jPanel.add((Component)jComponent, rmaGridBagConstraints);
        rmaGridBagConstraints.set(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0);
        jPanel.add((Component)this.m_numPumpsTxt, rmaGridBagConstraints);
        this.m_numPumpsTxt.setMinValue(0);
        this.m_numPumpsTxt.addFocusListener((FocusListener)new JPumpCardPanel$4(this));
        jComponent = new JLabel("Operating Limits");
        rmaGridBagConstraints.set(0, 1, 1, 1, 0.0, 0.0, 18, 0, RmaInsets.INSETS5505, 0, 0);
        jPanel.add((Component)jComponent, rmaGridBagConstraints);
        this.m_operatingLimitsTable.setModel((TableModel)((Object)new JPumpCardPanel$OperatingLimitTableModel(this)));
        this.m_operatingLimitsTable.setUnitsHeaderRenderer();
        this.m_operatingLimitsTable.setPrecision(2);
        this.m_operatingLimitsTable.setAddRemoveEnabled(false);
        jComponent = new RowHeaderRenderer();
        jComponent.setHorizontalAlignment(0);
        this.m_operatingLimitsTable.setColumnWidth(0, 50);
        this.m_operatingLimitsTable.getColumnModel().getColumn(0).setCellRenderer((TableCellRenderer)((Object)jComponent));
        this.m_operatingLimitsTable.setDoubleCellEditor(1, 2, true);
        jComponent = new JScrollPane((Component)this.m_operatingLimitsTable);
        rmaGridBagConstraints.set(1, 1, 1, 1, 1.0, 1.0, 18, 1, RmaInsets.INSETS5505, 0, 0);
        jPanel.add((Component)jComponent, rmaGridBagConstraints);
        rmaGridBagConstraints.set(2, 0, 1, 2, 0.0, 0.0, 12, 0, RmaInsets.INSETS5505, 0, 0);
        jPanel.add((Component)this.m_intakeGeometryPanel, rmaGridBagConstraints);
        jComponent = new JLabel("Pump Capacity");
        rmaGridBagConstraints.set(0, 2, 1, 1, 0.0, 0.0, 18, 0, RmaInsets.INSETS5500, 0, 0);
        jPanel.add((Component)jComponent, rmaGridBagConstraints);
        rmaGridBagConstraints.set(1, 2, 1, 1, 1.0, 0.0, 18, 2, RmaInsets.INSETS5505, 0, 0);
        jPanel.add((Component)this.m_capacityComboBox, rmaGridBagConstraints);
        this.m_capacityComboBox.setModifiable(true);
        this.m_capacityComboBox.addActionListener((ActionListener)new JPumpCardPanel$5(this));
        jPanel = new JPanel(new GridBagLayout());
        rmaGridBagConstraints.set(0, 3, 1, 1, 1.0, 1.0, 18, 1, RmaInsets.INSETS0000, 0, 0);
        this.add(jPanel, rmaGridBagConstraints);
        rmaGridBagConstraints.set(0, 1, 2, 1, 1.0, 0.0, 18, 2, RmaInsets.INSETS5505, 0, 0);
        jPanel.add((Component)new JSeparator(), rmaGridBagConstraints);
        rmaGridBagConstraints.set(0, 2, 2, 1, 1.0, 1.0, 18, 1, RmaInsets.INSETS0000, 0, 0);
        jPanel.add((Component)this.m_capacityCardPanel, rmaGridBagConstraints);
        jPanel = new JPanel(new GridBagLayout());
        this.m_capacityCardPanel.add("Constant", jPanel);
        jComponent = new RmaJLabel("Capacity (%S)");
        jComponent.setLabelFor((Component)this.m_constantCapacityTxt);
        rmaGridBagConstraints.set(0, 0, 1, 1, 0.0, 1.0, 18, 0, RmaInsets.INSETS5550, 0, 0);
        jPanel.add((Component)jComponent, rmaGridBagConstraints);
        rmaGridBagConstraints.set(1, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 5, 300), 0, 0);
        jPanel.add((Component)this.m_constantCapacityTxt, rmaGridBagConstraints);
        jPanel = new JPanel(new GridBagLayout());
        this.m_capacityCardPanel.add("Function of Operating Head", jPanel);
        rmaGridBagConstraints.set(0, 0, 1, 1, 1.0, 1.0, 18, 1, RmaInsets.INSETS5550, 0, 0);
        this.m_pumpCapacityTable.setModel((TableModel)new PairedValuesTableModel(new String[]{"Operating Head (%S)", "Pump Capacity (%S)"}, new boolean[]{true, true}));
        this.m_pumpCapacityTable.setUnitsHeaderRenderer();
        ((PairedValuesTableModel)this.m_pumpCapacityTable.getModel()).setShouldAddBlankRows(true);
        this.m_pumpCapacityTable.setDoubleCellEditor(true);
        this.m_pumpCapacityTable.setPrecision(2);
        jPanel.add((Component)new JScrollPane((Component)this.m_pumpCapacityTable), rmaGridBagConstraints);
        this.m_pumpCapacityTable.addCellEditorListener((CellEditorListener)new JPumpCardPanel$6(this));
        this.m_pumpCapacityTable.getRowCount();
        jComponent = PlotDefaultsManager.getDefaults();
        PlotDefaultsManager.setDefaults((PlotDefaults)new HotPlotDefaults());
        PlotLayout plotLayout = new PlotLayout();
        plotLayout.setHasLegend(false);
        plotLayout.setHasToolbar(false);
        ViewportLayout viewportLayout = plotLayout.addViewport();
        viewportLayout.addCurve("Y1", (Object)this.m_pumpCapacityPlotData);
        this.m_pumpCapacityPlotData.setYAxisType(0);
        this.m_pumpCapacityPlotData.setXAxisType(0);
        this.m_pumpCapacityPlotData.xunits = "Capacity (%S)";
        this.m_pumpCapacityPlotData.yunits = "Head (%S)";
        this.m_pumpCapacityPlotData.setData(this.m_pumpCapacityTable, 1, 0);
        this.m_pumpCapacityPlot.buildComponents(plotLayout);
        rmaGridBagConstraints.set(1, 0, 1, 1, 0.0, 1.0, 12, 0, RmaInsets.INSETS5505, 0, 0);
        jPanel.add((Component)this.m_pumpCapacityPlot, rmaGridBagConstraints);
        PlotDefaultsManager.setDefaults((PlotDefaults)jComponent);
    }

    public String getTabname() {
        return "Pump";
    }

    @Override
    public void fillPanel(ReservoirElement reservoirElement, RSimTreeNode rSimTreeNode) {
        this.fillPanel(((AdjustableFlow)rSimTreeNode.d().getFunction()).getPump(), reservoirElement);
    }

    public void fillPanel(Pump pump, ReservoirElement reservoirElement) {
        this.m_pump = pump;
        ((PairedValuesTableModel)this.m_pumpCapacityTable.getModel()).setPairedValues(this.m_pump.getPumpCapacityFunction());
        ((JPumpCardPanel$OperatingLimitTableModel)((Object)this.m_operatingLimitsTable.getModel())).setPairedValues(this.m_pump.getOperatingLimitFunction());
        int n = this.m_pump.getNumberOfPumps();
        this.m_numPumpsTxt.setValue(n);
        this.m_operatingLimitsTable.setNumRows(n);
        n = this.m_pump.getPumpCapacityType();
        switch (n) {
            case 0: {
                this.m_capacityComboBox.setSelectedItem((Object)"Constant");
                break;
            }
            case 1: {
                this.m_capacityComboBox.setSelectedItem((Object)"Function of Operating Head");
            }
        }
        this.m_constantCapacityTxt.setValue(new ParamDouble(this.m_pump.getPumpCapacityConstant(), Parameter.PARAMID_FLOW, reservoirElement.getUnitSystem()));
        this.plotData();
        ClientApp.app();
        Object object = (RssRmiWorkspace)ClientApp.Workspace().getChildWorkspace("rss");
        try {
            object = object.getRssAdvancedOptions();
            this.m_intakeGeometryPanel.setVisible(((RssAdvancedOptions)object).hasWaterQuality());
        }
        catch (RemoteException remoteException) {
            object = remoteException;
            remoteException.printStackTrace();
        }
        object = this.m_pump.getAdjustableFlow().getIntakeGeometry();
        this.m_intakeGeometryPanel.fillForm((IntakeGeometry)object);
    }

    @Override
    public boolean savePanel() {
        if (this.m_pump == null) {
            return true;
        }
        int n = this.m_numPumpsTxt.getValue();
        this.m_pump.setNumberOfPumps(n);
        if (this.m_capacityComboBox.getSelectedItem() == "Constant") {
            this.m_pump.setPumpCapacityType(0);
        } else {
            this.m_pump.setPumpCapacityType(1);
        }
        double d = this.m_constantCapacityTxt.getValue();
        this.m_pump.setPumpCapacityConstant(d);
        this.m_pumpCapacityTable.commitEdit(true);
        this.m_operatingLimitsTable.commitEdit(true);
        ((PairedValuesTableModel)this.m_pumpCapacityTable.getModel()).storeData(this.m_pump.getPumpCapacityFunction());
        ((JPumpCardPanel$OperatingLimitTableModel)((Object)this.m_operatingLimitsTable.getModel())).storeData(this.m_pump.getOperatingLimitFunction());
        this.plotData();
        this.m_intakeGeometryPanel.saveForm(this.m_pump.getAdjustableFlow().getIntakeGeometry());
        return true;
    }

    private void plotData() {
        this.m_pumpCapacityPlotData.setData(this.m_pumpCapacityTable, 1, 0);
        this.m_pumpCapacityPlot.repaint();
    }
}

