/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.data.ParamDouble;
import hec.rss.client.JOperationsPanel;
import hec.rss.model.OpRuleRef;
import hec.rss.model.RateChangeElevLimitOpRule;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.Serializable;
import java.util.EventObject;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import rma.swing.DefaultJPanel;
import rma.swing.RmaGridBagConstraints;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJDecimalField;
import rma.swing.RmaJDialog;
import rma.swing.RmaJLabel;
import rma.swing.RmaJRadioButton;
import rma.swing.RmaJTextField;
import rma.util.RMAIO;

public class JRateChangeElevLimitRulePanel
extends DefaultJPanel
implements FocusListener,
ItemListener {
    OpRuleRef _currentRuleRef = null;
    DefaultJPanel _parent = null;
    Insets INSETS5505 = new Insets(5, 5, 0, 5);
    Insets INSETS5500 = new Insets(5, 5, 0, 0);
    Insets INSETS5550 = new Insets(5, 5, 5, 0);
    Insets INSETS0500 = new Insets(0, 5, 0, 0);
    Insets INSETS5555 = new Insets(5, 5, 5, 5);
    String _oldRuleName = "";
    RmaJTextField jRuleTxt = new RmaJTextField();
    RmaJTextField jRuleDescTxt = new RmaJTextField();
    JLabel jRuleLabel = new JLabel("Elevation Rate of Change Limit:");
    JLabel jDescriptionLabel = new JLabel("Description:");
    JPanel jNameDescPanel = new JPanel();
    JLabel jTypeLbl = new JLabel("Type:");
    RmaJComboBox jTypeCombo = new RmaJComboBox();
    RmaJRadioButton jRadioInstantaneous = new RmaJRadioButton("Instantaneous");
    RmaJRadioButton jRadioPeriodAverage = new RmaJRadioButton("Period Average");
    JPanel jChangePanel = new JPanel();
    RmaJLabel jRateChangeLbl = new RmaJLabel("Max Rate of Change (%S/hr):");
    RmaJDecimalField jRateChangeTxt = new RmaJDecimalField();
    RmaJLabel jPeriodChangeLbl = new RmaJLabel("over");
    RmaJLabel jPeriodChangeLbl2 = new RmaJLabel("hours");
    RmaJDecimalField jPeriodChangeTxt = new RmaJDecimalField();

    public JRateChangeElevLimitRulePanel() {
        this.setLayout(new GridBagLayout());
        this.jNameDescPanel.setLayout(new GridBagLayout());
        this.jNameDescPanel.add((Component)this.jRuleLabel, new RmaGridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 18, 0, this.INSETS5500, 0, 0));
        this.jNameDescPanel.add((Component)this.jDescriptionLabel, new RmaGridBagConstraints(0, 1, 1, 1, 0.0, 1.0, 18, 0, this.INSETS5500, 0, 0));
        this.jNameDescPanel.add((Component)this.jRuleTxt, new RmaGridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 18, 2, this.INSETS5500, 0, 0));
        this.jNameDescPanel.add((Component)new JLabel(), new RmaGridBagConstraints(4, 0, 1, 1, 1.0, 0.0, 18, 2, this.INSETS5505, 0, 0));
        this.jNameDescPanel.add((Component)this.jRuleDescTxt, new RmaGridBagConstraints(1, 1, 4, 1, 1.0, 1.0, 18, 2, this.INSETS5555, 0, 0));
        this.jNameDescPanel.add((Component)this.jTypeLbl, new RmaGridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, this.INSETS5500, 0, 0));
        this.jTypeCombo.addItem((Object)"Increasing");
        this.jTypeCombo.addItem((Object)"Decreasing");
        this.jNameDescPanel.add((Component)this.jTypeCombo, new RmaGridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 0, 0), 0, 0));
        JRateChangeElevLimitRulePanel jRateChangeElevLimitRulePanel = this;
        jRateChangeElevLimitRulePanel.add(jRateChangeElevLimitRulePanel.jNameDescPanel, new RmaGridBagConstraints(0, 0, 3, 2, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        Serializable serializable = new JPanel();
        ((Container)serializable).setLayout(new GridBagLayout());
        this.add((Component)serializable, new RmaGridBagConstraints(0, 3, 2, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        ((Container)serializable).add((Component)this.jRadioInstantaneous, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 0, new Insets(10, 5, 0, 5), 0, 0));
        ((Container)serializable).add((Component)this.jRadioPeriodAverage, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 18, 0, new Insets(0, 5, 10, 5), 0, 0));
        this.jChangePanel.setLayout(new GridBagLayout());
        JRateChangeElevLimitRulePanel jRateChangeElevLimitRulePanel2 = this;
        jRateChangeElevLimitRulePanel2.add(jRateChangeElevLimitRulePanel2.jChangePanel, new RmaGridBagConstraints(0, 4, 3, 1, 1.0, 1.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.jChangePanel.add((Component)this.jRateChangeLbl, new RmaGridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, this.INSETS0500, 0, 0));
        this.jChangePanel.add((Component)this.jRateChangeTxt, new RmaGridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 18, 0, this.INSETS0500, 40, 0));
        this.jChangePanel.add((Component)this.jPeriodChangeLbl, new RmaGridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 18, 0, this.INSETS0500, 0, 0));
        this.jChangePanel.add((Component)this.jPeriodChangeTxt, new RmaGridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 18, 0, this.INSETS0500, 40, 0));
        this.jChangePanel.add((Component)this.jPeriodChangeLbl2, new RmaGridBagConstraints(4, 0, 1, 1, 1.0, 0.0, 18, 0, this.INSETS0500, 0, 0));
        this.jRateChangeLbl.setLabelFor((Component)this.jRateChangeTxt);
        serializable = new ButtonGroup();
        ((ButtonGroup)serializable).add((AbstractButton)this.jRadioInstantaneous);
        ((ButtonGroup)serializable).add((AbstractButton)this.jRadioPeriodAverage);
        this.jRadioInstantaneous.setSelected(true);
        this.jTypeCombo.addItemListener((ItemListener)this);
        this.jRadioInstantaneous.addItemListener((ItemListener)this);
        this.jRadioPeriodAverage.addItemListener((ItemListener)this);
        this.jRuleTxt.addFocusListener((FocusListener)this);
    }

    public void fillPanel() {
        if (this._currentRuleRef == null) {
            return;
        }
        this.clearPanel();
        RateChangeElevLimitOpRule rateChangeElevLimitOpRule = (RateChangeElevLimitOpRule)this._currentRuleRef.getRule();
        rateChangeElevLimitOpRule.getController().getName();
        this._oldRuleName = rateChangeElevLimitOpRule.getName();
        this.jRuleTxt.setText(rateChangeElevLimitOpRule.getName());
        this.jRuleDescTxt.setText(rateChangeElevLimitOpRule.getDescription());
        this.jTypeCombo.removeItemListener((ItemListener)this);
        this.jRadioInstantaneous.removeItemListener((ItemListener)this);
        this.jRadioPeriodAverage.removeItemListener((ItemListener)this);
        if (rateChangeElevLimitOpRule.getType() == 1) {
            this.jTypeCombo.setSelectedItem((Object)"Increasing");
        } else {
            this.jTypeCombo.setSelectedItem((Object)"Decreasing");
        }
        if (rateChangeElevLimitOpRule.isInstantaneous()) {
            this.jRadioInstantaneous.setSelected(true);
        } else {
            this.jRadioPeriodAverage.setSelected(true);
        }
        ParamDouble paramDouble = new ParamDouble();
        rateChangeElevLimitOpRule.getMaxRateOfChange(paramDouble);
        this.jRateChangeTxt.setValue(paramDouble);
        if (rateChangeElevLimitOpRule.isInstantaneous()) {
            this.setInstantaneousMode();
        } else {
            this.jPeriodChangeTxt.setValue(rateChangeElevLimitOpRule.getPeriodAverageTime());
            this.setPeriodAverageMode();
        }
        this.jRadioInstantaneous.addItemListener((ItemListener)this);
        this.jRadioPeriodAverage.addItemListener((ItemListener)this);
        this.jTypeCombo.addItemListener((ItemListener)this);
    }

    @Override
    public void itemStateChanged(ItemEvent object) {
        if (((ItemEvent)object).getStateChange() != 1) {
            return;
        }
        if ((object = ((EventObject)object).getSource()) == this.jTypeCombo) {
            this.setModified(true);
        }
        if (object == this.jRadioInstantaneous) {
            this.setInstantaneousMode();
        } else if (object == this.jRadioPeriodAverage) {
            this.setPeriodAverageMode();
        }
        this.setModified(true);
    }

    private void setInstantaneousMode() {
        this.jRateChangeLbl.setText("Max Rate of Change (%S/hr)");
        this.jPeriodChangeLbl.setVisible(false);
        this.jPeriodChangeTxt.setVisible(false);
        this.jPeriodChangeLbl2.setText(" ");
        Window window = SwingUtilities.windowForComponent((Component)((Object)this));
        ((RmaJDialog)window).updateUnitSystem((Container)((Object)this));
    }

    private void setPeriodAverageMode() {
        this.jRateChangeLbl.setText("Max Change of (%S)");
        this.jPeriodChangeLbl.setVisible(true);
        this.jPeriodChangeTxt.setVisible(true);
        this.jPeriodChangeLbl2.setText("hours");
        Window window = SwingUtilities.windowForComponent((Component)((Object)this));
        ((RmaJDialog)window).updateUnitSystem((Container)((Object)this));
    }

    public void refresh() {
    }

    public boolean savePanel() {
        RateChangeElevLimitOpRule rateChangeElevLimitOpRule = (RateChangeElevLimitOpRule)this._currentRuleRef.getRule();
        if (rateChangeElevLimitOpRule == null) {
            return false;
        }
        this._currentRuleRef.getRule().setName(this.jRuleTxt.getText());
        this._currentRuleRef.setName(this.jRuleTxt.getText());
        this._oldRuleName = this.jRuleTxt.getText();
        rateChangeElevLimitOpRule.setDescription(this.jRuleDescTxt.getText());
        String string = (String)this.jTypeCombo.getSelectedItem();
        if (string.equals("Increasing")) {
            rateChangeElevLimitOpRule.setType(1);
        } else {
            rateChangeElevLimitOpRule.setType(0);
        }
        rateChangeElevLimitOpRule.setInstantaneous(this.jRadioInstantaneous.isSelected());
        rateChangeElevLimitOpRule.setMaxRateOfChange(this.jRateChangeTxt.getParamValue());
        if (this.jRadioPeriodAverage.isSelected()) {
            rateChangeElevLimitOpRule.setPeriodAverageTime(this.jPeriodChangeTxt.getValueUndefined());
        }
        return true;
    }

    public void clearPanel() {
        this.jRateChangeTxt.setText("");
        this.jTypeCombo.addItemListener((ItemListener)this);
    }

    public void setRuleRef(OpRuleRef opRuleRef) {
        if (opRuleRef == null) {
            return;
        }
        if (this.isModified()) {
            this.savePanel();
        }
        this._currentRuleRef = opRuleRef;
        this.fillPanel();
    }

    public void setParent(JPanel jPanel) {
        this._parent = (JOperationsPanel)((Object)jPanel);
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
    }

    @Override
    public void focusLost(FocusEvent object) {
        if ((object = ((EventObject)object).getSource()) == this.jRuleTxt) {
            if (this.jRuleTxt.getText().equals("")) {
                this.jRuleTxt.setText(this._currentRuleRef.getRule().getName());
                RMAIO.postError((Component)((Object)this), (String)"Cannot have a blank Rule Name!");
                return;
            }
            this._currentRuleRef.getRule().setName(this.jRuleTxt.getText());
            this._currentRuleRef.setName(this.jRuleTxt.getText());
            ((JOperationsPanel)this._parent).treeDataChanged(0, this._oldRuleName, this.jRuleTxt.getText());
        }
    }

    public void deselectPanel() {
        if (this.isModified()) {
            this.savePanel();
        }
    }
}

