/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.data.ParamDouble;
import hec.rss.client.JOperationsPanel;
import hec.rss.model.OpRuleRef;
import hec.rss.model.RateChangeLimitOpRule;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.EventObject;
import javax.swing.JLabel;
import javax.swing.JPanel;
import rma.swing.DefaultJPanel;
import rma.swing.RmaGridBagConstraints;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJDecimalField;
import rma.swing.RmaJLabel;
import rma.swing.RmaJTextField;
import rma.util.RMAIO;

public class JRateChangeLimitRulePanel
extends DefaultJPanel
implements FocusListener,
ItemListener {
    OpRuleRef _currentRuleRef = null;
    DefaultJPanel _parent = null;
    Insets INSETS5505 = new Insets(5, 5, 0, 5);
    Insets INSETS5500 = new Insets(5, 5, 0, 0);
    Insets INSETS5550 = new Insets(5, 5, 5, 0);
    Insets INSETS5555 = new Insets(5, 5, 5, 5);
    String _oldRuleName = "";
    RmaJTextField jRuleTxt = new RmaJTextField();
    RmaJTextField jRuleDescTxt = new RmaJTextField();
    JLabel jRuleLabel = new JLabel("Flow Rate of Change Limit");
    JLabel jDescriptionLabel = new JLabel("Description");
    JPanel jNameDescPanel = new JPanel();
    JLabel jParameterLbl = new JLabel("Parameter");
    JLabel jTypeLbl = new JLabel("Type");
    RmaJLabel jMaxRateChangeLbl = new RmaJLabel("Max Rate of Change (%S/hr)");
    RmaJDecimalField jMaxChangeTxt = new RmaJDecimalField();
    RmaJComboBox jTypeCombo = new RmaJComboBox();

    public JRateChangeLimitRulePanel() {
        this.setLayout(new GridBagLayout());
        this.jNameDescPanel.setLayout(new GridBagLayout());
        this.jNameDescPanel.add((Component)this.jRuleLabel, new RmaGridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 18, 0, this.INSETS5500, 0, 0));
        this.jNameDescPanel.add((Component)this.jDescriptionLabel, new RmaGridBagConstraints(0, 1, 1, 1, 0.0, 1.0, 18, 0, this.INSETS5500, 0, 0));
        this.jNameDescPanel.add((Component)this.jRuleTxt, new RmaGridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 18, 2, this.INSETS5500, 0, 0));
        this.jNameDescPanel.add((Component)new JLabel(), new RmaGridBagConstraints(4, 0, 1, 1, 1.0, 0.0, 18, 2, this.INSETS5505, 0, 0));
        this.jNameDescPanel.add((Component)this.jRuleDescTxt, new RmaGridBagConstraints(1, 1, 4, 1, 1.0, 1.0, 18, 2, this.INSETS5555, 0, 0));
        JRateChangeLimitRulePanel jRateChangeLimitRulePanel = this;
        jRateChangeLimitRulePanel.add(jRateChangeLimitRulePanel.jNameDescPanel, new RmaGridBagConstraints(0, 0, 3, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        JRateChangeLimitRulePanel jRateChangeLimitRulePanel2 = this;
        jRateChangeLimitRulePanel2.add(jRateChangeLimitRulePanel2.jTypeLbl, new RmaGridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, this.INSETS5500, 0, 0));
        this.jTypeCombo.addItem((Object)"Increasing");
        this.jTypeCombo.addItem((Object)"Decreasing");
        JRateChangeLimitRulePanel jRateChangeLimitRulePanel3 = this;
        jRateChangeLimitRulePanel3.add((Component)jRateChangeLimitRulePanel3.jTypeCombo, new RmaGridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 0, 200), 0, 0));
        JRateChangeLimitRulePanel jRateChangeLimitRulePanel4 = this;
        jRateChangeLimitRulePanel4.add((Component)jRateChangeLimitRulePanel4.jMaxRateChangeLbl, new RmaGridBagConstraints(0, 3, 1, 1, 0.0, 1.0, 18, 0, this.INSETS5550, 0, 0));
        JRateChangeLimitRulePanel jRateChangeLimitRulePanel5 = this;
        jRateChangeLimitRulePanel5.add((Component)jRateChangeLimitRulePanel5.jMaxChangeTxt, new RmaGridBagConstraints(1, 3, 1, 1, 1.0, 1.0, 18, 2, new Insets(5, 5, 5, 200), 0, 0));
        this.jMaxRateChangeLbl.setLabelFor((Component)this.jMaxChangeTxt);
        this.jTypeCombo.addItemListener((ItemListener)this);
        this.jRuleTxt.addFocusListener((FocusListener)this);
    }

    public void fillPanel() {
        if (this._currentRuleRef == null) {
            return;
        }
        this.clearPanel();
        RateChangeLimitOpRule rateChangeLimitOpRule = (RateChangeLimitOpRule)this._currentRuleRef.getRule();
        this._oldRuleName = rateChangeLimitOpRule.getName();
        this.jRuleTxt.setText(rateChangeLimitOpRule.getName());
        this.jRuleDescTxt.setText(rateChangeLimitOpRule.getDescription());
        this.jTypeCombo.removeItemListener((ItemListener)this);
        if (rateChangeLimitOpRule.getType() == 1) {
            this.jTypeCombo.setSelectedItem((Object)"Increasing");
        } else {
            this.jTypeCombo.setSelectedItem((Object)"Decreasing");
        }
        ParamDouble paramDouble = new ParamDouble();
        rateChangeLimitOpRule.getMaxRateOfChange(paramDouble);
        this.jMaxChangeTxt.setValue(paramDouble);
        this.jTypeCombo.addItemListener((ItemListener)this);
    }

    @Override
    public void itemStateChanged(ItemEvent object) {
        if (((ItemEvent)object).getStateChange() == 2) {
            return;
        }
        if ((object = ((EventObject)object).getSource()) == this.jTypeCombo) {
            this.setModified(true);
        }
    }

    public void refresh() {
    }

    public boolean savePanel() {
        RateChangeLimitOpRule rateChangeLimitOpRule = (RateChangeLimitOpRule)this._currentRuleRef.getRule();
        if (rateChangeLimitOpRule == null) {
            return false;
        }
        this._currentRuleRef.getRule().setName(this.jRuleTxt.getText());
        this._currentRuleRef.setName(this.jRuleTxt.getText());
        this._oldRuleName = this.jRuleTxt.getText();
        rateChangeLimitOpRule.setDescription(this.jRuleDescTxt.getText());
        String string = (String)this.jTypeCombo.getSelectedItem();
        if (string.equals("Increasing")) {
            rateChangeLimitOpRule.setType(1);
        } else {
            rateChangeLimitOpRule.setType(0);
        }
        rateChangeLimitOpRule.setMaxRateOfChange(this.jMaxChangeTxt.getParamValue());
        return true;
    }

    public void clearPanel() {
        this.jTypeCombo.removeItemListener((ItemListener)this);
        this.jTypeCombo.setSelectedIndex(0);
        this.jMaxChangeTxt.setText("");
        this.jTypeCombo.addItemListener((ItemListener)this);
    }

    public void setRuleRef(OpRuleRef opRuleRef) {
        if (opRuleRef == null) {
            return;
        }
        if (this.isModified()) {
            this.savePanel();
        }
        this._currentRuleRef = opRuleRef;
        this.fillPanel();
    }

    public void setParent(JPanel jPanel) {
        this._parent = (JOperationsPanel)((Object)jPanel);
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
    }

    @Override
    public void focusLost(FocusEvent object) {
        if ((object = ((EventObject)object).getSource()) == this.jRuleTxt) {
            if (this.jRuleTxt.getText().equals("")) {
                this.jRuleTxt.setText(this._currentRuleRef.getRule().getName());
                RMAIO.postError((Component)((Object)this), (String)"Cannot have a blank Rule Name!");
                return;
            }
            this._currentRuleRef.getRule().setName(this.jRuleTxt.getText());
            this._currentRuleRef.setName(this.jRuleTxt.getText());
            ((JOperationsPanel)this._parent).treeDataChanged(0, this._oldRuleName, this.jRuleTxt.getText());
        }
    }

    public void deselectPanel() {
        if (this.isModified()) {
            this.savePanel();
        }
    }
}

