/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.clientapp.client.ClientApp;
import hec.gfx2d.G2dPanel;
import hec.gfx2d.G2dPanelProp;
import hec.gfx2d.G2dPlotProp;
import hec.gfx2d.HotPlotDefaults;
import hec.gfx2d.PlotDefaults;
import hec.gfx2d.PlotDefaultsManager;
import hec.gfx2d.SimplePairedValuesData;
import hec.model.PairedValues;
import hec.rss.client.JOperationsPanel;
import hec.rss.client.ReservoirJFrame;
import hec.rss.client.RisingFallingCondDialog;
import hec.rss.model.OpRuleRef;
import hec.rss.model.ReleaseFunctionInflowOpRule;
import hec.rss.model.ReleaseInflowTableModel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.Serializable;
import java.util.EventObject;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableModel;
import rma.swing.DefaultJPanel;
import rma.swing.RmaGridBagConstraints;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJDialog;
import rma.swing.RmaJDssPathPartField;
import rma.swing.RmaJFrame;
import rma.swing.RmaJTable;
import rma.swing.RmaJTextField;
import rma.swing.print.PageText;
import rma.util.RMAIO;

public class JReleaseInflowRulePanel
extends DefaultJPanel
implements ActionListener,
FocusListener,
ItemListener,
CellEditorListener {
    public static final String INFLOW_RATIO = "Ratio";
    public static final String INFLOW_CONSTANT = "Release";
    Insets INSETS5555 = new Insets(5, 5, 5, 5);
    Insets INSETS5500 = new Insets(5, 5, 0, 0);
    Insets INSETS5505 = new Insets(5, 5, 0, 5);
    Insets INSETS5550 = new Insets(5, 5, 5, 0);
    String xUnits = new String("");
    String yUnits = new String("");
    String _oldRuleName = "";
    SimplePairedValuesData _releaseInflowData = this.getReleaseInflowData();
    OpRuleRef _currentRuleRef = null;
    DefaultJPanel _parent = null;
    RmaJTextField jRuleTxt = new RmaJDssPathPartField();
    RmaJTextField jRuleDescTxt = new RmaJTextField();
    RmaJComboBox jLimitCombo = new RmaJComboBox();
    RmaJComboBox jInterpCombo = new RmaJComboBox();
    String[] colLabels = new String[]{"Inflow (%S)", "Release"};
    RmaJTable jReleaseInflowTable;
    G2dPanel jReleaseInflowPlot;
    JLabel jLimitLabel;
    JLabel jInterpLabel;
    JLabel jInflowTypeLabel;
    JLabel jRuleLabel;
    JLabel jDescriptionLabel;
    JPanel jNameDescPanel;
    JPanel jRisingFallingOptPanel;
    JCheckBox jRisingFallingCheck;
    JButton jRisingFallingButton;

    public JReleaseInflowRulePanel() {
        JReleaseInflowRulePanel jReleaseInflowRulePanel = this;
        this.jReleaseInflowTable = new RmaJTable((Component)((Object)jReleaseInflowRulePanel), (Object[])jReleaseInflowRulePanel.colLabels);
        this.jReleaseInflowPlot = new G2dPanel();
        this.jLimitLabel = new JLabel("Limit Type");
        this.jInterpLabel = new JLabel("Interpolate");
        this.jInflowTypeLabel = new JLabel("Inflow Type");
        this.jRuleLabel = new JLabel("Release as Function of Inflow");
        this.jDescriptionLabel = new JLabel("Description");
        this.jNameDescPanel = new JPanel();
        this.jRisingFallingOptPanel = new JPanel();
        this.jRisingFallingCheck = new JCheckBox("Apply Rising / Falling Cond");
        this.jRisingFallingButton = new JButton("Edit");
        this.setLayout(new GridBagLayout());
        this.jRuleTxt.setModifiable(false);
        this.jRuleTxt.setEditable(false);
        this.jNameDescPanel.setLayout(new GridBagLayout());
        this.jNameDescPanel.add((Component)this.jRuleLabel, new RmaGridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 18, 0, this.INSETS5500, 0, 0));
        this.jNameDescPanel.add((Component)this.jDescriptionLabel, new RmaGridBagConstraints(0, 1, 1, 1, 0.0, 1.0, 18, 0, this.INSETS5500, 0, 0));
        this.jNameDescPanel.add((Component)this.jRuleTxt, new RmaGridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 18, 2, this.INSETS5500, 0, 0));
        this.jNameDescPanel.add((Component)new JLabel(), new RmaGridBagConstraints(4, 0, 1, 1, 1.0, 0.0, 18, 2, this.INSETS5505, 0, 0));
        this.jNameDescPanel.add((Component)this.jRuleDescTxt, new RmaGridBagConstraints(1, 1, 4, 1, 1.0, 1.0, 18, 2, this.INSETS5555, 0, 0));
        JReleaseInflowRulePanel jReleaseInflowRulePanel2 = this;
        jReleaseInflowRulePanel2.add(jReleaseInflowRulePanel2.jNameDescPanel, new RmaGridBagConstraints(0, 0, 3, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.add(jPanel, new RmaGridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.jLimitLabel, new RmaGridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, this.INSETS5500, 0, 0));
        this.jLimitCombo.addItem((Object)"Minimum Flow");
        this.jLimitCombo.addItem((Object)"Maximum Flow");
        this.jLimitCombo.addItem((Object)"Specified Flow");
        this.jLimitCombo.setModifiable(true);
        jPanel.add((Component)this.jLimitCombo, new RmaGridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 2, this.INSETS5505, 0, 0));
        jPanel.add((Component)this.jInterpLabel, new RmaGridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, this.INSETS5500, 0, 0));
        for (int i = 0; i < PairedValues.INTERP_STRINGS.length; ++i) {
            this.jInterpCombo.addItem((Object)PairedValues.INTERP_STRINGS[i]);
        }
        this.jInterpCombo.setModifiable(true);
        jPanel.add((Component)this.jInterpCombo, new RmaGridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 18, 2, this.INSETS5505, 0, 0));
        this.jReleaseInflowTable.setModel((TableModel)((Object)new ReleaseInflowTableModel(this.colLabels, new boolean[]{true, true})));
        this.jReleaseInflowTable.setUnitsHeaderRenderer();
        this.jReleaseInflowTable.setDoubleCellEditor(0);
        this.jReleaseInflowTable.setDoubleCellEditor(1, true);
        this.jReleaseInflowTable.setNumRows(10);
        JReleaseInflowRulePanel jReleaseInflowRulePanel3 = this;
        jReleaseInflowRulePanel3.add(jReleaseInflowRulePanel3.jReleaseInflowTable.getScrollPane(), new RmaGridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 18, 1, this.INSETS5550, 0, 0));
        this.jRisingFallingOptPanel.setLayout(new GridBagLayout());
        this.jRisingFallingOptPanel.add((Component)this.jRisingFallingCheck, new RmaGridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 16, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.jRisingFallingOptPanel.add((Component)this.jRisingFallingButton, new RmaGridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 16, 0, new Insets(0, 5, 0, 5), 10, 0));
        JReleaseInflowRulePanel jReleaseInflowRulePanel4 = this;
        jReleaseInflowRulePanel4.add(jReleaseInflowRulePanel4.jRisingFallingOptPanel, new RmaGridBagConstraints(0, 4, 2, 1, 1.0, 0.0, 18, 2, INSETS0000, 0, 0));
        JReleaseInflowRulePanel jReleaseInflowRulePanel5 = this;
        jReleaseInflowRulePanel5.add((Component)jReleaseInflowRulePanel5.jReleaseInflowPlot, new RmaGridBagConstraints(1, 1, 1, 3, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 150, 150));
        JReleaseInflowRulePanel jReleaseInflowRulePanel6 = this;
        jReleaseInflowRulePanel6.configureFlowPlot(jReleaseInflowRulePanel6.jReleaseInflowPlot);
        Vector<SimplePairedValuesData> vector = new Vector<SimplePairedValuesData>();
        vector.addElement(this._releaseInflowData);
        this.jReleaseInflowPlot.setPlotObjects(vector);
        this.jReleaseInflowTable.addCellEditorListener((CellEditorListener)this);
        this.jInterpCombo.addItemListener((ItemListener)this);
        this.jLimitCombo.addItemListener((ItemListener)this);
        this.jRuleTxt.addFocusListener((FocusListener)this);
        this.jRisingFallingButton.addActionListener(this);
    }

    @Override
    public void editingCanceled(ChangeEvent changeEvent) {
    }

    @Override
    public void editingStopped(ChangeEvent changeEvent) {
        this.releaseInflowReplot();
    }

    @Override
    public void actionPerformed(ActionEvent object) {
        if ((object = ((EventObject)object).getSource()) == this.jRisingFallingButton) {
            this.risingFallingButton_ActionPerformed();
        }
    }

    public void risingFallingButton_ActionPerformed() {
        Object object = SwingUtilities.windowForComponent((Component)((Object)this));
        if (!(object instanceof ReservoirJFrame)) {
            return;
        }
        if (this._currentRuleRef == null) {
            return;
        }
        object = new RisingFallingCondDialog((Dialog)object, true);
        ((RisingFallingCondDialog)object).fillForm(this._currentRuleRef.getRule());
        object.setVisible(true);
        if (((RisingFallingCondDialog)object).isOk()) {
            this.setModified(true);
        }
    }

    public void fillPanel() {
        if (this._currentRuleRef == null) {
            return;
        }
        this.clearPanel();
        Serializable serializable = (ReleaseFunctionInflowOpRule)this._currentRuleRef.getRule();
        this._oldRuleName = serializable.getName();
        this.jRuleTxt.setText(serializable.getName());
        this.jRuleDescTxt.setText(serializable.getDescription());
        if (serializable.getLimitType() == -1) {
            this.jLimitCombo.setSelectedIndex(0);
        } else if (serializable.getLimitType() == 1) {
            this.jLimitCombo.setSelectedIndex(1);
        } else {
            this.jLimitCombo.setSelectedIndex(2);
        }
        this.jInterpCombo.removeItemListener((ItemListener)this);
        this.jInterpCombo.setSelectedIndex(serializable.getInterpolationType());
        this.jInterpCombo.addItemListener((ItemListener)this);
        Object object = serializable.getReleaseFunction();
        ((ReleaseInflowTableModel)((Object)this.jReleaseInflowTable.getModel())).setPairedValues((PairedValues)object, false);
        ClientApp.app();
        object = new String("Workspace: " + ClientApp.Workspace().getTitleName());
        object = (String)object + "\n ResSim System: " + ((JOperationsPanel)this._parent)._reservoir.getSystem().getName();
        object = (String)object + "\n Reservoir: " + ((JOperationsPanel)this._parent)._reservoir.getName();
        object = (String)object + "\n Operation Set: " + ((JOperationsPanel)this._parent)._currentOpSet.getName();
        object = (String)object + "\n Flow Release Rule: " + this._currentRuleRef.getName() + " \n ";
        object = new PageText((String)object, 0);
        this.jReleaseInflowTable.setPrintTitle((PageText)object);
        this.releaseInflowReplot();
        this.jRisingFallingCheck.removeItemListener(this);
        this.jRisingFallingCheck.setSelected(serializable.getEnableRiseFallCondition());
        this.jRisingFallingCheck.addItemListener(this);
        serializable = SwingUtilities.windowForComponent((Component)((Object)this));
        if (serializable instanceof RmaJDialog) {
            ((RmaJDialog)serializable).updateUnitSystem((Container)((Object)this));
        } else if (serializable instanceof RmaJFrame) {
            ((RmaJFrame)serializable).updateUnitSystem((Container)((Object)this));
        }
        this.setModified(false);
    }

    @Override
    public void itemStateChanged(ItemEvent object) {
        if (((ItemEvent)object).getStateChange() == 2) {
            return;
        }
        if ((object = ((EventObject)object).getSource()) == this.jInterpCombo) {
            this.setModified(true);
            this.releaseInflowReplot();
            return;
        }
        if (object == this.jLimitCombo) {
            this.setModified(true);
            return;
        }
        if (object == this.jRisingFallingCheck) {
            this.setModified(true);
        }
    }

    public void refresh() {
    }

    public boolean savePanel() {
        if (this._currentRuleRef == null) {
            return false;
        }
        if (this.jRuleTxt.getText().equals("")) {
            RMAIO.postError((Component)((Object)this), (String)"Cannot have an empty rule name!");
            return false;
        }
        ReleaseFunctionInflowOpRule releaseFunctionInflowOpRule = (ReleaseFunctionInflowOpRule)this._currentRuleRef.getRule();
        if (releaseFunctionInflowOpRule == null) {
            return false;
        }
        this._currentRuleRef.getRule().setName(this.jRuleTxt.getText());
        this._currentRuleRef.setName(this.jRuleTxt.getText());
        this._oldRuleName = this.jRuleTxt.getText();
        releaseFunctionInflowOpRule.setDescription(this.jRuleDescTxt.getText());
        if (this.jLimitCombo.getSelectedIndex() == 0) {
            releaseFunctionInflowOpRule.setLimitType(-1);
        } else if (this.jLimitCombo.getSelectedIndex() == 1) {
            releaseFunctionInflowOpRule.setLimitType(1);
        } else {
            releaseFunctionInflowOpRule.setLimitType(0);
        }
        this.jReleaseInflowTable.commitEdit(true);
        ReleaseInflowTableModel releaseInflowTableModel = (ReleaseInflowTableModel)((Object)this.jReleaseInflowTable.getModel());
        boolean bl = this.isInflowRatio();
        PairedValues pairedValues = new PairedValues();
        releaseInflowTableModel.storeData(pairedValues, bl);
        releaseFunctionInflowOpRule.setReleaseFunction(pairedValues, bl);
        releaseFunctionInflowOpRule.setInterpolationType(this.jInterpCombo.getSelectedIndex());
        releaseFunctionInflowOpRule.setEnableRiseFallCondition(this.jRisingFallingCheck.isSelected());
        this.setModified(false);
        return true;
    }

    private void releaseInflowReplot() {
        Vector<SimplePairedValuesData> vector = new Vector<SimplePairedValuesData>();
        PairedValues pairedValues = new PairedValues();
        boolean bl = this.isInflowRatio();
        this._releaseInflowData = this.getReleaseInflowData();
        ReleaseInflowTableModel releaseInflowTableModel = (ReleaseInflowTableModel)((Object)this.jReleaseInflowTable.getModel());
        releaseInflowTableModel.storeData(pairedValues, bl);
        String string = (String)this.jInterpCombo.getSelectedItem();
        this._releaseInflowData.setInterpolationType(string);
        this._releaseInflowData.setData(pairedValues);
        this._releaseInflowData.calcPlotArrays();
        vector.addElement(this._releaseInflowData);
        this.jReleaseInflowPlot.setPlotObjects(vector);
        this.jReleaseInflowPlot.paintGfx();
    }

    private void configureFlowPlot(G2dPanel g2dPanel) {
        PlotDefaults plotDefaults = PlotDefaultsManager.getDefaults();
        PlotDefaultsManager.setDefaults((PlotDefaults)new HotPlotDefaults());
        G2dPanelProp g2dPanelProp = new G2dPanelProp();
        new G2dPanelProp().hasTitle = false;
        g2dPanelProp.hasToolbar = false;
        g2dPanelProp.hasLegend = false;
        G2dPlotProp g2dPlotProp = new G2dPlotProp();
        new G2dPlotProp().hasXScroll = false;
        g2dPlotProp.hasYScroll = false;
        g2dPlotProp.x1AxisProp.name = "Inflow (%S)";
        g2dPlotProp.y1AxisProp.name = this.isInflowRatio() ? INFLOW_RATIO : INFLOW_CONSTANT;
        g2dPlotProp.y1AxisProp.isReversed = true;
        g2dPanelProp.addPlotProp(g2dPlotProp);
        g2dPanel.configurePanel(g2dPanelProp);
        PlotDefaultsManager.setDefaults((PlotDefaults)plotDefaults);
    }

    private SimplePairedValuesData getReleaseInflowData() {
        SimplePairedValuesData simplePairedValuesData = new SimplePairedValuesData();
        new SimplePairedValuesData().xunits = "Inflow (%S)";
        simplePairedValuesData.yunits = this.isInflowRatio() ? INFLOW_RATIO : INFLOW_CONSTANT;
        PairedValues pairedValues = new PairedValues();
        pairedValues.setInterpolationType(0);
        simplePairedValuesData.resetData();
        return simplePairedValuesData;
    }

    public void clearPanel() {
        this.jReleaseInflowTable.clearCells();
        Vector vector = new Vector();
        this.jReleaseInflowPlot.setPlotObjects(vector);
        this.jReleaseInflowPlot.paintGfx();
        this.jReleaseInflowPlot.revalidate();
    }

    public void setRuleRef(OpRuleRef opRuleRef) {
        if (opRuleRef == null) {
            return;
        }
        if (this.isModified()) {
            this.savePanel();
        }
        this._currentRuleRef = opRuleRef;
        this.fillPanel();
    }

    public void setParent(JPanel jPanel) {
        this._parent = (JOperationsPanel)((Object)jPanel);
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
    }

    @Override
    public void focusLost(FocusEvent object) {
        if ((object = ((EventObject)object).getSource()) == this.jRuleTxt) {
            if (this.jRuleTxt.getText().equals("")) {
                this.jRuleTxt.setText(this._currentRuleRef.getRule().getName());
                RMAIO.postError((Component)((Object)this), (String)"Cannot have a blank Rule Name!");
                return;
            }
            this._currentRuleRef.getRule().setName(this.jRuleTxt.getText());
            this._currentRuleRef.setName(this.jRuleTxt.getText());
            ((JOperationsPanel)this._parent).treeDataChanged(0, this._oldRuleName, this.jRuleTxt.getText());
        }
    }

    public void deselectPanel() {
        if (this.isModified()) {
            this.savePanel();
        }
    }

    public boolean isInflowRatio() {
        return false;
    }
}

