/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.gfx2d.G2dPanel;
import hec.gfx2d.G2dPanelProp;
import hec.gfx2d.G2dPlotProp;
import hec.gfx2d.HotPlotDefaults;
import hec.gfx2d.PlotDefaults;
import hec.gfx2d.PlotDefaultsManager;
import hec.gfx2d.SimpleJTableSeasonalData;
import hec.gfx2d.SimpleSeasonalData;
import hec.io.AsciiSerializable;
import hec.model.SeasonalRecord;
import hec.model.SeasonalRecordTableModel;
import hec.rss.client.DayOfWeekMultiplierJDialog;
import hec.rss.client.JResSysFlowLimitRulePanel$1;
import hec.rss.client.JResSysFlowLimitRulePanel$2;
import hec.rss.client.JSystemRulePanel;
import hec.rss.model.DayOfWeekMultiplier;
import hec.rss.model.ReservoirElement;
import hec.rss.model.ReservoirSysOp;
import hec.rss.model.RssNode;
import hec.rss.model.SystemFlowLimitOpRule;
import hec.rss.model.SystemOpRuleRef;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.EventObject;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableModel;
import rma.swing.RmaGridBagConstraints;
import rma.swing.RmaJCalendarField;
import rma.swing.RmaJCheckBox;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJDialog;
import rma.swing.RmaJFrame;
import rma.swing.RmaJTable;
import rma.util.RMAIO;

public class JResSysFlowLimitRulePanel
extends JSystemRulePanel
implements ActionListener,
CellEditorListener {
    SimpleJTableSeasonalData _storageZonePlotArray;
    SystemOpRuleRef _currentRuleRef;
    ReservoirSysOp _reservoirSysOp = null;
    String _oldRuleName = "";
    float _oldPriority = Float.NEGATIVE_INFINITY;
    int[] _currentResIDS = new int[0];
    JLabel jLocationLabel = new JLabel("Location");
    RmaJComboBox jLocationCombo = new RmaJComboBox();
    JLabel jLimitTypeLabel = new JLabel("Limit Type");
    RmaJComboBox jLimitTypeCombo = new RmaJComboBox();
    JLabel jInterpTypeLabel = new JLabel("Interpolation Type");
    RmaJComboBox jInterpTypeCombo = new RmaJComboBox();
    JLabel jStartYearLabel = new JLabel("Starting Year");
    JPanel jTablePanel = new JPanel();
    JPanel jMultiplierPanel = new JPanel();
    RmaJCheckBox jMultiplierCheck = new RmaJCheckBox("Day of Week Multiplier");
    JButton jMultiplierButton = new JButton("Edit");
    RmaJCalendarField jStartYearTxt = new RmaJCalendarField("YYYY", "");
    RmaJCheckBox jMultiYearCheck = new RmaJCheckBox("Allow Multi-year Seasonal Data");
    String[] colLabels = new String[]{"Date", "Flow (%S)"};
    RmaJTable jRuleTable = new RmaJTable((Component)((Object)this));
    G2dPanel storageZonePlot = new G2dPanel();

    public JResSysFlowLimitRulePanel() {
        this.jRuleNameLabel.setText("Flow Limit Rule");
        this.jTablePanel.setLayout(new GridBagLayout());
        this.jTablePanel.add((Component)this.jLimitTypeLabel, new RmaGridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, this.INSETS5500, 0, 0));
        this.jTablePanel.add((Component)this.jLimitTypeCombo, new RmaGridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 2, this.INSETS5505, 0, 0));
        this.jTablePanel.add((Component)this.jInterpTypeLabel, new RmaGridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, this.INSETS5500, 0, 0));
        this.jTablePanel.add((Component)this.jInterpTypeCombo, new RmaGridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 18, 2, this.INSETS5505, 0, 0));
        this.jTablePanel.add((Component)this.jLocationLabel, new RmaGridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, this.INSETS5500, 0, 0));
        this.jTablePanel.add((Component)this.jLocationCombo, new RmaGridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 18, 2, this.INSETS5505, 0, 0));
        this.jRuleTable.setModel((TableModel)new SeasonalRecordTableModel(this.colLabels, new boolean[]{true, true}));
        this.jRuleTable.setDoubleCellEditor(1);
        this.jRuleTable.setUnitsHeaderRenderer();
        this.jRuleTable.setDateCellEditor(0, "DDMMM");
        this.jRuleTable.setHorizontalAlignment(2, 0);
        this.jRuleTable.setHorizontalAlignment(4, 1);
        this.jRuleTable.setNumRows(10);
        this.jRuleTable.getScrollPane().setVerticalScrollBarPolicy(22);
        this.jRuleTable.getScrollPane().setHorizontalScrollBarPolicy(30);
        this.jTablePanel.add((Component)this.jRuleTable.getScrollPane(), new RmaGridBagConstraints(0, 3, 2, 1, 1.0, 1.0, 18, 1, this.INSETS5505, 0, 0));
        JResSysFlowLimitRulePanel jResSysFlowLimitRulePanel = this;
        jResSysFlowLimitRulePanel.configurePlotPanel(jResSysFlowLimitRulePanel.storageZonePlot);
        Vector<SimpleJTableSeasonalData> vector = new Vector<SimpleJTableSeasonalData>();
        this._storageZonePlotArray = this.getStorageZonePlotArray();
        vector.addElement(this._storageZonePlotArray);
        this.storageZonePlot.setPlotObjects(vector);
        this.jTablePanel.add((Component)this.storageZonePlot, new RmaGridBagConstraints(3, 0, 1, 4, 0.0, 1.0, 12, 0, this.INSETS5555, 150, 150));
        this.jMultiplierPanel.setLayout(new GridBagLayout());
        this.jMultiplierPanel.add((Component)this.jMultiplierCheck, new RmaGridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 16, 0, this.INSETS5550, 0, 0));
        this.jMultiplierPanel.add((Component)this.jMultiplierButton, new RmaGridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 16, 0, this.INSETS5555, 10, 0));
        this.jComponentPanel.add((Component)this.jTablePanel, new RmaGridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, this.INSETS0000, 0, 0));
        this.jComponentPanel.add((Component)this.jMultiplierPanel, new RmaGridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 18, 2, this.INSETS0000, 0, 0));
        this.jLimitTypeCombo.addItem((Object)"Minimum Flow");
        this.jLimitTypeCombo.addItem((Object)"Maximum Flow");
        this.jLocationCombo.addItem((Object)"Reservoir Release");
        this.jLocationCombo.addItem((Object)"Reservoir Tailwater");
        for (int i = 0; i < SeasonalRecord.INTERP_STRINGS.length; ++i) {
            this.jInterpTypeCombo.addItem((Object)SeasonalRecord.INTERP_STRINGS[i]);
        }
        this.jRuleTable.addCellEditorListener((CellEditorListener)this);
        this.jRuleNameTxt.addFocusListener((FocusListener)this);
        this.jPriorityTxt.addFocusListener((FocusListener)this);
        this.jMultiplierCheck.addActionListener((ActionListener)new JResSysFlowLimitRulePanel$1(this));
        this.jMultiplierButton.addActionListener(new JResSysFlowLimitRulePanel$2(this));
    }

    public void itemStateChanged(ItemEvent object) {
        if (((ItemEvent)object).getStateChange() == 2) {
            return;
        }
        if ((object = ((EventObject)object).getSource()) == this.jLocationCombo) {
            this.setModified(true);
            return;
        }
        if (object == this.jLimitTypeCombo) {
            this.setModified(true);
            return;
        }
        if (object == this.jInterpTypeCombo) {
            this.setModified(true);
            this.replot();
        }
    }

    @Override
    public void editingCanceled(ChangeEvent changeEvent) {
    }

    @Override
    public void editingStopped(ChangeEvent changeEvent) {
        changeEvent.getSource();
        this.setModified(true);
    }

    @Override
    public void fillPanel() {
        int dayOfWeekMultiplier;
        if (this._currentRuleRef == null) {
            return;
        }
        ((JSystemRulePanel)this).clearPanel();
        SystemFlowLimitOpRule systemFlowLimitOpRule = (SystemFlowLimitOpRule)this._currentRuleRef.getRule();
        this.jRuleNameTxt.setText(systemFlowLimitOpRule.getName());
        this.jDescriptionTxt.setText(systemFlowLimitOpRule.getDescription());
        this.jPriorityTxt.setText(Float.toString(this._currentRuleRef.getPriority()));
        this._oldRuleName = systemFlowLimitOpRule.getName();
        this._oldPriority = this._currentRuleRef.getPriority();
        this.jLimitTypeCombo.removeItemListener((ItemListener)((Object)this));
        if (systemFlowLimitOpRule.getLimitType() == -1) {
            this.jLimitTypeCombo.setSelectedIndex(0);
        } else {
            this.jLimitTypeCombo.setSelectedIndex(1);
        }
        this.jLimitTypeCombo.addItemListener((ItemListener)((Object)this));
        this.jLocationCombo.removeItemListener((ItemListener)((Object)this));
        int bl = systemFlowLimitOpRule.getRssNodeIndex();
        if (bl < 0) {
            this.jLocationCombo.setSelectedIndex(0);
        } else {
            int seasonalRecord;
            int stringArray2 = this.jLocationCombo.getItemCount();
            for (seasonalRecord = 1; seasonalRecord < stringArray2; ++seasonalRecord) {
                RssNode n = (RssNode)this.jLocationCombo.getItemAt(seasonalRecord);
                if (n.getIndex() != bl) continue;
                this.jLocationCombo.setSelectedIndex(seasonalRecord);
                break;
            }
            if (seasonalRecord == stringArray2) {
                this.jLocationCombo.setSelectedIndex(0);
            }
        }
        this.jLocationCombo.addItemListener((ItemListener)((Object)this));
        SeasonalRecord seasonalRecord = systemFlowLimitOpRule.getSeasonalRecord();
        ((SeasonalRecordTableModel)this.jRuleTable.getModel()).setSeasonalRecord(seasonalRecord, "");
        this.jInterpTypeCombo.removeItemListener((ItemListener)((Object)this));
        this.jInterpTypeCombo.setSelectedIndex(systemFlowLimitOpRule.getInterpolationType());
        this.jInterpTypeCombo.addItemListener((ItemListener)((Object)this));
        if (this._reservoirSysOp == null) {
            return;
        }
        this._currentResIDS = this._reservoirSysOp.getReservoirIDs();
        String[] stringArray = new String[this._currentResIDS.length + 1];
        String[] stringArray2 = stringArray;
        stringArray[0] = "";
        for (dayOfWeekMultiplier = 0; dayOfWeekMultiplier < this._currentResIDS.length; ++dayOfWeekMultiplier) {
            ReservoirElement reservoirElement = this._reservoirSysOp.getReservoirById(this._currentResIDS[dayOfWeekMultiplier]);
            if (reservoirElement == null) continue;
            stringArray2[dayOfWeekMultiplier + 1] = reservoirElement.getName();
        }
        this.jOpRuleTable.setNumColumns(stringArray2.length);
        this.jOpRuleTable.setNumRows(1);
        this.jOpRuleTable.setColumnLabels(stringArray2);
        for (dayOfWeekMultiplier = 0; dayOfWeekMultiplier < this._currentResIDS.length; ++dayOfWeekMultiplier) {
            boolean window = this._currentRuleRef.doesRuleApplyToReservoir(this._currentResIDS[dayOfWeekMultiplier]);
            this.jOpRuleTable.setCell((Object)window, 0, dayOfWeekMultiplier + 1);
        }
        this.replot();
        DayOfWeekMultiplier dayOfWeekMultiplier2 = systemFlowLimitOpRule.getMultiplier();
        if (dayOfWeekMultiplier2.isDefaults()) {
            this.jMultiplierCheck.setSelected(false);
        } else {
            this.jMultiplierCheck.setSelected(true);
        }
        Window window = SwingUtilities.windowForComponent((Component)((Object)this));
        if (window instanceof RmaJDialog) {
            ((RmaJDialog)window).updateUnitSystem((Container)((Object)this));
        } else if (window instanceof RmaJFrame) {
            ((RmaJFrame)window).updateUnitSystem((Container)((Object)this));
        }
        this.setModified(false);
    }

    @Override
    public void refresh() {
    }

    @Override
    public boolean savePanel() {
        if (this._currentRuleRef == null) {
            return false;
        }
        if (this.jRuleNameTxt.getText().equals("")) {
            RMAIO.postError((Component)((Object)this), (String)"Cannot have an empty rule name!");
            return false;
        }
        SystemFlowLimitOpRule systemFlowLimitOpRule = (SystemFlowLimitOpRule)this._currentRuleRef.getRule();
        if (systemFlowLimitOpRule == null) {
            return false;
        }
        this._currentRuleRef.getPriority();
        float f = RMAIO.parseFloat((String)this.jPriorityTxt.getText());
        if (f != Float.NEGATIVE_INFINITY) {
            this._currentRuleRef.setPriority(f);
            this._oldPriority = f;
        }
        this._currentRuleRef.getRule().setName(this.jRuleNameTxt.getText());
        this._currentRuleRef.setName(this.jRuleNameTxt.getText());
        this._oldRuleName = this.jRuleNameTxt.getText();
        systemFlowLimitOpRule.setDescription(this.jDescriptionTxt.getText());
        if (this.jLimitTypeCombo.getSelectedIndex() == 0) {
            systemFlowLimitOpRule.setLimitType(-1);
        } else {
            systemFlowLimitOpRule.setLimitType(1);
        }
        Object object = this.jLocationCombo.getSelectedItem();
        if (object instanceof RssNode) {
            systemFlowLimitOpRule.setRssNodeIndex(((RssNode)object).getIndex());
        } else {
            systemFlowLimitOpRule.setRssNodeIndex(-1);
        }
        systemFlowLimitOpRule.setInterpolationType(this.jInterpTypeCombo.getSelectedIndex());
        this.jRuleTable.commitEdit(true);
        object = (SeasonalRecordTableModel)this.jRuleTable.getModel();
        object.storeData(systemFlowLimitOpRule.getSeasonalRecord());
        this.jOpRuleTable.commitEdit(true);
        this._currentRuleRef.clearRuleReservoirApplications();
        for (int i = 0; i < this._currentResIDS.length && i < this.jOpRuleTable.getColumnCount(); ++i) {
            object = this.jOpRuleTable.getCell(0, i + 1);
            ReservoirElement reservoirElement = this._reservoirSysOp.getReservoirById(this._currentResIDS[i]);
            if (reservoirElement == null) continue;
            if (object instanceof String) {
                this._currentRuleRef.applyRuleToReservoir(reservoirElement, false);
            }
            if (!(object instanceof Boolean)) continue;
            this._currentRuleRef.applyRuleToReservoir(reservoirElement, object.toString().equalsIgnoreCase("true"));
        }
        this.setModified(false);
        return true;
    }

    @Override
    public void clearPanel() {
        super.clearPanel();
        this.jRuleTable.clearCells();
        this.jMultiYearCheck.setSelected(false);
        this.jStartYearTxt.setEnabled(false);
    }

    public void setRuleRef(SystemOpRuleRef systemOpRuleRef) {
        if (systemOpRuleRef == null) {
            return;
        }
        if (this.isModified()) {
            ((JSystemRulePanel)this).savePanel();
        }
        this._currentRuleRef = systemOpRuleRef;
        ((JSystemRulePanel)this).fillPanel();
    }

    public void setReservoirSystemOp(ReservoirSysOp reservoirSysOp) {
        this._reservoirSysOp = reservoirSysOp;
    }

    private SimpleJTableSeasonalData getStorageZonePlotArray() {
        SimpleJTableSeasonalData simpleJTableSeasonalData = new SimpleJTableSeasonalData();
        new SimpleJTableSeasonalData().xunits = "Date";
        simpleJTableSeasonalData.yunits = "Flow";
        simpleJTableSeasonalData.setXAxisType(2);
        simpleJTableSeasonalData.setData(null, -1, -1);
        return simpleJTableSeasonalData;
    }

    private void configurePlotPanel(G2dPanel g2dPanel) {
        PlotDefaults plotDefaults = PlotDefaultsManager.getDefaults();
        PlotDefaultsManager.setDefaults((PlotDefaults)new HotPlotDefaults());
        G2dPanelProp g2dPanelProp = new G2dPanelProp();
        new G2dPanelProp().hasTitle = false;
        g2dPanelProp.hasToolbar = false;
        g2dPanelProp.hasLegend = false;
        G2dPlotProp g2dPlotProp = new G2dPlotProp();
        new G2dPlotProp().hasXScroll = false;
        g2dPlotProp.hasYScroll = false;
        g2dPlotProp.x1AxisProp.name = "Minutes";
        g2dPlotProp.x1AxisProp.type = 2;
        g2dPlotProp.y1AxisProp.name = "Flow";
        g2dPlotProp.x1AxisProp.numTicLabelLayers = 1;
        g2dPlotProp.hasX1Label = false;
        g2dPlotProp.y1AxisProp.isReversed = true;
        g2dPlotProp.x1AxisProp.isDefaultLimits = false;
        g2dPlotProp.x1AxisProp.min = 0.0;
        g2dPlotProp.x1AxisProp.max = 525600.0;
        g2dPanelProp.addPlotProp(g2dPlotProp);
        g2dPanelProp.addPlotProp(g2dPlotProp);
        g2dPanel.configurePanel(g2dPanelProp);
        PlotDefaultsManager.setDefaults((PlotDefaults)plotDefaults);
    }

    public void replot() {
        this.plotRule();
    }

    private void plotRule() {
        Vector<SeasonalRecordTableModel> vector = new Vector<SeasonalRecordTableModel>();
        Object object = new SeasonalRecord();
        SeasonalRecordTableModel seasonalRecordTableModel = (SeasonalRecordTableModel)this.jRuleTable.getModel();
        seasonalRecordTableModel.storeData(object);
        seasonalRecordTableModel = new SimpleSeasonalData();
        seasonalRecordTableModel.setData(object);
        seasonalRecordTableModel.xunits = "Minutes";
        seasonalRecordTableModel.yunits = "Flow";
        seasonalRecordTableModel.setPlotYears(1);
        object = (String)this.jInterpTypeCombo.getSelectedItem();
        seasonalRecordTableModel.setInterpolationType((String)object);
        seasonalRecordTableModel.calcPlotArrays();
        vector.addElement(seasonalRecordTableModel);
        this.storageZonePlot.setPlotObjects(vector);
        this.storageZonePlot.paintGfx();
    }

    public void setDownstreamLocationComboModel(Vector vector) {
        this.jLocationCombo.removeItemListener((ItemListener)((Object)this));
        this.jLocationCombo.setModel(new DefaultComboBoxModel(vector));
        this.jLocationCombo.addItemListener((ItemListener)((Object)this));
    }

    @Override
    public void focusLost(FocusEvent object) {
        if ((object = ((EventObject)object).getSource()) == this.jRuleNameTxt) {
            if (this.jRuleNameTxt.getText().equals("")) {
                this.jRuleNameTxt.setText(this._currentRuleRef.getRule().getName());
                RMAIO.postError((Component)((Object)this), (String)"Cannot have a blank Rule Name!");
                return;
            }
            this._currentRuleRef.getRule().setName(this.jRuleNameTxt.getText());
            this._currentRuleRef.setName(this.jRuleNameTxt.getText());
            this._parent.treeDataChanged(0, this._oldRuleName, this.jRuleNameTxt.getText());
            return;
        }
        if (object == this.jPriorityTxt) {
            float f = RMAIO.parseFloat((String)this.jPriorityTxt.getText());
            if (f == Float.NEGATIVE_INFINITY) {
                this.jPriorityTxt.setText(Float.toString(this._currentRuleRef.getPriority()));
                RMAIO.postError((Component)((Object)this), (String)"Cannot hava a undefined Priority value!");
                return;
            }
            this._currentRuleRef.setPriority(RMAIO.parseFloat((String)this.jPriorityTxt.getText()));
            this._parent.treeDataChanged(1, null, null);
        }
    }

    public void jMultiplierCheck_Action() {
        if (this._currentRuleRef == null) {
            this.jMultiplierCheck.setSelected(false);
            return;
        }
        AsciiSerializable asciiSerializable = (SystemFlowLimitOpRule)this._currentRuleRef.getRule();
        if (asciiSerializable == null) {
            this.jMultiplierCheck.setSelected(false);
            return;
        }
        if (((DayOfWeekMultiplier)(asciiSerializable = asciiSerializable.getMultiplier())).isDefaults()) {
            this.jMultiplierCheck.setSelected(false);
            return;
        }
        this.jMultiplierCheck.setSelected(true);
    }

    public void MultiplierButton_ActionPerformed() {
        Object object = SwingUtilities.windowForComponent((Component)((Object)this));
        if (object instanceof Dialog) {
            Object object2 = "Day of Week Multiplier";
            object = new DayOfWeekMultiplierJDialog((Dialog)object, (String)object2, true);
            object2 = (SystemFlowLimitOpRule)this._currentRuleRef.getRule();
            ((DayOfWeekMultiplierJDialog)((Object)object)).setData(((SystemFlowLimitOpRule)object2).getMultiplier());
            ((DayOfWeekMultiplierJDialog)((Object)object)).setVisible(true);
            if (!((DayOfWeekMultiplierJDialog)((Object)object)).isCanceled()) {
                this.setModified(true);
            }
            if (((DayOfWeekMultiplier)(object = ((SystemFlowLimitOpRule)object2).getMultiplier())).isDefaults()) {
                this.jMultiplierCheck.setSelected(false);
                return;
            }
            this.jMultiplierCheck.setSelected(true);
        }
    }

    public void deselectPanel() {
        if (this.isModified()) {
            ((JSystemRulePanel)this).savePanel();
        }
    }

    public static void a(String[] object) {
        object = new JFrame();
        ((JFrame)object).getContentPane().setLayout(new GridBagLayout());
        ((JFrame)object).getContentPane().add((Component)((Object)new JResSysFlowLimitRulePanel()), new RmaGridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        ((Window)object).setVisible(true);
    }
}

