/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.client.MoverDialog;
import hec.clientapp.client.ClientApp;
import hec.rss.client.ReservoirSystemJDialog;
import hec.rss.model.ReservoirElement;
import hec.rss.model.ReservoirSysOp;
import hec.rss.model.RssSystem;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EventObject;
import java.util.List;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JMenuItem;
import rma.swing.DefaultJPanel;
import rma.swing.RmaGridBagConstraints;
import rma.swing.RmaJTable;
import rma.swing.print.PageText;
import rma.swing.table.RmaTableModel;
import rma.util.RMAIO;

public class JResSysReservoirsPanel
extends DefaultJPanel
implements ActionListener {
    String[] _colLabels = new String[]{"Reservoir Name", "Description"};
    int[] _colWidths = new int[]{20, 80};
    JDialog _owner;
    ReservoirSysOp _sysOp = null;
    RssSystem _system = null;
    RmaJTable reservoirsTable;
    JButton jButton_Up;
    JButton jButton_Down;

    public JResSysReservoirsPanel(JDialog jDialog) {
        JResSysReservoirsPanel jResSysReservoirsPanel = this;
        this.reservoirsTable = new RmaJTable((Component)((Object)jResSysReservoirsPanel), (Object[])jResSysReservoirsPanel._colLabels);
        this.jButton_Up = new JButton("Up");
        this.jButton_Down = new JButton("Down");
        this._owner = jDialog;
        this.setLayout(new GridBagLayout());
        this.reservoirsTable.setNumRows(5);
        this.reservoirsTable.setColumnWidths(this._colWidths);
        this.reservoirsTable.setEnabled(false);
        this.reservoirsTable.setCellSelectionEnabled(false);
        this.reservoirsTable.setColumnSelectionAllowed(false);
        this.reservoirsTable.setRowSelectionAllowed(true);
        this.reservoirsTable.getScrollPane().setVerticalScrollBarPolicy(20);
        this.reservoirsTable.getScrollPane().setHorizontalScrollBarPolicy(30);
        this.reservoirsTable.setNumRows(0);
        JResSysReservoirsPanel jResSysReservoirsPanel2 = this;
        jResSysReservoirsPanel2.add(jResSysReservoirsPanel2.reservoirsTable.getScrollPane(), new RmaGridBagConstraints(0, 0, 1, 2, 1.0, 1.0, 18, 1, new Insets(20, 5, 5, 0), 0, 0));
        JResSysReservoirsPanel jResSysReservoirsPanel3 = this;
        jResSysReservoirsPanel3.add(jResSysReservoirsPanel3.jButton_Up, new RmaGridBagConstraints(1, 0, 1, 1, 0.0, 1.0, 16, 0, new Insets(5, 5, 5, 5), 16, 0));
        JResSysReservoirsPanel jResSysReservoirsPanel4 = this;
        jResSysReservoirsPanel4.add(jResSysReservoirsPanel4.jButton_Down, new RmaGridBagConstraints(1, 1, 1, 1, 0.0, 1.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.jButton_Up.addActionListener(this);
        this.jButton_Down.addActionListener(this);
        this.jButton_Up.setMnemonic('U');
        this.jButton_Down.setMnemonic('W');
    }

    @Override
    public void actionPerformed(ActionEvent object) {
        if ((object = ((EventObject)object).getSource()) instanceof JMenuItem) {
            this.menuAction_EditReservoirSet();
            return;
        }
        if (object == this.jButton_Up) {
            this.buttonAction_Up();
            return;
        }
        if (object == this.jButton_Down) {
            this.buttonAction_Down();
        }
    }

    private void menuAction_EditReservoirSet() {
        if (this._sysOp == null) {
            RMAIO.postWarning((Component)((Object)this), (String)"Need to Create a Reservoir System Operations");
            return;
        }
        MoverDialog moverDialog = new MoverDialog(this._owner, true, "Reservoir Selection Editor");
        Object object = "";
        Object object2 = "";
        if (this._system != null) {
            object = this._sysOp.getName();
            object2 = this._sysOp.getDescription();
        }
        object = "Reservoir System: " + (String)object;
        object = (String)object + " \nDescription: " + (String)object2;
        object2 = new Vector();
        Vector<ReservoirElement> vector = new Vector<ReservoirElement>();
        Object object3 = this._sysOp.getReservoirIDs();
        for (int i = 0; i < ((int[])object3).length; ++i) {
            ReservoirElement reservoirElement = this._sysOp.getReservoirById(object3[i]);
            vector.addElement(reservoirElement);
        }
        String[] stringArray = this._system.getReservoirNames();
        for (int i = 0; i < stringArray.length; ++i) {
            object3 = this._system.findReservoir(stringArray[i]);
            ((Vector)object2).addElement(object3);
        }
        moverDialog.setDesc((String)object);
        moverDialog.setData((List)object2, vector);
        moverDialog.setVisible(true);
        if (moverDialog.isCanceled()) {
            return;
        }
        Object[] objectArray = moverDialog.getAvailableObjects();
        for (int i = 0; i < objectArray.length; ++i) {
            this._sysOp.deleteReservoir((ReservoirElement)objectArray[i]);
        }
        Object[] objectArray2 = moverDialog.getSelectedObjects();
        for (int i = 0; i < objectArray2.length; ++i) {
            this._sysOp.addReservoir((ReservoirElement)objectArray2[i]);
        }
        this.fillPanel();
        ((ReservoirSystemJDialog)((Object)this._owner)).reservoirSystemChanged();
    }

    private void buttonAction_Up() {
        int n = this.reservoirsTable.getSelectedRow();
        if (n < 0) {
            RMAIO.postWarning((Component)((Object)this), (String)"Please Select a row first!");
            return;
        }
        if (n == 0 || n >= this.reservoirsTable.getNumRows()) {
            return;
        }
        Cloneable cloneable = ((RmaTableModel)this.reservoirsTable.getModel()).getRow(n);
        ((RmaTableModel)this.reservoirsTable.getModel()).deleteRow(n);
        ((RmaTableModel)this.reservoirsTable.getModel()).insertRow(n - 1, cloneable);
        cloneable = this._sysOp.getReservoirByName((String)cloneable.elementAt(0));
        if (cloneable != null) {
            this._sysOp.raisePriority((ReservoirElement)cloneable);
        }
        this.reservoirsTable.updateSelection(n - 1, 0, false, false);
        this.setModified(true);
    }

    private void buttonAction_Down() {
        int n = this.reservoirsTable.getSelectedRow();
        if (n < 0) {
            RMAIO.postWarning((Component)((Object)this), (String)"Please Select a row first!");
            return;
        }
        if (n >= this.reservoirsTable.getNumRows() - 1) {
            return;
        }
        Cloneable cloneable = ((RmaTableModel)this.reservoirsTable.getModel()).getRow(n);
        ((RmaTableModel)this.reservoirsTable.getModel()).deleteRow(n);
        ((RmaTableModel)this.reservoirsTable.getModel()).insertRow(n + 1, cloneable);
        cloneable = this._sysOp.getReservoirByName((String)cloneable.elementAt(0));
        if (cloneable != null) {
            this._sysOp.lowerPriority((ReservoirElement)cloneable);
        }
        this.reservoirsTable.updateSelection(n + 1, 0, false, false);
        this.setModified(true);
    }

    public void setTablePrintHeaders() {
        ClientApp.app();
        Object object = new String("Workspace: " + ClientApp.Workspace().getTitleName());
        object = (String)object + "\n Reservoir System - Reservoirs Table \n ";
        object = new PageText((String)object, 0);
        this.reservoirsTable.setPrintTitle((PageText)object);
    }

    public void fillPanel() {
        this.clearPanel();
        if (this._system == null || this._sysOp == null) {
            return;
        }
        int[] nArray = this._sysOp.getReservoirIDs();
        this.reservoirsTable.setNumRows(nArray.length);
        for (int i = 0; i < nArray.length; ++i) {
            ReservoirElement reservoirElement = this._sysOp.getReservoirById(nArray[i]);
            this.reservoirsTable.setCell((Object)reservoirElement.getName(), i, 0);
            this.reservoirsTable.setCell((Object)reservoirElement.getDescription(), i, 1);
        }
        this.setTablePrintHeaders();
        this.setModified(false);
    }

    public boolean savePanel() {
        return true;
    }

    public Vector getResTableData() {
        this.reservoirsTable.commitEdit(true);
        Vector vector = this.reservoirsTable.getCells();
        return vector;
    }

    public void clearPanel() {
        this.reservoirsTable.commitEdit(true);
        this.reservoirsTable.clearCells();
    }

    public void setData(RssSystem rssSystem, ReservoirSysOp reservoirSysOp) {
        this._system = rssSystem;
        this._sysOp = reservoirSysOp;
    }

    public void refresh() {
    }
}

