/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.clientapp.client.ClientApp;
import hec.gfx2d.ComplexSeasonalData;
import hec.gfx2d.G2dPanel;
import hec.gfx2d.G2dPanelProp;
import hec.gfx2d.G2dPlotProp;
import hec.gfx2d.HotPlotDefaults;
import hec.gfx2d.PlotDefaults;
import hec.gfx2d.PlotDefaultsManager;
import hec.gfx2d.SimpleSeasonalData;
import hec.lang.NamedType;
import hec.model.SeasonalRecord;
import hec.rss.client.JResSysStorageZonePanel$1;
import hec.rss.client.JResSysSysOpsPanel;
import hec.rss.model.OpSet;
import hec.rss.model.OpSetRef;
import hec.rss.model.ResSystemOpSet;
import hec.rss.model.ReservoirElement;
import hec.rss.model.ReservoirSysOp;
import hec.rss.model.StorageZone;
import hec.rss.model.SystemReservoirStorage;
import hec.rss.model.SystemStorageZone;
import hec.rss.model.ZoneBounds;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemListener;
import java.io.Serializable;
import java.util.Arrays;
import java.util.EventObject;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import rma.lang.Modifiable;
import rma.swing.DefaultJPanel;
import rma.swing.RmaGridBagConstraints;
import rma.swing.RmaJDescriptionField;
import rma.swing.RmaJDssPathPartField;
import rma.swing.RmaJTable;
import rma.swing.RmaJTextField;
import rma.swing.print.PageText;
import rma.swing.table.TwoTablesOneFixedPanel;
import rma.util.RMAIO;

public class JResSysStorageZonePanel
extends DefaultJPanel
implements ActionListener,
FocusListener,
ItemListener,
CellEditorListener,
Modifiable {
    Insets INSETS5505 = new Insets(5, 5, 0, 5);
    Insets INSETS5500 = new Insets(5, 5, 0, 0);
    Insets INSETS5550 = new Insets(5, 5, 5, 0);
    Insets INSETS5555 = new Insets(5, 5, 5, 5);
    Insets INSETS0000 = new Insets(0, 0, 0, 0);
    Vector _zoneData = null;
    ResSystemOpSet _opSet = null;
    ReservoirSysOp _resSysOp = null;
    SystemStorageZone _currentZone = null;
    String _oldStorageName = "";
    DefaultJPanel _parent = null;
    boolean _ignoringModifiedEvents = false;
    Dimension d = null;
    JLabel jStorageLabel = new JLabel("System Storage Zone");
    JLabel jDescriptionLabel = new JLabel("Description");
    JPanel jNameDescPanel = new JPanel();
    JPanel jTablePanel = new JPanel();
    JPanel jBottomPanel = new JPanel();
    RmaJTextField jStorageZoneTxt = new RmaJDssPathPartField();
    RmaJDescriptionField jDescriptionTxt = new RmaJDescriptionField();
    TwoTablesOneFixedPanel jSysStorageZoneTabelPanel = new TwoTablesOneFixedPanel();

    public JResSysStorageZonePanel() {
        this.buildPanel();
    }

    private void buildPanel() {
        this.setLayout(new GridBagLayout());
        this.jNameDescPanel.setLayout(new GridBagLayout());
        this.jTablePanel.setLayout(new GridBagLayout());
        Serializable serializable = new Insets(5, 10, 0, 0);
        this.jNameDescPanel.add((Component)this.jStorageLabel, new RmaGridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, serializable, 0, 0));
        this.jNameDescPanel.add((Component)this.jDescriptionLabel, new RmaGridBagConstraints(0, 1, 1, 1, 0.0, 1.0, 17, 0, serializable, 0, 0));
        this.jNameDescPanel.add((Component)this.jStorageZoneTxt, new RmaGridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 1, new Insets(5, 5, 0, 5), 0, 0));
        this.jNameDescPanel.add((Component)new JPanel(), new RmaGridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 5), 0, 0));
        this.jNameDescPanel.add((Component)this.jDescriptionTxt, new RmaGridBagConstraints(1, 1, 2, 1, 1.0, 1.0, 17, 1, this.INSETS5555, 0, -3));
        this.jStorageZoneTxt.getHeight();
        serializable = this.jStorageZoneTxt.getFont();
        ((Font)serializable).getSize();
        JResSysStorageZonePanel jResSysStorageZonePanel = this;
        jResSysStorageZonePanel.add(jResSysStorageZonePanel.jNameDescPanel, new RmaGridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 2, this.INSETS0000, 0, 0));
        this.jDescriptionLabel.setLabelFor((Component)this.jDescriptionTxt);
        this.jDescriptionTxt.setLineWrap(true);
        this.jDescriptionTxt.setWrapStyleWord(true);
        serializable = new Dimension(50, 25);
        this.jDescriptionTxt.setMinimumSize((Dimension)serializable);
        serializable = this.jDescriptionTxt.getFont();
        ((Font)serializable).getSize();
        this.jDescriptionTxt.setSize(10, 22);
        serializable = new TitledBorder("Contributing Zones per Reservoir and their Relative Balance");
        this.jTablePanel.setBorder((Border)((Object)serializable));
        this.jTablePanel.add((Component)this.jSysStorageZoneTabelPanel, new RmaGridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, this.INSETS0000, 0, 0));
        this.jSysStorageZoneTabelPanel.getUpperTable().addCellEditorListener((CellEditorListener)this);
        serializable = new Insets(5, 0, 0, 0);
        JResSysStorageZonePanel jResSysStorageZonePanel2 = this;
        jResSysStorageZonePanel2.add(jResSysStorageZonePanel2.jTablePanel, new RmaGridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 1, serializable, 0, 0));
        this.jStorageZoneTxt.addFocusListener((FocusListener)this);
        this.jStorageLabel.setDisplayedMnemonic('S');
        this.jStorageLabel.setLabelFor((Component)this.jStorageZoneTxt);
        this.jDescriptionLabel.setDisplayedMnemonic('D');
        this.jDescriptionLabel.setLabelFor((Component)this.jDescriptionTxt);
    }

    public void setData(Vector vector, ResSystemOpSet resSystemOpSet, ReservoirSysOp reservoirSysOp) {
        this._zoneData = vector;
        this._opSet = resSystemOpSet;
        this._resSysOp = reservoirSysOp;
        this._currentZone = null;
    }

    public void setParent(DefaultJPanel defaultJPanel) {
        this._parent = defaultJPanel;
    }

    @Override
    public void editingCanceled(ChangeEvent changeEvent) {
    }

    @Override
    public void editingStopped(ChangeEvent changeEvent) {
        this.replot();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        actionEvent.getSource();
    }

    public void addData(SystemStorageZone systemStorageZone) {
        if (this._zoneData == null) {
            this._zoneData = new Vector();
        }
        this._zoneData.addElement(systemStorageZone);
    }

    public boolean selectZone(String string) {
        if (string == null) {
            return false;
        }
        if (this.isModified() && !this.savePanel()) {
            return false;
        }
        for (int i = 0; i < this._zoneData.size(); ++i) {
            SystemStorageZone systemStorageZone = (SystemStorageZone)this._zoneData.elementAt(i);
            if (!string.equalsIgnoreCase(systemStorageZone.getName())) continue;
            this._currentZone = systemStorageZone;
            this.fillPanel();
            return true;
        }
        return true;
    }

    public void setIgnoringModifiedEvents(boolean bl) {
        this._ignoringModifiedEvents = bl;
    }

    public boolean isIgnoringModifiedEvents() {
        return this._ignoringModifiedEvents;
    }

    public void fillPanel() {
        Object object;
        Object object2;
        int n;
        if (this._zoneData == null || this._zoneData.size() == 0 || this._opSet == null || this._resSysOp == null) {
            return;
        }
        this.setIgnoreModifiedEvents(true);
        if (this._currentZone == null) {
            this._currentZone = (SystemStorageZone)this._zoneData.elementAt(0);
        }
        this.clearPanel();
        this.jStorageZoneTxt.setText(this._currentZone.getName());
        this.jDescriptionTxt.setText(this._currentZone.getDescription());
        RmaJTable rmaJTable = this.jSysStorageZoneTabelPanel.getLowerTable();
        RmaJTable rmaJTable2 = this.jSysStorageZoneTabelPanel.getUpperTable();
        rmaJTable.setSelectionMode(2);
        int[] nArray = this._resSysOp.getReservoirIDs();
        int n2 = 0;
        for (int i = 0; i < nArray.length; ++i) {
            ReservoirElement reservoirElement = this._resSysOp.getReservoirById(nArray[i]);
            if (reservoirElement != null) {
                ++n2;
                continue;
            }
            nArray[i] = -1;
        }
        Object[] objectArray = new int[n2];
        int n3 = 0;
        if (objectArray.length != 0) {
            for (n2 = 0; n2 < nArray.length; ++n2) {
                if (nArray[n2] == -1) continue;
                objectArray[n3++] = nArray[n2];
            }
        }
        nArray = objectArray;
        Object object3 = new String[objectArray.length];
        Object[] objectArray2 = new String[nArray.length];
        objectArray = objectArray2;
        Arrays.fill(objectArray2, "");
        rmaJTable2.setNumColumns(objectArray.length);
        rmaJTable2.setColumnLabels((String[])objectArray);
        rmaJTable2.setMlHeaderRenderer();
        rmaJTable2.setNumRows(1);
        if (this.d == null) {
            JComponent jComponent = (JComponent)this.jSysStorageZoneTabelPanel.getComponent(0);
            this.d = jComponent.getMinimumSize();
            this.d.height += 15;
            jComponent.setMinimumSize(this.d);
        }
        Arrays.fill((Object[])object3, "% Storage");
        rmaJTable.setNumColumns(((Object[])object3).length);
        rmaJTable.setColumnLabels((String[])object3);
        rmaJTable.setNumRows(10);
        rmaJTable.setRowBackground(0, Color.lightGray);
        rmaJTable.setRowEnabled(false, 0);
        for (n = 0; n < nArray.length; ++n) {
            object3 = this._resSysOp.getReservoirById(nArray[n]);
            rmaJTable.setCell((Object)RMAIO.toTable((int)100), 0, n);
            if (object3 == null) {
                objectArray[n] = (int)"Unknown";
                continue;
            }
            object2 = this._opSet.getOpSetReferences((ReservoirElement)object3);
            object = "Unknown";
            if (object2 != null) {
                object = object2.getDisplayName();
            }
            objectArray[n] = (int)(object3.getName() + "\n(" + (String)object + ")");
            object2 = this._opSet.getOpSetReferences((ReservoirElement)object3);
            ((ReservoirElement)object3).getReservoirOp().getOperationSets();
            if (object2 == null || (object3 = ((OpSet)(object = ((OpSetRef)object2).getOpSet())).getZoneVector()) == null || ((Vector)object3).size() == 0) continue;
            object2 = rmaJTable2;
            object = rmaJTable2.setComboBoxEditor(n, (Vector)object3);
            ((JComboBox)object).addItemListener(new JResSysStorageZonePanel$1(this, (JTable)object2));
            if (((Vector)object3).size() <= 0) continue;
            rmaJTable2.setCell(((Vector)object3).elementAt(0), 0, n);
        }
        rmaJTable2.setColumnLabels((String[])objectArray);
        for (n = 0; n < this._currentZone.getNumResevoirStorages() && n < nArray.length; ++n) {
            ZoneBounds zoneBounds = this._currentZone.getStorageZoneBounds(nArray[n]);
            object2 = this._currentZone.getSystemStorage(nArray[n]);
            if (zoneBounds != null) {
                rmaJTable2.setCell((Object)zoneBounds.getUpperBound(), 0, n);
            }
            if (object2 == null) continue;
            object = ((SystemReservoirStorage)object2).getStorageValues();
            if (rmaJTable.getNumRows() < ((Object)object).length) {
                rmaJTable.setNumRows(((Object)object).length + 5);
            }
            for (int i = 0; i < ((Object)object).length; ++i) {
                rmaJTable.setCell((Object)RMAIO.toTable((double)object[i]), i, n);
            }
        }
        ClientApp.app();
        Object object4 = new String("Workspace: " + ClientApp.Workspace().getTitleName());
        object4 = (String)object4 + "\n Storage Zone: " + this._currentZone.getName() + " \n ";
        new PageText((String)object4, 0);
        int[] nArray2 = new int[rmaJTable2.getColumnCount()];
        object2 = nArray2;
        Arrays.fill(nArray2, 150);
        rmaJTable2.setColumnWidths((int[])object2);
        this.replot();
        this.setIgnoreModifiedEvents(false);
    }

    public void setModified(boolean bl) {
        if (!this.isIgnoringModifiedEvents()) {
            super.setModified(bl);
        }
    }

    public void refresh() {
    }

    public boolean savePanel() {
        if (this.jStorageZoneTxt.getText().equals("")) {
            RMAIO.postError((Component)((Object)this), (String)"Cannot have a empty storage zone name!");
            return false;
        }
        this._currentZone.setName(this.jStorageZoneTxt.getText());
        this._oldStorageName = this.jStorageZoneTxt.getText();
        this._currentZone.setDescription(this.jDescriptionTxt.getText());
        RmaJTable rmaJTable = this.jSysStorageZoneTabelPanel.getLowerTable();
        RmaJTable rmaJTable2 = this.jSysStorageZoneTabelPanel.getUpperTable();
        rmaJTable.commitEdit(true);
        rmaJTable2.commitEdit(true);
        int[] nArray = this._resSysOp.getReservoirIDs();
        for (int i = 0; i < nArray.length; ++i) {
            ReservoirElement reservoirElement = this._resSysOp.getReservoirById(nArray[i]);
            Object object = rmaJTable2.getCell(0, i);
            if (!(object instanceof StorageZone)) continue;
            object = (StorageZone)object;
            OpSetRef opSetRef = this._opSet.getOpSetReferences(reservoirElement);
            this._currentZone.addStorageZoneBounds(reservoirElement, new ZoneBounds(reservoirElement.getIndex(), opSetRef.getOpSetID(), (StorageZone)object, null));
            object = new SystemReservoirStorage(reservoirElement.getIndex());
            for (int j = 0; j < rmaJTable.getNumRows(); ++j) {
                double d = RMAIO.parseDouble((Object)rmaJTable.getCell(j, i));
                if (d == Double.NEGATIVE_INFINITY) continue;
                ((SystemReservoirStorage)object).addStorageValue(d);
            }
            this._currentZone.addSystemReservoirStorage(reservoirElement, (SystemReservoirStorage)object);
        }
        this.replot();
        this.setModified(false);
        return true;
    }

    public void clearPanel() {
        this.jStorageZoneTxt.setText("");
        this.jDescriptionTxt.setText("");
        RmaJTable rmaJTable = this.jSysStorageZoneTabelPanel.getLowerTable();
        RmaJTable rmaJTable2 = this.jSysStorageZoneTabelPanel.getUpperTable();
        (new String[1])[0] = "";
        rmaJTable.clearAll();
        rmaJTable2.clearAll();
    }

    public void replot() {
        this.plotStorageZone();
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
    }

    @Override
    public void focusLost(FocusEvent object) {
        object = ((EventObject)object).getSource();
        if (this._currentZone == null) {
            return;
        }
        if (object == this.jStorageZoneTxt) {
            if (this.jStorageZoneTxt.getText().equals("")) {
                this.jStorageZoneTxt.setText(this._currentZone.getName());
                RMAIO.postError((Component)((Object)this), (String)"Cannot have a blank Rule Name!");
                return;
            }
            this._currentZone.setName(this.jStorageZoneTxt.getText());
            ((JResSysSysOpsPanel)this._parent).treeDataChanged(0, this.jStorageZoneTxt.getText(), this._oldStorageName);
        }
    }

    public void deselectPanel() {
        if (this.isModified()) {
            this.savePanel();
        }
    }

    private void configurePlotPanel(G2dPanel g2dPanel) {
        PlotDefaults plotDefaults = PlotDefaultsManager.getDefaults();
        PlotDefaultsManager.setDefaults((PlotDefaults)new HotPlotDefaults());
        G2dPanelProp g2dPanelProp = new G2dPanelProp();
        new G2dPanelProp().hasTitle = false;
        g2dPanelProp.hasToolbar = false;
        g2dPanelProp.hasLegend = false;
        G2dPlotProp g2dPlotProp = new G2dPlotProp();
        new G2dPlotProp().hasXScroll = false;
        g2dPlotProp.hasYScroll = false;
        g2dPlotProp.x1AxisProp.name = "Minutes";
        g2dPlotProp.x1AxisProp.type = 2;
        g2dPlotProp.y1AxisProp.type = 0;
        g2dPlotProp.y1AxisProp.name = "Elevation";
        g2dPlotProp.x1AxisProp.numTicLabelLayers = 1;
        g2dPlotProp.hasX1Label = false;
        g2dPlotProp.y1AxisProp.isReversed = true;
        g2dPlotProp.x1AxisProp.isDefaultLimits = false;
        g2dPlotProp.x1AxisProp.min = 0.0;
        g2dPlotProp.x1AxisProp.max = 525600.0;
        g2dPanelProp.addPlotProp(g2dPlotProp);
        g2dPanel.configurePanel(g2dPanelProp);
        PlotDefaultsManager.setDefaults((PlotDefaults)plotDefaults);
    }

    private void plotStorageZone() {
        Vector<ComplexSeasonalData> vector = new Vector<ComplexSeasonalData>();
        new Vector();
        if (this._zoneData != null) {
            Object object;
            ComplexSeasonalData complexSeasonalData;
            NamedType namedType;
            Cloneable cloneable;
            int n;
            int n2 = 1;
            for (n = 0; n < this._zoneData.size(); ++n) {
                cloneable = (SystemStorageZone)this._zoneData.elementAt(n);
                cloneable = ((SystemStorageZone)cloneable).getAllStorageZoneBounds();
                for (int i = 0; i < ((Vector)cloneable).size(); ++i) {
                    ZoneBounds zoneBounds = (ZoneBounds)((Vector)cloneable).elementAt(i);
                    namedType = zoneBounds.getUpperBound();
                    if (namedType == null || (complexSeasonalData = namedType.getSeasonalRecord()) == null || complexSeasonalData.getTimeArray() == null || complexSeasonalData.getTimeArray().length <= 1) continue;
                    object = complexSeasonalData.getTimeArray();
                    int n3 = object[((int[])object).length - 1] - object[0];
                    int n4 = n3 / 525600;
                    if (n3 % 525600 > 0) {
                        ++n4;
                    }
                    if (n4 <= n2) continue;
                    n2 = n4;
                }
            }
            for (n = 0; n < this._zoneData.size(); ++n) {
                complexSeasonalData = new ComplexSeasonalData();
                complexSeasonalData.setYAxisName("Elevation");
                cloneable = (SystemStorageZone)this._zoneData.elementAt(n);
                if (cloneable == this._currentZone) {
                    cloneable = this.jSysStorageZoneTabelPanel.getUpperTable();
                    cloneable.commitEdit(true);
                    for (int i = 0; i < cloneable.getColumnCount(); ++i) {
                        Object object2 = cloneable.getCell(0, i);
                        if (!(object2 instanceof StorageZone) || (namedType = ((StorageZone)object2).getSeasonalRecord()) == null) continue;
                        object = new SimpleSeasonalData();
                        object.setData((SeasonalRecord)namedType);
                        object.setPlotYears(n2);
                        object.setInterpolationType("linear");
                        object.calcPlotArrays();
                        complexSeasonalData.addData((SimpleSeasonalData)object);
                    }
                } else {
                    Vector vector2 = ((SystemStorageZone)cloneable).getAllStorageZoneBounds();
                    for (int i = 0; i < vector2.size(); ++i) {
                        namedType = (ZoneBounds)vector2.elementAt(i);
                        StorageZone storageZone = ((ZoneBounds)namedType).getUpperBound();
                        object = storageZone;
                        if (storageZone == null || (cloneable = ((StorageZone)object).getSeasonalRecord()) == null) continue;
                        namedType = new SimpleSeasonalData();
                        namedType.setData((SeasonalRecord)cloneable);
                        namedType.setPlotYears(n2);
                        namedType.setInterpolationType("linear");
                        namedType.calcPlotArrays();
                        complexSeasonalData.addData((SimpleSeasonalData)namedType);
                    }
                }
                complexSeasonalData.calcPlotArrays();
                vector.addElement(complexSeasonalData);
            }
        }
    }
}

