/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.client.RenameDlg;
import hec.rss.client.JNameSelectDialog;
import hec.rss.client.JResSysStorageZonePanel;
import hec.rss.client.NewSystemOpSetJDialog;
import hec.rss.client.ResSystemStorageZoneRootNode;
import hec.rss.client.ReservoirSystemJDialog;
import hec.rss.model.OpRuleRef;
import hec.rss.model.ResSystemOpSet;
import hec.rss.model.ReservoirElement;
import hec.rss.model.ReservoirSysOp;
import hec.rss.model.SystemStorageZone;
import hec.server.NameDialog;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.Document;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import rma.swing.DefaultJPanel;
import rma.swing.RmaGridBagConstraints;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJDescriptionField;
import rma.swing.text.DssPathnamePartDocument;
import rma.util.RMAIO;
import rma.util.RMAUtil;

public class JResSysSysOpsPanel
extends DefaultJPanel
implements ActionListener,
ItemListener,
TreeSelectionListener {
    Insets INSETS5505 = new Insets(5, 5, 0, 5);
    Insets INSETS5500 = new Insets(5, 5, 0, 0);
    Insets INSETS5550 = new Insets(5, 5, 5, 0);
    Insets INSETS5555 = new Insets(5, 5, 5, 5);
    private int DEFAULT_ZONE_TREE_WIDTH = 175;
    private int MIN_PLOT_ZONES = 2;
    JDialog _parent = null;
    boolean _controlsCreated = false;
    ReservoirElement _reservoir = null;
    Vector _opSetList = null;
    DefaultJPanel _currentPanel = null;
    ResSystemStorageZoneRootNode _root = new ResSystemStorageZoneRootNode();
    ReservoirSysOp _resSysOp = null;
    public ResSystemOpSet _currentSysOpSet = null;
    SystemStorageZone _currentZone = null;
    private Vector<SystemStorageZone> _zoneVec = null;
    public static final String NEW_OPERATION_SET = "NewOperationsSet";
    public static final String RENAME_OPERATION_SET = "RenameOperationSet";
    public static final String DELETE_OPERATION_SET = "DeleteOperationSet";
    public static final String DUPLICATE_OPERATION_SET = "DuplicateOperationSet";
    public static final String NEW_ZONE = "NewZone";
    public static final String REMOVE_ZONE = "RemoveZone";
    public static final String COPY_ZONE = "CopyZone";
    public static final int NODE_NAME_CHANGE = 0;
    public static final int NODE_ORDER_CHANGE = 1;
    public static final String SELECT_GUIDE_CURVE = "SelectGuideCurve";
    JResSysStorageZonePanel jStorageZonePanel;
    JPanel panel1;
    JPanel emptyPanel;
    JPanel cardPanel;
    JSplitPane jSplitPane;
    JTree jZoneTree;
    JLabel systemBalanceLabel;
    JLabel jDescriptionLabel;
    RmaJComboBox jOpsComboBox;
    RmaJDescriptionField jDescriptionTxt;

    public boolean areControlsCreated() {
        return this._controlsCreated;
    }

    public void createControls() {
        if (this.areControlsCreated()) {
            return;
        }
        this.jStorageZonePanel = new JResSysStorageZonePanel();
        this.emptyPanel = new JPanel();
        this.panel1 = new JPanel();
        this.cardPanel = new JPanel();
        this.jSplitPane = new JSplitPane(1, false);
        this.jZoneTree = new JTree();
        this.systemBalanceLabel = new JLabel("System Balance    ");
        this.jDescriptionLabel = new JLabel("Description");
        this.jOpsComboBox = new RmaJComboBox();
        this.jDescriptionTxt = new RmaJDescriptionField();
        this.setLayout(new GridBagLayout());
        this.panel1.setLayout(new GridBagLayout());
        Serializable serializable = new Insets(0, 5, 0, 0);
        Serializable serializable2 = new Insets(0, 0, 5, 5);
        this.panel1.add((Component)this.systemBalanceLabel, new RmaGridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, (Insets)serializable, 0, 0));
        this.panel1.add((Component)this.jOpsComboBox, new RmaGridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, (Insets)serializable, 0, 0));
        this.panel1.add((Component)this.jDescriptionLabel, new RmaGridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, (Insets)serializable, 0, 0));
        this.panel1.add((Component)this.jDescriptionTxt, new RmaGridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 17, 1, (Insets)serializable, 0, -3));
        JResSysSysOpsPanel jResSysSysOpsPanel = this;
        jResSysSysOpsPanel.add(jResSysSysOpsPanel.panel1, new RmaGridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 17, 2, serializable2, 0, 0));
        this.jDescriptionLabel.setLabelFor((Component)this.jDescriptionTxt);
        this.jDescriptionTxt.setLineWrap(true);
        this.jDescriptionTxt.setWrapStyleWord(true);
        this.jOpsComboBox.setModifiable(false);
        this.cardPanel.setLayout(new CardLayout());
        this.cardPanel.add("StorageZone", (Component)((Object)this.jStorageZonePanel));
        this.cardPanel.add("EMPTY", this.emptyPanel);
        this.jStorageZonePanel.setParent(this);
        serializable = new JScrollPane(this.jZoneTree);
        serializable2 = new TitledBorder("System Zones");
        ((JComponent)serializable).setBorder((Border)((Object)serializable2));
        ((JComponent)serializable).setPreferredSize(new Dimension(100, 100));
        ((JComponent)serializable).setMinimumSize(new Dimension(100, 100));
        ((JScrollPane)serializable).setVerticalScrollBarPolicy(20);
        ((JScrollPane)serializable).setHorizontalScrollBarPolicy(30);
        this.jSplitPane.setLeftComponent((Component)serializable);
        this.jSplitPane.setRightComponent(this.cardPanel);
        ((DefaultTreeModel)this.jZoneTree.getModel()).setRoot(this._root);
        this.jZoneTree.setRootVisible(false);
        this.jZoneTree.getSelectionModel().setSelectionMode(1);
        this.jSplitPane.setDividerLocation(this.DEFAULT_ZONE_TREE_WIDTH);
        JResSysSysOpsPanel jResSysSysOpsPanel2 = this;
        jResSysSysOpsPanel2.add(jResSysSysOpsPanel2.jSplitPane, new RmaGridBagConstraints(0, 1, 1, 1, 2.0, 1.0, 16, 1, this.INSETS5555, 0, 0));
        this.systemBalanceLabel.setDisplayedMnemonic('O');
        this.systemBalanceLabel.setLabelFor((Component)this.jOpsComboBox);
        this.jDescriptionLabel.setDisplayedMnemonic('p');
        this.jDescriptionLabel.setLabelFor((Component)this.jDescriptionTxt);
        this.jOpsComboBox.addItemListener((ItemListener)this);
        this.jZoneTree.addTreeSelectionListener(this);
        this._controlsCreated = true;
        this.setModified(false);
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl) {
            if (!this.areControlsCreated()) {
                this.createControls();
            }
            this.jSplitPane.setDividerLocation(this.DEFAULT_ZONE_TREE_WIDTH);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent object) {
        if (((ItemEvent)object).getStateChange() == 2) {
            return;
        }
        if ((object = ((EventObject)object).getSource()) == this.jOpsComboBox) {
            this.OperationsCombo_StateChanged();
        }
    }

    @Override
    public void actionPerformed(ActionEvent object) {
        if ((object = ((EventObject)object).getSource()) instanceof JMenuItem) {
            if (((AbstractButton)(object = (JMenuItem)object)).getActionCommand().equals(NEW_OPERATION_SET)) {
                this.mNewOperationSet_ActionPerformed();
                return;
            }
            if (((AbstractButton)object).getActionCommand().equals(DELETE_OPERATION_SET)) {
                this.mRemoveOperationSet_ActionPerformed();
                return;
            }
            if (((AbstractButton)object).getActionCommand().equals(RENAME_OPERATION_SET)) {
                this.mRenameOperationSet_ActionPerformed();
                return;
            }
            if (((AbstractButton)object).getActionCommand().equals(DUPLICATE_OPERATION_SET)) {
                this.mDuplicateOperationsSet_ActionCommand();
                return;
            }
            if (((AbstractButton)object).getActionCommand().equals(NEW_ZONE)) {
                this.mNewZone_ActionPerformed();
                return;
            }
            if (((AbstractButton)object).getActionCommand().equals(REMOVE_ZONE)) {
                this.mRemoveZone_ActionPerformed();
            }
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent serializable) {
        this._currentSysOpSet = (ResSystemOpSet)this.jOpsComboBox.getSelectedItem();
        if (((TreeSelectionEvent)serializable).getNewLeadSelectionPath() == null) {
            return;
        }
        serializable = ((TreeSelectionEvent)serializable).getNewLeadSelectionPath();
        if ((serializable = (DefaultMutableTreeNode)((TreePath)serializable).getLastPathComponent()) != null) {
            if (this._currentPanel != null) {
                this._currentPanel.deselectPanel();
                serializable = this.jZoneTree.getSelectionPath();
                serializable = (DefaultMutableTreeNode)((TreePath)serializable).getLastPathComponent();
            }
            if (((DefaultMutableTreeNode)serializable).getLevel() == 1) {
                if (!this.jStorageZonePanel.selectZone((serializable = (SystemStorageZone)((DefaultMutableTreeNode)serializable).getUserObject()).getName())) {
                    return;
                }
                this._currentZone = serializable;
                ((CardLayout)this.cardPanel.getLayout()).show(this.cardPanel, "StorageZone");
                this._currentPanel = this.jStorageZonePanel;
                if (!this.jStorageZonePanel.isModified()) {
                    this.setModified(false);
                }
            }
        }
    }

    public ResSystemOpSet getSelectedSystemBalance() {
        ResSystemOpSet resSystemOpSet = (ResSystemOpSet)this.jOpsComboBox.getSelectedItem();
        return resSystemOpSet;
    }

    private void OperationsCombo_StateChanged() {
        ResSystemOpSet resSystemOpSet = (ResSystemOpSet)this.jOpsComboBox.getSelectedItem();
        if (resSystemOpSet == null) {
            return;
        }
        if (this._resSysOp == null) {
            return;
        }
        System.out.println("Saving old opset");
        boolean bl = true;
        if (this.isModified()) {
            bl = this.saveOpSet();
        }
        if (!bl) {
            System.out.println("Error Saving old opset");
            this.jOpsComboBox.removeItemListener((ItemListener)this);
            this.jOpsComboBox.setSelectedItem((Object)this._currentSysOpSet);
            return;
        }
        this.fillPanel(resSystemOpSet);
    }

    private void mNewOperationSet_ActionPerformed() {
        NewSystemOpSetJDialog newSystemOpSetJDialog = new NewSystemOpSetJDialog(this._parent, "New System Balance", true);
        if (this._resSysOp == null) {
            return;
        }
        int[] nArray = this._resSysOp.getReservoirIDs();
        ReservoirElement[] reservoirElementArray = new ReservoirElement[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            ReservoirElement reservoirElement;
            reservoirElementArray[i] = reservoirElement = this._resSysOp.getReservoirById(nArray[i]);
        }
        newSystemOpSetJDialog.setData(reservoirElementArray, this._resSysOp);
        newSystemOpSetJDialog.setVisible(true);
        if (newSystemOpSetJDialog.isCanceled()) {
            return;
        }
        ResSystemOpSet resSystemOpSet = newSystemOpSetJDialog.getNewOperationSet();
        if (resSystemOpSet == null) {
            return;
        }
        this.setEnabled(true);
        this.jOpsComboBox.addItem((Object)resSystemOpSet);
        this.jOpsComboBox.setSelectedItem((Object)resSystemOpSet);
        this._currentSysOpSet = resSystemOpSet;
        ((ReservoirSystemJDialog)((Object)this._parent)).setZoneMenuEnabled(true);
        this.setModified(true);
    }

    private void validateAvailableActions() {
        int n = this._currentSysOpSet.getStorageZoneIDs().length;
        if (this._currentSysOpSet != null && n >= this.MIN_PLOT_ZONES) {
            ((ReservoirSystemJDialog)((Object)this._parent)).setPlotButtonEnabled(true);
        } else {
            ((ReservoirSystemJDialog)((Object)this._parent)).setPlotButtonEnabled(false);
        }
        if (n > 0) {
            ((ReservoirSystemJDialog)((Object)this._parent)).setZoneActionsEnabled(true);
            return;
        }
        ((ReservoirSystemJDialog)((Object)this._parent)).setZoneActionsEnabled(false);
    }

    private void mRemoveOperationSet_ActionPerformed() {
        Object object = this._resSysOp.getSystemOpSetIDs();
        if (object == null || ((int[])object).length == 0) {
            RMAIO.postWarning((Component)((Object)this), (String)"No Operation Sets Exist");
            return;
        }
        ResSystemOpSet[] resSystemOpSetArray = new ResSystemOpSet[((int[])object).length];
        for (int i = 0; i < ((int[])object).length; ++i) {
            resSystemOpSetArray[i] = this._resSysOp.getSystemOpSet(object[i]);
        }
        JNameSelectDialog jNameSelectDialog = new JNameSelectDialog(this._parent, true);
        jNameSelectDialog.setData(resSystemOpSetArray);
        jNameSelectDialog.setTitle("Delete Operation Set");
        jNameSelectDialog.setVisible(true);
        if (jNameSelectDialog.isCanceled()) {
            return;
        }
        object = (ResSystemOpSet)jNameSelectDialog.getSelectedName();
        int n = RMAIO.postYesNoWarning((Component)((Object)this), (String)("Do you really want to delete " + object.getName()));
        if (n == 1) {
            return;
        }
        this.jOpsComboBox.removeItemListener((ItemListener)this);
        n = ((DefaultComboBoxModel)this.jOpsComboBox.getModel()).getIndexOf(object);
        int n2 = this.jOpsComboBox.getSelectedIndex();
        this.jOpsComboBox.removeItem(object);
        this._resSysOp.removeSystemOpSet((ResSystemOpSet)object);
        if (this.jOpsComboBox.getItemCount() <= 0) {
            ((CardLayout)this.cardPanel.getLayout()).show(this.cardPanel, "EMPTY");
            this.jStorageZonePanel.clearPanel();
            this._root.removeAllChildren();
            ((DefaultTreeModel)this.jZoneTree.getModel()).nodeStructureChanged(this._root);
            ((ReservoirSystemJDialog)((Object)this._parent)).setZoneMenuEnabled(false);
            ((ReservoirSystemJDialog)((Object)this._parent)).setBalanceActionsEnabled(false);
            this.setEnabled(false);
        } else if (n == n2) {
            this.jDescriptionTxt.setText("");
            this._root.removeAllChildren();
            ((DefaultTreeModel)this.jZoneTree.getModel()).nodeStructureChanged(this._root);
            this.expandAllTreeNodes();
            this.jOpsComboBox.setSelectedIndex(0);
            object = (ResSystemOpSet)this.jOpsComboBox.getSelectedItem();
            this.fillPanel((ResSystemOpSet)object);
        }
        this.jOpsComboBox.addItemListener((ItemListener)this);
        this.setModified(true);
    }

    private void mRenameOperationSet_ActionPerformed() {
        RenameDlg renameDlg = new RenameDlg((Dialog)this._parent, "Rename Operation Set", true);
        ResSystemOpSet resSystemOpSet = (ResSystemOpSet)this.jOpsComboBox.getSelectedItem();
        if (resSystemOpSet == null) {
            RMAIO.postError((Component)((Object)this), (String)"Must select a valid operation set!");
            return;
        }
        renameDlg.removeFileComponents();
        renameDlg.setName(resSystemOpSet.getName());
        renameDlg.setDescription(resSystemOpSet.getDescription());
        renameDlg.setVisible(true);
        if (renameDlg.getCanceled()) {
            return;
        }
        this.jOpsComboBox.removeItemListener((ItemListener)this);
        this.jOpsComboBox.removeItem((Object)resSystemOpSet);
        resSystemOpSet.setName(renameDlg.getName());
        resSystemOpSet.setDescription(renameDlg.getDescription());
        this.jOpsComboBox.addItem((Object)resSystemOpSet);
        this.jOpsComboBox.setSelectedItem((Object)resSystemOpSet);
        this.jOpsComboBox.addItemListener((ItemListener)this);
        this.jDescriptionTxt.setText(renameDlg.getDescription());
        this.setModified(true);
    }

    private void mDuplicateOperationsSet_ActionCommand() {
    }

    private void mNewZone_ActionPerformed() {
        Object object;
        Object object2;
        while (true) {
            if (this._currentSysOpSet == null) {
                RMAIO.postError((Component)((Object)this), (String)"Create an Operation Set first");
                return;
            }
            object2 = new NameDialog((Dialog)this._parent, "New Zone", true);
            object2.setNameFieldDocument((Document)new DssPathnamePartDocument());
            object2.setVisible(true);
            if (object2.isCanceled()) {
                return;
            }
            ((CardLayout)this.cardPanel.getLayout()).show(this.cardPanel, "StorageZone");
            object = object2.getName();
            object2 = object2.getDescription();
            if (((String)object).equals("")) {
                RMAIO.postError((Component)((Object)this), (String)"Cannot have blank name");
                return;
            }
            if (!this._currentSysOpSet.doesStorageZoneNameExist((String)object)) break;
            RMAIO.postError((Component)((Object)this), (String)("Storage Zone " + (String)object + " already exits! Please use another name."));
        }
        if ((object2 = this._currentSysOpSet.addNewSystemStorageZone((String)object, (String)object2)) == null) {
            RMAIO.postError((Component)((Object)this), (String)"Unable to create a new System Operation Set!");
            return;
        }
        this.jStorageZonePanel.addData((SystemStorageZone)object2);
        this.jStorageZonePanel.selectZone(object2.getName());
        this.jZoneTree.removeTreeSelectionListener(this);
        object2 = this._root.add((SystemStorageZone)object2);
        this._root.sortChildrenTreeNodes();
        ((DefaultTreeModel)this.jZoneTree.getModel()).nodeStructureChanged(this._root);
        this.expandAllTreeNodes();
        object = new TreePath(this._root);
        object = ((TreePath)object).pathByAddingChild(object2);
        this.jZoneTree.setSelectionPath((TreePath)object);
        this.jZoneTree.addTreeSelectionListener(this);
        this.validateAvailableActions();
        this.setModified(true);
    }

    private void mRemoveZone_ActionPerformed() {
        if (this._currentZone == null) {
            Serializable serializable = this.jZoneTree.getSelectionPath();
            if (serializable == null) {
                RMAIO.postWarning((Component)((Object)this), (String)"Need to select a Zone First");
                return;
            }
            if ((serializable = (DefaultMutableTreeNode)((TreePath)serializable).getLastPathComponent()) == null) {
                return;
            }
            int n = ((DefaultMutableTreeNode)serializable).getLevel();
            if (n > 1) {
                RMAIO.postWarning((Component)((Object)this), (String)"Need to select a Zone First");
                return;
            }
            this._currentZone = (SystemStorageZone)((DefaultMutableTreeNode)serializable).getUserObject();
        }
        JResSysSysOpsPanel jResSysSysOpsPanel = this;
        int n = JOptionPane.showConfirmDialog((Component)((Object)jResSysSysOpsPanel), "Delete System Storage Zone \"" + jResSysSysOpsPanel._currentZone.getName() + "\"", "RSS - Delete System Storage Zone", 2, 2);
        if (n != 0) {
            return;
        }
        this._currentSysOpSet.deleteSystemStorageZone(this._currentZone.getIndex());
        this._currentZone = null;
        JResSysSysOpsPanel jResSysSysOpsPanel2 = this;
        jResSysSysOpsPanel2.fillPanel(jResSysSysOpsPanel2._currentSysOpSet);
        int[] nArray = this._currentSysOpSet.getStorageZoneIDs();
        if (nArray.length == 0) {
            this.jZoneTree.removeTreeSelectionListener(this);
            this._root.removeAllChildren();
            ((DefaultTreeModel)this.jZoneTree.getModel()).nodeStructureChanged(this._root);
            this.jZoneTree.addTreeSelectionListener(this);
            ((CardLayout)this.cardPanel.getLayout()).show(this.cardPanel, "EMPTY");
        }
        this.validateAvailableActions();
        this.setModified(true);
    }

    public void refresh() {
    }

    public void fillPanel() {
        if (!this._controlsCreated) {
            return;
        }
        this.jOpsComboBox.removeAllItems();
        this.clearPanel();
        if (this._resSysOp == null) {
            return;
        }
        int[] nArray = this._resSysOp.getSystemOpSetIDs();
        this.jOpsComboBox.removeItemListener((ItemListener)this);
        for (int i = 0; i < nArray.length; ++i) {
            this.jOpsComboBox.addItem((Object)this._resSysOp.getSystemOpSet(nArray[i]));
        }
        if (nArray.length > 0) {
            this.setEnabled(true);
            this.jOpsComboBox.setSelectedIndex(0);
            JResSysSysOpsPanel jResSysSysOpsPanel = this;
            jResSysSysOpsPanel.fillPanel((ResSystemOpSet)jResSysSysOpsPanel.jOpsComboBox.getSelectedItem());
            ((ReservoirSystemJDialog)((Object)this._parent)).setZoneMenuEnabled(true);
        } else {
            ((CardLayout)this.cardPanel.getLayout()).show(this.cardPanel, "EMPTY");
            this.setEnabled(false);
        }
        this.jOpsComboBox.addItemListener((ItemListener)this);
        this.setModified(false);
    }

    private void fillPanel(ResSystemOpSet serializable) {
        if (!this._controlsCreated) {
            return;
        }
        if (serializable == null) {
            return;
        }
        this._currentSysOpSet = serializable;
        this._root.setSystem(this._resSysOp.getSystem());
        this.jDescriptionTxt.setText(serializable.getDescription());
        this.jZoneTree.removeTreeSelectionListener(this);
        this.fillSystemZones();
        this.jStorageZonePanel.setData(this._zoneVec, (ResSystemOpSet)serializable, this._resSysOp);
        this.jStorageZonePanel.fillPanel();
        if (this._root.getChildCount() > 0 && (serializable = (DefaultMutableTreeNode)this._root.getChildAt(0)) != null) {
            serializable = (SystemStorageZone)((DefaultMutableTreeNode)serializable).getUserObject();
            this.jStorageZonePanel.selectZone(serializable.getName());
        }
        ((ReservoirSystemJDialog)((Object)this._parent)).setBalanceActionsEnabled(true);
        this.jOpsComboBox.setEnabled(true);
        this.setModified(false);
    }

    private void fillSystemZones() {
        int[] nArray = this._currentSysOpSet.getStorageZoneIDs();
        this._root.removeAllChildren();
        ((DefaultTreeModel)this.jZoneTree.getModel()).nodeStructureChanged(this._root);
        this._zoneVec = new Vector();
        if (nArray != null && nArray.length > 0) {
            Object[] objectArray;
            this.jStorageZonePanel.clearPanel();
            ((CardLayout)this.cardPanel.getLayout()).show(this.cardPanel, "StorageZone");
            for (int i = 0; i < nArray.length; ++i) {
                objectArray = new TreePath(this._root);
                Object object = this._currentSysOpSet.getStorageZone(nArray[i]);
                this._zoneVec.addElement((SystemStorageZone)object);
                DefaultMutableTreeNode defaultMutableTreeNode = this._root.add((SystemStorageZone)object);
                objectArray = objectArray.pathByAddingChild(defaultMutableTreeNode);
                object = ((SystemStorageZone)object).getSortedZoneRuleRefs(true);
                object = ((Vector)object).elements();
                while (object.hasMoreElements()) {
                    DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(object.nextElement());
                    defaultMutableTreeNode.add(defaultMutableTreeNode2);
                }
                this.jZoneTree.setSelectionPath((TreePath)objectArray);
            }
            ((DefaultTreeModel)this.jZoneTree.getModel()).nodeStructureChanged(this._root);
            this.expandAllTreeNodes();
            TreeNode treeNode = this._root.getChildAt(0);
            if (treeNode != null) {
                objectArray = new Object[]{this._root, treeNode};
                this.jZoneTree.setSelectionPath(new TreePath(objectArray));
            }
            this.jZoneTree.addTreeSelectionListener(this);
        } else {
            ((CardLayout)this.cardPanel.getLayout()).show(this.cardPanel, "EMPTY");
        }
        this.validateAvailableActions();
    }

    private boolean saveOpSet() {
        if (!this.areControlsCreated()) {
            return true;
        }
        if (this._currentSysOpSet == null) {
            return true;
        }
        this._currentSysOpSet.setDescription(this.jDescriptionTxt.getText());
        if (this.jStorageZonePanel.isVisible()) {
            this.jStorageZonePanel.savePanel();
        }
        return true;
    }

    public boolean savePanel() {
        if (!this.areControlsCreated()) {
            return true;
        }
        if (this._currentSysOpSet == null) {
            return true;
        }
        this._currentSysOpSet.setDescription(this.jDescriptionTxt.getText());
        boolean bl = true;
        if (this.jStorageZonePanel.isVisible()) {
            bl = true & this.jStorageZonePanel.savePanel();
        }
        if (!bl) {
            return false;
        }
        this.resortTreeNodes();
        return true;
    }

    public void resortTreeNodes() {
        TreePath treePath = this.jZoneTree.getSelectionPath();
        this._root.sortChildrenTreeNodes();
        ((DefaultTreeModel)this.jZoneTree.getModel()).nodeStructureChanged(this._root);
        this.jZoneTree.setSelectionPath(treePath);
    }

    public void clearPanel() {
        this.jDescriptionTxt.setText("");
        this._root.removeAllChildren();
        this.jStorageZonePanel.clearPanel();
        ((DefaultTreeModel)this.jZoneTree.getModel()).nodeStructureChanged(this._root);
        if (this.jOpsComboBox.getItemCount() <= 0) {
            ((CardLayout)this.cardPanel.getLayout()).show(this.cardPanel, "EMPTY");
            ((ReservoirSystemJDialog)((Object)this._parent)).setZoneMenuEnabled(false);
        }
    }

    public void clearBalanceComboBox() {
        this.jOpsComboBox.removeAllItems();
    }

    public void setParent(JDialog jDialog) {
        this._parent = jDialog;
    }

    public void setData(ReservoirSysOp reservoirSysOp) {
        this._resSysOp = reservoirSysOp;
    }

    public ReservoirElement getData() {
        return this._reservoir;
    }

    public void treeDataChanged(int n, String object, String object2) {
        this.jZoneTree.removeTreeSelectionListener(this);
        Serializable serializable = this.jZoneTree.getSelectionPath();
        serializable = (DefaultMutableTreeNode)((TreePath)serializable).getLastPathComponent();
        if (serializable == null) {
            return;
        }
        if (n == 0) {
            Enumeration<TreeNode> enumeration = this._root.breadthFirstEnumeration();
            while (enumeration.hasMoreElements()) {
                Object object3 = (DefaultMutableTreeNode)enumeration.nextElement();
                if (!((object3 = ((DefaultMutableTreeNode)object3).getUserObject()) instanceof OpRuleRef) || !object3.toString().equals(object)) continue;
                ((OpRuleRef)object3).setName((String)object2);
            }
            ((DefaultTreeModel)this.jZoneTree.getModel()).nodeChanged((TreeNode)((Object)serializable));
            this.expandAllTreeNodes();
        } else if (((DefaultMutableTreeNode)serializable).getLevel() == 2) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)((DefaultMutableTreeNode)serializable).getParent();
            Cloneable cloneable = (SystemStorageZone)defaultMutableTreeNode.getUserObject();
            defaultMutableTreeNode.removeAllChildren();
            cloneable = cloneable.getSortedZoneRuleRefs(true);
            object = ((Vector)cloneable).elements();
            while (object.hasMoreElements()) {
                object2 = new DefaultMutableTreeNode(object.nextElement());
                defaultMutableTreeNode.add((MutableTreeNode)object2);
            }
            ((DefaultTreeModel)this.jZoneTree.getModel()).nodeStructureChanged(defaultMutableTreeNode);
            serializable = new TreePath(this._root);
            serializable = ((TreePath)serializable).pathByAddingChild(defaultMutableTreeNode);
            this.jZoneTree.setSelectionPath((TreePath)serializable);
            this.expandAllTreeNodes();
        }
        this.jZoneTree.addTreeSelectionListener(this);
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.jOpsComboBox.setEnabled(bl);
        this.jDescriptionTxt.setEnabled(bl);
        if (!bl) {
            this.jDescriptionTxt.setText("");
        }
    }

    public boolean isModified() {
        return this._modified;
    }

    public void setModified(boolean bl) {
        super.setModified(bl);
        this._modified = bl;
        if (!bl) {
            RMAUtil.setChildrenUnmodified((Container)((Object)this));
        }
    }

    private void expandAllTreeNodes() {
        for (int i = 0; i < this.jZoneTree.getRowCount(); ++i) {
            this.jZoneTree.expandRow(i);
        }
    }
}

