/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.data.Parameter;
import hec.map.MapLabelItem;
import hec.model.PairedValuesExt;
import hec.rss.client.PairedValuesExtPanel;
import hec.rss.client.PhysicalTreeCardPanel;
import hec.rss.client.RSimTreeNode;
import hec.rss.client.datum.VerticalDatumPanel;
import hec.rss.model.ReservoirElement;
import hec.rss.model.VerticalDatumSettings;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ItemEvent;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import rma.swing.RmaGridBagConstraints;
import rma.swing.RmaInsets;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJDialog;
import rma.swing.RmaJFrame;
import rma.swing.table.RmaTableModel;

public class JReservoirCardPanel
extends PhysicalTreeCardPanel {
    PairedValuesExtPanel _compositeReleasePanel = new PairedValuesExtPanel(new String[]{"Elevation (%S)", "Controlled (%S)", "Uncontrolled (%S)", "Total (%S)"}, new String[]{"Elevation (%S)", "Flow (%S)", "Flow (%S)", "Flow (%S)"}, new int[]{Parameter.PARAMID_ELEV, Parameter.PARAMID_FLOW, Parameter.PARAMID_FLOW, Parameter.PARAMID_FLOW}, true);
    protected RmaJComboBox _labelCombo;
    VerticalDatumPanel _verticalDatumPanel;

    @Override
    public void createControls() {
        if (((PhysicalTreeCardPanel)this).areControlsCreated()) {
            return;
        }
        this.setLayout(new GridBagLayout());
        this._compositeReleasePanel.setBorder(BorderFactory.createTitledBorder("Composite Release Capacity"));
        new GridBagConstraints();
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        this._compositeReleasePanel.add((Component)jPanel, gridBagConstraints);
        this._verticalDatumPanel = new VerticalDatumPanel();
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = RmaInsets.insets((int)0, (int)0, (int)0, (int)0);
        this._verticalDatumPanel.setBorder(BorderFactory.createTitledBorder("Native Vertical Datum"));
        this._verticalDatumPanel.setMinimumSize(this._verticalDatumPanel.getPreferredSize());
        jPanel.add((Component)this._verticalDatumPanel, gridBagConstraints);
        this._verticalDatumPanel.setVisible(Boolean.getBoolean("ResSim.UsesVerticalDatum"));
        JLabel jLabel = new JLabel("Label Position:");
        jLabel.setDisplayedMnemonic('L');
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)8, (int)5);
        jPanel.add((Component)jLabel, gridBagConstraints);
        this._labelCombo = new RmaJComboBox((Object[])MapLabelItem.POSITION_STRINGS);
        this._labelCombo.setModifiable(true);
        jLabel.setLabelFor((Component)this._labelCombo);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)5, (int)5);
        jPanel.add((Component)this._labelCombo, gridBagConstraints);
        JReservoirCardPanel jReservoirCardPanel = this;
        jReservoirCardPanel.add(jReservoirCardPanel._compositeReleasePanel, new RmaGridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 1, INSETS5500, 0, 0));
        this._controlsCreated = true;
        this.setModified(false);
    }

    @Override
    public boolean areControlsCreated() {
        return this._controlsCreated;
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl && !((PhysicalTreeCardPanel)this).areControlsCreated()) {
            ((PhysicalTreeCardPanel)this).createControls();
            Window window = SwingUtilities.windowForComponent((Component)((Object)this));
            if (window instanceof RmaJDialog) {
                ((RmaJDialog)window).updateUnitSystem((Container)((Object)this));
                return;
            }
            ((RmaJFrame)window).updateUnitSystem((Container)((Object)this));
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
    }

    @Override
    public void fillPanel(ReservoirElement reservoirElement, RSimTreeNode object) {
        super.fillPanel(reservoirElement, (RSimTreeNode)object);
        if (!this._controlsCreated) {
            ((PhysicalTreeCardPanel)this).createControls();
        }
        if (object == null) {
            return;
        }
        if ((object = ((RSimTreeNode)object).d()) == null || !(object instanceof ReservoirElement)) {
            return;
        }
        String[] stringArray = reservoirElement.getVerticalDatumSettings();
        this._verticalDatumPanel.fillPanel((VerticalDatumSettings)stringArray);
        stringArray = new String[]{"Controlled Release Capacity", "Uncontrolled Release Capacity", "Total Release Capacity"};
        this._compositeReleasePanel.setPopupPlotLegendNames(stringArray);
        this._compositeReleasePanel.setPopupPlotTitle("Release Capacity: " + reservoirElement.getName());
        object = ((ReservoirElement)object).getCompositeRelease();
        this._compositeReleasePanel.fillForm((PairedValuesExt)object);
        this._labelCombo.setSelectedIndex(reservoirElement.getLabelPosition());
        this._compositeReleasePanel.setEnabled(false);
        reservoirElement = this._compositeReleasePanel.getTable();
        reservoirElement.setPrecision(1);
        RmaTableModel cfr_ignored_0 = (RmaTableModel)reservoirElement.getModel();
        this.setModified(false);
    }

    public void clearPanel() {
    }

    @Override
    public boolean savePanel() {
        if (!((PhysicalTreeCardPanel)this).areControlsCreated()) {
            return true;
        }
        this._currentReservoir.setLabelPosition(this._labelCombo.getSelectedIndex());
        VerticalDatumSettings verticalDatumSettings = this._verticalDatumPanel.savePanel();
        int n = this._currentReservoir.getUnitSystem();
        String string = Parameter.getUnitsStringForSystem((int)Parameter.PARAMID_ELEV, (int)n);
        verticalDatumSettings.setUnits(string);
        this._currentReservoir.setVerticalDatumSettings(verticalDatumSettings);
        return true;
    }
}

