/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.data.ParamDouble;
import hec.gfx2d.G2dPanel;
import hec.gfx2d.G2dPanelProp;
import hec.gfx2d.G2dPlotProp;
import hec.gfx2d.HotPlotDefaults;
import hec.gfx2d.PlotDefaults;
import hec.gfx2d.PlotDefaultsManager;
import hec.gfx2d.SimpleJTableData;
import hec.model.PairedValues;
import hec.model.PairedValuesTableModel;
import hec.rss.client.JSeepageCardPanel$1;
import hec.rss.client.JSeepageCardPanel$2;
import hec.rss.client.JSeepageCardPanel$3;
import hec.rss.client.PhysicalTreeCardPanel;
import hec.rss.client.PhysicalTreeCardPanel$PhysicalG2dPanel;
import hec.rss.client.RSimTreeNode;
import hec.rss.model.ReservoirElement;
import hec.rss.model.Storage;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.CellEditorListener;
import javax.swing.table.TableModel;
import rma.swing.RmaGridBagConstraints;
import rma.swing.RmaInsets;
import rma.swing.RmaJDecimalField;
import rma.swing.RmaJRadioButton;
import rma.swing.RmaJTable;

public class JSeepageCardPanel
extends PhysicalTreeCardPanel {
    Storage _storage;
    SimpleJTableData _seepData = this.getSeepData();
    RmaJRadioButton constSeepRadio;
    RmaJRadioButton reFuncSeepRadio;
    RmaJDecimalField constSeepText;
    RmaJTable reSeepTable;
    PhysicalTreeCardPanel$PhysicalG2dPanel reSeepPlot;

    public JSeepageCardPanel() {
        JSeepageCardPanel jSeepageCardPanel = this;
        jSeepageCardPanel.buildSeepagePanel((JPanel)((Object)jSeepageCardPanel));
    }

    void buildSeepagePanel(JPanel serializable) {
        ((Container)serializable).setLayout(new GridBagLayout());
        Object object = new JPanel();
        object.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        ((Container)serializable).add((Component)object, gridBagConstraints);
        this.constSeepRadio = new RmaJRadioButton("Constant Seepage (%S)");
        this.constSeepRadio.setMnemonic('C');
        gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, RmaInsets.insets((int)5, (int)5, (int)0, (int)0), 0, 0);
        object.add((Component)this.constSeepRadio, gridBagConstraints);
        this.constSeepText = new RmaJDecimalField();
        gridBagConstraints = new GridBagConstraints(1, 0, 11, 1, 1.0, 0.0, 18, 2, RmaInsets.insets((int)5, (int)1, (int)0, (int)75), 0, 0);
        this.constSeepRadio.setLabelFor((Component)this.constSeepText);
        object.add((Component)this.constSeepText, gridBagConstraints);
        this.reFuncSeepRadio = new RmaJRadioButton("Seepage as a function of Reservoir Elevation");
        this.reFuncSeepRadio.setMnemonic('S');
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        ((Container)serializable).add((Component)this.reFuncSeepRadio, gridBagConstraints);
        object = new String[]{"Elevation (%S)", "Seepage(%S)"};
        this.reSeepTable = new RmaJTable((Component)serializable);
        this.reSeepTable.setModel((TableModel)new PairedValuesTableModel(object, new boolean[]{true, true}));
        ((PairedValuesTableModel)this.reSeepTable.getModel()).setShouldAddBlankRows(true);
        this.reSeepTable.setNumRows(10);
        this.reSeepTable.clearColors();
        this.reSeepTable.setDoubleCellEditor(0);
        this.reSeepTable.setDoubleCellEditor(1);
        this.reSeepTable.setUnitsHeaderRenderer();
        ((Container)serializable).add(this.reSeepTable.getScrollPane(), new RmaGridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 30, 0, 0), 0, 0));
        object = new JLabel("  ");
        ((Container)serializable).add((Component)object, new RmaGridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 18, 0, INSETS5500, 0, 0));
        this.reSeepPlot = new PhysicalTreeCardPanel$PhysicalG2dPanel(this, "Seepage Curve: ");
        ((Container)serializable).add((Component)((Object)this.reSeepPlot), new RmaGridBagConstraints(1, 2, 1, 1, 0.0, 1.0, 18, 0, INSETS5555, 100, 100));
        JSeepageCardPanel jSeepageCardPanel = this;
        jSeepageCardPanel.configureSeepPlot(jSeepageCardPanel.reSeepPlot);
        serializable = new Vector<SimpleJTableData>();
        ((Vector)serializable).addElement(this._seepData);
        this.reSeepPlot.setPlotObjects((List)((Object)serializable));
        serializable = new ButtonGroup();
        ((ButtonGroup)serializable).add((AbstractButton)this.constSeepRadio);
        ((ButtonGroup)serializable).add((AbstractButton)this.reFuncSeepRadio);
        this.constSeepRadio.addActionListener((ActionListener)new JSeepageCardPanel$1(this));
        this.reFuncSeepRadio.addActionListener((ActionListener)new JSeepageCardPanel$2(this));
        this.reSeepTable.addCellEditorListener((CellEditorListener)new JSeepageCardPanel$3(this));
        this.constSeepRadio.setModifiable(false);
        this.constSeepRadio.doClick();
        this.constSeepRadio.setModifiable(true);
        this._controlsCreated = true;
        this.setModified(false);
    }

    @Override
    public void fillPanel(ReservoirElement element, RSimTreeNode rSimTreeNode) {
        super.fillPanel((ReservoirElement)element, rSimTreeNode);
        if (!this._controlsCreated) {
            this.createControls();
        }
        if (rSimTreeNode == null) {
            return;
        }
        element = rSimTreeNode.d();
        if (element == null) {
            return;
        }
        if (!(element.getFunction() instanceof Storage)) {
            return;
        }
        this._storage = (Storage)element.getFunction();
        if (this._currentReservoir == null) {
            return;
        }
        this.reSeepTable.commitEdit(true);
        element = new ParamDouble();
        this._storage.getConstSeepage((ParamDouble)element);
        if (this._storage.getSeepageType() == 0) {
            this.constSeepRadio.setModifiable(false);
            this.constSeepRadio.doClick();
            this.constSeepRadio.setModifiable(true);
            this.constSeepText.setValue((ParamDouble)element);
            this.reSeepTable.clearCells();
        } else {
            this.reFuncSeepRadio.setModifiable(false);
            this.reFuncSeepRadio.doClick();
            this.reFuncSeepRadio.setModifiable(true);
            element.setValue(Double.NEGATIVE_INFINITY);
            this.constSeepText.setValue((ParamDouble)element);
        }
        ((PairedValuesTableModel)this.reSeepTable.getModel()).setPairedValues(this._storage.getSeepageValues());
        this.seepReplot();
        System.out.println("Filled Seepage Panel");
    }

    @Override
    public boolean savePanel() {
        if (!this.areControlsCreated()) {
            return true;
        }
        if (this._storage == null || this._currentReservoir == null) {
            return false;
        }
        if (this.reFuncSeepRadio.isSelected()) {
            this._storage.setSeepageType(1);
            this.reSeepTable.commitEdit(true);
            PairedValues pairedValues = new PairedValues();
            ((PairedValuesTableModel)this.reSeepTable.getModel()).storeData(pairedValues);
            this._storage.setSeepageValues(pairedValues);
        } else {
            this._storage.setSeepageType(0);
            this._storage.setConstSeepage(this.constSeepText.getParamValue());
        }
        return true;
    }

    private void configureSeepPlot(G2dPanel g2dPanel) {
        PlotDefaults plotDefaults = PlotDefaultsManager.getDefaults();
        PlotDefaultsManager.setDefaults((PlotDefaults)new HotPlotDefaults());
        G2dPanelProp g2dPanelProp = new G2dPanelProp();
        new G2dPanelProp().hasTitle = false;
        g2dPanelProp.hasToolbar = false;
        g2dPanelProp.hasLegend = false;
        G2dPlotProp g2dPlotProp = new G2dPlotProp();
        new G2dPlotProp().hasXScroll = false;
        g2dPlotProp.hasYScroll = false;
        g2dPlotProp.x1AxisProp.name = "Seepage(%S)";
        g2dPlotProp.y1AxisProp.name = "Elev(%S)";
        g2dPlotProp.y1AxisProp.isReversed = true;
        g2dPanelProp.addPlotProp(g2dPlotProp);
        g2dPanel.configurePanel(g2dPanelProp);
        PlotDefaultsManager.setDefaults((PlotDefaults)plotDefaults);
    }

    private void seepReplot() {
        Vector<SimpleJTableData> vector = new Vector<SimpleJTableData>();
        this._seepData.setData(this.reSeepTable, 1, 0);
        this._seepData.name = "Seepage";
        this._seepData.lineStyleName = "FLOW";
        vector.addElement(this._seepData);
        this.reSeepPlot.setPlotObjects(vector);
        this.reSeepPlot.paintGfx();
        this.reSeepPlot.revalidate();
    }

    private SimpleJTableData getSeepData() {
        SimpleJTableData simpleJTableData = new SimpleJTableData();
        new SimpleJTableData().xunits = "Seepage(%S)";
        simpleJTableData.yunits = "Elev(%S)";
        simpleJTableData.setData(null, -1, -1);
        return simpleJTableData;
    }
}

