/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.clientapp.client.ClientApp;
import hec.gfx2d.G2dPanel;
import hec.gfx2d.G2dPanelProp;
import hec.gfx2d.G2dPlotProp;
import hec.gfx2d.HotPlotDefaults;
import hec.gfx2d.PlotDefaults;
import hec.gfx2d.PlotDefaultsManager;
import hec.gfx2d.SimpleSeasonalData;
import hec.model.SeasonalRecWithTimeTableModel;
import hec.model.SeasonalRecord;
import hec.rss.RssRmiWorkspace;
import hec.rss.client.DayOfWeekMultiplierJDialog;
import hec.rss.client.JOperationsPanel;
import hec.rss.client.ReservoirJFrame;
import hec.rss.client.RisingFallingCondDialog;
import hec.rss.model.DayOfWeekMultiplier;
import hec.rss.model.OpRule;
import hec.rss.model.OpRuleRef;
import hec.rss.model.SpecFlowOpRule;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.rmi.RemoteException;
import java.util.EventObject;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import rma.swing.DefaultJPanel;
import rma.swing.RmaGridBagConstraints;
import rma.swing.RmaJ24HourTimeField;
import rma.swing.RmaJCalendarField;
import rma.swing.RmaJCheckBox;
import rma.swing.RmaJDialog;
import rma.swing.RmaJDssPathPartField;
import rma.swing.RmaJFrame;
import rma.swing.RmaJTable;
import rma.swing.RmaJTextField;
import rma.swing.print.PageText;
import rma.swing.table.RmaDateTimeEditor;
import rma.swing.table.RmaDateTimeRenderer;
import rma.util.RMAIO;

public class JSpecFlowRulePanel
extends DefaultJPanel
implements ActionListener,
FocusListener,
CellEditorListener {
    Insets INSETS5505 = new Insets(5, 5, 0, 5);
    Insets INSETS5500 = new Insets(5, 5, 0, 0);
    Insets INSETS5550 = new Insets(5, 5, 5, 0);
    Insets INSETS5555 = new Insets(5, 5, 5, 5);
    Insets INSETS0000 = new Insets(0, 0, 0, 0);
    SimpleSeasonalData _storageZonePlotArray;
    OpRuleRef _currentRuleRef;
    String _oldRuleName = "";
    DefaultJPanel _parent = null;
    JLabel jInterpTypeLabel = new JLabel("Interpolation Type");
    JComboBox jInterpTypeCombo = new JComboBox();
    JLabel jStorageLabel = new JLabel("Specified Flow Rule");
    JLabel jDescriptionLabel = new JLabel("Description");
    JLabel jStartYearLabel = new JLabel("Starting Year");
    JPanel jNameDescPanel = new JPanel();
    JPanel jTablePanel = new JPanel();
    JPanel jBottomPanel = new JPanel();
    RmaJTextField jStorageZoneTxt = new RmaJDssPathPartField();
    RmaJTextField jDescriptionTxt = new RmaJTextField();
    RmaJCalendarField jStartYearTxt = new RmaJCalendarField("YYYY", "");
    RmaJCheckBox jMultiYearCheck = new RmaJCheckBox("Allow Multi-year Seasonal Data");
    String[] colLabels = new String[]{"Date", "Time", "Flow (%S)"};
    RmaJTable jStorageZoneTable = new RmaJTable((Component)((Object)this));
    G2dPanel storageZonePlot = new G2dPanel();
    JPanel jRisingFallingOptPanel = new JPanel();
    JCheckBox jRisingFallingCheck = new JCheckBox("Apply Rising / Falling Cond");
    JButton jRisingFallingButton = new JButton("Edit");
    JCheckBox jMultiplierCheck = new JCheckBox("Day of Week Multiplier");
    JButton jMultiplierButton = new JButton("Edit");

    public JSpecFlowRulePanel() {
        this.setLayout(new GridBagLayout());
        this.jStorageZoneTxt.setModifiable(false);
        this.jStorageZoneTxt.setEditable(false);
        this.jNameDescPanel.setLayout(new GridBagLayout());
        this.jNameDescPanel.add((Component)this.jStorageLabel, new RmaGridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, this.INSETS5500, 0, 0));
        this.jNameDescPanel.add((Component)this.jDescriptionLabel, new RmaGridBagConstraints(0, 1, 1, 1, 0.0, 1.0, 18, 0, this.INSETS5500, 0, 0));
        this.jNameDescPanel.add((Component)this.jStorageZoneTxt, new RmaGridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 2, this.INSETS5500, 0, 0));
        this.jNameDescPanel.add((Component)new JLabel(), new RmaGridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 18, 2, this.INSETS5505, 0, 0));
        this.jNameDescPanel.add((Component)this.jDescriptionTxt, new RmaGridBagConstraints(1, 1, 3, 1, 1.0, 1.0, 18, 2, this.INSETS5555, 0, 0));
        this.jTablePanel.setLayout(new GridBagLayout());
        this.jTablePanel.add((Component)this.jInterpTypeLabel, new RmaGridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, this.INSETS5505, 0, 0));
        this.jTablePanel.add((Component)this.jInterpTypeCombo, new RmaGridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 2, this.INSETS5505, 0, 0));
        this.jStorageZoneTable.setModel((TableModel)new SeasonalRecWithTimeTableModel(this.colLabels, new boolean[]{true, true, true}));
        this.jStorageZoneTable.setUnitsHeaderRenderer();
        this.jStorageZoneTable.getColumnModel().getColumn(0).setCellRenderer((TableCellRenderer)new RmaDateTimeRenderer(0, "ddMMM"));
        this.jStorageZoneTable.getColumnModel().getColumn(1).setCellRenderer((TableCellRenderer)new RmaDateTimeRenderer(1));
        this.jStorageZoneTable.getColumnModel().getColumn(0).setCellEditor((TableCellEditor)new RmaDateTimeEditor(new RmaJCalendarField("ddMMM", "")));
        this.jStorageZoneTable.getColumnModel().getColumn(1).setCellEditor((TableCellEditor)new RmaDateTimeEditor(new RmaJ24HourTimeField()));
        this.jStorageZoneTable.setDoubleCellEditor(2);
        this.jStorageZoneTable.setCellEnabled(false, 0, 0);
        this.jStorageZoneTable.setCellEnabled(false, 0, 1);
        this.jStorageZoneTable.setNumRows(10);
        this.jStorageZoneTable.getScrollPane().setVerticalScrollBarPolicy(22);
        this.jStorageZoneTable.getScrollPane().setHorizontalScrollBarPolicy(30);
        this.jTablePanel.add((Component)this.jStorageZoneTable.getScrollPane(), new RmaGridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 18, 1, this.INSETS5555, 0, 0));
        JSpecFlowRulePanel jSpecFlowRulePanel = this;
        jSpecFlowRulePanel.configurePlotPanel(jSpecFlowRulePanel.storageZonePlot);
        Vector<SimpleSeasonalData> vector = new Vector<SimpleSeasonalData>();
        this._storageZonePlotArray = this.getStorageZonePlotArray();
        vector.addElement(this._storageZonePlotArray);
        this.storageZonePlot.setPlotObjects(vector);
        this.jTablePanel.add((Component)this.storageZonePlot, new RmaGridBagConstraints(3, 0, 1, 2, 0.0, 1.0, 12, 0, this.INSETS5555, 150, 140));
        this.jRisingFallingOptPanel.setLayout(new GridBagLayout());
        this.jRisingFallingOptPanel.add((Component)this.jRisingFallingCheck, new RmaGridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 5, 2, 0), 0, 0));
        this.jRisingFallingOptPanel.add((Component)this.jRisingFallingButton, new RmaGridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 0, new Insets(0, 5, 2, 5), 0, 0));
        this.jRisingFallingOptPanel.add((Component)this.jMultiplierCheck, new RmaGridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 15, 2, 0), 0, 0));
        this.jRisingFallingOptPanel.add((Component)this.jMultiplierButton, new RmaGridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 18, 0, new Insets(0, 5, 2, 15), 0, 0));
        JSpecFlowRulePanel jSpecFlowRulePanel2 = this;
        jSpecFlowRulePanel2.add(jSpecFlowRulePanel2.jNameDescPanel, new RmaGridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 2, this.INSETS0000, 0, 0));
        JSpecFlowRulePanel jSpecFlowRulePanel3 = this;
        jSpecFlowRulePanel3.add(jSpecFlowRulePanel3.jTablePanel, new RmaGridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 1, this.INSETS0000, 0, 0));
        JSpecFlowRulePanel jSpecFlowRulePanel4 = this;
        jSpecFlowRulePanel4.add(jSpecFlowRulePanel4.jRisingFallingOptPanel, new RmaGridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 18, 2, this.INSETS0000, 0, 0));
        for (int i = 0; i < SeasonalRecord.INTERP_STRINGS.length; ++i) {
            this.jInterpTypeCombo.addItem(SeasonalRecord.INTERP_STRINGS[i]);
        }
        this.jStorageZoneTable.addCellEditorListener((CellEditorListener)this);
        this.jMultiYearCheck.addActionListener((ActionListener)this);
        this.jInterpTypeCombo.addItemListener((ItemListener)((Object)this));
        this.jStorageZoneTxt.addFocusListener((FocusListener)this);
        this.jRisingFallingButton.addActionListener(this);
        this.jRisingFallingCheck.addActionListener(this);
        this.jMultiplierButton.addActionListener(this);
        this.jMultiplierCheck.addActionListener(this);
    }

    public void itemStateChanged(ItemEvent object) {
        if (((ItemEvent)object).getStateChange() == 2) {
            return;
        }
        if ((object = ((EventObject)object).getSource()) == this.jInterpTypeCombo) {
            this.setModified(true);
            this.replot();
        }
    }

    @Override
    public void editingCanceled(ChangeEvent changeEvent) {
    }

    @Override
    public void editingStopped(ChangeEvent changeEvent) {
        this.setModified(true);
        this.replot();
    }

    @Override
    public void actionPerformed(ActionEvent object) {
        if ((object = ((EventObject)object).getSource()) == this.jMultiYearCheck) {
            this.MultiYearCheck_ActionPerformed();
            return;
        }
        if (object == this.jRisingFallingButton) {
            this.risingFallingButton_ActionPerformed();
            return;
        }
        if (object == this.jRisingFallingCheck) {
            this.risingFallingCheck_ActionPerformed();
            return;
        }
        if (object == this.jMultiplierButton) {
            this.MultiplierButton_ActionPerformed();
        }
    }

    private void risingFallingButton_ActionPerformed() {
        Object object = SwingUtilities.windowForComponent((Component)((Object)this));
        if (!(object instanceof ReservoirJFrame)) {
            return;
        }
        if (this._currentRuleRef == null) {
            return;
        }
        object = new RisingFallingCondDialog((Dialog)object, true);
        ((RisingFallingCondDialog)object).fillForm(this._currentRuleRef.getRule());
        object.setVisible(true);
        if (((RisingFallingCondDialog)object).isOk()) {
            this.setModified(true);
        }
    }

    private void risingFallingCheck_ActionPerformed() {
        if (this._currentRuleRef == null) {
            this.jRisingFallingCheck.setSelected(false);
            return;
        }
        SpecFlowOpRule specFlowOpRule = (SpecFlowOpRule)this._currentRuleRef.getRule();
        if (!specFlowOpRule.riseFallConditionIsValid() && this.jRisingFallingCheck.isSelected()) {
            this.jRisingFallingCheck.setSelected(false);
            JOptionPane.showMessageDialog((Component)((Object)this), "Rising-Falling Condition data Incomplete.\nEdit and complete data first.", "Apply Rising/Falling Condition", 2);
            return;
        }
        this.setModified(true);
    }

    private void MultiplierButton_ActionPerformed() {
        Object object = SwingUtilities.windowForComponent((Component)((Object)this));
        if (!(object instanceof ReservoirJFrame)) {
            return;
        }
        Object object2 = "Day of Week Multiplier";
        object = new DayOfWeekMultiplierJDialog((Dialog)object, (String)object2, true);
        object2 = (SpecFlowOpRule)this._currentRuleRef.getRule();
        if (((OpRule)object2).getMultiplier() == null) {
            ((OpRule)object2).setMultiplier(new DayOfWeekMultiplier());
        }
        ((DayOfWeekMultiplierJDialog)((Object)object)).setData(((OpRule)object2).getMultiplier());
        ((DayOfWeekMultiplierJDialog)((Object)object)).setVisible(true);
        if (!((DayOfWeekMultiplierJDialog)((Object)object)).isCanceled()) {
            this.setModified(true);
        }
        if (((DayOfWeekMultiplier)(object = ((OpRule)object2).getMultiplier())).isDefaults()) {
            this.jMultiplierCheck.setSelected(false);
            return;
        }
        this.jMultiplierCheck.setSelected(true);
    }

    private void MultiYearCheck_ActionPerformed() {
        if (this.jMultiYearCheck.isSelected()) {
            this.jStartYearTxt.setEnabled(true);
            return;
        }
        this.jStartYearTxt.setEnabled(false);
    }

    public void setRuleRef(OpRuleRef opRuleRef) {
        if (opRuleRef == null) {
            return;
        }
        if (this.isModified()) {
            this.savePanel();
        }
        this._currentRuleRef = opRuleRef;
        this.fillPanel();
    }

    public void fillPanel() {
        Object object;
        if (this._currentRuleRef == null) {
            return;
        }
        Object object2 = (SpecFlowOpRule)this._currentRuleRef.getRule();
        this.clearPanel();
        this.jStorageZoneTxt.setText(object2.getName());
        this.jDescriptionTxt.setText(object2.getDescription());
        this._oldRuleName = object2.getName();
        SeasonalRecord seasonalRecord = ((SpecFlowOpRule)object2).getSeasonalRecord();
        Object object3 = "";
        try {
            ClientApp.app();
            object = ClientApp.Workspace();
            object = ((RssRmiWorkspace)object.getChildWorkspace("rss")).getStartOfWaterYear();
            object3 = object.date(104);
            object3 = ((String)object3).substring(0, 5);
            object3 = (String)object3 + " 0000";
        }
        catch (RemoteException remoteException) {
            System.out.println("Error Setting water year start - " + remoteException.getMessage());
            System.out.println("Resuming as normal");
        }
        ((SeasonalRecWithTimeTableModel)this.jStorageZoneTable.getModel()).setSeasonalRecord(seasonalRecord, (String)object3);
        this.jInterpTypeCombo.setSelectedIndex(((SpecFlowOpRule)object2).getInterpolationType());
        ClientApp.app();
        object = new String("Workspace: " + ClientApp.Workspace().getTitleName());
        object = (String)object + "\n ResSim System: " + ((JOperationsPanel)this._parent)._reservoir.getSystem().getName();
        object = (String)object + "\n Reservoir: " + ((JOperationsPanel)this._parent)._reservoir.getName();
        object = (String)object + "\n Operation Set: " + ((JOperationsPanel)this._parent)._currentOpSet.getName();
        object = (String)object + "\n Specified Flow Rule: " + this._currentRuleRef.getName() + " \n ";
        object = new PageText((String)object, 0);
        this.jStorageZoneTable.setPrintTitle((PageText)object);
        this.replot();
        if (((OpRule)object2).riseFallConditionIsValid() && ((OpRule)object2).getEnableRiseFallCondition()) {
            this.jRisingFallingCheck.setSelected(true);
        } else {
            this.jRisingFallingCheck.setSelected(false);
        }
        object2 = SwingUtilities.windowForComponent((Component)((Object)this));
        if (object2 instanceof RmaJDialog) {
            ((RmaJDialog)object2).updateUnitSystem((Container)((Object)this));
            ((RmaJDialog)object2).updateTimeZone((Container)((Object)this));
        } else if (object2 instanceof RmaJFrame) {
            ((RmaJFrame)object2).updateUnitSystem((Container)((Object)this));
            ((RmaJFrame)object2).updateTimeZone((Container)((Object)this));
        }
        this.setModified(false);
    }

    public void refresh() {
    }

    public boolean savePanel() {
        if (this._currentRuleRef == null) {
            return false;
        }
        if (this.jStorageZoneTxt.getText().equals("")) {
            RMAIO.postError((Component)((Object)this), (String)"Cannot have an empty rule name!");
            return false;
        }
        SpecFlowOpRule specFlowOpRule = (SpecFlowOpRule)this._currentRuleRef.getRule();
        if (specFlowOpRule == null) {
            return false;
        }
        this._currentRuleRef.getRule().setName(this.jStorageZoneTxt.getText());
        this._currentRuleRef.setName(this.jStorageZoneTxt.getText());
        this._oldRuleName = this.jStorageZoneTxt.getText();
        specFlowOpRule.setDescription(this.jDescriptionTxt.getText());
        specFlowOpRule.setInterpolationType(this.jInterpTypeCombo.getSelectedIndex());
        this.jStorageZoneTable.commitEdit(true);
        SeasonalRecWithTimeTableModel seasonalRecWithTimeTableModel = (SeasonalRecWithTimeTableModel)this.jStorageZoneTable.getModel();
        seasonalRecWithTimeTableModel.storeData(specFlowOpRule.getSeasonalRecord());
        specFlowOpRule.setEnableRiseFallCondition(this.jRisingFallingCheck.isSelected());
        this.setModified(false);
        return true;
    }

    public void clearPanel() {
        this.jStorageZoneTable.clearCells();
        this.jStorageZoneTxt.setText("");
        this.jDescriptionTxt.setText("");
        this.jMultiYearCheck.setSelected(false);
        this.jStartYearTxt.setEnabled(false);
    }

    private SimpleSeasonalData getStorageZonePlotArray() {
        SimpleSeasonalData simpleSeasonalData = new SimpleSeasonalData();
        new SimpleSeasonalData().xunits = "Date";
        simpleSeasonalData.yunits = "Flow (%S)";
        simpleSeasonalData.setPlotYears(1);
        simpleSeasonalData.setInterpolationType("linear");
        simpleSeasonalData.setData(new int[0], new double[0]);
        return simpleSeasonalData;
    }

    private void configurePlotPanel(G2dPanel g2dPanel) {
        PlotDefaults plotDefaults = PlotDefaultsManager.getDefaults();
        PlotDefaultsManager.setDefaults((PlotDefaults)new HotPlotDefaults());
        G2dPanelProp g2dPanelProp = new G2dPanelProp();
        new G2dPanelProp().hasTitle = false;
        g2dPanelProp.hasToolbar = false;
        g2dPanelProp.hasLegend = false;
        G2dPlotProp g2dPlotProp = new G2dPlotProp();
        new G2dPlotProp().hasXScroll = false;
        g2dPlotProp.hasYScroll = false;
        g2dPlotProp.x1AxisProp.name = "Minutes";
        g2dPlotProp.x1AxisProp.type = 2;
        g2dPlotProp.y1AxisProp.name = "Flow (%S)";
        g2dPlotProp.x1AxisProp.numTicLabelLayers = 1;
        g2dPlotProp.hasX1Label = false;
        g2dPlotProp.y1AxisProp.isReversed = true;
        g2dPlotProp.x1AxisProp.isDefaultLimits = false;
        g2dPlotProp.x1AxisProp.min = 0.0;
        g2dPlotProp.x1AxisProp.max = 525600.0;
        g2dPanelProp.addPlotProp(g2dPlotProp);
        g2dPanelProp.addPlotProp(g2dPlotProp);
        g2dPanel.configurePanel(g2dPanelProp);
        PlotDefaultsManager.setDefaults((PlotDefaults)plotDefaults);
    }

    public void replot() {
        this.plotRule();
    }

    private void plotRule() {
        new Vector();
        this._storageZonePlotArray.resetData();
        SeasonalRecord seasonalRecord = new SeasonalRecord();
        Object object = (SeasonalRecWithTimeTableModel)this.jStorageZoneTable.getModel();
        object.storeData(seasonalRecord);
        object = (String)this.jInterpTypeCombo.getSelectedItem();
        this._storageZonePlotArray.setPlotYears(1);
        this._storageZonePlotArray.setInterpolationType((String)object);
        this._storageZonePlotArray.setData(seasonalRecord);
    }

    public void setParent(JPanel jPanel) {
        this._parent = (JOperationsPanel)((Object)jPanel);
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
    }

    @Override
    public void focusLost(FocusEvent object) {
        if ((object = ((EventObject)object).getSource()) == this.jStorageZoneTxt) {
            if (this.jStorageZoneTxt.getText().equals("")) {
                this.jStorageZoneTxt.setText(this._currentRuleRef.getRule().getName());
                RMAIO.postError((Component)((Object)this), (String)"Cannot have a blank Rule Name!");
                return;
            }
            this._currentRuleRef.getRule().setName(this.jStorageZoneTxt.getText());
            this._currentRuleRef.setName(this.jStorageZoneTxt.getText());
            ((JOperationsPanel)this._parent).treeDataChanged(0, this._oldRuleName, this.jStorageZoneTxt.getText());
        }
    }

    public void deselectPanel() {
        if (this.isModified()) {
            this.savePanel();
        }
    }
}

