/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.clientapp.client.ClientApp;
import hec.data.ParamDouble;
import hec.gfx2d.G2dPanel;
import hec.gfx2d.G2dPanelProp;
import hec.gfx2d.G2dPlotProp;
import hec.gfx2d.HotPlotDefaults;
import hec.gfx2d.PlotDefaults;
import hec.gfx2d.PlotDefaultsManager;
import hec.model.PairedValues;
import hec.model.PairedValuesTableModel;
import hec.rss.RssRmiWorkspace;
import hec.rss.client.IntakeGeometryPanel;
import hec.rss.client.JSpillwayCardPanel$1;
import hec.rss.client.PhysicalTreeCardPanel;
import hec.rss.client.PhysicalTreeCardPanel$PhysicalG2dPanel;
import hec.rss.client.RSimTreeNode;
import hec.rss.gfx2d.SimpleJTableData;
import hec.rss.model.ReservoirElement;
import hec.rss.model.Spillway;
import hec.rss.server.RssAdvancedOptions;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.UIManager;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableModel;
import rma.swing.RmaGridBagConstraints;
import rma.swing.RmaJDecimalField;
import rma.swing.RmaJLabel;
import rma.swing.RmaJRadioButton;
import rma.swing.RmaJTable;
import rma.swing.print.PageText;
import rma.util.RMAIO;
import rma.util.RMAUtil;

public class JSpillwayCardPanel
extends PhysicalTreeCardPanel
implements ItemListener,
CellEditorListener {
    private static Color a = UIManager.getColor("TextField.disabledBackground");
    SimpleJTableData _elevationPlotArray;
    String _flowUnits = "%S";
    String _lengthUnits = "%S";
    Spillway _spillway;
    RmaJLabel jLabelLength = new RmaJLabel("Length (%S)");
    JLabel jLabelWeir = new JLabel("Weir Coef.");
    RmaJLabel jLabelSpillwayElev = new RmaJLabel("Outlet Crest Elevation (%S)");
    JLabel jLabelSpill = new JLabel("Spill");
    RmaJDecimalField jLengthTxt = new RmaJDecimalField();
    RmaJDecimalField jSpillwayTxt = new RmaJDecimalField();
    RmaJDecimalField jWeirTxt = new RmaJDecimalField();
    RmaJDecimalField jConstantTxt = new RmaJDecimalField();
    RmaJRadioButton jRadioWeirCoef = new RmaJRadioButton("Free Flow Weir Equation");
    RmaJRadioButton jRadioElev = new RmaJRadioButton("Elevation vs. Outflow");
    PhysicalTreeCardPanel$PhysicalG2dPanel jElevationPlot = new PhysicalTreeCardPanel$PhysicalG2dPanel(this, "Release Capacity: ");
    String[] colLabels = new String[]{"Elevation (" + this._lengthUnits + ")", "Outflow (" + this._flowUnits + ")"};
    RmaJTable jTableElevation = new RmaJTable((Component)((Object)this));
    IntakeGeometryPanel jIntakeGeometryPanel;

    public JSpillwayCardPanel() {
        this.setLayout(new GridBagLayout());
        Serializable serializable = new Insets(5, 22, 0, 0);
        JSpillwayCardPanel jSpillwayCardPanel = this;
        jSpillwayCardPanel.add((Component)jSpillwayCardPanel.jRadioWeirCoef, new RmaGridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, INSETS5500, 0, 0));
        JSpillwayCardPanel jSpillwayCardPanel2 = this;
        jSpillwayCardPanel2.add((Component)jSpillwayCardPanel2.jLabelSpillwayElev, new RmaGridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, (Insets)serializable, 0, 0));
        JSpillwayCardPanel jSpillwayCardPanel3 = this;
        jSpillwayCardPanel3.add((Component)jSpillwayCardPanel3.jSpillwayTxt, new RmaGridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 18, 2, INSETS5500, 0, 0));
        JSpillwayCardPanel jSpillwayCardPanel4 = this;
        jSpillwayCardPanel4.add(jSpillwayCardPanel4.jLabelWeir, new RmaGridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, (Insets)serializable, 0, 0));
        JSpillwayCardPanel jSpillwayCardPanel5 = this;
        jSpillwayCardPanel5.add((Component)jSpillwayCardPanel5.jWeirTxt, new RmaGridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 18, 2, INSETS5500, 0, 0));
        JSpillwayCardPanel jSpillwayCardPanel6 = this;
        jSpillwayCardPanel6.add((Component)jSpillwayCardPanel6.jLabelLength, new RmaGridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 18, 0, (Insets)serializable, 0, 0));
        JSpillwayCardPanel jSpillwayCardPanel7 = this;
        jSpillwayCardPanel7.add((Component)jSpillwayCardPanel7.jLengthTxt, new RmaGridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 18, 2, INSETS5500, 0, 0));
        JSpillwayCardPanel jSpillwayCardPanel8 = this;
        jSpillwayCardPanel8.add((Component)jSpillwayCardPanel8.jRadioElev, new RmaGridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 18, 0, INSETS5500, 0, 0));
        this.jTableElevation.setModel((TableModel)new PairedValuesTableModel(this.colLabels, new boolean[]{true, true}));
        this.jTableElevation.setUnitsHeaderRenderer();
        this.jTableElevation.setDoubleCellEditor();
        JSpillwayCardPanel jSpillwayCardPanel9 = this;
        jSpillwayCardPanel9.add(jSpillwayCardPanel9.jTableElevation.getScrollPane(), new RmaGridBagConstraints(0, 5, 2, 2, 1.0, 1.0, 18, 1, INSETS5500, 0, 0));
        serializable = new ButtonGroup();
        ((ButtonGroup)serializable).add((AbstractButton)this.jRadioWeirCoef);
        ((ButtonGroup)serializable).add((AbstractButton)this.jRadioElev);
        this.jRadioWeirCoef.setSelected(true);
        this.jTableElevation.setEnabled(false);
        this.jTableElevation.setBackground(a);
        JSpillwayCardPanel jSpillwayCardPanel10 = this;
        jSpillwayCardPanel10.configurePlotPanel(jSpillwayCardPanel10.jElevationPlot);
        serializable = new Vector();
        this._elevationPlotArray = this.getElevationPlotArray();
        ((Vector)serializable).addElement(this._elevationPlotArray);
        this.jElevationPlot.setPlotObjects((List)((Object)serializable));
        JSpillwayCardPanel jSpillwayCardPanel11 = this;
        jSpillwayCardPanel11.add((Component)((Object)jSpillwayCardPanel11.jElevationPlot), new RmaGridBagConstraints(2, 5, 1, 1, 0.0, 0.0, 12, 0, INSETS5500, 100, 100));
        this.jIntakeGeometryPanel = new IntakeGeometryPanel();
        this.jIntakeGeometryPanel.setOpensFromComboBoxEnabled(false);
        JSpillwayCardPanel jSpillwayCardPanel12 = this;
        jSpillwayCardPanel12.add(jSpillwayCardPanel12.jIntakeGeometryPanel, new RmaGridBagConstraints(2, 6, 1, 1, 0.0, 0.0, 12, 0, INSETS5555, 0, 0));
        this.jIntakeGeometryPanel.setOpensFromComboBoxEnabled(false);
        this.jRadioWeirCoef.addItemListener((ItemListener)this);
        this.jRadioElev.addItemListener((ItemListener)this);
        this.jTableElevation.addCellEditorListener((CellEditorListener)this);
        this.jRadioWeirCoef.setMnemonic('W');
        this.jRadioElev.setMnemonic('O');
        this.jLabelLength.setDisplayedMnemonic('L');
        this.jLabelSpillwayElev.setDisplayedMnemonic('O');
        this.jLabelLength.setLabelFor((Component)this.jLengthTxt);
        this.jLabelSpillwayElev.setLabelFor((Component)this.jSpillwayTxt);
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 2) {
            return;
        }
        Object object = itemEvent.getSource();
        if (object == this.jRadioWeirCoef || object == this.jRadioElev) {
            this.Coeficient_StateChange(itemEvent);
        }
    }

    private void Coeficient_StateChange(ItemEvent itemEvent) {
        this.jSpillwayTxt.setEnabled(this.jRadioWeirCoef.isSelected());
        this.jWeirTxt.setEnabled(this.jRadioWeirCoef.isSelected());
        this.jTableElevation.setEnabled(!this.jRadioWeirCoef.isSelected());
        this.jTableElevation.commitEdit(true);
        this.jTableElevation.setBackground(this.jRadioWeirCoef.isSelected() ? a : Color.white);
        this.jLengthTxt.setEnabled(this.jRadioWeirCoef.isSelected());
    }

    @Override
    public void editingCanceled(ChangeEvent changeEvent) {
    }

    @Override
    public void editingStopped(ChangeEvent changeEvent) {
        this.replot();
    }

    @Override
    public void fillPanel(ReservoirElement element, RSimTreeNode object) {
        super.fillPanel((ReservoirElement)element, (RSimTreeNode)object);
        if (!this._controlsCreated) {
            this.createControls();
        }
        if (object == null) {
            return;
        }
        element = ((RSimTreeNode)object).d();
        if (element == null || !(element.getFunction() instanceof Spillway)) {
            return;
        }
        this._spillway = (Spillway)element.getFunction();
        if (this._spillway == null) {
            RMAIO.postError((Component)((Object)this), (String)"Null Spillway Object");
            return;
        }
        this.jRadioWeirCoef.setModifiable(false);
        this.jRadioElev.setModifiable(false);
        object = new ParamDouble();
        this._spillway.getWidthOfDam((ParamDouble)object);
        this.jLengthTxt.setValue((ParamDouble)object);
        this._spillway.getTopOfDam((ParamDouble)object);
        this.jSpillwayTxt.setValue((ParamDouble)object);
        this.jWeirTxt.setText(RMAIO.toTable((double)this._spillway.getWeirCoef()));
        object = "Workspace: " + ClientApp.Workspace().getTitleName();
        object = (String)object + "\n ResSim System: " + this._currentReservoir.getSystem().getName();
        object = (String)object + "\n Reservoir: " + this._currentReservoir.getName();
        object = (String)object + "\n Uncontrolled Outlet: " + element.getName() + " \n ";
        element = new PageText((String)object, 0);
        this.jTableElevation.setPrintTitle((PageText)element);
        int n = this._spillway.getSpillFunctionType();
        if (n == 0) {
            this.jRadioWeirCoef.doClick();
            this.jTableElevation.setEnabled(false);
            this.jTableElevation.setBackground(a);
        } else {
            this.jRadioElev.doClick();
            this.jWeirTxt.setEnabled(false);
            this.jLengthTxt.setEnabled(false);
        }
        Object object2 = this._spillway.getElevOutflowValues();
        if (object2 != null) {
            ((PairedValuesTableModel)this.jTableElevation.getModel()).setPairedValues((PairedValues)object2);
            this.replot();
        }
        if (object2.size() < 20) {
            this.jTableElevation.setNumRows(object2.size() + (20 - object2.size()));
        }
        RMAUtil.setChildrenUnmodified((Container)((Object)this));
        this.jRadioWeirCoef.setModifiable(true);
        this.jRadioElev.setModifiable(true);
        object2 = (RssRmiWorkspace)ClientApp.Workspace().getChildWorkspace("rss");
        try {
            object2 = object2.getRssAdvancedOptions();
            this.jIntakeGeometryPanel.setVisible(((RssAdvancedOptions)object2).hasWaterQuality());
        }
        catch (RemoteException remoteException) {
            object2 = remoteException;
            remoteException.printStackTrace();
        }
        this.jIntakeGeometryPanel.fillForm(this._spillway.getIntakeGeometry());
    }

    public void clearPlot() {
        Vector vector = new Vector();
        this.jElevationPlot.setPlotObjects(vector);
        this.jElevationPlot.paintGfx();
    }

    public void refresh() {
    }

    @Override
    public boolean savePanel() {
        if (this._spillway == null) {
            return false;
        }
        if (this.jRadioWeirCoef.isSelected()) {
            this._spillway.setSpillFunctionType(0);
        } else {
            this._spillway.setSpillFunctionType(1);
        }
        double d = this.jWeirTxt.getValue();
        this._spillway.setWeirCoef(d);
        this._spillway.setElevOutflowValues(new PairedValues());
        PairedValues pairedValues = new PairedValues();
        this.jTableElevation.commitEdit(true);
        ((PairedValuesTableModel)this.jTableElevation.getModel()).storeData(pairedValues);
        this._spillway.setElevOutflowValues(pairedValues);
        this._spillway.setWidthOfDam(this.jLengthTxt.getParamValue());
        this._spillway.setTopOfDam(this.jSpillwayTxt.getParamValue());
        this.jIntakeGeometryPanel.saveForm(this._spillway.getIntakeGeometry());
        return true;
    }

    private void replot() {
        Vector<SimpleJTableData> vector = new Vector<SimpleJTableData>();
        this._elevationPlotArray = this.getElevationPlotArray();
        this._elevationPlotArray.setData(this.jTableElevation, 1, 0);
        this._elevationPlotArray.name = "Release Capacity";
        vector.addElement(this._elevationPlotArray);
        this.jElevationPlot.setVisible(false);
        this.jElevationPlot.setPlotObjects(vector);
        this.jElevationPlot.setVisible(true);
        this.jElevationPlot.paintGfx();
    }

    void configurePlotPanel(G2dPanel g2dPanel) {
        PlotDefaults plotDefaults = PlotDefaultsManager.getDefaults();
        PlotDefaultsManager.setDefaults((PlotDefaults)new HotPlotDefaults());
        G2dPanelProp g2dPanelProp = new G2dPanelProp();
        new G2dPanelProp().hasTitle = false;
        g2dPanelProp.hasToolbar = false;
        g2dPanelProp.hasLegend = false;
        G2dPlotProp g2dPlotProp = new G2dPlotProp();
        new G2dPlotProp().hasXScroll = false;
        g2dPlotProp.hasYScroll = false;
        g2dPlotProp.x1AxisProp.name = "Outflow (" + this._flowUnits + ")";
        g2dPlotProp.y1AxisProp.name = "Elevation (" + this._lengthUnits + ")";
        g2dPlotProp.x1AxisProp.type = 0;
        g2dPlotProp.y1AxisProp.isReversed = true;
        g2dPanelProp.addPlotProp(g2dPlotProp);
        g2dPanel.configurePanel(g2dPanelProp);
        PlotDefaultsManager.setDefaults((PlotDefaults)plotDefaults);
    }

    SimpleJTableData getElevationPlotArray() {
        JSpillwayCardPanel$1 jSpillwayCardPanel$1 = new JSpillwayCardPanel$1(this);
        new JSpillwayCardPanel$1(this).xunits = "Outflow (" + this._flowUnits + ")";
        jSpillwayCardPanel$1.yunits = "Elevation (" + this._lengthUnits + ")";
        jSpillwayCardPanel$1.setXAxisType(0);
        jSpillwayCardPanel$1.setData(null, -1, -1);
        return jSpillwayCardPanel$1;
    }

    public void setFlowUnits(String string) {
        if (string == null) {
            return;
        }
        this._flowUnits = string;
    }

    public void setLenghtUnits(String string) {
        if (string == null) {
            return;
        }
        this._lengthUnits = string;
    }
}

