/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.clientapp.client.ClientApp;
import hec.data.ParamDouble;
import hec.gfx2d.G2dPanel;
import hec.gfx2d.G2dPanelProp;
import hec.gfx2d.G2dPlotProp;
import hec.gfx2d.HotPlotDefaults;
import hec.gfx2d.PlotDefaults;
import hec.gfx2d.PlotDefaultsManager;
import hec.gfx2d.SimplePairedValuesData;
import hec.model.PairedValues;
import hec.rss.client.JStorageCardPanel$1;
import hec.rss.client.JStorageCardPanel$MyG2dPanel;
import hec.rss.client.PhysicalTreeCardPanel;
import hec.rss.client.RSimTreeNode;
import hec.rss.client.ReservoirJFrame;
import hec.rss.model.CapacityRecord;
import hec.rss.model.ReservoirElement;
import hec.rss.model.Storage;
import hec.rss.model.StorageTableModel;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.Serializable;
import java.util.EventObject;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableModel;
import rma.swing.RmaGridBagConstraints;
import rma.swing.RmaJDecimalField;
import rma.swing.RmaJLabel;
import rma.swing.RmaJRadioButton;
import rma.swing.RmaJTable;
import rma.swing.print.PageText;
import rma.util.RMAIO;

public class JStorageCardPanel
extends PhysicalTreeCardPanel
implements ItemListener,
CellEditorListener {
    JStorageCardPanel$MyG2dPanel _g2dpanel;
    SimplePairedValuesData _storagePlotArray;
    SimplePairedValuesData _areaPlotArray;
    String units = "";
    Storage _storage;
    JPanel _jPanelPlot = new JPanel();
    RmaJRadioButton _jRadio_conicInterp = new RmaJRadioButton("Conic Interpolation");
    RmaJRadioButton _jRadio_linearInterp = new RmaJRadioButton("Linear Interpolation");
    RmaJDecimalField _jTxt_initialConicDepth = new RmaJDecimalField();
    RmaJLabel _jLabel_initialConicDepth = new RmaJLabel("Initial Conic Depth (%S)");
    RmaJTable _elevationTable;
    StorageTableModel _linearTableModel;
    StorageTableModel _conicTableModel;

    @Override
    public void createControls() {
        if (this.areControlsCreated()) {
            return;
        }
        this.setLayout(new GridBagLayout());
        Object object = new String[]{"Elevation", "Storage", "Area"};
        this._elevationTable = new RmaJTable((Component)((Object)this), (Object[])object);
        this._elevationTable.setNumRows(20);
        this._elevationTable.setDoubleCellEditor(0);
        this._elevationTable.setMlHeaderRenderer();
        for (int i = 1; i < 3; ++i) {
            object = this._elevationTable.setDoubleCellEditor(i);
            if (object == null) continue;
            object.setMinValue(0.0);
        }
        JStorageCardPanel jStorageCardPanel = this;
        jStorageCardPanel.add(jStorageCardPanel._elevationTable.getScrollPane(), new RmaGridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 1, INSETS5500, 0, 0));
        this._jPanelPlot.setLayout(new GridBagLayout());
        JStorageCardPanel jStorageCardPanel2 = this;
        jStorageCardPanel2.add(jStorageCardPanel2._jPanelPlot, new RmaGridBagConstraints(1, 1, 1, 3, 0.0, 1.0, 12, 3, new Insets(5, 5, 5, 5), 0, 0));
        this._g2dpanel = new JStorageCardPanel$MyG2dPanel(this);
        JStorageCardPanel jStorageCardPanel3 = this;
        jStorageCardPanel3.configurePlotPanel(jStorageCardPanel3._g2dpanel);
        Vector<SimplePairedValuesData> vector = new Vector<SimplePairedValuesData>();
        this._storagePlotArray = this.getStoragePlotArray();
        this._areaPlotArray = this.getAreaPlotArray();
        vector.addElement(this._storagePlotArray);
        vector.addElement(this._areaPlotArray);
        this._g2dpanel.setPlotObjects(vector);
        this._jPanelPlot.add((Component)((Object)this._g2dpanel), new RmaGridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 12, 0, INSETS5555, 100, 180));
        object = new JPanel();
        ((Container)object).setLayout(new GridBagLayout());
        ((Container)object).add((Component)this._jRadio_linearInterp, new RmaGridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 0, 5), 0, 0));
        ((Container)object).add((Component)this._jRadio_conicInterp, new RmaGridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 0, 5), 0, 0));
        ((Container)object).add((Component)this._jLabel_initialConicDepth, new RmaGridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 0, 5), 0, 0));
        ((Container)object).add((Component)this._jTxt_initialConicDepth, new RmaGridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 13, 2, new Insets(0, 5, 0, 5), 20, 0));
        this.add((Component)object, new RmaGridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 15, 2, new Insets(5, 5, 5, 5), 0, 0));
        this._jLabel_initialConicDepth.setLabelFor((Component)this._jTxt_initialConicDepth);
        object = new ButtonGroup();
        ((ButtonGroup)object).add((AbstractButton)this._jRadio_linearInterp);
        ((ButtonGroup)object).add((AbstractButton)this._jRadio_conicInterp);
        this._jRadio_linearInterp.setSelected(true);
        this._jLabel_initialConicDepth.setEnabled(false);
        this._jTxt_initialConicDepth.setEnabled(false);
        this._elevationTable.addCellEditorListener((CellEditorListener)this);
        this._jRadio_linearInterp.addItemListener((ItemListener)this);
        this._jRadio_conicInterp.addItemListener((ItemListener)this);
        this._jTxt_initialConicDepth.addFocusListener((FocusListener)new JStorageCardPanel$1(this));
        this._controlsCreated = true;
        this.setModified(false);
    }

    @Override
    public void fillPanel(ReservoirElement element, RSimTreeNode object) {
        super.fillPanel((ReservoirElement)element, (RSimTreeNode)object);
        if (!this._controlsCreated) {
            ((PhysicalTreeCardPanel)this).createControls();
        }
        if (object == null) {
            return;
        }
        element = ((RSimTreeNode)object).d();
        if (element == null) {
            return;
        }
        if (!(element.getFunction() instanceof Storage)) {
            return;
        }
        this._storage = (Storage)element.getFunction();
        if (this._currentReservoir == null) {
            return;
        }
        new ParamDouble();
        this._storage.getCapacityVector();
        element = new String[]{"Elevation\n(%S)", "Storage\n(%S)", "Area\n(%S)"};
        object = new boolean[]{true, true, true};
        this._linearTableModel = new StorageTableModel((String[])element, this._storage, (boolean[])object, false);
        this._conicTableModel = new StorageTableModel((String[])element, this._storage, (boolean[])object, true);
        if (this._storage.useConicInterpolation()) {
            this._elevationTable.setModel((TableModel)((Object)this._conicTableModel));
        } else {
            this._elevationTable.setModel((TableModel)((Object)this._linearTableModel));
        }
        this._elevationTable.setDoubleCellEditor(0);
        this._elevationTable.setUnitsHeaderRenderer();
        for (int i = 1; i < 3; ++i) {
            element = this._elevationTable.setDoubleCellEditor(i);
            if (element == null) continue;
            element.setMinValue(0.0);
        }
        ClientApp.app();
        Object object2 = new String("Workspace: " + ClientApp.Workspace().getTitleName());
        object2 = (String)object2 + "\n ResSim System: " + this._currentReservoir.getSystem().getName();
        object2 = (String)object2 + "\n Reservoir: " + this._currentReservoir.getName();
        object2 = (String)object2 + "\n Storage \n ";
        element = new PageText((String)object2, 0);
        this._elevationTable.setPrintTitle((PageText)element);
        element = new ParamDouble();
        this._storage.getInitialConicDepth((ParamDouble)element);
        this._jTxt_initialConicDepth.setValue((ParamDouble)element);
        if (this._storage.useConicInterpolation()) {
            this._jRadio_conicInterp.removeItemListener((ItemListener)this);
            this._jRadio_conicInterp.setSelected(true);
            this._jRadio_conicInterp.addItemListener((ItemListener)this);
            this.setConicInterpolation();
        } else {
            this._jRadio_linearInterp.removeItemListener((ItemListener)this);
            this._jRadio_linearInterp.setSelected(true);
            this._jRadio_linearInterp.addItemListener((ItemListener)this);
            this.setLinearInterpolation();
        }
        this.plotCapacity();
        if (this._parent != null) {
            this._parent.updateUnitSystem((Container)((Object)this));
        }
        this.setModified(false);
    }

    public void clearPanel() {
    }

    public void refresh() {
        if (!this.areControlsCreated()) {
            return;
        }
        Serializable serializable = SwingUtilities.windowForComponent((Component)((Object)this));
        if (serializable instanceof ReservoirJFrame) {
            this.units = ((ReservoirJFrame)((Object)serializable)).getUnits();
            JStorageCardPanel jStorageCardPanel = this;
            jStorageCardPanel.configurePlotPanel(jStorageCardPanel._g2dpanel);
            serializable = new Vector<SimplePairedValuesData>();
            ((Vector)serializable).addElement(this._storagePlotArray);
            ((Vector)serializable).addElement(this._areaPlotArray);
            this._g2dpanel.setPlotObjects((List)((Object)serializable));
        }
    }

    @Override
    public boolean savePanel() {
        if (!this.areControlsCreated()) {
            return true;
        }
        this._elevationTable.commitEdit(true);
        boolean bl = this._jRadio_conicInterp.isSelected();
        this._storage.setUseConicInterpolation(bl);
        if (bl) {
            this._storage.clearConicElevationAreaValues();
            PairedValues pairedValues = new PairedValues();
            PairedValues pairedValues2 = new PairedValues();
            StorageTableModel storageTableModel = (StorageTableModel)((Object)this._elevationTable.getModel());
            storageTableModel.storeData(pairedValues, pairedValues2);
            this._storage.setConicElevationAreaValues(pairedValues2);
            double d = Double.NEGATIVE_INFINITY;
            if (pairedValues.size() > 0) {
                d = pairedValues.getYValue(0);
            }
            this._storage.setFirstStorageValue(d);
            double d2 = this._jTxt_initialConicDepth.getValue();
            this._storage.setInitialConicDepth(d2);
            PairedValues pairedValues3 = this._storage.getConicElevationAreaValues();
            if (!pairedValues3.canInterpX() || !pairedValues3.canInterpY()) {
                JOptionPane.showMessageDialog((Component)((Object)this), "Elevation and Area values of your function must be a continuously increasing sequence.", "Capacity Curve Error", 2);
                return false;
            }
            if (d > 0.0 && pairedValues3.getValuePair((int)0).yval == 0.0) {
                JOptionPane.showMessageDialog((Component)((Object)this), "First Area value must be non-zero for a non-zero Storage value.", "Storage Curve Error", 2);
                return false;
            }
        } else {
            Object object;
            new Vector();
            this._storage.emptyCapacityVector();
            Vector vector = this._elevationTable.getCells();
            for (int i = 0; i < vector.size(); ++i) {
                if (vector.elementAt(i) == null || ((Vector)vector.elementAt(i)).size() < 3) continue;
                object = ((Vector)vector.elementAt(i)).elementAt(0);
                Object e = ((Vector)vector.elementAt(i)).elementAt(1);
                Object e2 = ((Vector)vector.elementAt(i)).elementAt(2);
                double d = RMAIO.parseDouble(object);
                double d3 = RMAIO.parseDouble(e);
                double d4 = RMAIO.parseDouble(e2);
                if (d == Double.NEGATIVE_INFINITY && d4 == Double.NEGATIVE_INFINITY && d3 == Double.NEGATIVE_INFINITY) continue;
                CapacityRecord capacityRecord = new CapacityRecord(d, d3, d4);
                this._storage.addCapacityRecord(capacityRecord);
            }
            PairedValues pairedValues = this._storage.getElevationStorageValues();
            if (!pairedValues.canInterpX() || !pairedValues.canInterpY()) {
                JOptionPane.showMessageDialog((Component)((Object)this), "Elevation and Storage values of your function must be a continuously increasing sequence.", "Storage Curve Error", 2);
                return false;
            }
            if (!(!this._storage.hasEvap() || (object = this._storage.getElevationAreaValues()).canInterpX() && object.canInterpY())) {
                JOptionPane.showMessageDialog((Component)((Object)this), "Reservoir has Evaporation.\nElevation and Area values of your function must be a continuously increasing sequence.", "Storage Curve Error", 2);
                return false;
            }
        }
        this.plotCapacity();
        return true;
    }

    SimplePairedValuesData getStoragePlotArray() {
        SimplePairedValuesData simplePairedValuesData = new SimplePairedValuesData();
        new SimplePairedValuesData().xunits = "Stor (%S)";
        simplePairedValuesData.yunits = "Elev (%S)";
        simplePairedValuesData.setXAxisType(0);
        simplePairedValuesData.resetData();
        simplePairedValuesData.setPlotXvsY(true);
        return simplePairedValuesData;
    }

    SimplePairedValuesData getAreaPlotArray() {
        SimplePairedValuesData simplePairedValuesData = new SimplePairedValuesData();
        new SimplePairedValuesData().xunits = "Area (%S)";
        simplePairedValuesData.yunits = "Elev (%S)";
        simplePairedValuesData.setXAxisType(0);
        simplePairedValuesData.resetData();
        simplePairedValuesData.setPlotXvsY(true);
        return simplePairedValuesData;
    }

    void configurePlotPanel(G2dPanel g2dPanel) {
        PlotDefaults plotDefaults = PlotDefaultsManager.getDefaults();
        PlotDefaultsManager.setDefaults((PlotDefaults)new HotPlotDefaults());
        G2dPanelProp g2dPanelProp = new G2dPanelProp();
        new G2dPanelProp().hasTitle = false;
        g2dPanelProp.hasToolbar = false;
        g2dPanelProp.hasLegend = false;
        G2dPlotProp g2dPlotProp = new G2dPlotProp();
        new G2dPlotProp().hasXScroll = false;
        g2dPlotProp.hasYScroll = false;
        g2dPlotProp.x1AxisProp.name = "Stor (%S)";
        g2dPlotProp.y1AxisProp.name = "Elev (%S)";
        g2dPlotProp.y1AxisProp.isReversed = true;
        g2dPanelProp.addPlotProp(g2dPlotProp);
        g2dPlotProp = new G2dPlotProp();
        new G2dPlotProp().row = 1;
        g2dPlotProp.hasXScroll = false;
        g2dPlotProp.hasYScroll = false;
        g2dPlotProp.x1AxisProp.name = "Area (%S)";
        g2dPlotProp.y1AxisProp.name = "Elev (%S)";
        g2dPlotProp.y1AxisProp.isReversed = true;
        g2dPanelProp.addPlotProp(g2dPlotProp);
        g2dPanel.configurePanel(g2dPanelProp);
        PlotDefaultsManager.setDefaults((PlotDefaults)plotDefaults);
    }

    @Override
    public void editingCanceled(ChangeEvent changeEvent) {
    }

    @Override
    public void editingStopped(ChangeEvent changeEvent) {
        if (this._jRadio_conicInterp.isSelected()) {
            this.updateStorageColumn();
        }
        this.replot();
    }

    private void updateStorageColumn() {
        if (this._conicTableModel != this._elevationTable.getModel()) {
            return;
        }
        double d = this._jTxt_initialConicDepth.getValue();
        Object object = this._conicTableModel.getValueAt(0, 1);
        if (!(object instanceof ParamDouble)) {
            return;
        }
        object = (ParamDouble)object;
        double d2 = object.getValue();
        Vector vector = this._conicTableModel.getDataVector();
        PairedValues pairedValues = new PairedValues();
        PairedValues pairedValues2 = new PairedValues();
        this._conicTableModel.storeData(pairedValues2, pairedValues);
        double[] dArray = Storage.getConicStorageArray(pairedValues, d2, d);
        double[] dArray2 = pairedValues.getXArray();
        int n = vector.size();
        int n2 = 0;
        for (int i = 1; i < n; ++i) {
            double d3;
            Vector vector2 = (Vector)vector.elementAt(i);
            if (vector2.size() < 3) continue;
            vector2 = vector2.elementAt(0);
            boolean bl = false;
            if (vector2 instanceof ParamDouble && (d3 = ((ParamDouble)vector2).getValue()) != Double.NEGATIVE_INFINITY) {
                while (n2 < dArray2.length && d3 > dArray2[n2]) {
                    ++n2;
                }
                if (n2 < dArray2.length && d3 == dArray2[n2]) {
                    try {
                        vector2 = (ParamDouble)object.clone();
                    }
                    catch (Exception exception) {
                        continue;
                    }
                    if (vector2 != null) {
                        vector2.setValue(dArray[n2]);
                        vector2.setPrecision(object.getPrecision());
                        this._conicTableModel.setValueAt(vector2, i, 1);
                        bl = true;
                    }
                }
            }
            if (bl) continue;
            this._conicTableModel.setValueAt("", i, 1);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent object) {
        if (((ItemEvent)object).getStateChange() == 2) {
            return;
        }
        if ((object = ((EventObject)object).getSource()) == this._jRadio_linearInterp || object == this._jRadio_conicInterp) {
            if (this._jRadio_conicInterp.isSelected()) {
                this.setConicInterpolation();
                return;
            }
            this.setLinearInterpolation();
        }
    }

    private void setConicInterpolation() {
        if (this._conicTableModel.isEmpty()) {
            double d = this._jTxt_initialConicDepth.getValue();
            this._conicTableModel.copyConicFromLinear(this._linearTableModel, d);
        }
        JStorageCardPanel jStorageCardPanel = this;
        jStorageCardPanel.setTableModel(jStorageCardPanel._conicTableModel);
        this._parent.updateUnitSystem((Container)((Object)this));
        this._jLabel_initialConicDepth.setEnabled(true);
        this._jTxt_initialConicDepth.setEnabled(true);
        this._elevationTable.setColumnEnabled(false, 1);
        this._elevationTable.setCellEnabled(true, 0, 1);
        this.replot();
    }

    private void setLinearInterpolation() {
        if (this._linearTableModel.isEmpty()) {
            this._linearTableModel.copyLinearFromConic(this._conicTableModel);
        }
        JStorageCardPanel jStorageCardPanel = this;
        jStorageCardPanel.setTableModel(jStorageCardPanel._linearTableModel);
        this._parent.updateUnitSystem((Container)((Object)this));
        this._jLabel_initialConicDepth.setEnabled(false);
        this._jTxt_initialConicDepth.setEnabled(false);
        this._elevationTable.setColumnEnabled(true, 1);
        this.replot();
    }

    private void setTableModel(StorageTableModel storageTableModel) {
        int n = this._elevationTable.getNumRows();
        this._elevationTable.setModel((TableModel)((Object)storageTableModel));
        this._elevationTable.setDoubleCellEditor(0);
        this._elevationTable.setUnitsHeaderRenderer();
        for (int i = 1; i < 3; ++i) {
            storageTableModel = this._elevationTable.setDoubleCellEditor(i);
            if (storageTableModel == null) continue;
            storageTableModel.setMinValue(0.0);
        }
        if (this._elevationTable.getNumRows() < n) {
            this._elevationTable.setNumRows(n);
        }
    }

    public RmaJTable getCapacityTable() {
        return this._elevationTable;
    }

    public void replot() {
        this.plotCapacity();
    }

    private void plotCapacity() {
        PairedValues pairedValues = new PairedValues();
        PairedValues pairedValues2 = new PairedValues();
        Object object = (StorageTableModel)((Object)this._elevationTable.getModel());
        object.storeData(pairedValues, pairedValues2);
        this._storagePlotArray.resetData();
        this._areaPlotArray.resetData();
        if (this._jRadio_conicInterp.isSelected()) {
            object = this._jTxt_initialConicDepth.getParamValue();
            double d = object.getValue();
            object = new ParamDouble();
            pairedValues.getYValue(0, (ParamDouble)object);
            double d2 = object.getValue();
            if (d2 == Double.NEGATIVE_INFINITY) {
                return;
            }
            object = Storage.getConicStorageArray(pairedValues2, d2, d);
            double[] dArray = pairedValues2.getXArray();
            if (dArray != null && dArray.length > 1) {
                double d3 = dArray[dArray.length - 1] - dArray[0];
                d3 /= 100.0;
                pairedValues.clearValues();
                double d4 = pairedValues2.getXValue(0);
                pairedValues.addPair(d4, d2);
                for (int i = 0; i < 101; ++i) {
                    double d5 = Storage.getConicStorageForElevation(d4 += d3, pairedValues2, (double[])object, d2, d);
                    pairedValues.addPair(d4, d5);
                }
            }
        }
        this._storagePlotArray.name = "Storage Capacity";
        this._storagePlotArray.lineStyleName = "STORAGE";
        this._areaPlotArray.name = "Area";
        this._areaPlotArray.lineStyleName = "AREA";
        this._storagePlotArray.setData(pairedValues);
        this._areaPlotArray.setData(pairedValues2);
    }
}

