/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.clientapp.client.ClientApp;
import hec.clientapp.client.ClientWorkspace;
import hec.data.DataSetIllegalArgumentException;
import hec.data.ParamDouble;
import hec.data.Parameter;
import hec.gfx2d.G2dLabelDrawProp;
import hec.gfx2d.G2dLineProperties;
import hec.gfx2d.G2dPanel;
import hec.gfx2d.G2dPanelProp;
import hec.gfx2d.G2dPlotProp;
import hec.gfx2d.HotPlotDefaults;
import hec.gfx2d.PlotDefaults;
import hec.gfx2d.PlotDefaultsManager;
import hec.gfx2d.PlotLayout;
import hec.gfx2d.SimpleJTableSeasonalData;
import hec.gfx2d.ViewportLayout;
import hec.model.ModelVariable;
import hec.model.PairedValues;
import hec.model.PairedValuesExt;
import hec.model.SeasonalPairedValues;
import hec.model.SeasonalRecord;
import hec.model.SeasonalRecordExt;
import hec.model.SeasonalRecordTableModel;
import hec.rss.RssRmiWorkspace;
import hec.rss.client.IndependentVariableDialog;
import hec.rss.client.JOperationsPanel;
import hec.rss.client.JStorageZonePanel$1;
import hec.rss.client.JStorageZonePanel$DateTablePanel;
import hec.rss.client.JStorageZonePanel$DateTimeTablePanel;
import hec.rss.client.JStorageZonePanel$MyG2dPanel;
import hec.rss.client.JStorageZonePanel$PairedValuesPanel;
import hec.rss.client.JStorageZonePanel$SeasonalPairedValuesPanel;
import hec.rss.client.JStorageZonePanel$SimpleSeasonData2;
import hec.rss.client.JStorageZonePanel$TwoVariableRuleCurvesPanel;
import hec.rss.client.JStorageZonePanel$ZoneTablePanel;
import hec.rss.model.IndependentVariable;
import hec.rss.model.StateVariable;
import hec.rss.model.Storage;
import hec.rss.model.StorageZone;
import hec.rss.model.globalvariable.GlobalVariable;
import hec.rss.model.globalvariable.TimeSeriesGlobalVariable;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.EventObject;
import java.util.List;
import java.util.TimeZone;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableModel;
import rma.lang.Modifiable;
import rma.lang.RmaMath;
import rma.swing.DefaultJPanel;
import rma.swing.JButtonGroup;
import rma.swing.RmaGridBagConstraints;
import rma.swing.RmaInsets;
import rma.swing.RmaJCalendarField;
import rma.swing.RmaJDecimalField;
import rma.swing.RmaJDescriptionField;
import rma.swing.RmaJDialog;
import rma.swing.RmaJDssPathPartField;
import rma.swing.RmaJFrame;
import rma.swing.RmaJRadioButton;
import rma.swing.RmaJTable;
import rma.swing.RmaJTextField;
import rma.swing.event.ReflectMultiListener;
import rma.util.RMAConst;
import rma.util.RMAIO;
import rma.util.RmaDrawConst;

public class JStorageZonePanel
extends DefaultJPanel
implements ActionListener,
FocusListener,
CellEditorListener,
Modifiable {
    private Insets INSETS5505 = new Insets(5, 5, 0, 5);
    private Insets INSETS5500 = new Insets(5, 5, 0, 0);
    private Insets INSETS5550 = new Insets(5, 5, 5, 0);
    private Insets INSETS5555 = new Insets(5, 5, 5, 5);
    private Insets INSETS0000 = new Insets(0, 0, 0, 0);
    private Insets INSETS02055 = new Insets(0, 20, 5, 5);
    private Insets INSETS55555 = new Insets(5, 5, 5, 55);
    private SimpleJTableSeasonalData _storageZonePlotArray;
    private Vector _zoneData = null;
    private StorageZone _currentZone = null;
    private String _oldStorageName = "";
    private DefaultJPanel _parent = null;
    protected ReflectMultiListener _listener;
    protected IndependentVariableDialog _independentVariableDialog;
    private JStorageZonePanel$ZoneTablePanel _currentPanel;
    private int _currentFunctionType = -1;
    private IndependentVariable _independentVariable;
    private int _xParamId = -1;
    private int _yParamId = Parameter.PARAMID_ELEV;
    private int _zParamId = -1;
    private String _xParamString = "undef x";
    private String _zParamString = "undef z";
    private final String YAXIS_STORAGE_LABEL = "Top Storage";
    private final String YAXIS_ELEVAION_LABEL = "Top Elevation";
    private String _yParamString = "Top Elevation";
    protected static final MessageFormat a = new MessageFormat("Top {0} (%S)");
    static final String[] b = new String[]{" "};
    static final Color c = UIManager.getColor("TextField.disabledBackground");
    private static final MessageFormat e = new MessageFormat("Zone Sort Value {0}");
    private JLabel _storageLabel = new JLabel("Storage Zone");
    private JLabel _descriptionLabel = new JLabel("Description");
    private JLabel _startYearLabel = new JLabel("Starting Year");
    private JLabel _functionOfLabel = new JLabel("Function of");
    private JLabel _referenceElevationLabel = new JLabel(e.format(new String[]{""}));
    private JButton _editColumnValuesButton = new JButton("Edit Column Values");
    private JPanel _nameDescPanel = new JPanel();
    private JPanel _funcDefinePanel = new JPanel();
    private JPanel _tablePanel = new JPanel();
    private JButton _defineButton = new JButton("Define...");
    private RmaJRadioButton _elevationDefinition;
    private RmaJRadioButton _storageDefinition;
    private RmaJTextField _functionOfTxt = new RmaJTextField();
    private RmaJTextField _storageZoneTxt = new RmaJDssPathPartField();
    private RmaJDescriptionField _descriptionTxt = new RmaJDescriptionField();
    private RmaJCalendarField _startYearTxt = new RmaJCalendarField("YYYY", "");
    private RmaJDecimalField _referenceElevationFld = new RmaJDecimalField();
    private JStorageZonePanel$ZoneTablePanel _blankPanel;
    private JStorageZonePanel$DateTablePanel _datePanel;
    private JStorageZonePanel$DateTimeTablePanel _dateTimePanel;
    private JStorageZonePanel$PairedValuesPanel _modelVariablePanel;
    private JStorageZonePanel$SeasonalPairedValuesPanel _seasonalVariablePanel;
    private JStorageZonePanel$TwoVariableRuleCurvesPanel _twoVariableRulePanel;
    private JPanel _cardPanel;
    private String[] _colLabels2 = new String[]{"Date", a.format(new String[]{""})};
    RmaJTable jStorageZoneTable;
    JStorageZonePanel$MyG2dPanel storageZonePlot;
    protected static final String[] d = new String[]{"Date", "Date and Time", "Model Variable", "External Time-Series", "Two Variable Rule"};

    public JStorageZonePanel() {
        JStorageZonePanel jStorageZonePanel = this;
        this.jStorageZoneTable = new JStorageZonePanel$1(jStorageZonePanel, (Component)((Object)jStorageZonePanel), this._colLabels2);
        this.storageZonePlot = new JStorageZonePanel$MyG2dPanel(this);
        this._listener = new ReflectMultiListener();
        this.setLayout(new GridBagLayout());
        Serializable serializable = this._descriptionTxt.getPreferredSize();
        this._descriptionTxt.getPreferredSize().width = 150;
        this._storageZoneTxt.setPreferredSize((Dimension)serializable);
        this._storageZoneTxt.setMinimumSize((Dimension)serializable);
        this._nameDescPanel.setLayout(new GridBagLayout());
        this._storageZoneTxt.setEditable(false);
        this._storageZoneTxt.setModifiable(false);
        this._nameDescPanel.add((Component)this._storageLabel, new RmaGridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, this.INSETS5500, 0, 0));
        this._nameDescPanel.add((Component)this._descriptionLabel, new RmaGridBagConstraints(2, 0, 1, 1, 0.0, 1.0, 17, 0, this.INSETS5500, 0, 0));
        this._nameDescPanel.add((Component)this._storageZoneTxt, new RmaGridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 2, this.INSETS5505, 0, 0));
        this._nameDescPanel.add((Component)this._descriptionTxt, new RmaGridBagConstraints(3, 0, 1, 1, 2.0, 1.0, 17, 2, this.INSETS5505, 0, 0));
        this._funcDefinePanel.setLayout(new GridBagLayout());
        new GridBagConstraints();
        serializable = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        ((GridBagConstraints)serializable).gridy = 1;
        ((GridBagConstraints)serializable).gridwidth = 1;
        ((GridBagConstraints)serializable).weightx = 0.0;
        ((GridBagConstraints)serializable).anchor = 17;
        ((GridBagConstraints)serializable).fill = 0;
        ((GridBagConstraints)serializable).insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)0);
        this._funcDefinePanel.add((Component)this._functionOfLabel, serializable);
        this._functionOfTxt.setEditable(false);
        this._functionOfTxt.setModifiable(false);
        serializable = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        ((GridBagConstraints)serializable).gridy = 1;
        ((GridBagConstraints)serializable).gridwidth = 2;
        ((GridBagConstraints)serializable).weightx = 2.0;
        ((GridBagConstraints)serializable).anchor = 17;
        ((GridBagConstraints)serializable).fill = 2;
        ((GridBagConstraints)serializable).insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        this._funcDefinePanel.add((Component)this._functionOfTxt, serializable);
        serializable = new GridBagConstraints();
        new GridBagConstraints().gridx = 3;
        ((GridBagConstraints)serializable).gridy = 1;
        ((GridBagConstraints)serializable).gridwidth = 1;
        ((GridBagConstraints)serializable).weightx = 0.0;
        ((GridBagConstraints)serializable).anchor = 12;
        ((GridBagConstraints)serializable).fill = 0;
        ((GridBagConstraints)serializable).insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        this._funcDefinePanel.add((Component)this._defineButton, serializable);
        JStorageZonePanel jStorageZonePanel2 = this;
        this._defineButton.addActionListener((ActionListener)this._listener.add((Object)jStorageZonePanel2, (Object)jStorageZonePanel2._defineButton, "displayDefineFunctionDialog"));
        this._tablePanel.setLayout(new GridBagLayout());
        this.jStorageZoneTable.setModel((TableModel)new SeasonalRecordTableModel(this._colLabels2, new boolean[]{true, true}));
        this._referenceElevationLabel.setToolTipText("Elevation to be used to sort zones and display in plot. Must be relative to the other zone elevations.");
        JStorageZonePanel jStorageZonePanel3 = this;
        jStorageZonePanel3.configurePlotPanel(jStorageZonePanel3.storageZonePlot);
        serializable = new Vector();
        this._storageZonePlotArray = this.getStorageZonePlotArray();
        ((Vector)serializable).addElement(this._storageZonePlotArray);
        this.storageZonePlot.setPlotObjects((List)((Object)serializable));
        serializable = new JPanel();
        ((Container)serializable).setLayout(new GridBagLayout());
        this._elevationDefinition = new RmaJRadioButton("Elevation");
        this._storageDefinition = new RmaJRadioButton("Storage");
        JLabel jLabel = new JLabel("Define By:");
        JButtonGroup jButtonGroup = new JButtonGroup();
        jButtonGroup.add((AbstractButton)this._elevationDefinition);
        jButtonGroup.add((AbstractButton)this._storageDefinition);
        ((Container)serializable).add(jLabel, new RmaGridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        ((Container)serializable).add((Component)this._elevationDefinition, new RmaGridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        ((Container)serializable).add((Component)this._storageDefinition, new RmaGridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this._tablePanel.add((Component)((Object)this.storageZonePlot), new RmaGridBagConstraints(2, 0, 1, 1, 0.0, 1.0, 12, 0, this.INSETS5555, 150, 150));
        this._tablePanel.add((Component)this._referenceElevationLabel, new RmaGridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, this.INSETS5555, 0, 0));
        this._tablePanel.add((Component)this._referenceElevationFld, new RmaGridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 17, 2, this.INSETS55555, 0, 0));
        this._tablePanel.add((Component)this._editColumnValuesButton, new RmaGridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 12, 0, this.INSETS55555, 0, 0));
        JStorageZonePanel jStorageZonePanel4 = this;
        jStorageZonePanel4.add(jStorageZonePanel4._nameDescPanel, new RmaGridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 2, this.INSETS0000, 0, 0));
        JStorageZonePanel jStorageZonePanel5 = this;
        jStorageZonePanel5.add(jStorageZonePanel5._funcDefinePanel, new RmaGridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 18, 2, this.INSETS0000, 0, 0));
        this.add((Component)serializable, new RmaGridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 18, 2, this.INSETS0000, 0, 0));
        JStorageZonePanel jStorageZonePanel6 = this;
        jStorageZonePanel6.add(jStorageZonePanel6._tablePanel, new RmaGridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 18, 1, this.INSETS0000, 0, 0));
        this._editColumnValuesButton.setVisible(false);
        this._referenceElevationFld.setEnabled(false);
        this._storageZoneTxt.addFocusListener((FocusListener)this);
        this._referenceElevationFld.addActionListener((ActionListener)this);
        this._storageLabel.setDisplayedMnemonic('g');
        this._descriptionLabel.setDisplayedMnemonic('t');
        this._startYearLabel.setDisplayedMnemonic('a');
        this._storageLabel.setLabelFor((Component)this._storageZoneTxt);
        this._referenceElevationLabel.setDisplayedMnemonic('r');
        this._descriptionLabel.setLabelFor((Component)this._descriptionTxt);
        this._startYearLabel.setLabelFor((Component)this._startYearTxt);
        this._cardPanel = new JPanel(new CardLayout());
        serializable = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        ((GridBagConstraints)serializable).gridy = 0;
        ((GridBagConstraints)serializable).gridwidth = 2;
        ((GridBagConstraints)serializable).gridheight = 1;
        ((GridBagConstraints)serializable).weightx = 1.0;
        ((GridBagConstraints)serializable).weighty = 1.0;
        ((GridBagConstraints)serializable).anchor = 18;
        ((GridBagConstraints)serializable).fill = 1;
        ((GridBagConstraints)serializable).insets = RmaInsets.insets((int)5, (int)5, (int)5, (int)0);
        this._tablePanel.add((Component)this._cardPanel, serializable);
        this._datePanel = new JStorageZonePanel$DateTablePanel(this);
        this._dateTimePanel = new JStorageZonePanel$DateTimeTablePanel(this);
        this._modelVariablePanel = new JStorageZonePanel$PairedValuesPanel(this);
        this._seasonalVariablePanel = new JStorageZonePanel$SeasonalPairedValuesPanel(this);
        this._twoVariableRulePanel = new JStorageZonePanel$TwoVariableRuleCurvesPanel(this);
        this._cardPanel.add(d[0], this._datePanel);
        this._cardPanel.add(d[1], this._dateTimePanel);
        this._cardPanel.add(d[2], this._seasonalVariablePanel);
        this._cardPanel.add(d[3], this._modelVariablePanel);
        this._cardPanel.add(d[4], this._twoVariableRulePanel);
        ((CardLayout)this._cardPanel.getLayout()).show(this._cardPanel, d[2]);
        this._elevationDefinition.addActionListener(actionEvent -> this.elevationRadioButtonSelected());
        this._storageDefinition.addActionListener(actionEvent -> this.storageRadioButtonSelected());
    }

    public void elevationRadioButtonSelected() {
        if (this._yParamId != Parameter.PARAMID_ELEV) {
            this.convertZonePanelTables("Elevation", Parameter.PARAMID_ELEV, "Top Elevation");
            this.setModified(true);
        }
    }

    public void storageRadioButtonSelected() {
        if (this._yParamId != Parameter.PARAMID_STOR) {
            this.convertZonePanelTables("Storage", Parameter.PARAMID_STOR, "Top Storage");
            this.setModified(true);
        }
    }

    private void convertZonePanelTables(String string, int n, String string2) {
        ((JStorageZonePanel$ZoneTablePanel)this._datePanel).convertTableValues(n);
        ((JStorageZonePanel$ZoneTablePanel)this._dateTimePanel).convertTableValues(n);
        ((JStorageZonePanel$ZoneTablePanel)this._modelVariablePanel).convertTableValues(n);
        ((JStorageZonePanel$ZoneTablePanel)this._seasonalVariablePanel).convertTableValues(n);
        ((JStorageZonePanel$ZoneTablePanel)this._twoVariableRulePanel).convertTableValues(n);
        double d = this._referenceElevationFld.getValue();
        if (this._currentZone != null && RMAConst.isValidValue((double)d)) {
            Storage storage = this._currentZone.getReservoirElement().getStorageFunction();
            int n2 = ParamDouble.findPrecision((double)d);
            int n3 = (int)Math.floor(Math.log10(d)) + n2 + 1;
            double d2 = n == Parameter.PARAMID_ELEV ? storage.storageToElevation(d) : storage.elevationToStorage(d);
            int n4 = (int)(Math.floor(Math.log10(d2)) + 1.0);
            n4 = Math.max(1, n3 - n4);
            d2 = RmaMath.roundToSignificantDigits((double)d2, (int)n4);
            this._referenceElevationFld.setValue(d2);
        }
        this.updateZonePanelLabels(string, n, string2);
    }

    private void updateZonePanelLabels(String object, int n, String string) {
        this._yParamId = n;
        this._yParamString = string;
        this._datePanel.updateParameterColumnLabel(a.format(new String[]{object}), n);
        this._dateTimePanel.updateParameterColumnLabel(a.format(new String[]{object}), n);
        this._modelVariablePanel.updateParameterColumnLabel(a.format(new String[]{object}), n);
        this._seasonalVariablePanel.updateParameterColumnLabel(a.format(new String[]{object}), n);
        this._twoVariableRulePanel.updateParameterColumnLabel(a.format(new String[]{object}), n);
        this.replot();
        object = SwingUtilities.windowForComponent((Component)((Object)this));
        if (object instanceof RmaJDialog) {
            ((RmaJDialog)object).updateUnitSystem((Container)((Object)this));
            ((RmaJDialog)object).updateTimeZone((Container)((Object)this));
            return;
        }
        if (object instanceof RmaJFrame) {
            ((RmaJFrame)object).updateUnitSystem((Container)((Object)this));
            ((RmaJFrame)object).updateTimeZone((Container)((Object)this));
        }
    }

    @Override
    public void editingCanceled(ChangeEvent changeEvent) {
    }

    @Override
    public void editingStopped(ChangeEvent serializable) {
        this.replot();
        serializable = SwingUtilities.windowForComponent((Component)((Object)this));
        if (serializable instanceof RmaJDialog) {
            ((RmaJDialog)serializable).updateUnitSystem((Container)((Object)this.storageZonePlot));
            return;
        }
        ((RmaJFrame)serializable).updateUnitSystem((Container)((Object)this.storageZonePlot));
    }

    public void setData(Vector vector) {
        this._zoneData = vector;
        this._currentZone = null;
    }

    public void addData(StorageZone storageZone) {
        this._zoneData.addElement(storageZone);
    }

    public boolean selectZone(String string) {
        if (string == null) {
            return false;
        }
        for (int i = 0; i < this._zoneData.size(); ++i) {
            StorageZone storageZone = (StorageZone)this._zoneData.elementAt(i);
            if (!string.equalsIgnoreCase(storageZone.getName())) continue;
            this._currentZone = storageZone;
            this.fillPanel();
            return true;
        }
        return true;
    }

    void setZoneName(String string) {
        this._storageZoneTxt.setText(string);
    }

    public void fillPanel() {
        IndependentVariable independentVariable;
        if (this._zoneData == null || this._zoneData.size() == 0) {
            return;
        }
        if (this._currentZone == null) {
            this._currentZone = (StorageZone)this._zoneData.elementAt(0);
        }
        Object object = this._currentZone;
        this.clearPanel();
        this._independentVariable = independentVariable = this._currentZone.getIndependentVariable();
        this._currentFunctionType = independentVariable.getType();
        JStorageZonePanel jStorageZonePanel = this;
        jStorageZonePanel.setZoneName(jStorageZonePanel._currentZone.getName());
        this._descriptionTxt.setText(this._currentZone.getDescription());
        this._referenceElevationFld.setValue(this._currentZone.getReferenceValue());
        int n = independentVariable.getType();
        this._oldStorageName = this._currentZone.getName();
        ClientApp.app();
        Object object2 = new String("Workspace: " + ClientApp.Workspace().getTitleName());
        object2 = (String)object2 + "\n ResSim System: " + ((JOperationsPanel)this._parent)._reservoir.getSystem().getName();
        object2 = (String)object2 + "\n Reservoir: " + ((JOperationsPanel)this._parent)._reservoir.getName();
        object2 = (String)object2 + "\n Operation Set: " + ((JOperationsPanel)this._parent)._currentOpSet.getName();
        String cfr_ignored_0 = (String)object2 + "\n Storage Zone: " + this._currentZone.getName() + " \n ";
        if (this._independentVariable != null) {
            n = this._independentVariable.getType();
        }
        object = n == 2 || n == 3 || n == 4 || n == 6 || n == 5 ? ((StorageZone)object).getFunctionElevation() : ((StorageZone)object).getSeasonalRecord();
        int n2 = this._currentZone.getZoneTypeID();
        this.setFunctionType(n, object, n2);
        if (n2 == 0) {
            this._elevationDefinition.setSelected(true);
            this._storageDefinition.setSelected(false);
        } else {
            this._storageDefinition.setSelected(true);
            this._elevationDefinition.setSelected(false);
        }
        this.refreshZonePanel();
        this.replot();
        this.setModified(false);
    }

    public void refresh() {
    }

    public boolean savePanel() {
        if (this._storageZoneTxt.getText().equals("")) {
            RMAIO.postError((Component)((Object)this), (String)"Storage Zones cannot have a blank name!");
        }
        if (this._referenceElevationFld.isEnabled() && this._referenceElevationFld.getText().isEmpty()) {
            JStorageZonePanel jStorageZonePanel = this;
            RMAIO.postError((Component)((Object)jStorageZonePanel), (String)("Storage Zone, " + jStorageZonePanel.getName() + " cannot have an empty Zone Sort Value!"));
        } else if (this._referenceElevationFld.isEnabled()) {
            this._currentZone.setReferenceValue(this._referenceElevationFld.getValue());
            this._currentZone.setUseReferenceValue(true);
        } else {
            this._currentZone.setUseReferenceValue(false);
        }
        this._currentZone.setName(this._storageZoneTxt.getText());
        this._oldStorageName = this._storageZoneTxt.getText();
        this._currentZone.setDescription(this._descriptionTxt.getText());
        if (this._functionOfTxt.getText().equalsIgnoreCase(d[3])) {
            this._currentZone.useTimeSeries(true);
        } else {
            this._currentZone.useTimeSeries(false);
        }
        if (this._independentVariable != null) {
            JStorageZonePanel jStorageZonePanel = this;
            String string = jStorageZonePanel.buildFunctionOfString(jStorageZonePanel._independentVariable);
            this._functionOfTxt.setText(string);
            this._currentZone.setIndependentVariable(this._independentVariable);
        }
        int n = this._storageDefinition.isSelected() ? 1 : 0;
        this._currentZone.setZoneTypeID(n);
        if (!super.savePanel()) {
            return false;
        }
        StorageZone storageZone = this._currentZone;
        if (storageZone == null) {
            return false;
        }
        storageZone.setUseTwoVariableIndependentVariable(false);
        if (this._currentFunctionType == -1) {
            return false;
        }
        storageZone.setIndependentVariable(this._independentVariable);
        if (this._currentPanel instanceof JStorageZonePanel$DateTablePanel || this._currentPanel instanceof JStorageZonePanel$DateTimeTablePanel) {
            SeasonalRecord seasonalRecord = (SeasonalRecord)this._currentPanel.saveTable();
            storageZone.setSeasonalRecord(seasonalRecord);
        } else if (this._currentPanel instanceof JStorageZonePanel$PairedValuesPanel) {
            PairedValues pairedValues = (PairedValues)this._currentPanel.saveTable();
            SeasonalPairedValues seasonalPairedValues = new SeasonalPairedValues();
            seasonalPairedValues.setData(pairedValues, "01Jan");
            seasonalPairedValues.setHasSeasonalVariation(false);
            storageZone.setFunctionElevation(seasonalPairedValues);
        } else if (this._currentPanel instanceof JStorageZonePanel$SeasonalPairedValuesPanel) {
            SeasonalPairedValues seasonalPairedValues = (SeasonalPairedValues)this._currentPanel.saveTable();
            seasonalPairedValues.setHasSeasonalVariation(true);
            storageZone.setFunctionElevation(seasonalPairedValues);
        } else if (this._currentPanel instanceof JStorageZonePanel$TwoVariableRuleCurvesPanel) {
            if (this._independentVariable.getRowVariable().getType() == 0 || this._independentVariable.getRowVariable().getType() == 1) {
                SeasonalRecordExt seasonalRecordExt = (SeasonalRecordExt)this._currentPanel.saveTable();
                storageZone.setUserDefinedValues(seasonalRecordExt);
                storageZone.setFunctionElevation(seasonalRecordExt);
                storageZone.setUserDefinedColumnValues(seasonalRecordExt.getCurveLabels());
            } else {
                PairedValuesExt pairedValuesExt = (PairedValuesExt)this._currentPanel.saveTable();
                storageZone.setUserDefinedValues(pairedValuesExt);
                storageZone.setFunctionElevation(pairedValuesExt);
                storageZone.setUserDefinedColumnValues(pairedValuesExt.getCurveLabels());
            }
            storageZone.setUseTwoVariableIndependentVariable(true);
            storageZone.setIndependentVariable(this._independentVariable);
            storageZone.setTVRowIndependentVariable(this._independentVariable.getRowVariable());
            storageZone.setTVColIndependentVariable(this._independentVariable.getColVariable());
        }
        this.setModified(false);
        return true;
    }

    public void clearPanel() {
        this._storageZoneTxt.setText("");
        this._descriptionTxt.setText("");
        this._referenceElevationFld.setValue(Double.NEGATIVE_INFINITY);
        this._startYearTxt.setEnabled(false);
        this.storageZonePlot.setPlotObjects(new Vector());
        this.storageZonePlot.paintGfx();
        this._currentFunctionType = -1;
        this._currentPanel = null;
        this._independentVariable = null;
        this._datePanel.clearPanel();
        this._dateTimePanel.clearPanel();
        this._seasonalVariablePanel.clearPanel();
        this._modelVariablePanel.clearPanel();
        this._twoVariableRulePanel.clearPanel();
    }

    public void setParent(JPanel jPanel) {
        this._parent = (JOperationsPanel)((Object)jPanel);
    }

    private SimpleJTableSeasonalData getStorageZonePlotArray() {
        SimpleJTableSeasonalData simpleJTableSeasonalData = new SimpleJTableSeasonalData();
        new SimpleJTableSeasonalData().xunits = "Minutes";
        simpleJTableSeasonalData.yunits = "Elevation (%S)";
        simpleJTableSeasonalData.setXAxisType(2);
        simpleJTableSeasonalData.setData(null, -1, -1);
        TimeZone timeZone = RmaJFrame.getTimeZone();
        if (timeZone != null) {
            simpleJTableSeasonalData.setGmtOffset(timeZone.getRawOffset() / 3600000);
        }
        return simpleJTableSeasonalData;
    }

    private void configurePlotPanel(G2dPanel g2dPanel) {
        PlotDefaults plotDefaults = PlotDefaultsManager.getDefaults();
        PlotDefaultsManager.setDefaults((PlotDefaults)new HotPlotDefaults());
        G2dPanelProp g2dPanelProp = new G2dPanelProp();
        new G2dPanelProp().hasTitle = false;
        g2dPanelProp.hasToolbar = false;
        g2dPanelProp.hasLegend = false;
        G2dPlotProp g2dPlotProp = new G2dPlotProp();
        new G2dPlotProp().hasXScroll = false;
        g2dPlotProp.hasYScroll = false;
        g2dPlotProp.x1AxisProp.name = "Minutes";
        g2dPlotProp.x1AxisProp.type = 2;
        g2dPlotProp.y1AxisProp.name = "Elevation (%S)";
        g2dPlotProp.x1AxisProp.numTicLabelLayers = 1;
        g2dPlotProp.hasX1Label = false;
        g2dPlotProp.y1AxisProp.isReversed = true;
        g2dPlotProp.x1AxisProp.isDefaultLimits = false;
        g2dPlotProp.x1AxisProp.min = 0.0;
        g2dPlotProp.x1AxisProp.max = 525600.0;
        g2dPanelProp.addPlotProp(g2dPlotProp);
        g2dPanel.configurePanel(g2dPanelProp);
        PlotDefaultsManager.setDefaults((PlotDefaults)plotDefaults);
    }

    public void replot() {
        if (this._currentZone.getIndependentVariable().getType() != 5) {
            this.plotStorageZone();
            return;
        }
        if (this._currentPanel instanceof JStorageZonePanel$TwoVariableRuleCurvesPanel) {
            this.plotStorageZone();
        }
    }

    private void plotStorageZone() {
        int n;
        this.storageZonePlot.setVisible(false);
        Vector<Object> vector = new Vector<Object>();
        Vector<G2dLineProperties> vector2 = new Vector<G2dLineProperties>();
        new StorageZone();
        double[] dArray = new double[2];
        int[] nArray = new int[2];
        int[] nArray2 = nArray;
        nArray[0] = 1;
        nArray2[1] = 525600;
        this.storageZonePlot.clearPanel();
        JStorageZonePanel jStorageZonePanel = this;
        jStorageZonePanel.configurePlotPanel(jStorageZonePanel.storageZonePlot);
        PlotLayout plotLayout = new PlotLayout();
        ViewportLayout viewportLayout = plotLayout.addViewport();
        plotLayout.setTitle("");
        plotLayout.setHasToolbar(false);
        plotLayout.setHasLegend(false);
        boolean bl = this._elevationDefinition.isSelected();
        if (this._zoneData == null) {
            this._storageZonePlotArray.setData(this.jStorageZoneTable, 0, 2);
            this._storageZonePlotArray.setXAxisType(2);
        } else {
            n = ((JOperationsPanel)this._parent)._currentOpSet.getGuideCurveZoneIndex();
            for (int i = 0; i < this._zoneData.size(); ++i) {
                Object object;
                StorageZone storageZone = (StorageZone)this._zoneData.elementAt(i);
                G2dLineProperties g2dLineProperties = new G2dLineProperties();
                SeasonalRecord seasonalRecord = new SeasonalRecord();
                if (storageZone.useReferenceValue() && storageZone.getReferenceValue() != Double.NEGATIVE_INFINITY) {
                    dArray[0] = storageZone.getReferenceValue();
                    dArray[1] = storageZone.getReferenceValue();
                    seasonalRecord.setUnitSystem(storageZone.getUnitSystem());
                    seasonalRecord.setParameterId(this._yParamId);
                    seasonalRecord.setArrays(nArray2, dArray);
                } else {
                    try {
                        seasonalRecord = (SeasonalRecord)storageZone.getSeasonalRecord().clone();
                    }
                    catch (CloneNotSupportedException cloneNotSupportedException) {
                        seasonalRecord = new SeasonalRecord();
                    }
                }
                if (seasonalRecord.getDataArray() == null || seasonalRecord.getDataArray().length == 0) continue;
                if (bl && storageZone.getZoneTypeID() == 1) {
                    object = storageZone.getReservoirElement().getStorageFunction();
                    double[] dArray2 = seasonalRecord.getDataArray();
                    if (dArray2 != null) {
                        var15_18 = dArray2.length;
                        for (var16_19 = 0; var16_19 < var15_18; ++var16_19) {
                            dArray2[var16_19] = ((Storage)object).storageToElevation(dArray2[var16_19]);
                        }
                    }
                } else if (!bl && storageZone.getZoneTypeID() == 0) {
                    object = storageZone.getReservoirElement().getStorageFunction();
                    double[] dArray3 = seasonalRecord.getDataArray();
                    if (dArray3 != null) {
                        var15_18 = dArray3.length;
                        for (var16_19 = 0; var16_19 < var15_18; ++var16_19) {
                            dArray3[var16_19] = ((Storage)object).elevationToStorage(dArray3[var16_19]);
                        }
                    }
                }
                g2dLineProperties._lineColor = storageZone == this._currentZone ? Color.RED : (storageZone.getIndex() == n ? Color.CYAN : Color.BLACK);
                if (storageZone.getIndependentVariable() != null && storageZone.getIndependentVariable().getType() == 3) {
                    g2dLineProperties._lineStylePattern = RmaDrawConst.DASH_STYLE_PATTERN;
                }
                object = new JStorageZonePanel$SimpleSeasonData2(this);
                new JStorageZonePanel$SimpleSeasonData2(this).name = storageZone.getName();
                object.setData(seasonalRecord);
                ((JStorageZonePanel$SimpleSeasonData2)((Object)object)).xunits = "Minutes";
                ((JStorageZonePanel$SimpleSeasonData2)((Object)object)).yunits = this._yParamString + " (%S)";
                object.setYParameterId(this._yParamId);
                object.setPlotYears(1);
                object.setInterpolationType("linear");
                ((JStorageZonePanel$SimpleSeasonData2)((Object)object)).lineStyleName = "ELEV-ZONE";
                if (((JOperationsPanel)this._parent)._currentOpSet != null && ((JOperationsPanel)this._parent)._currentOpSet.getElementOp() != null) {
                    int n2 = ((JOperationsPanel)this._parent)._currentOpSet.getElementOp().getGmtOffset();
                    object.setGmtOffset(n2);
                }
                if (g2dLineProperties._lineColor != Color.RED) {
                    vector2.add(0, g2dLineProperties);
                    vector.add(0, object);
                    continue;
                }
                vector2.addElement(g2dLineProperties);
                vector.addElement(object);
            }
        }
        if (vector.size() > 0) {
            for (n = 0; n < vector.size(); ++n) {
                viewportLayout.addCurve("Y1", vector.get(n), (G2dLineProperties)vector2.get(n));
            }
            this.storageZonePlot.buildComponents(plotLayout);
            this.storageZonePlot.getViewportAxis(this.storageZonePlot.getViewports()[0], 0).setNumTicLabelLevels(1);
            G2dLabelDrawProp g2dLabelDrawProp = this.storageZonePlot.getViewportAxisLabel(this.storageZonePlot.getViewports()[0], 0).getProperties();
            this.storageZonePlot.getViewportAxisLabel(this.storageZonePlot.getViewports()[0], 0).getProperties().showLabel = false;
            this.storageZonePlot.getViewportAxisLabel(this.storageZonePlot.getViewports()[0], 0).setProperties(g2dLabelDrawProp);
            this.storageZonePlot.setPlotObjects(vector, vector2);
            this.storageZonePlot.revalidate();
            this.storageZonePlot.paintGfx();
        }
        this.storageZonePlot.repaint();
        this.storageZonePlot.setVisible(true);
    }

    protected void refreshZonePanel() {
        if (this._independentVariable != null) {
            int n = this._independentVariable.getType();
            if (this._independentVariable.isTSOptChecked()) {
                this._referenceElevationFld.setEnabled(true);
                this._referenceElevationFld.setPrecision(1);
                this._referenceElevationFld.setValue(this._currentZone.getReferenceValue());
                this._seasonalVariablePanel._spvTable.setAllColumnsEnabled(false);
            } else if (n == 2 || n == 3 || n == 6 || n == 4) {
                this._referenceElevationFld.setEnabled(true);
                this._referenceElevationFld.setPrecision(1);
                this._seasonalVariablePanel._spvTable.setAllColumnsEnabled(true);
            } else if (n == 5) {
                this._referenceElevationFld.setEnabled(true);
                this._referenceElevationFld.setPrecision(1);
            } else {
                this._referenceElevationFld.setEnabled(false);
                this._referenceElevationFld.setValue(Double.NEGATIVE_INFINITY);
            }
            if (n == 5) {
                this._editColumnValuesButton.setVisible(true);
            } else {
                this._editColumnValuesButton.setVisible(false);
            }
        }
        if (this._elevationDefinition.isSelected()) {
            this.updateZonePanelLabels("Elevation", Parameter.PARAMID_ELEV, "Top Elevation");
            return;
        }
        this.updateZonePanelLabels("Storage", Parameter.PARAMID_STOR, "Top Storage");
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
    }

    @Override
    public void focusLost(FocusEvent object) {
        if ((object = ((EventObject)object).getSource()) == this._storageZoneTxt) {
            if (this._storageZoneTxt.getText().equals("")) {
                this._storageZoneTxt.setText(this._currentZone.getName());
                RMAIO.postError((Component)((Object)this), (String)"Cannot have a blank zone Name!");
                return;
            }
            if (this._currentZone != null) {
                this._currentZone.setName(this._storageZoneTxt.getText());
            }
            ((JOperationsPanel)this._parent).treeDataChanged(0, this._storageZoneTxt.getText(), this._oldStorageName);
        }
    }

    public void deselectPanel() {
        if (this.isModified()) {
            this.savePanel();
        }
    }

    protected void displayDefineFunctionDialog() {
        int n;
        IndependentVariable independentVariable = this._independentVariable;
        StorageZone storageZone = this._currentZone;
        if (storageZone == null) {
            return;
        }
        this._independentVariableDialog = new IndependentVariableDialog((Dialog)SwingUtilities.windowForComponent((Component)((Object)this)), true, true, "Zone");
        this._independentVariableDialog.setNetwork(storageZone.getSystem());
        this._independentVariableDialog.setElement(storageZone.getReservoirElement());
        if (this._independentVariable != null) {
            this._independentVariableDialog.setIndependentVariable(this._independentVariable);
        }
        this._independentVariableDialog.setExternalVariableName(storageZone.getReservoirElement().getName() + " - " + storageZone.getName());
        this._independentVariableDialog.setVisible(true);
        if (this._independentVariableDialog.isCanceled()) {
            return;
        }
        this._independentVariable = this._independentVariableDialog.getIndependentVariable();
        int n2 = this._independentVariable.getType();
        JStorageZonePanel jStorageZonePanel = this;
        Object object = jStorageZonePanel.buildFunctionOfString(jStorageZonePanel._independentVariable);
        this._functionOfTxt.setText((String)object);
        object = null;
        if (independentVariable != null) {
            n = independentVariable.getType();
            if (!(n != 0 && n != 1 || n2 != 0 && n2 != 1)) {
                if (!this._currentPanel.isEmpty()) {
                    object = this._currentPanel.saveTable();
                }
            } else if (n2 == 3 && n2 == n) {
                if (!this._currentPanel.isEmpty()) {
                    object = this._currentPanel.saveTable();
                }
            } else if (n == 5 && n2 == 5) {
                n = independentVariable.getColVariable().getType();
                int n3 = independentVariable.getRowVariable().getType();
                int n4 = this._independentVariable.getColVariable().getType();
                int n5 = this._independentVariable.getRowVariable().getType();
                String[] stringArray = independentVariable.getTwoVariableColumnValues();
                if (stringArray != null && stringArray.length > 0) {
                    this._independentVariable.setTwoVariableColumnValues(stringArray);
                }
                if (n == n4 && n3 == n5) {
                    if (!this._currentPanel.isEmpty()) {
                        object = this._currentPanel.saveTable();
                    }
                    if (this._independentVariable.getRowVariable().areTheSame(independentVariable.getRowVariable()) && this._independentVariable.getColVariable().areTheSame(independentVariable.getColVariable())) {
                        this.setModified(false);
                        return;
                    }
                }
                if (!(n3 != 0 && n3 != 1 || n5 != 0 && n5 != 1)) {
                    if (!this._currentPanel.isEmpty()) {
                        object = this._currentPanel.saveTable();
                    }
                    this._independentVariable.setTwoVariableColumnValues(independentVariable.getTwoVariableColumnValues());
                } else if (this._currentPanel instanceof JStorageZonePanel$TwoVariableRuleCurvesPanel) {
                    ((JStorageZonePanel$TwoVariableRuleCurvesPanel)this._currentPanel).clearPanel();
                }
            } else if (this._independentVariable.areTheSame(independentVariable)) {
                this.setModified(false);
                return;
            }
        }
        n = this._elevationDefinition.isSelected() ? 0 : 1;
        this.setFunctionType(n2, object, n);
        this.refreshZonePanel();
        this.setModified(true);
    }

    public void setFunctionType(int n, Object object, int n2) {
        if (1 != n2 && n2 != 0) {
            throw new IllegalArgumentException("Zone Type must either be StorageZone.ZONE_STORAGE or StorageZone.ZONE_ELEVATION");
        }
        this._yParamId = 1 == n2 ? Parameter.PARAMID_STOR : Parameter.PARAMID_ELEV;
        this._yParamString = 1 == n2 ? "Top Storage" : "Top Elevation";
        this._currentFunctionType = n;
        JStorageZonePanel jStorageZonePanel = this;
        Object object2 = jStorageZonePanel.buildFunctionOfString(jStorageZonePanel._independentVariable);
        if (((String)object2).startsWith("External Variable")) {
            object2 = this._currentZone.getReservoirElement().getName() + " - " + this._currentZone.getName();
        }
        this._functionOfTxt.setText((String)object2);
        if (n == 2 || n == 3 || n == 6 || n == 4) {
            this._xParamId = -1;
            if (n == 2) {
                ModelVariable modelVariable = this._independentVariable.getModelVariable();
                if (modelVariable != null) {
                    this._xParamId = modelVariable.getParamId();
                    this._xParamString = Parameter.getParamString((int)this._xParamId);
                    this._functionOfTxt.setToolTipText("Model Variable");
                }
            } else if (n == 6) {
                GlobalVariable globalVariable = this._currentZone.getSystem().getGlobalVariable(this._independentVariable.getGlobalVariableId());
                if (globalVariable instanceof TimeSeriesGlobalVariable) {
                    object2 = (TimeSeriesGlobalVariable)globalVariable;
                    this._xParamString = ((TimeSeriesGlobalVariable)object2).getParameterType();
                    try {
                        object2 = new Parameter(this._xParamString);
                        this._xParamId = object2.getParameterId();
                    }
                    catch (DataSetIllegalArgumentException dataSetIllegalArgumentException) {
                        System.out.println("setFunctionType:Illegal Parameter " + String.valueOf((Object)dataSetIllegalArgumentException));
                        this._xParamId = -1;
                    }
                    this._functionOfTxt.setToolTipText("Global Variable");
                }
            } else if (n == 4) {
                StateVariable stateVariable = this._currentZone.getSystem().getStateVariable(this._independentVariable.getStateVariableId());
                this._xParamString = stateVariable.getParamName();
                this._functionOfTxt.setToolTipText("State Variable");
                try {
                    object2 = new Parameter(stateVariable.getParamType());
                    this._xParamId = object2.getParameterId();
                }
                catch (DataSetIllegalArgumentException dataSetIllegalArgumentException) {
                    System.out.println("setFunctionType:Illegal Parameter " + String.valueOf((Object)dataSetIllegalArgumentException));
                    this._xParamId = -1;
                }
            } else {
                this._xParamString = this._independentVariable.getTimeSeriesName();
            }
            if (this._xParamString.endsWith(this._currentZone.getName()) && this._independentVariable.isTSOptChecked()) {
                if (!(object instanceof SeasonalPairedValues) && !(object instanceof PairedValues)) {
                    object = new SeasonalPairedValues();
                }
                ((SeasonalPairedValues)object).setParamXId(this._xParamId);
                ((SeasonalPairedValues)object).setParamYId(this._yParamId);
                ((SeasonalPairedValues)object).setUnitSystem(this._currentZone.getUnitSystem());
                this._seasonalVariablePanel.setData(object);
                ((CardLayout)this._cardPanel.getLayout()).show(this._cardPanel, d[2]);
                this._seasonalVariablePanel.enableTable(false);
                this._currentPanel = this._seasonalVariablePanel;
            } else if (this._currentZone.hasSeasonalVariation()) {
                if (!(object instanceof SeasonalPairedValues) && !(object instanceof PairedValues)) {
                    object = new SeasonalPairedValues();
                }
                ((SeasonalPairedValues)object).setParamXId(this._xParamId);
                ((SeasonalPairedValues)object).setParamYId(this._yParamId);
                ((SeasonalPairedValues)object).setUnitSystem(this._currentZone.getUnitSystem());
                this._seasonalVariablePanel.setData(object);
                ((CardLayout)this._cardPanel.getLayout()).show(this._cardPanel, d[2]);
                this._seasonalVariablePanel.enableTable(true);
                this._currentPanel = this._seasonalVariablePanel;
            } else if (object instanceof PairedValuesExt && !(object instanceof SeasonalPairedValues)) {
                ((PairedValuesExt)object).setParamXId(this._xParamId);
                ((PairedValuesExt)object).setParamYId(this._yParamId);
                ((PairedValuesExt)object).setUnitSystem(this._currentZone.getUnitSystem());
                this._twoVariableRulePanel.setData(object);
                ((CardLayout)this._cardPanel.getLayout()).show(this._cardPanel, d[3]);
                this._currentPanel = this._twoVariableRulePanel;
            } else {
                if (object instanceof SeasonalPairedValues) {
                    object = ((SeasonalPairedValues)object).getPairedValues();
                    object.setParamXId(this._xParamId);
                    ((PairedValues)object).setParamYId(this._yParamId);
                }
                if (!(object instanceof PairedValues)) {
                    object = new PairedValues();
                    object.setParamXId(this._xParamId);
                    ((PairedValues)object).setParamYId(this._yParamId);
                    ((PairedValues)object).setUnitSystem(this._currentZone.getUnitSystem());
                }
                this._modelVariablePanel.setData(object);
                ((CardLayout)this._cardPanel.getLayout()).show(this._cardPanel, d[3]);
                this._currentPanel = this._modelVariablePanel;
            }
        } else if (n == 0) {
            SeasonalRecord seasonalRecord;
            if (object instanceof SeasonalRecord) {
                seasonalRecord = (SeasonalRecord)object;
            } else if (!this._datePanel.isEmpty()) {
                seasonalRecord = (SeasonalRecord)this._datePanel.saveTable();
            } else {
                seasonalRecord = new SeasonalRecord();
                seasonalRecord.setParameterId(this._yParamId);
                seasonalRecord.setUnitSystem(this._currentZone.getUnitSystem());
            }
            this._datePanel.setData(seasonalRecord);
            ((CardLayout)this._cardPanel.getLayout()).show(this._cardPanel, d[0]);
            this._currentPanel = this._datePanel;
        } else if (n == 1) {
            SeasonalRecord seasonalRecord;
            if (object instanceof SeasonalRecord) {
                seasonalRecord = (SeasonalRecord)object;
            } else if (!this._dateTimePanel.isEmpty()) {
                seasonalRecord = (SeasonalRecord)this._dateTimePanel.saveTable();
            } else {
                seasonalRecord = new SeasonalRecord();
                seasonalRecord.setParameterId(this._yParamId);
                seasonalRecord.setUnitSystem(this._currentZone.getUnitSystem());
            }
            this._dateTimePanel.setData(seasonalRecord);
            ((CardLayout)this._cardPanel.getLayout()).show(this._cardPanel, d[1]);
            this._currentPanel = this._dateTimePanel;
        } else if (n == 5) {
            String[] stringArray = new String[1];
            String[] stringArray2 = stringArray;
            stringArray[0] = " ";
            if (!(this._independentVariable.getRowVariable().getType() != 0 && this._independentVariable.getRowVariable().getType() != 1 || this._independentVariable.getColVariable().getType() != 0 && this._independentVariable.getColVariable().getType() != 1)) {
                this._xParamId = -1;
                this._xParamString = Parameter.getParamString((int)this._xParamId);
                this._yParamId = -1;
                this._yParamString = Parameter.getParamString((int)this._yParamId);
            } else if (this._independentVariable.getRowVariable().getType() == 0 || this._independentVariable.getRowVariable().getType() == 1) {
                this._xParamId = -1;
                this._xParamString = Parameter.getParamString((int)this._xParamId);
                int n3 = this._independentVariable.getColVariable().getType();
                if (n3 == 2) {
                    ModelVariable modelVariable = this._independentVariable.getColVariable().getModelVariable();
                    if (modelVariable != null) {
                        this._zParamId = modelVariable.getParamId();
                        this._zParamString = Parameter.getParamString((int)this._zParamId);
                    }
                } else if (n3 == 4) {
                    StateVariable stateVariable = this._currentZone.getSystem().getStateVariable(this._independentVariable.getColVariable().getStateVariableId());
                    this._zParamString = stateVariable.getParamName();
                    try {
                        stateVariable = new Parameter(stateVariable.getParamType());
                        this._zParamId = stateVariable.getParameterId();
                    }
                    catch (DataSetIllegalArgumentException dataSetIllegalArgumentException) {
                        System.out.println("setFunctionType:Illegal Parameter " + String.valueOf((Object)dataSetIllegalArgumentException));
                        this._zParamId = -1;
                    }
                } else if (n3 == 6) {
                    GlobalVariable globalVariable = this._currentZone.getSystem().getGlobalVariable(this._independentVariable.getGlobalVariableId());
                    if (globalVariable instanceof TimeSeriesGlobalVariable) {
                        globalVariable = (TimeSeriesGlobalVariable)globalVariable;
                        this._zParamString = ((TimeSeriesGlobalVariable)globalVariable).getParameterType();
                        try {
                            globalVariable = new Parameter(this._xParamString);
                            this._zParamId = globalVariable.getParameterId();
                        }
                        catch (DataSetIllegalArgumentException dataSetIllegalArgumentException) {
                            System.out.println("setFunctionType:Illegal Parameter " + String.valueOf((Object)dataSetIllegalArgumentException));
                            this._zParamId = -1;
                        }
                    }
                } else {
                    this._zParamString = this._independentVariable.getColVariable().getTimeSeriesName();
                }
                if (object == null) {
                    object = new SeasonalRecordExt();
                }
                ((SeasonalRecordExt)object).setParameterId(this._zParamId);
                ((SeasonalRecordExt)object).setUnitSystem(this._currentZone.getUnitSystem());
                this._twoVariableRulePanel.setData(object);
                if (this._independentVariable != null && this._independentVariable.getTwoVariableColumnValues() != null && this._independentVariable.getTwoVariableColumnValues().length > 0) {
                    stringArray2 = this._independentVariable.getTwoVariableColumnValues();
                }
                this._twoVariableRulePanel.rebuildTableModel((SeasonalRecordExt)object, stringArray2);
                ((CardLayout)this._cardPanel.getLayout()).show(this._cardPanel, d[4]);
                this._currentPanel = this._twoVariableRulePanel;
            } else if (this._independentVariable.getColVariable().getType() == 0 || this._independentVariable.getColVariable().getType() == 1) {
                this._xParamId = -1;
                this._xParamString = Parameter.getParamString((int)this._xParamId);
                this._yParamId = -1;
                this._yParamString = Parameter.getParamString((int)this._yParamId);
            } else if (this._independentVariable.getRowVariable().getType() == 2 || this._independentVariable.getRowVariable().getType() == 3 || this._independentVariable.getRowVariable().getType() == 6 || this._independentVariable.getRowVariable().getType() == 4) {
                this._xParamId = -1;
                int n4 = this._independentVariable.getRowVariable().getType();
                if (n4 == 2) {
                    ModelVariable modelVariable = this._independentVariable.getRowVariable().getModelVariable();
                    if (modelVariable != null) {
                        this._xParamId = modelVariable.getParamId();
                        this._xParamString = Parameter.getParamString((int)this._xParamId);
                    }
                } else if (n4 == 4) {
                    StateVariable stateVariable = this._currentZone.getSystem().getStateVariable(this._independentVariable.getRowVariable().getStateVariableId());
                    this._xParamString = stateVariable.getParamName();
                    try {
                        stateVariable = new Parameter(stateVariable.getParamType());
                        this._xParamId = stateVariable.getParameterId();
                    }
                    catch (DataSetIllegalArgumentException dataSetIllegalArgumentException) {
                        System.out.println("setFunctionType:Illegal Parameter " + String.valueOf((Object)dataSetIllegalArgumentException));
                        this._xParamId = -1;
                    }
                } else if (n4 == 6) {
                    GlobalVariable globalVariable = this._currentZone.getSystem().getGlobalVariable(this._independentVariable.getRowVariable().getGlobalVariableId());
                    if (globalVariable instanceof TimeSeriesGlobalVariable) {
                        globalVariable = (TimeSeriesGlobalVariable)globalVariable;
                        this._xParamString = ((TimeSeriesGlobalVariable)globalVariable).getParameterType();
                        try {
                            globalVariable = new Parameter(this._xParamString);
                            this._xParamId = globalVariable.getParameterId();
                        }
                        catch (DataSetIllegalArgumentException dataSetIllegalArgumentException) {
                            System.out.println("setFunctionType:Illegal Parameter " + String.valueOf((Object)dataSetIllegalArgumentException));
                            this._xParamId = -1;
                        }
                    }
                } else {
                    this._xParamString = this._independentVariable.getRowVariable().getTimeSeriesName();
                }
                if (object == null) {
                    object = new PairedValuesExt();
                }
                ((PairedValuesExt)object).setParamXId(this._xParamId);
                ((PairedValuesExt)object).setParamYId(this._yParamId);
                ((PairedValuesExt)object).setUnitSystem(this._currentZone.getUnitSystem());
                this._twoVariableRulePanel.setData(object);
                if (this._independentVariable != null && this._independentVariable.getTwoVariableColumnValues() != null && this._independentVariable.getTwoVariableColumnValues().length > 0) {
                    stringArray2 = this._independentVariable.getTwoVariableColumnValues();
                }
                this._twoVariableRulePanel.rebuildTableModel((PairedValuesExt)object, stringArray2);
                ((CardLayout)this._cardPanel.getLayout()).show(this._cardPanel, d[4]);
                this._currentPanel = this._twoVariableRulePanel;
            }
        } else {
            SeasonalRecord seasonalRecord;
            if (object instanceof SeasonalRecord) {
                seasonalRecord = (SeasonalRecord)object;
            } else if (!this._datePanel.isEmpty()) {
                seasonalRecord = (SeasonalRecord)this._datePanel.saveTable();
            } else {
                seasonalRecord = new SeasonalRecord();
                seasonalRecord.setParameterId(this._yParamId);
                seasonalRecord.setUnitSystem(this._currentZone.getUnitSystem());
            }
            this._datePanel.setData(seasonalRecord);
            ((CardLayout)this._cardPanel.getLayout()).show(this._cardPanel, d[0]);
            this._currentPanel = this._datePanel;
        }
        this.replot();
        Window window = SwingUtilities.windowForComponent((Component)((Object)this));
        if (window instanceof RmaJDialog) {
            ((RmaJDialog)window).updateUnitSystem((Container)((Object)this));
            ((RmaJDialog)window).updateTimeZone((Container)((Object)this));
            return;
        }
        if (window instanceof RmaJFrame) {
            ((RmaJFrame)window).updateUnitSystem((Container)((Object)this));
            ((RmaJFrame)window).updateTimeZone((Container)((Object)this));
        }
    }

    public String buildFunctionOfString(IndependentVariable independentVariable) {
        if (independentVariable == null) {
            return "Function Not Defined";
        }
        return independentVariable.buildFunctionOfString(this._currentZone);
    }

    private String getDefaultTime() {
        Object object = "";
        try {
            ClientWorkspace clientWorkspace = ClientApp.Workspace();
            clientWorkspace = ((RssRmiWorkspace)clientWorkspace.getChildWorkspace("rss")).getStartOfWaterYear();
            object = clientWorkspace.date(104);
            object = ((String)object).substring(0, 5);
            object = (String)object + " 0000";
        }
        catch (RemoteException remoteException) {
            System.out.println("Error Setting water year start - " + remoteException.getMessage());
            System.out.println("Resuming as normal");
        }
        return object;
    }

    protected String getAdditionalYParamString() {
        return "";
    }

    protected String getAdditionalYUnitsString() {
        return "";
    }

    protected void limitTypeComboChanged() {
    }
}

