/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.clientapp.client.ClientApp;
import hec.data.ParamDouble;
import hec.data.Parameter;
import hec.model.PairedValues;
import hec.rss.client.PhysicalTreeCardPanel;
import hec.rss.client.RSimTreeNode;
import hec.rss.model.Element;
import hec.rss.model.JunctionElement;
import hec.rss.model.ReservoirElement;
import hec.rss.model.RssRatingObject;
import hec.rss.model.RssReturnStatusConstants;
import hec.rss.model.RssSystem;
import hec.rss.model.TailElevContainer;
import hec.rss.model.TailwaterElevation;
import hec.rss.server.JRatingCurvePanel2;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.EventObject;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import rma.swing.RmaGridBagConstraints;
import rma.swing.RmaJCheckBox;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJDecimalField;
import rma.swing.RmaJLabel;
import rma.util.RMAIO;

public class JTailElevCardPanel
extends PhysicalTreeCardPanel {
    String units = "";
    TailwaterElevation _tailElev;
    JRatingCurvePanel2 _ratingCurvePanel = new JRatingCurvePanel2();
    JPanel _tailwaterPanel = new JPanel();
    RmaJCheckBox _constCheckBox = new RmaJCheckBox("Constant Elevation (%S)");
    RmaJCheckBox _dwnstrmCheckBox = new RmaJCheckBox("Downstream Control");
    RmaJCheckBox _ratingCheckBox = new RmaJCheckBox("Rating Curve");
    RmaJDecimalField _constElevTxt = new RmaJDecimalField();
    RmaJComboBox _dnstrmCombo = new RmaJComboBox();
    RmaJLabel _datumLabel = new RmaJLabel("Stage Datum (%S)");
    RmaJDecimalField _datumTxt = new RmaJDecimalField();

    @Override
    public void createControls() {
        if (((PhysicalTreeCardPanel)this).areControlsCreated()) {
            return;
        }
        this.setLayout(new GridBagLayout());
        Object object = new PairedValues();
        object.setUnitSystem(ClientApp.Workspace().getUnitSystem());
        object.setParamXId(Parameter.PARAMID_STAGE);
        object.setParamYId(Parameter.PARAMID_FLOW);
        this._constCheckBox.setLabelFor((Component)this._constElevTxt);
        this._ratingCurvePanel.fillForm((PairedValues)object);
        object = new Insets(5, 15, 0, 0);
        JLabel jLabel = new JLabel("Use Highest Elevation From:");
        this.add(jLabel, new RmaGridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, INSETS5500, 0, 0));
        JTailElevCardPanel jTailElevCardPanel = this;
        jTailElevCardPanel.add((Component)jTailElevCardPanel._constCheckBox, new RmaGridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, (Insets)object, 0, 0));
        JTailElevCardPanel jTailElevCardPanel2 = this;
        jTailElevCardPanel2.add((Component)jTailElevCardPanel2._constElevTxt, new RmaGridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 18, 2, INSETS5500, 0, 0));
        this.add(new JPanel(), new RmaGridBagConstraints(2, 1, 1, 2, 0.0, 0.0, 18, 0, (Insets)object, 190, 0));
        JTailElevCardPanel jTailElevCardPanel3 = this;
        jTailElevCardPanel3.add((Component)jTailElevCardPanel3._dwnstrmCheckBox, new RmaGridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, (Insets)object, 0, 0));
        JTailElevCardPanel jTailElevCardPanel4 = this;
        jTailElevCardPanel4.add((Component)jTailElevCardPanel4._dnstrmCombo, new RmaGridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 18, 2, INSETS5500, 0, 0));
        JTailElevCardPanel jTailElevCardPanel5 = this;
        jTailElevCardPanel5.add((Component)jTailElevCardPanel5._ratingCheckBox, new RmaGridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 18, 0, (Insets)object, 0, 0));
        JTailElevCardPanel jTailElevCardPanel6 = this;
        jTailElevCardPanel6.add((Component)((Object)jTailElevCardPanel6._ratingCurvePanel), new RmaGridBagConstraints(0, 4, 3, 1, 1.0, 1.0, 18, 1, (Insets)object, 0, 0));
        this._constCheckBox.setSelected(false);
        this._constElevTxt.setEnabled(false);
        this._dwnstrmCheckBox.setSelected(false);
        this._dnstrmCombo.setEnabled(false);
        this._ratingCheckBox.setSelected(false);
        this._ratingCurvePanel.setEnabled(false);
        this._datumTxt.setEnabled(false);
        this._constCheckBox.addItemListener((ItemListener)((Object)this));
        this._dwnstrmCheckBox.addItemListener((ItemListener)((Object)this));
        this._ratingCheckBox.addItemListener((ItemListener)((Object)this));
        this._dnstrmCombo.setModifiable(true);
        this._controlsCreated = true;
        this.setModified(false);
    }

    @Override
    public boolean areControlsCreated() {
        return this._controlsCreated;
    }

    public void itemStateChanged(ItemEvent object) {
        if ((object = ((EventObject)object).getSource()) == this._constCheckBox) {
            this._constElevTxt.setEnabled(this._constCheckBox.isSelected());
            return;
        }
        if (object == this._dwnstrmCheckBox) {
            this._dnstrmCombo.setEnabled(this._dwnstrmCheckBox.isSelected());
            return;
        }
        if (object == this._ratingCheckBox) {
            this._ratingCurvePanel.setEnabled(this._ratingCheckBox.isSelected());
        }
    }

    @Override
    public void fillPanel(ReservoirElement cloneable, RSimTreeNode object) {
        super.fillPanel((ReservoirElement)cloneable, (RSimTreeNode)object);
        if (!this._controlsCreated) {
            ((PhysicalTreeCardPanel)this).createControls();
        }
        if (object == null) {
            return;
        }
        if ((object = ((RSimTreeNode)object).d()) == null) {
            return;
        }
        if (this._currentReservoir == null) {
            return;
        }
        this._tailElev = null;
        if (object instanceof TailElevContainer) {
            this._tailElev = ((TailElevContainer)object).getTailwaterElevation();
        } else if (((Element)object).getFunction() != null || ((Element)object).getFunction() instanceof TailElevContainer) {
            this._tailElev = ((TailElevContainer)((Object)((Element)object).getFunction())).getTailwaterElevation();
        }
        this._constCheckBox.setSelected(this._tailElev.usesConstElev());
        this._dwnstrmCheckBox.setSelected(this._tailElev.usesDnstrmElev());
        this._ratingCheckBox.setSelected(this._tailElev.usesRatingCurveElev());
        ParamDouble paramDouble = new ParamDouble();
        this._tailElev.getConstElev(paramDouble);
        this._constElevTxt.setValue(paramDouble);
        if (this._dnstrmCombo.getItemCount() > 0) {
            this._dnstrmCombo.removeAllItems();
        }
        RssReturnStatusConstants rssReturnStatusConstants = this._tailElev.getElement();
        int n = this._tailElev.getDnstrmJuncId();
        int n2 = -1;
        if ((rssReturnStatusConstants = ((Element)rssReturnStatusConstants).getSystem()) != null) {
            if ((cloneable = ((RssSystem)rssReturnStatusConstants).getDownstreamElements((Element)((Object)cloneable))) != null) {
                int n3 = 0;
                for (int i = 0; i < ((Vector)cloneable).size(); ++i) {
                    rssReturnStatusConstants = (Element)((Vector)cloneable).elementAt(i);
                    if (rssReturnStatusConstants instanceof JunctionElement) {
                        if (!((JunctionElement)(rssReturnStatusConstants = (JunctionElement)rssReturnStatusConstants)).hasRatingCurve()) continue;
                        if (rssReturnStatusConstants.getIndex() == n) {
                            n2 = n3;
                        }
                        this._dnstrmCombo.addItem((Object)rssReturnStatusConstants);
                        ++n3;
                        continue;
                    }
                    if (!(rssReturnStatusConstants instanceof ReservoirElement)) continue;
                    if ((rssReturnStatusConstants = (ReservoirElement)rssReturnStatusConstants).getIndex() == n) {
                        n2 = n3;
                    }
                    this._dnstrmCombo.addItem((Object)rssReturnStatusConstants);
                    ++n3;
                }
            }
            if (n2 >= 0 && n2 < this._dnstrmCombo.getItemCount()) {
                this._dnstrmCombo.setSelectedIndex(n2);
            } else {
                this._dnstrmCombo.setSelectedIndex(-1);
            }
        }
        this._ratingCurvePanel.setPopupPlotTitle("Tailwater Rating Curve: " + this.getFullName());
        cloneable = this._tailElev.getRatingCurve();
        this._tailElev.getStageDatum(paramDouble);
        cloneable.setDatum(paramDouble);
        this._ratingCurvePanel.setElement((Element)object);
        rssReturnStatusConstants = this._tailElev.getRatingObject();
        this._ratingCurvePanel.setVisible(false);
        this._ratingCurvePanel.fillForm((PairedValues)cloneable);
        this._ratingCurvePanel.fillForm((RssRatingObject)rssReturnStatusConstants);
        this._ratingCurvePanel.setVisible(true);
        this.setModified(false);
    }

    public void clearPanel() {
    }

    @Override
    public boolean savePanel() {
        Object object;
        if (!((PhysicalTreeCardPanel)this).areControlsCreated()) {
            return true;
        }
        if (this._tailElev == null) {
            RMAIO.postError((Component)((Object)this), (String)"Data Error!  NULL Data object");
            return false;
        }
        this._tailElev.setUsesConstElev(this._constCheckBox.isSelected());
        if (this._constCheckBox.isSelected()) {
            this._tailElev.setConstElev(this._constElevTxt.getParamValue());
        }
        this._tailElev.setUsesDnstrmElev(this._dwnstrmCheckBox.isSelected());
        if (this._dwnstrmCheckBox.isSelected() && this._dnstrmCombo.getSelectedItem() != null) {
            object = (Element)this._dnstrmCombo.getSelectedItem();
            this._tailElev.setDnstrmJuncId(object.getIndex());
        }
        this._tailElev.setUsesRatingCurveElev(this._ratingCheckBox.isSelected());
        if (this._ratingCheckBox.isSelected()) {
            object = this._ratingCurvePanel.storeForm(this._tailElev.getRatingCurve());
            this._tailElev.setRatingCurve((PairedValues)object);
            ParamDouble paramDouble = new ParamDouble();
            object.getDatum(paramDouble);
            this._tailElev.setStageDatum(paramDouble);
            object = this._tailElev.getRatingCurve();
            if (!(object.getPairCount() <= 0 || object.canInterpX() && object.canInterpY())) {
                JOptionPane.showMessageDialog((Component)((Object)this), "Elevation and Flow values of your function must be a continuously increasing sequence.", "Tailwater Elevation Curve Error", 2);
                return false;
            }
            object = this._ratingCurvePanel.getIndependentVariable();
            if (object != null) {
                object = this._tailElev.getRatingObject();
                object = this._ratingCurvePanel.storeForm((RssRatingObject)object);
                this._tailElev.setRatingObject((RssRatingObject)object);
            }
        }
        this._ratingCurvePanel.setModified(false);
        this.setModified(false);
        return true;
    }
}

